/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 31.03.2010 - [HM] - creation
 */
package com.sibvisions.rad.ui.swing.ext;

import javax.rad.model.ui.ICellEditorListener;

import com.sibvisions.rad.ui.swing.ext.format.ICellFormatter;

/**
 * This Interface is necessary to give Swing CellEditorHandler access to the 
 * ICellFormatter of the Control.
 * 
 * @author Martin Handsteiner
 * @see	javax.rad.model.ui.ICellEditorListener
 */
public interface ICellFormatterEditorListener extends ICellEditorListener
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
     * Gets the CellFormatter.
     *
     * @return the CellFormatter.
     */
    public ICellFormatter getCellFormatter();
	
}	// ICellFormatterEditorListener
