/*
 * Copyright 2011 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 11.12.2011 - [JR] - creation
 */
package com.sibvisions.rad.server.http.rest;

import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.routing.Router;
import org.restlet.security.ChallengeAuthenticator;

/**
 * The <code>RESTAdapter</code> class enables access to application life-cycle objects of JVx.
 * 
 * @author Ren Jahn
 */
public class RESTAdapter extends Application
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** the name of the "application name" parameter. */
	public static final String PARAM_APP_NAME = "APP_NAME";

	/** the name of the "lifecycle class" parameter. */
	public static final String PARAM_LCO_CLASS = "LCO_CLASS";
	
	/** the name of the "object" parameter. */
	public static final String PARAM_OBJECT_NAME = "OBJECT_NAME";  
	
	/** the name of the "action" parameter. */
	public static final String PARAM_ACTION_NAME = "ACTION_NAME";  

	/** the name of the "primary key" parameter. */
	public static final String PARAM_PK = "PK";  

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a root Restlet that will receive all incoming calls.
	 * 
	 * @return the inbound root restlet
	 */
	@Override
	public synchronized Restlet createInboundRoot() 
	{
		Context ctxt = getContext();
		
		Router routerApp = new Router(ctxt);
		Router routerLco = new Router(ctxt);

		SecurityManagerVerifier verify = new SecurityManagerVerifier();

		ChallengeAuthenticator chauth = new ChallengeAuthenticator(ctxt, ChallengeScheme.HTTP_BASIC, "Application access")
		{
			protected void afterHandle(Request pRequest, Response pResponse)
			{
				try
				{
					super.afterHandle(pRequest, pResponse);
				}
				finally
				{
					RESTSession session = (RESTSession)pRequest.getClientInfo().getUser();
					
					if (session != null)
					{
						try
						{
							session.destroy();
						}
						catch (Throwable th)
						{
							//nothing to be done
						}
					}
				}
			}
		};
		
		chauth.setVerifier(verify);
		chauth.setNext(routerLco);

		//authentication
		routerApp.attach("/{" + PARAM_APP_NAME + "}/{" + PARAM_LCO_CLASS + "}", chauth);
		
		//services
		routerLco.attach("/data/{" + PARAM_OBJECT_NAME + "}", AbstractStorageServerResource.class);
		routerLco.attach("/data/{" + PARAM_OBJECT_NAME + "}/{" + PARAM_PK + "}", AbstractStorageServerResource.class);

		routerLco.attach("/action/{" + PARAM_ACTION_NAME + "}", CallServerResource.class);
		routerLco.attach("/object/{" + PARAM_OBJECT_NAME + "}/{" + PARAM_ACTION_NAME + "}", CallServerResource.class);
		
		return routerApp;
	}
	
}	// RESTAdapter
