/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.persist;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import javax.rad.model.ModelException;
import javax.rad.persist.ColumnMetaData;

public class MetaData
implements Serializable,
Cloneable {
    private ArrayUtil<ColumnMetaData> auColumnMetaData = new ArrayUtil();
    private String[] saPrimaryKeyColumnNames;
    private String[] saRepresentationColumnNames;
    private String[] saAutoIncrementColumnNames;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnMetaData :: ");
        stringBuilder.append(this.auColumnMetaData.toString());
        if (this.saPrimaryKeyColumnNames != null) {
            stringBuilder.append("PrimaryKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saPrimaryKeyColumnNames));
        }
        if (this.saRepresentationColumnNames != null) {
            stringBuilder.append("UniqueKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saRepresentationColumnNames));
        }
        if (this.saAutoIncrementColumnNames != null) {
            stringBuilder.append("AutoIncrementKeyColumnNames :: ");
            stringBuilder.append(StringUtil.toString(this.saAutoIncrementColumnNames));
        }
        return stringBuilder.toString();
    }

    public MetaData clone() {
        try {
            MetaData metaData = (MetaData)super.clone();
            if (this.saAutoIncrementColumnNames != null) {
                metaData.saAutoIncrementColumnNames = (String[])this.saAutoIncrementColumnNames.clone();
            }
            if (this.saPrimaryKeyColumnNames != null) {
                metaData.saPrimaryKeyColumnNames = (String[])this.saPrimaryKeyColumnNames.clone();
            }
            if (this.saRepresentationColumnNames != null) {
                metaData.saRepresentationColumnNames = (String[])this.saRepresentationColumnNames.clone();
            }
            return metaData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void addColumnMetaData(ColumnMetaData columnMetaData) {
        this.auColumnMetaData.add(columnMetaData);
    }

    public void setColumnMetaData(ColumnMetaData[] columnMetaDataArray) {
        this.auColumnMetaData.clear();
        this.auColumnMetaData.addAll((ColumnMetaData[])columnMetaDataArray);
    }

    public ColumnMetaData[] getColumnMetaData() {
        return this.auColumnMetaData.toArray(new ColumnMetaData[this.auColumnMetaData.size()]);
    }

    public ColumnMetaData getColumnMetaData(String string) throws ModelException {
        int n = this.getColumnMetaDataIndex(string);
        if (n >= 0) {
            return this.auColumnMetaData.get(n);
        }
        throw new ModelException("Column '" + string + "' doesn't exists in MetaData!");
    }

    public int getColumnMetaDataIndex(String string) {
        for (int i = 0; i < this.auColumnMetaData.size(); ++i) {
            if (!this.auColumnMetaData.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String[] getPrimaryKeyColumnNames() {
        return this.saPrimaryKeyColumnNames;
    }

    public void setPrimaryKeyColumnNames(String[] stringArray) {
        this.saPrimaryKeyColumnNames = stringArray;
    }

    public String[] getRepresentationColumnNames() {
        return this.saRepresentationColumnNames;
    }

    public void setRepresentationColumnNames(String[] stringArray) {
        this.saRepresentationColumnNames = stringArray;
    }

    public String[] getAutoIncrementColumnNames() {
        return this.saAutoIncrementColumnNames;
    }

    public void setAutoIncrementColumnNames(String[] stringArray) {
        this.saAutoIncrementColumnNames = stringArray;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.auColumnMetaData.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.auColumnMetaData.get(i).getName();
        }
        return stringArray;
    }
}

