/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.persist;

import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.ObjectDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.model.reference.StorageReferenceDefinition;

public class ColumnMetaData
implements Serializable,
Cloneable {
    private String sName;
    private String sLabel;
    private int iDataTypeIdentifier = 12;
    private boolean bNullable;
    private int iPrecision;
    private int iScale;
    private boolean bSigned;
    private boolean bWriteable = true;
    private boolean bAutoIncrement = false;
    private Object oDefault;
    private Object[] oAllowedValues;
    private StorageReferenceDefinition srdLinkReference;

    public ColumnMetaData() {
    }

    public ColumnMetaData(String string) {
        this.sName = string;
    }

    public ColumnMetaData(String string, int n) {
        this.sName = string;
        this.iDataTypeIdentifier = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ColumnMetaData ::[");
        stringBuilder.append(this.sName);
        stringBuilder.append("],Type=");
        stringBuilder.append(this.iDataTypeIdentifier);
        stringBuilder.append(",Label=");
        stringBuilder.append(this.sLabel);
        stringBuilder.append(",Nullable=");
        stringBuilder.append(this.bNullable);
        stringBuilder.append(",Precision=");
        stringBuilder.append(this.iPrecision);
        stringBuilder.append(",Scale=");
        stringBuilder.append(this.iScale);
        stringBuilder.append(",Signed=");
        stringBuilder.append(this.bSigned);
        stringBuilder.append(",bWriteable=");
        stringBuilder.append(this.bWriteable);
        stringBuilder.append(",Default=");
        stringBuilder.append(this.oDefault);
        stringBuilder.append(",Allowed=");
        stringBuilder.append(StringUtil.toString(this.oAllowedValues));
        return stringBuilder.toString();
    }

    public ColumnMetaData clone() {
        try {
            ColumnMetaData columnMetaData = (ColumnMetaData)super.clone();
            if (this.oAllowedValues != null) {
                columnMetaData.oAllowedValues = (Object[])this.oAllowedValues.clone();
            }
            return columnMetaData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setName(String string) {
        this.sName = string;
    }

    public String getName() {
        return this.sName;
    }

    public String getLabel() {
        if (this.sLabel == null) {
            return ColumnMetaData.getDefaultLabel(this.sName);
        }
        return this.sLabel;
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public void setDataType(int n) {
        this.iDataTypeIdentifier = n;
    }

    public int getDataType() {
        return this.iDataTypeIdentifier;
    }

    public void setNullable(boolean bl) {
        this.bNullable = bl;
    }

    public boolean isNullable() {
        return this.bNullable;
    }

    public int getPrecision() {
        return this.iPrecision;
    }

    public void setPrecision(int n) {
        this.iPrecision = n;
    }

    public int getScale() {
        return this.iScale;
    }

    public void setScale(int n) {
        this.iScale = n;
    }

    public void setWritable(boolean bl) {
        this.bWriteable = bl;
    }

    public boolean isWritable() {
        return this.bWriteable;
    }

    public boolean isSigned() {
        return this.bSigned;
    }

    public void setSigned(boolean bl) {
        this.bSigned = bl;
    }

    public boolean isAutoIncrement() {
        return this.bAutoIncrement;
    }

    public void setAutoIncrement(boolean bl) {
        this.bAutoIncrement = bl;
    }

    public StorageReferenceDefinition getLinkReference() {
        return this.srdLinkReference;
    }

    public void setLinkReference(StorageReferenceDefinition storageReferenceDefinition) {
        this.srdLinkReference = storageReferenceDefinition;
    }

    public static ColumnDefinition createColumnDefinition(ColumnMetaData columnMetaData) throws ModelException {
        ColumnDefinition columnDefinition = new ColumnDefinition(columnMetaData.getName());
        columnDefinition.setWritable(columnMetaData.isWritable());
        columnDefinition.setNullable(columnMetaData.isNullable());
        columnDefinition.setDataType(ColumnMetaData.createDataType(columnMetaData));
        columnDefinition.setLabel(columnMetaData.getLabel());
        columnDefinition.setDefaultValue(columnMetaData.getDefaultValue());
        columnDefinition.setAllowedValues(columnMetaData.getAllowedValues());
        return columnDefinition;
    }

    public static IDataType createDataType(ColumnMetaData columnMetaData) {
        if (columnMetaData.getDataType() == 12) {
            StringDataType stringDataType = new StringDataType();
            stringDataType.setSize(columnMetaData.getPrecision());
            return stringDataType;
        }
        if (columnMetaData.getDataType() == 16) {
            return new BooleanDataType();
        }
        if (columnMetaData.getDataType() == 3) {
            BigDecimalDataType bigDecimalDataType = new BigDecimalDataType();
            bigDecimalDataType.setPrecision(columnMetaData.getPrecision());
            bigDecimalDataType.setScale(columnMetaData.getScale());
            bigDecimalDataType.setSigned(columnMetaData.isSigned());
            return bigDecimalDataType;
        }
        if (columnMetaData.getDataType() == 93) {
            return new TimestampDataType();
        }
        if (columnMetaData.getDataType() == -2) {
            BinaryDataType binaryDataType = new BinaryDataType();
            binaryDataType.setSize(columnMetaData.getPrecision());
            return binaryDataType;
        }
        if (columnMetaData.getDataType() == 2000) {
            ObjectDataType objectDataType = new ObjectDataType();
            return objectDataType;
        }
        return null;
    }

    public static ColumnMetaData createColumnMetaData(ColumnDefinition columnDefinition) {
        int n = columnDefinition.getDataType().getTypeIdentifier();
        ColumnMetaData columnMetaData = new ColumnMetaData(columnDefinition.getName());
        columnMetaData.setLabel(columnDefinition.getLabel());
        columnMetaData.setNullable(columnDefinition.isNullable());
        columnMetaData.setWritable(columnDefinition.isWritable());
        columnMetaData.setDataType(n);
        if (n == 3) {
            columnMetaData.setPrecision(((BigDecimalDataType)columnDefinition.getDataType()).getPrecision());
            columnMetaData.setScale(((BigDecimalDataType)columnDefinition.getDataType()).getScale());
            columnMetaData.setSigned(((BigDecimalDataType)columnDefinition.getDataType()).isSigned());
        } else if (n == 12) {
            columnMetaData.setPrecision(((StringDataType)columnDefinition.getDataType()).getSize());
        } else if (n == -2) {
            columnMetaData.setPrecision(((BinaryDataType)columnDefinition.getDataType()).getSize());
        }
        columnMetaData.setDefaultValue(columnDefinition.getDefaultValue());
        columnMetaData.setAllowedValues(columnDefinition.getAllowedValues());
        return columnMetaData;
    }

    public static String getDefaultLabel(String string) {
        return StringUtil.formatInitCap(string);
    }

    public void setDefaultValue(Object object) {
        this.oDefault = object;
    }

    public Object getDefaultValue() {
        return this.oDefault;
    }

    public void setAllowedValues(Object[] objectArray) {
        this.oAllowedValues = objectArray;
    }

    public Object[] getAllowedValues() {
        return this.oAllowedValues;
    }
}

