/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.datatype;

import javax.rad.model.ModelException;
import javax.rad.model.datatype.DataType;

public class BinaryDataType
extends DataType {
    public static final int TYPE_IDENTIFIER = -2;

    public BinaryDataType() {
        this.setSize(Integer.MAX_VALUE);
    }

    public int getTypeIdentifier() {
        return -2;
    }

    public Class getTypeClass() {
        return byte[].class;
    }

    public Object convertAndCheckToTypeClass(Object object) throws ModelException {
        byte[] byArray = (byte[])this.convertToTypeClass(object);
        if (byArray == null) {
            return null;
        }
        if (byArray.length > this.getSize()) {
            throw new ModelException("Binary too large! - length from " + byArray.length + " to " + this.getSize());
        }
        return byArray;
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return new String((byte[])object);
    }

    public Object convertToTypeClass(Object object) throws ModelException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            return string.getBytes();
        }
        throw new ModelException("Conversion failed! Type not supported ! from " + object.getClass().getName() + " to " + this.getTypeClass().getName());
    }

    public int compareTo(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object != null && object2 != null && object instanceof byte[]) {
            try {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = (byte[])this.convertToTypeClass(object2);
                if (byArray.length < byArray2.length) {
                    return -1;
                }
                if (byArray.length > byArray2.length) {
                    return 1;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] < byArray2[i]) {
                        return -1;
                    }
                    if (byArray[i] <= byArray2[i]) continue;
                    return 1;
                }
                return 0;
            }
            catch (ModelException modelException) {
                return -1;
            }
        }
        return super.compareTo(object, object2);
    }

    public BinaryDataType clone() {
        return (BinaryDataType)super.clone();
    }
}

