/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.condition;

import com.sibvisions.util.ArrayUtil;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.CompareCondition;
import javax.rad.model.condition.Equals;
import javax.rad.model.condition.GreaterEquals;
import javax.rad.model.condition.ICondition;
import javax.rad.model.condition.LessEquals;
import javax.rad.model.condition.Like;
import javax.rad.model.condition.LikeIgnoreCase;
import javax.rad.model.condition.Or;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.datatype.StringDataType;
import javax.rad.model.datatype.TimestampDataType;
import javax.rad.persist.ColumnMetaData;
import javax.rad.ui.celleditor.ILinkedCellEditor;

public class Filter {
    protected Filter() {
    }

    public static ICondition createLikeFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new Like(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Like(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createLikeIgnoreCaseFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new LikeIgnoreCase(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new LikeIgnoreCase(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createEqualsFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = new Equals(iDataRow, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Equals(iDataRow, stringArray[i]));
        }
        return baseCondition;
    }

    public static ICondition createEqualsFilter(String[] stringArray, Object[] objectArray, ColumnMetaData[] columnMetaDataArray) {
        if (stringArray.length == 0) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = columnMetaDataArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = ArrayUtil.indexOf(stringArray, columnMetaDataArray[i].getName());
            if (n2 < 0) continue;
            nArray[n2] = i;
        }
        BaseCondition baseCondition = new Equals(stringArray[0], objectArray[nArray[0]]);
        for (n = 1; n < stringArray.length; ++n) {
            baseCondition = baseCondition.and(new Equals(stringArray[n], objectArray[nArray[n]]));
        }
        return baseCondition;
    }

    public static ICondition createFilter(IDataRow iDataRow) {
        return Filter.createFilter(iDataRow, iDataRow.getRowDefinition().getColumnNames());
    }

    public static ICondition createFilter(IDataRow iDataRow, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        BaseCondition baseCondition = null;
        CompareCondition compareCondition = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDefinition columnDefinition = iDataRow.getRowDefinition().getColumnDefinition(i);
            IDataType iDataType = columnDefinition.getDataType();
            compareCondition = iDataType instanceof TimestampDataType && i + 1 < stringArray.length && iDataRow.getRowDefinition().getColumnDefinition(i + 1).getDataType() instanceof TimestampDataType ? new GreaterEquals(iDataRow, stringArray[i]) : (iDataType instanceof TimestampDataType && compareCondition instanceof GreaterEquals ? new LessEquals(iDataRow, stringArray[i]) : (iDataType instanceof BigDecimalDataType || iDataType instanceof BooleanDataType || iDataType.getCellEditor() instanceof ILinkedCellEditor && ((ILinkedCellEditor)iDataType.getCellEditor()).isValidationEnabled() || iDataType instanceof TimestampDataType ? new Equals(iDataRow, stringArray[i]) : (iDataType instanceof StringDataType ? new LikeIgnoreCase(iDataRow, stringArray[i]) : null)));
            if (compareCondition == null) continue;
            baseCondition = baseCondition == null ? compareCondition : baseCondition.and(compareCondition);
        }
        return baseCondition;
    }

    public static ICondition createFullTextFilter(IDataBook iDataBook, String string, String ... stringArray) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String[] stringArray2 = stringArray != null && stringArray.length > 0 ? stringArray : iDataBook.getRowDefinition().getColumnNames();
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            if (!(iDataBook.getRowDefinition().getColumnDefinition(i).getDataType() instanceof BinaryDataType) && iDataBook.getRowDefinition().getColumnDefinition(i).isWritable()) continue;
            stringArray2 = (String[])ArrayUtil.remove(stringArray2, i);
        }
        string = "*" + string.trim() + "*";
        Or or = new Or();
        for (int i = 0; i < stringArray2.length; ++i) {
            or.add(new LikeIgnoreCase(stringArray2[i], (Object)string));
        }
        return or;
    }
}

