/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model;

import com.sibvisions.util.ArrayUtil;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.condition.BaseCondition;
import javax.rad.model.condition.Equals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePathFinder {
    private TreePathFinder parent;
    private IDataBook dataBook;
    private Object[] primaryKeyValues;

    public TreePathFinder(IChangeableDataRow iChangeableDataRow) throws ModelException {
        this(null, iChangeableDataRow);
    }

    public TreePathFinder(TreePathFinder treePathFinder, IChangeableDataRow iChangeableDataRow) throws ModelException {
        this.parent = treePathFinder;
        if (iChangeableDataRow == null) {
            this.dataBook = this.parent.getDataBook();
            this.primaryKeyValues = null;
        } else {
            this.dataBook = iChangeableDataRow.getDataPage().getDataBook();
            this.primaryKeyValues = iChangeableDataRow.getRowIndex() < 0 ? null : iChangeableDataRow.getValues(iChangeableDataRow.getRowDefinition().getPrimaryKeyColumnNames());
        }
    }

    public TreePathFinder getRoot() {
        TreePathFinder treePathFinder = this;
        TreePathFinder treePathFinder2 = this.parent;
        while (treePathFinder2 != null) {
            treePathFinder = treePathFinder2;
            treePathFinder2 = treePathFinder.parent;
        }
        return treePathFinder;
    }

    public TreePathFinder getParentWithDataBook(IDataBook iDataBook) {
        TreePathFinder treePathFinder = this.parent;
        while (treePathFinder != null && treePathFinder.dataBook != iDataBook) {
            treePathFinder = treePathFinder.parent;
        }
        return treePathFinder;
    }

    public TreePathFinder getParent() {
        return this.parent;
    }

    public IDataBook getDataBook() {
        return this.dataBook;
    }

    public Object[] getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public TreePathFinder getChild(IChangeableDataRow iChangeableDataRow) throws ModelException {
        return new TreePathFinder(this, iChangeableDataRow);
    }

    public boolean selectTreePath() throws ModelException {
        ArrayUtil<TreePathFinder> arrayUtil = new ArrayUtil<TreePathFinder>();
        TreePathFinder treePathFinder = this;
        do {
            arrayUtil.add(0, treePathFinder);
        } while ((treePathFinder = treePathFinder.parent) != null);
        return this.selectTreePathIntern(arrayUtil);
    }

    private boolean selectTreePathIntern(ArrayUtil<TreePathFinder> arrayUtil) throws ModelException {
        TreePathFinder treePathFinder = arrayUtil.remove(0);
        if (treePathFinder.dataBook.isSelfJoined()) {
            if (treePathFinder.parent == null || treePathFinder.parent.dataBook != treePathFinder.dataBook) {
                treePathFinder.dataBook.setTreePath(null);
            } else {
                treePathFinder.dataBook.setTreePath(treePathFinder.dataBook.getTreePath().getChildPath(treePathFinder.dataBook.getSelectedRow()));
            }
        }
        int n = treePathFinder.getIndexOfPrimaryKey();
        treePathFinder.dataBook.setSelectedRow(n);
        if (arrayUtil.size() > 0) {
            if (n < 0) {
                return false;
            }
            return this.selectTreePathIntern(arrayUtil);
        }
        return n >= 0 || treePathFinder.primaryKeyValues == null;
    }

    public int getIndexOfPrimaryKey() throws ModelException {
        if (this.primaryKeyValues == null) {
            return -1;
        }
        String[] stringArray = this.dataBook.getRowDefinition().getPrimaryKeyColumnNames();
        BaseCondition baseCondition = new Equals(stringArray[0], this.primaryKeyValues[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            baseCondition = baseCondition.and(new Equals(stringArray[i], this.primaryKeyValues[i]));
        }
        return this.dataBook.searchNext(baseCondition);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        TreePathFinder.toString(this, stringBuilder);
        return stringBuilder.toString();
    }

    private static void toString(TreePathFinder treePathFinder, StringBuilder stringBuilder) {
        if (treePathFinder != null) {
            TreePathFinder.toString(treePathFinder.parent, stringBuilder);
            stringBuilder.append("DataBook: ");
            stringBuilder.append(treePathFinder.dataBook.getName());
            String[] stringArray = treePathFinder.dataBook.getRowDefinition().getPrimaryKeyColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("=");
                if (treePathFinder.primaryKeyValues == null && treePathFinder.primaryKeyValues.length <= i) {
                    stringBuilder.append("null");
                    continue;
                }
                stringBuilder.append(treePathFinder.primaryKeyValues[i]);
            }
            stringBuilder.append("\n");
        }
    }
}

