/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.IControl;
import javax.rad.ui.celleditor.ILinkedCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowDefinition
implements IRowDefinition,
Serializable {
    private static transient HashMap<Class<? extends IControl>, Class<? extends IControl>> hmClassLookup = new HashMap();
    private transient ArrayUtil<IDataBook> auDataBooks;
    private transient HashMap<Class<?>, ColumnView> hmColumnViews;
    private transient ColumnView defaultColumnView;
    private ArrayUtil<ColumnDefinition> auColumnDefinitions = new ArrayUtil();
    private ArrayUtil<String> auColumnNames = new ArrayUtil();
    private String[] saPKColumnNames;
    private static String[] saDefaultIgnoredColumnNames = new String[]{"id", "*_id", "*_intern", "ID", "*_ID", "*_INTERN"};
    private ArrayUtil<WeakReference<IControl>> auControls;

    @Override
    public void addDataBook(IDataBook iDataBook) throws ModelException {
        if (iDataBook != null && iDataBook.getRowDefinition() == this) {
            if (this.auDataBooks == null) {
                this.auDataBooks = new ArrayUtil();
                this.auDataBooks.add(iDataBook);
            } else if (this.auDataBooks.indexOfReference(iDataBook) < 0) {
                this.auDataBooks.add(iDataBook);
            }
        }
    }

    @Override
    public void removeDataBook(IDataBook iDataBook) {
        int n = this.auDataBooks.indexOfReference(iDataBook);
        if (n >= 0) {
            this.auDataBooks.remove(n);
        }
    }

    @Override
    public IDataBook[] getDataBooks() {
        if (this.auDataBooks == null) {
            return new IDataBook[0];
        }
        return this.auDataBooks.toArray(new IDataBook[this.auDataBooks.size()]);
    }

    @Override
    public IRowDefinition createRowDefinition(String[] stringArray) throws ModelException {
        if (stringArray == null) {
            return this;
        }
        RowDefinition rowDefinition = new RowDefinition();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDefinition columnDefinition = this.getColumnDefinition(stringArray[i]).clone();
            columnDefinition.setNullable(true);
            rowDefinition.addColumnDefinition(columnDefinition);
        }
        return rowDefinition;
    }

    @Override
    public void addColumnDefinition(ColumnDefinition columnDefinition) throws ModelException {
        if (columnDefinition != null) {
            if (columnDefinition.getRowDefinition() != null) {
                throw new ModelException("Column '" + columnDefinition.getName() + "' already added to another RowDefinition! - " + columnDefinition.getRowDefinition().toString());
            }
            if (this.auColumnNames.contains(columnDefinition.getName())) {
                throw new ModelException("Column '" + columnDefinition.getName() + "' already exists in RowDefinition!");
            }
            if (this.auDataBooks != null && this.auDataBooks.size() > 0) {
                throw new ModelException("RowDefinition already in IDataBook in use! -> Changes not possible! - " + this.auDataBooks.get(0).toString());
            }
            this.auColumnDefinitions.add(columnDefinition);
            this.auColumnNames.add(columnDefinition.getName());
            columnDefinition.setRowDefinition(this);
        }
    }

    @Override
    public ColumnDefinition getColumnDefinition(String string) throws ModelException {
        int n = this.auColumnNames.indexOf(string);
        if (n < 0) {
            throw new ModelException("Column '" + string + "' doesn't exists in RowDefinition! - Check that the DataBook is open or the column is added before.");
        }
        ColumnDefinition columnDefinition = this.auColumnDefinitions.get(n);
        return columnDefinition;
    }

    @Override
    public ColumnDefinition getColumnDefinition(int n) {
        return this.auColumnDefinitions.get(n);
    }

    @Override
    public int getColumnDefinitionIndex(String string) {
        return this.auColumnNames.indexOf(string);
    }

    @Override
    public int getColumnCount() {
        return this.auColumnDefinitions.size();
    }

    @Override
    public String[] getColumnNames() {
        return this.auColumnNames.toArray(new String[this.auColumnNames.size()]);
    }

    @Override
    public String[] getPrimaryKeyColumnNames() {
        if (this.saPKColumnNames == null) {
            return null;
        }
        return (String[])this.saPKColumnNames.clone();
    }

    @Override
    public void setPrimaryKeyColumnNames(String[] stringArray) throws ModelException {
        if (this.auDataBooks != null && this.auDataBooks.size() > 0) {
            throw new ModelException("RowDefinition already in IDataBook in use! -> Changes not possible! - " + this.auDataBooks.get(0).toString());
        }
        this.saPKColumnNames = stringArray == null ? null : (String[])stringArray.clone();
    }

    private Class<? extends IControl> getBaseControlClass(Class<? extends IControl> clazz) {
        Class<? extends IControl> clazz2 = hmClassLookup.get(clazz);
        if (clazz2 == null) {
            Class<? extends IControl> clazz3 = clazz.getSuperclass();
            if (clazz3 != null && IControl.class.isAssignableFrom(clazz3)) {
                clazz2 = this.getBaseControlClass(clazz3);
            } else {
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (classArray[i] == IControl.class || !IControl.class.isAssignableFrom(classArray[i])) continue;
                    clazz2 = this.getBaseControlClass(classArray[i]);
                }
            }
            if (clazz2 == null) {
                clazz2 = clazz;
            }
            hmClassLookup.put(clazz, clazz2);
        }
        return clazz2;
    }

    @Override
    public ColumnView getColumnView(Class<? extends IControl> clazz) {
        if (clazz == null || this.hmColumnViews == null) {
            if (this.defaultColumnView == null) {
                this.defaultColumnView = this.getDefaultColumnView();
                this.defaultColumnView.addRowDefinition(this);
            }
            return this.defaultColumnView;
        }
        ColumnView columnView = this.hmColumnViews.get(this.getBaseControlClass(clazz));
        if (columnView == null) {
            return this.getColumnView(null);
        }
        return columnView;
    }

    @Override
    public void setColumnView(Class<? extends IControl> clazz, ColumnView columnView) throws ModelException {
        ColumnView columnView2;
        if (columnView == null) {
            if (clazz == null) {
                this.defaultColumnView.removeRowDefinition(this);
                this.defaultColumnView = null;
            } else if (this.hmColumnViews != null && (columnView2 = this.hmColumnViews.remove(clazz)) != null) {
                columnView2.removeRowDefinition(this);
            }
        } else {
            this.checkColumnNames(columnView.getColumnNames());
            if (clazz == null) {
                if (this.defaultColumnView != null) {
                    this.defaultColumnView.removeRowDefinition(this);
                }
                this.defaultColumnView = columnView;
                this.defaultColumnView.addRowDefinition(this);
            } else {
                if (this.hmColumnViews == null) {
                    this.hmColumnViews = new HashMap();
                }
                if ((columnView2 = this.hmColumnViews.put(this.getBaseControlClass(clazz), columnView)) != null) {
                    columnView2.removeRowDefinition(this);
                }
                columnView.addRowDefinition(this);
            }
        }
        if (this.auDataBooks != null) {
            for (int i = 0; i < this.auDataBooks.size(); ++i) {
                IControl[] iControlArray;
                IDataBook iDataBook = this.auDataBooks.get(i);
                for (IControl iControl : iControlArray = iDataBook.getControls()) {
                    iControl.notifyRepaint();
                }
            }
        }
    }

    @Override
    public void setReadOnly(String[] stringArray) throws ModelException {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = this.getColumnNames();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.getColumnDefinition(stringArray[i]).setReadOnly(true);
        }
    }

    @Override
    public String[] getReadOnly() {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (int i = 0; i < this.auColumnDefinitions.size(); ++i) {
            if (!this.auColumnDefinitions.get(i).isReadOnly()) continue;
            arrayUtil.add(this.auColumnDefinitions.get(i).getName());
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    @Override
    public void addControl(IControl iControl) {
        if (this.auControls == null) {
            this.auControls = new ArrayUtil();
        } else {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                if (this.auControls.get(i).get() != null) continue;
                this.auControls.remove(i);
            }
        }
        if (this.auControls.indexOf(iControl) < 0) {
            this.auControls.add(new WeakReference<IControl>(iControl));
        }
    }

    @Override
    public void removeControl(IControl iControl) {
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl2 = (IControl)this.auControls.get(i).get();
                if (iControl2 != null && iControl2 != iControl) continue;
                this.auControls.remove(i);
            }
        }
    }

    @Override
    public IControl[] getControls() {
        ArrayUtil<IControl> arrayUtil = new ArrayUtil<IControl>();
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl = (IControl)this.auControls.get(i).get();
                if (iControl == null) {
                    this.auControls.remove(i);
                    continue;
                }
                arrayUtil.add(0, iControl);
            }
        }
        return arrayUtil.toArray(new IControl[arrayUtil.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RowDefinition :: ");
        for (int i = 0; i < this.auColumnDefinitions.size(); ++i) {
            ColumnDefinition columnDefinition = this.auColumnDefinitions.get(i);
            stringBuilder.append("[");
            stringBuilder.append(columnDefinition.getName());
            if (columnDefinition.isWritable()) {
                stringBuilder.append("(storeable)");
            }
            if (ArrayUtil.indexOf(this.saPKColumnNames, columnDefinition.getName()) >= 0) {
                stringBuilder.append("(PK)");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private void checkColumnNames(String[] stringArray) throws ModelException {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.getColumnDefinition(stringArray[i]);
        }
    }

    public ColumnView getDefaultColumnView() {
        if (this.getColumnCount() == 0) {
            throw new IllegalStateException("It is not allowed to call getDefaultColumnView, if the RowDefinition has no columns!");
        }
        ColumnView columnView = new ColumnView(new String[0]);
        int n = this.auColumnNames.size();
        for (int i = 0; i < n; ++i) {
            String string = this.auColumnNames.get(i);
            if (this.auColumnDefinitions.get(i).getDataType() instanceof BinaryDataType || RowDefinition.isColumnIgnored(string) || this.isMasterLinkColumn(string)) continue;
            columnView.addColumnNames(string);
        }
        return columnView;
    }

    public String[] getLinkReferenceColumnNames(String string) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        int n = this.auColumnDefinitions.size();
        for (int i = 0; i < n; ++i) {
            ReferenceDefinition referenceDefinition;
            ICellEditor iCellEditor = this.auColumnDefinitions.get(i).getDataType().getCellEditor();
            if (!(iCellEditor instanceof ILinkedCellEditor) || ArrayUtil.indexOf((referenceDefinition = ((ILinkedCellEditor)iCellEditor).getLinkReference()).getColumnNames(), string) < 0) continue;
            arrayUtil.add(this.auColumnNames.get(i));
        }
        if (arrayUtil.size() == 0) {
            return null;
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    public ReferenceDefinition getLinkReference(String string) {
        ReferenceDefinition referenceDefinition = null;
        int n = this.auColumnDefinitions.size();
        for (int i = 0; i < n; ++i) {
            ReferenceDefinition referenceDefinition2;
            ICellEditor iCellEditor = this.auColumnDefinitions.get(i).getDataType().getCellEditor();
            if (!(iCellEditor instanceof ILinkedCellEditor) || ArrayUtil.indexOf((referenceDefinition2 = ((ILinkedCellEditor)iCellEditor).getLinkReference()).getColumnNames(), string) < 0 || referenceDefinition != null && referenceDefinition2.getColumnNames().length >= referenceDefinition.getColumnNames().length) continue;
            referenceDefinition = referenceDefinition2;
        }
        return referenceDefinition;
    }

    public ReferenceDefinition getMasterReference() {
        if (this.auDataBooks != null) {
            int n = this.auDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = this.auDataBooks.get(i);
                if (iDataBook.getMasterReference() == null) continue;
                return iDataBook.getMasterReference();
            }
        }
        return null;
    }

    public boolean isMasterLinkColumn(String string) {
        ReferenceDefinition referenceDefinition = this.getMasterReference();
        ReferenceDefinition referenceDefinition2 = this.getLinkReference(string);
        return referenceDefinition != null && (ArrayUtil.indexOf(referenceDefinition.getColumnNames(), string) >= 0 || referenceDefinition2 != null && ArrayUtil.containsAll(referenceDefinition2.getColumnNames(), referenceDefinition.getColumnNames()));
    }

    public static void setDefaultIgnoredColumnNames(String ... stringArray) {
        saDefaultIgnoredColumnNames = stringArray;
    }

    public static String[] getDefaultIgnoredColumnNames() {
        return saDefaultIgnoredColumnNames;
    }

    public static boolean isColumnIgnored(String string) {
        if (saDefaultIgnoredColumnNames == null) {
            return false;
        }
        for (int i = 0; i < saDefaultIgnoredColumnNames.length; ++i) {
            if (!StringUtil.like(string, saDefaultIgnoredColumnNames[i])) continue;
            return true;
        }
        return false;
    }
}

