/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model;

import com.sibvisions.util.ArrayUtil;
import java.lang.ref.WeakReference;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ui.IControl;

public class ColumnView {
    private ArrayUtil<String> auColumnNames = new ArrayUtil();
    private ArrayUtil<WeakReference<IRowDefinition>> auRowDefinitions;

    public ColumnView(String ... stringArray) {
        this.addColumnNames(stringArray);
    }

    public ColumnView(ColumnView columnView) {
        this.addColumnNames(columnView.getColumnNames());
    }

    public ColumnView(IRowDefinition iRowDefinition) {
        this.addColumnNames(iRowDefinition.getColumnNames());
    }

    public ColumnView(IDataRow iDataRow) {
        this.addColumnNames(iDataRow.getRowDefinition().getColumnNames());
    }

    public int getColumnCount() {
        return this.auColumnNames.size();
    }

    public String getColumnName(int n) {
        return this.auColumnNames.get(n);
    }

    public int getColumnNameIndex(String string) {
        return this.auColumnNames.indexOf(string);
    }

    public String[] getColumnNames() {
        return this.auColumnNames.toArray(new String[this.auColumnNames.size()]);
    }

    public void setColumnNames(String ... stringArray) {
        this.auColumnNames.clear();
        this.addColumnNames(0, stringArray);
    }

    public void addColumnNames(String ... stringArray) {
        this.addColumnNames(this.auColumnNames.size(), stringArray);
    }

    public void addColumnNames(int n, String ... stringArray) {
        this.auColumnNames.addAll(n, (String[])stringArray);
        this.notifyRepaint();
    }

    public void removeColumnNames(String ... stringArray) {
        this.auColumnNames.removeAll((String[])stringArray);
        this.notifyRepaint();
    }

    public void removeColumnName(int n) {
        this.auColumnNames.remove(n);
        this.notifyRepaint();
    }

    public void moveColumnName(int n, int n2) {
        String string = this.auColumnNames.remove(n);
        this.auColumnNames.add(n2, string);
        this.notifyRepaint();
    }

    public void addRowDefinition(IRowDefinition iRowDefinition) {
        boolean bl = true;
        if (this.auRowDefinitions == null) {
            this.auRowDefinitions = new ArrayUtil();
        } else {
            for (int i = this.auRowDefinitions.size() - 1; i >= 0; --i) {
                IRowDefinition iRowDefinition2 = (IRowDefinition)this.auRowDefinitions.get(i).get();
                if (iRowDefinition2 == null) {
                    this.auRowDefinitions.remove(i);
                    continue;
                }
                if (iRowDefinition2 != iRowDefinition) continue;
                bl = false;
            }
        }
        if (bl) {
            this.auRowDefinitions.add(new WeakReference<IRowDefinition>(iRowDefinition));
        }
    }

    public void removeRowDefinition(IRowDefinition iRowDefinition) {
        if (this.auRowDefinitions != null) {
            for (int i = this.auRowDefinitions.size() - 1; i >= 0; --i) {
                IRowDefinition iRowDefinition2 = (IRowDefinition)this.auRowDefinitions.get(i).get();
                if (iRowDefinition2 != null && iRowDefinition2 != iRowDefinition) continue;
                this.auRowDefinitions.remove(i);
            }
        }
    }

    public IRowDefinition[] getRowDefinitions() {
        ArrayUtil<IRowDefinition> arrayUtil = new ArrayUtil<IRowDefinition>();
        if (this.auRowDefinitions != null) {
            for (int i = this.auRowDefinitions.size() - 1; i >= 0; --i) {
                IRowDefinition iRowDefinition = (IRowDefinition)this.auRowDefinitions.get(i).get();
                if (iRowDefinition == null) {
                    this.auRowDefinitions.remove(i);
                    continue;
                }
                arrayUtil.add(0, iRowDefinition);
            }
        }
        return arrayUtil.toArray(new IRowDefinition[arrayUtil.size()]);
    }

    public void notifyRepaint() {
        if (this.auRowDefinitions != null) {
            for (int i = this.auRowDefinitions.size() - 1; i >= 0; --i) {
                IDataBook[] iDataBookArray;
                IRowDefinition iRowDefinition = (IRowDefinition)this.auRowDefinitions.get(i).get();
                if (iRowDefinition == null) continue;
                for (IDataBook iDataBook : iDataBookArray = iRowDefinition.getDataBooks()) {
                    IControl[] iControlArray;
                    for (IControl iControl : iControlArray = iDataBook.getControls()) {
                        iControl.notifyRepaint();
                    }
                }
            }
        }
    }
}

