/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui.container;

import com.sibvisions.util.ArrayUtil;
import javax.rad.genui.UIContainer;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.UIImage;
import javax.rad.ui.IComponent;
import javax.rad.ui.IImage;
import javax.rad.ui.container.ITabsetPanel;
import javax.rad.ui.event.TabsetHandler;
import javax.rad.ui.event.UITabsetEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UITabsetPanel
extends UIContainer<ITabsetPanel>
implements ITabsetPanel {
    private ArrayUtil<IImage> images = new ArrayUtil();
    private ArrayUtil<String> texts = new ArrayUtil();

    public UITabsetPanel() {
        this(UIFactoryManager.getFactory().createTabsetPanel());
    }

    protected UITabsetPanel(ITabsetPanel iTabsetPanel) {
        super(iTabsetPanel);
        ((ITabsetPanel)this.uiResource).eventTabClosed().addListener(this, "doTabClosed");
        ((ITabsetPanel)this.uiResource).eventTabMoved().addListener(this, "doTabMoved");
    }

    @Override
    public void setTabPlacement(int n) {
        ((ITabsetPanel)this.uiResource).setTabPlacement(n);
    }

    @Override
    public int getTabPlacement() {
        return ((ITabsetPanel)this.uiResource).getTabPlacement();
    }

    @Override
    public void setEnabledAt(int n, boolean bl) {
        ((ITabsetPanel)this.uiResource).setEnabledAt(n, bl);
    }

    @Override
    public boolean isEnabledAt(int n) {
        return ((ITabsetPanel)this.uiResource).isEnabledAt(n);
    }

    @Override
    public void setTabLayoutPolicy(int n) {
        ((ITabsetPanel)this.uiResource).setTabLayoutPolicy(n);
    }

    @Override
    public int getTabLayoutPolicy() {
        return ((ITabsetPanel)this.uiResource).getTabLayoutPolicy();
    }

    @Override
    public void setSelectedIndex(int n) {
        ((ITabsetPanel)this.uiResource).setSelectedIndex(n);
    }

    @Override
    public int getSelectedIndex() {
        return ((ITabsetPanel)this.uiResource).getSelectedIndex();
    }

    @Override
    public IImage getIconAt(int n) {
        return this.images.get(n);
    }

    @Override
    public void setIconAt(int n, IImage iImage) {
        if (iImage instanceof UIImage) {
            ((ITabsetPanel)this.uiResource).setIconAt(n, (IImage)((UIImage)iImage).getUIResource());
        } else {
            ((ITabsetPanel)this.uiResource).setIconAt(n, iImage);
        }
        this.images.set(n, iImage);
    }

    @Override
    public void setClosableAt(int n, boolean bl) {
        ((ITabsetPanel)this.uiResource).setClosableAt(n, bl);
    }

    @Override
    public boolean isClosableAt(int n) {
        return ((ITabsetPanel)this.uiResource).isClosableAt(n);
    }

    @Override
    public void setDragable(boolean bl) {
        ((ITabsetPanel)this.uiResource).setDragable(bl);
    }

    @Override
    public boolean isDragable() {
        return ((ITabsetPanel)this.uiResource).isDragable();
    }

    @Override
    public void setTextAt(int n, String string) {
        ((ITabsetPanel)this.uiResource).setTextAt(n, this.translate(string));
        this.texts.set(n, string);
    }

    @Override
    public String getTextAt(int n) {
        return this.texts.get(n);
    }

    @Override
    public void setNavigationKeysEnabled(boolean bl) {
        ((ITabsetPanel)this.uiResource).setNavigationKeysEnabled(bl);
    }

    @Override
    public boolean isNavigationKeysEnabled() {
        return ((ITabsetPanel)this.uiResource).isNavigationKeysEnabled();
    }

    @Override
    public TabsetHandler eventTabClosed() {
        return ((ITabsetPanel)this.uiResource).eventTabClosed();
    }

    @Override
    public TabsetHandler eventTabMoved() {
        return ((ITabsetPanel)this.uiResource).eventTabMoved();
    }

    @Override
    public void add(IComponent iComponent, Object object, int n) {
        super.add(iComponent, this.translate((String)object), n);
        if (n < 0) {
            this.images.add(null);
            this.texts.add((String)object);
        } else {
            this.images.add(n, null);
            this.texts.add(n, (String)object);
        }
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        this.images.remove(n);
        this.texts.remove(n);
    }

    @Override
    public void updateTranslation() {
        boolean bl = this.isTranslationChanged();
        super.updateTranslation();
        if (bl) {
            int n = this.texts.size();
            for (int i = 0; i < n; ++i) {
                ((ITabsetPanel)this.uiResource).setTextAt(i, this.translate(this.texts.get(i)));
            }
        }
    }

    public void doTabClosed(UITabsetEvent uITabsetEvent) {
        int n = uITabsetEvent.getOldIndex();
        this.remove(n);
    }

    public void doTabMoved(UITabsetEvent uITabsetEvent) {
        int n = uITabsetEvent.getOldIndex();
        int n2 = uITabsetEvent.getNewIndex();
        IComponent iComponent = this.getComponent(n);
        String string = this.texts.get(n);
        IImage iImage = this.images.get(n);
        this.remove(n);
        this.add(iComponent, string, n2);
        this.setIconAt(n2, iImage);
    }
}

