/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import javax.rad.genui.UIImage;
import javax.rad.ui.IFactory;

public class UIFactoryManager {
    private static IFactory factory = null;
    private static Class factoryClass = null;
    private static ThreadLocal<IFactory> threadLocal = null;

    protected UIFactoryManager() {
    }

    public static IFactory getFactory() {
        IFactory iFactory;
        if (threadLocal != null && (iFactory = threadLocal.get()) != null) {
            return iFactory;
        }
        return factory;
    }

    public static void setFactoryInstance(IFactory iFactory) {
        if (factory == null) {
            factory = iFactory;
            factoryClass = iFactory.getClass();
            UIImage.setDefaults();
        } else if (iFactory == null || factory.getClass() != iFactory.getClass()) {
            throw new IllegalStateException("Only one factory class is supported per virtual machine instance!");
        }
    }

    public static IFactory getFactoryInstance(Class clazz) {
        try {
            if (factory == null) {
                if (threadLocal != null) {
                    throw new IllegalStateException("A static factory instance can not be created in threaded factory mode!");
                }
                factory = (IFactory)clazz.newInstance();
                factoryClass = clazz;
                UIImage.setDefaults();
            } else if (factoryClass != clazz) {
                throw new IllegalStateException("Only one factory class is supported per virtual machine instance!");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("It is impossible to instanciate an IFactory with the given class!", exception);
        }
        return factory;
    }

    public static void registerThreadFactoryInstance(IFactory iFactory) {
        try {
            boolean bl = false;
            if (factory != null) {
                throw new IllegalStateException("The threaded factory registration can not be used in static factory mode!");
            }
            if (factoryClass == null) {
                factoryClass = iFactory.getClass();
                threadLocal = new ThreadLocal();
                bl = true;
            } else if (factoryClass != iFactory.getClass()) {
                throw new IllegalStateException("Only one factory class is supported in per virtual machine instance!");
            }
            threadLocal.set(iFactory);
            if (bl) {
                UIImage.setDefaults();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("It is impossible to register the given IFactory!", exception);
        }
    }

    public static void unregisterThreadFactoryInstance() {
        if (threadLocal != null) {
            threadLocal.set(null);
        }
    }
}

