/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil {
    private static HashMap<Character, String> hmpReplaceCharacters = new HashMap();
    private static HashMap<String, Character> hmpReplaceReverseCharacters = new HashMap();

    private StringUtil() {
    }

    public static int[] getQuotedBoundaries(String string) {
        int[] nArray = new int[]{};
        int n = -1;
        boolean bl = false;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '\"' || i <= 0 || string.charAt(i - 1) == '\\') continue;
            boolean bl2 = bl = !bl;
            if (bl) {
                n = i;
                continue;
            }
            nArray = ArrayUtil.add(nArray, n);
            nArray = ArrayUtil.add(nArray, i);
        }
        return nArray;
    }

    public static ArrayUtil<String> separateList(String string, String string2, boolean bl) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        if (string != null) {
            if (!string.endsWith(string2)) {
                string = string + string2;
            }
            int n = 0;
            int n2 = 0;
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                String string3 = string.substring(n, n2);
                if (bl) {
                    string3 = string3.trim();
                }
                arrayUtil.add(string3);
                n = n2 + string2.length();
            }
        }
        return arrayUtil;
    }

    public static int[] parseInteger(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, string2, true);
        int[] nArray = new int[arrayUtil.size()];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt(arrayUtil.get(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = -1;
            }
        }
        return nArray;
    }

    private static boolean like(String string, int n, int n2, String string2, int n3, int n4) {
        int n5 = n;
        for (int i = n3; i < n4; ++i) {
            char c = string2.charAt(i);
            if (c == '*') {
                if (i == n4 - 1) {
                    return true;
                }
                int n6 = i + 1;
                while (n5 < n2) {
                    if (StringUtil.like(string, n5, n2, string2, n6, n4)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (n5 == n2) {
                return false;
            }
            if (c != '?' && c != string.charAt(n5)) {
                return false;
            }
            ++n5;
        }
        return n5 == n2;
    }

    public static boolean like(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtil.like(string, 0, string.length(), string2, 0, string2.length());
    }

    public static String formatInitCap(String string) {
        return StringUtil.formatInitCap(string, false);
    }

    public static String formatInitCap(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        boolean bl2 = true;
        int n2 = -1;
        int n3 = -1;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl3 = Character.isWhitespace(c);
            if (!bl3 && n2 == -1) {
                n2 = i;
            }
            if (n2 < 0) continue;
            if (Character.isLetter(c)) {
                if (bl2) {
                    c = Character.toUpperCase(c);
                    bl2 = false;
                } else {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else if (bl3 || c == '_') {
                bl3 = true;
                bl2 = true;
                if (!bl) {
                    stringBuilder.append(' ');
                }
            } else {
                stringBuilder.append(c);
            }
            if (bl3) continue;
            n3 = stringBuilder.length();
        }
        if (n2 >= 0 && n3 >= 0) {
            return stringBuilder.substring(0, n3);
        }
        return stringBuilder.toString();
    }

    public static String formatMemberName(String string) {
        return StringUtil.formatMethodName(null, string);
    }

    public static String formatMethodName(String string, String string2) {
        if (string2 != null && string2.trim().length() > 0) {
            if (string == null) {
                return Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
            }
            return string + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
        }
        return null;
    }

    public static String convertToMemberName(String string) {
        return StringUtil.convertToMethodName(null, string);
    }

    public static String convertToMethodName(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            int n = string2.length();
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                boolean bl3 = Character.isLetter(c);
                String string3 = hmpReplaceCharacters.get(Character.valueOf(c));
                if (!bl2 && (string3 != null || bl3)) {
                    bl2 = true;
                }
                if (!bl2) continue;
                if (string3 != null) {
                    if (bl) {
                        string3 = string3.length() > 0 ? Character.toUpperCase(string3.charAt(0)) + string3.substring(1).toLowerCase() : string3.toUpperCase();
                        bl = false;
                    } else {
                        string3 = string3.toLowerCase();
                    }
                    stringBuilder.append(string3);
                    continue;
                }
                if (bl3) {
                    if (bl) {
                        c = Character.toUpperCase(c);
                        bl = false;
                    } else {
                        c = Character.toLowerCase(c);
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if (Character.isWhitespace(c) || c == '_') {
                    bl = true;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c)) continue;
                stringBuilder.append(c);
            }
            if (stringBuilder.length() > 0) {
                if (string == null) {
                    return Character.toLowerCase(stringBuilder.charAt(0)) + stringBuilder.substring(1);
                }
                return string + Character.toUpperCase(stringBuilder.charAt(0)) + stringBuilder.substring(1);
            }
        }
        return null;
    }

    public static String convertToName(String string) {
        if (string != null && string.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                String string2 = hmpReplaceCharacters.get(Character.valueOf(c));
                if (!bl) {
                    if (string2 != null) {
                        bl = Character.isLetter(string2.charAt(0)) || Character.isDigit(string2.charAt(0));
                    } else {
                        boolean bl2 = bl = Character.isLetter(c) || Character.isDigit(c);
                    }
                }
                if (!bl) continue;
                if (string2 != null) {
                    stringBuilder.append(string2);
                    continue;
                }
                if (Character.isWhitespace(c) || !Character.isJavaIdentifierPart(c)) continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static String convertMethodNameToText(String string) {
        return StringUtil.convertMethodNameToText(string, false);
    }

    public static String convertMethodNameToText(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (bl) {
                    Character c2 = hmpReplaceReverseCharacters.get(String.valueOf(c));
                    if (c2 == null && i < n - 1 && (c2 = hmpReplaceReverseCharacters.get(string.substring(i, i + 2))) != null) {
                        ++i;
                    }
                    if (c2 != null) {
                        c = c2.charValue();
                    }
                }
                if (!bl2) {
                    bl2 = Character.isUpperCase(c);
                }
                if (!bl2) continue;
                if (stringBuilder.length() > 0 && Character.isUpperCase(c)) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static String getText(String string, TextType textType) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (textType) {
                case Letters: {
                    if (!Character.isLetter(c)) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case Digits: {
                    if (!Character.isDigit(c)) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case LettersDigits: {
                    if (!Character.isLetter(c) && !Character.isDigit(c)) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case LettersDigitsSpace: {
                    if (!Character.isLetter(c) && !Character.isDigit(c) && !Character.isSpaceChar(c)) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case LettersDigitsWhitespace: {
                    if (!Character.isLetter(c) && !Character.isDigit(c) && !Character.isWhitespace(c)) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case AZLetters: {
                    if ((c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case AZLettersDigits: {
                    if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && !Character.isDigit(c)) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case WithoutLeadingDigits: {
                    if (!bl) {
                        boolean bl2 = bl = !Character.isDigit(c);
                    }
                    if (!bl) continue block11;
                    stringBuilder.append(c);
                    continue block11;
                }
                case FromFirstLetter: {
                    if (!bl) {
                        bl = Character.isLetter(c);
                    }
                    if (!bl) continue block11;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String removeCharacters(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        if (cArray == null || cArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            int n2 = cArray.length;
            for (int j = 0; j < n2 && !bl; ++j) {
                bl = c == cArray[j];
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.deepToString(object, stringBuilder, new HashSet<Object>());
        return stringBuilder.toString();
    }

    private static void deepToString(Object object, StringBuilder stringBuilder, Set<Object> set) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (set.contains(object)) {
            stringBuilder.append("#REF#");
            return;
        }
        set.add(object);
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            stringBuilder.append('{');
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (n != 0) {
                    stringBuilder.append(", ");
                }
                StringUtil.deepToString(iterator.next(), stringBuilder, set);
                ++n;
            }
            stringBuilder.append('}');
        } else if (object instanceof Map) {
            Map map = (Map)object;
            stringBuilder.append('{');
            int n = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (n != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('[');
                StringUtil.deepToString(entry.getKey(), stringBuilder, set);
                stringBuilder.append(", ");
                StringUtil.deepToString(entry.getValue(), stringBuilder, set);
                stringBuilder.append(']');
                ++n;
            }
            stringBuilder.append('}');
        } else if (object instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)object;
            stringBuilder.append('{');
            int n = 0;
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (n != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('[');
                StringUtil.deepToString(k, stringBuilder, set);
                stringBuilder.append(", ");
                StringUtil.deepToString(dictionary.get(k), stringBuilder, set);
                stringBuilder.append(']');
                ++n;
            }
            stringBuilder.append('}');
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                stringBuilder.append('[');
                if (clazz == byte[].class) {
                    stringBuilder.append(Arrays.toString((byte[])object));
                } else if (clazz == short[].class) {
                    stringBuilder.append(Arrays.toString((short[])object));
                } else if (clazz == int[].class) {
                    stringBuilder.append(Arrays.toString((int[])object));
                } else if (clazz == long[].class) {
                    stringBuilder.append(Arrays.toString((long[])object));
                } else if (clazz == char[].class) {
                    stringBuilder.append(Arrays.toString((char[])object));
                } else if (clazz == float[].class) {
                    stringBuilder.append(Arrays.toString((float[])object));
                } else if (clazz == double[].class) {
                    stringBuilder.append(Arrays.toString((double[])object));
                } else if (clazz == boolean[].class) {
                    stringBuilder.append(Arrays.toString((boolean[])object));
                } else {
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (i != 0) {
                            stringBuilder.append(", ");
                        }
                        StringUtil.deepToString(objectArray[i], stringBuilder, set);
                    }
                }
                stringBuilder.append(']');
            } else {
                stringBuilder.append(object.toString());
            }
        }
        set.remove(object);
    }

    public static String removeQuotes(String string, String string2) {
        return StringUtil.removeQuotes(string, string2, string2);
    }

    public static String removeQuotes(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = string.lastIndexOf(string3);
        if (n >= 0 && n2 > n) {
            return string.substring(n + string2.length(), n2);
        }
        return string;
    }

    public static String quote(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c2 = string.charAt(i);
                if (c2 == c) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c2);
            }
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((n = stringBuilder.indexOf(string2, n)) >= 0) {
            stringBuilder.replace(n, n + string2.length(), string3);
            n += string3.length();
        }
        return stringBuilder.toString();
    }

    public static CaseSensitiveType getCaseSensitiveType(String string) {
        if (string == null) {
            return CaseSensitiveType.NoLetter;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            if (Character.isLowerCase(c)) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (!bl || !bl2) continue;
            return CaseSensitiveType.MixedCase;
        }
        if (bl2) {
            return CaseSensitiveType.LowerCase;
        }
        if (bl) {
            return CaseSensitiveType.UpperCase;
        }
        return CaseSensitiveType.NoLetter;
    }

    public static CharacterType getCharacterType(String string) {
        if (string == null) {
            return CharacterType.None;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) {
                bl = true;
            } else if (Character.isDigit(c)) {
                bl2 = true;
            } else if (Character.isWhitespace(c)) {
                bl3 = true;
                bl6 = true;
                if (Character.isSpaceChar(c)) {
                    bl4 = true;
                } else {
                    bl5 = true;
                }
            } else {
                bl6 = true;
                bl7 = true;
            }
            if (!bl || !bl2 || !bl3 || !bl7) continue;
            return CharacterType.All;
        }
        if (bl && bl2 && bl3 && !bl7) {
            if (bl4 && !bl5) {
                return CharacterType.LettersDigitsSpace;
            }
            return CharacterType.LettersDigitsWhitespace;
        }
        if (bl && bl2 && !bl3 && !bl7) {
            return CharacterType.LettersDigits;
        }
        if (bl && !bl2 && !bl3 && !bl7) {
            return CharacterType.Letters;
        }
        if (bl && !bl2 && (bl3 || bl7)) {
            return CharacterType.LettersSpecial;
        }
        if (bl2 && !bl && !bl3 && !bl7) {
            return CharacterType.Digits;
        }
        if (bl2 && !bl && (bl3 || bl7)) {
            return CharacterType.DigitsSpecial;
        }
        if (bl3 && !bl7) {
            return CharacterType.OnlyWhitespace;
        }
        if (bl6) {
            return CharacterType.OnlySpecial;
        }
        return CharacterType.None;
    }

    static {
        hmpReplaceReverseCharacters.put("ue", Character.valueOf('\u00fc'));
        hmpReplaceReverseCharacters.put("Ue", Character.valueOf('\u00dc'));
        hmpReplaceReverseCharacters.put("UE", Character.valueOf('\u00dc'));
        hmpReplaceReverseCharacters.put("ae", Character.valueOf('\u00e4'));
        hmpReplaceReverseCharacters.put("Ae", Character.valueOf('\u00c4'));
        hmpReplaceReverseCharacters.put("AE", Character.valueOf('\u00c4'));
        hmpReplaceReverseCharacters.put("oe", Character.valueOf('\u00f6'));
        hmpReplaceReverseCharacters.put("Oe", Character.valueOf('\u00d6'));
        hmpReplaceReverseCharacters.put("OE", Character.valueOf('\u00d6'));
        hmpReplaceReverseCharacters.put("ss", Character.valueOf('\u00df'));
        hmpReplaceCharacters.put(Character.valueOf('\u00a2'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u00a5'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u00a9'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u00aa'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u00ae'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u00c0'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u00c1'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u00c2'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u00c3'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u00c4'), "AE");
        hmpReplaceCharacters.put(Character.valueOf('\u00c5'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u00c6'), "AE");
        hmpReplaceCharacters.put(Character.valueOf('\u00c7'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u00c8'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u00c9'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u00ca'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u00cb'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u00cc'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u00cd'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u00ce'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u00cf'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u00d0'), "D");
        hmpReplaceCharacters.put(Character.valueOf('\u00d1'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u00d2'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u00d3'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u00d4'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u00d5'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u00d6'), "OE");
        hmpReplaceCharacters.put(Character.valueOf('\u00d7'), "x");
        hmpReplaceCharacters.put(Character.valueOf('\u00d8'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u00d9'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u00da'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u00db'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u00dc'), "UE");
        hmpReplaceCharacters.put(Character.valueOf('\u00dd'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u00df'), "ss");
        hmpReplaceCharacters.put(Character.valueOf('\u00e0'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u00e1'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u00e2'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u00e3'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u00e4'), "ae");
        hmpReplaceCharacters.put(Character.valueOf('\u00e5'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u00e6'), "ae");
        hmpReplaceCharacters.put(Character.valueOf('\u00e7'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u00e8'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u00e9'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u00ea'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u00eb'), "ae");
        hmpReplaceCharacters.put(Character.valueOf('\u00ec'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u00ed'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u00ee'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u00ef'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u00f0'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u00f1'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u00f2'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u00f3'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u00f4'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u00f5'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u00f6'), "oe");
        hmpReplaceCharacters.put(Character.valueOf('\u00f8'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u00f9'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u00fa'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u00fb'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u00fc'), "ue");
        hmpReplaceCharacters.put(Character.valueOf('\u00fd'), "y");
        hmpReplaceCharacters.put(Character.valueOf('\u00fe'), "b");
        hmpReplaceCharacters.put(Character.valueOf('\u00ff'), "y");
        hmpReplaceCharacters.put(Character.valueOf('\u0100'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u0101'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u0102'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u0103'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u0104'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u0105'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u0106'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u0107'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u0108'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u0109'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u010a'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u010b'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u010c'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u010d'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u010e'), "D");
        hmpReplaceCharacters.put(Character.valueOf('\u010f'), "d");
        hmpReplaceCharacters.put(Character.valueOf('\u0110'), "D");
        hmpReplaceCharacters.put(Character.valueOf('\u0111'), "d");
        hmpReplaceCharacters.put(Character.valueOf('\u0112'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0113'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0114'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0115'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0116'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0117'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0118'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0119'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u011a'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u011b'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u011c'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u011d'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u011e'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u011f'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u0120'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u0121'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u0122'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u0123'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u0124'), "H");
        hmpReplaceCharacters.put(Character.valueOf('\u0125'), "h");
        hmpReplaceCharacters.put(Character.valueOf('\u0126'), "H");
        hmpReplaceCharacters.put(Character.valueOf('\u0127'), "h");
        hmpReplaceCharacters.put(Character.valueOf('\u0128'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0129'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u012a'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u012b'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u012c'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u012d'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u012e'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u012f'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u0130'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u0131'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0132'), "IJ");
        hmpReplaceCharacters.put(Character.valueOf('\u0133'), "ij");
        hmpReplaceCharacters.put(Character.valueOf('\u0134'), "J");
        hmpReplaceCharacters.put(Character.valueOf('\u0135'), "j");
        hmpReplaceCharacters.put(Character.valueOf('\u0136'), "K");
        hmpReplaceCharacters.put(Character.valueOf('\u0137'), "k");
        hmpReplaceCharacters.put(Character.valueOf('\u0138'), "K");
        hmpReplaceCharacters.put(Character.valueOf('\u0139'), "L");
        hmpReplaceCharacters.put(Character.valueOf('\u013a'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u013b'), "L");
        hmpReplaceCharacters.put(Character.valueOf('\u013c'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u013d'), "L");
        hmpReplaceCharacters.put(Character.valueOf('\u013e'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u013f'), "L");
        hmpReplaceCharacters.put(Character.valueOf('\u0140'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0141'), "L");
        hmpReplaceCharacters.put(Character.valueOf('\u0142'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0143'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u0144'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u0145'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u0146'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u0147'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u0148'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u0149'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u014a'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u014b'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u014c'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u014d'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u014e'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u014f'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u0150'), "OE");
        hmpReplaceCharacters.put(Character.valueOf('\u0151'), "oe");
        hmpReplaceCharacters.put(Character.valueOf('\u0152'), "OE");
        hmpReplaceCharacters.put(Character.valueOf('\u0153'), "oe");
        hmpReplaceCharacters.put(Character.valueOf('\u0154'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u0155'), "r");
        hmpReplaceCharacters.put(Character.valueOf('\u0156'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u0157'), "r");
        hmpReplaceCharacters.put(Character.valueOf('\u0158'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u0159'), "r");
        hmpReplaceCharacters.put(Character.valueOf('\u015a'), "S");
        hmpReplaceCharacters.put(Character.valueOf('\u015b'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u015c'), "S");
        hmpReplaceCharacters.put(Character.valueOf('\u015d'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u015e'), "S");
        hmpReplaceCharacters.put(Character.valueOf('\u015f'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u0160'), "S");
        hmpReplaceCharacters.put(Character.valueOf('\u0161'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u0162'), "T");
        hmpReplaceCharacters.put(Character.valueOf('\u0163'), "t");
        hmpReplaceCharacters.put(Character.valueOf('\u0164'), "T");
        hmpReplaceCharacters.put(Character.valueOf('\u0165'), "t");
        hmpReplaceCharacters.put(Character.valueOf('\u0166'), "F");
        hmpReplaceCharacters.put(Character.valueOf('\u0167'), "f");
        hmpReplaceCharacters.put(Character.valueOf('\u0168'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u0169'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u016a'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u016b'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u016c'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u016d'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u016e'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u016f'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u0170'), "UE");
        hmpReplaceCharacters.put(Character.valueOf('\u0171'), "ue");
        hmpReplaceCharacters.put(Character.valueOf('\u0172'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u0173'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u0174'), "W");
        hmpReplaceCharacters.put(Character.valueOf('\u0175'), "w");
        hmpReplaceCharacters.put(Character.valueOf('\u0176'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u0177'), "y");
        hmpReplaceCharacters.put(Character.valueOf('\u0178'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u0179'), "Z");
        hmpReplaceCharacters.put(Character.valueOf('\u017a'), "z");
        hmpReplaceCharacters.put(Character.valueOf('\u017b'), "Z");
        hmpReplaceCharacters.put(Character.valueOf('\u017c'), "z");
        hmpReplaceCharacters.put(Character.valueOf('\u017d'), "Z");
        hmpReplaceCharacters.put(Character.valueOf('\u017e'), "z");
        hmpReplaceCharacters.put(Character.valueOf('\u0180'), "b");
        hmpReplaceCharacters.put(Character.valueOf('\u0181'), "B");
        hmpReplaceCharacters.put(Character.valueOf('\u0182'), "b");
        hmpReplaceCharacters.put(Character.valueOf('\u0183'), "b");
        hmpReplaceCharacters.put(Character.valueOf('\u0184'), "b");
        hmpReplaceCharacters.put(Character.valueOf('\u0185'), "b");
        hmpReplaceCharacters.put(Character.valueOf('\u0186'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u0187'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u0188'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u0189'), "D");
        hmpReplaceCharacters.put(Character.valueOf('\u018a'), "D");
        hmpReplaceCharacters.put(Character.valueOf('\u018e'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u018f'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0191'), "F");
        hmpReplaceCharacters.put(Character.valueOf('\u0192'), "f");
        hmpReplaceCharacters.put(Character.valueOf('\u0193'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u0194'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u0196'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0197'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0198'), "K");
        hmpReplaceCharacters.put(Character.valueOf('\u0199'), "k");
        hmpReplaceCharacters.put(Character.valueOf('\u019a'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u019d'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u019e'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u01a0'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u01a1'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u01a4'), "P");
        hmpReplaceCharacters.put(Character.valueOf('\u01a6'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u01a7'), "S");
        hmpReplaceCharacters.put(Character.valueOf('\u01a8'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u01aa'), "l");
        hmpReplaceCharacters.put(Character.valueOf('\u01ab'), "t");
        hmpReplaceCharacters.put(Character.valueOf('\u01ac'), "T");
        hmpReplaceCharacters.put(Character.valueOf('\u01ad'), "f");
        hmpReplaceCharacters.put(Character.valueOf('\u01ae'), "T");
        hmpReplaceCharacters.put(Character.valueOf('\u01af'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01b0'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u01b2'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01b3'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u01b4'), "y");
        hmpReplaceCharacters.put(Character.valueOf('\u01b5'), "Z");
        hmpReplaceCharacters.put(Character.valueOf('\u01b6'), "z");
        hmpReplaceCharacters.put(Character.valueOf('\u01bc'), "5");
        hmpReplaceCharacters.put(Character.valueOf('\u01bf'), "P");
        hmpReplaceCharacters.put(Character.valueOf('\u01c0'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u01c4'), "DZ");
        hmpReplaceCharacters.put(Character.valueOf('\u01c5'), "Dz");
        hmpReplaceCharacters.put(Character.valueOf('\u01c6'), "dz");
        hmpReplaceCharacters.put(Character.valueOf('\u01c7'), "LJ");
        hmpReplaceCharacters.put(Character.valueOf('\u01c8'), "Lj");
        hmpReplaceCharacters.put(Character.valueOf('\u01c9'), "lj");
        hmpReplaceCharacters.put(Character.valueOf('\u01ca'), "NJ");
        hmpReplaceCharacters.put(Character.valueOf('\u01cb'), "Nj");
        hmpReplaceCharacters.put(Character.valueOf('\u01cc'), "nj");
        hmpReplaceCharacters.put(Character.valueOf('\u01cd'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u01ce'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u01cf'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u01d0'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u01d1'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u01d2'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u01d3'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01d4'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u01d5'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01d6'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u01d7'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01d8'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u01d9'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01da'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u01db'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u01dc'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u01dd'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u01de'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u01df'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u01e0'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u01e1'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u01e3'), "AE");
        hmpReplaceCharacters.put(Character.valueOf('\u01e4'), "ae");
        hmpReplaceCharacters.put(Character.valueOf('\u01e4'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u01e5'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u01e6'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u01e7'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u01e8'), "K");
        hmpReplaceCharacters.put(Character.valueOf('\u01e9'), "k");
        hmpReplaceCharacters.put(Character.valueOf('\u01ea'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u01eb'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u01ec'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u01ed'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u01f0'), "J");
        hmpReplaceCharacters.put(Character.valueOf('\u01f1'), "DZ");
        hmpReplaceCharacters.put(Character.valueOf('\u01f2'), "Dz");
        hmpReplaceCharacters.put(Character.valueOf('\u01f3'), "dz");
        hmpReplaceCharacters.put(Character.valueOf('\u01f4'), "G");
        hmpReplaceCharacters.put(Character.valueOf('\u01f5'), "g");
        hmpReplaceCharacters.put(Character.valueOf('\u01f6'), "Hu");
        hmpReplaceCharacters.put(Character.valueOf('\u01f7'), "D");
        hmpReplaceCharacters.put(Character.valueOf('\u01f8'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u01f9'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u01fa'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u01fb'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u01fc'), "AE");
        hmpReplaceCharacters.put(Character.valueOf('\u01fd'), "ae");
        hmpReplaceCharacters.put(Character.valueOf('\u01fe'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u01ff'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u01f8'), "N");
        hmpReplaceCharacters.put(Character.valueOf('\u0200'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u0201'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u0202'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u0203'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u0204'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0205'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0206'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0207'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0208'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0209'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u020a'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u020b'), "i");
        hmpReplaceCharacters.put(Character.valueOf('\u020c'), "OE");
        hmpReplaceCharacters.put(Character.valueOf('\u020d'), "oe");
        hmpReplaceCharacters.put(Character.valueOf('\u020e'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u0210'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u0211'), "r");
        hmpReplaceCharacters.put(Character.valueOf('\u0212'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u0213'), "r");
        hmpReplaceCharacters.put(Character.valueOf('\u0214'), "UE");
        hmpReplaceCharacters.put(Character.valueOf('\u0215'), "ue");
        hmpReplaceCharacters.put(Character.valueOf('\u0216'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u0217'), "u");
        hmpReplaceCharacters.put(Character.valueOf('\u0218'), "S");
        hmpReplaceCharacters.put(Character.valueOf('\u0219'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u021a'), "T");
        hmpReplaceCharacters.put(Character.valueOf('\u021e'), "H");
        hmpReplaceCharacters.put(Character.valueOf('\u021f'), "h");
        hmpReplaceCharacters.put(Character.valueOf('\u0220'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u0221'), "d");
        hmpReplaceCharacters.put(Character.valueOf('\u0224'), "Z");
        hmpReplaceCharacters.put(Character.valueOf('\u0225'), "z");
        hmpReplaceCharacters.put(Character.valueOf('\u0226'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u0227'), "a");
        hmpReplaceCharacters.put(Character.valueOf('\u0228'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0229'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u022a'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u022b'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u022c'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u022d'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u022e'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u022f'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u0230'), "O");
        hmpReplaceCharacters.put(Character.valueOf('\u0231'), "o");
        hmpReplaceCharacters.put(Character.valueOf('\u0232'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u0233'), "y");
        hmpReplaceCharacters.put(Character.valueOf('\u0234'), "I");
        hmpReplaceCharacters.put(Character.valueOf('\u0235'), "n");
        hmpReplaceCharacters.put(Character.valueOf('\u0236'), "t");
        hmpReplaceCharacters.put(Character.valueOf('\u0237'), "J");
        hmpReplaceCharacters.put(Character.valueOf('\u023a'), "A");
        hmpReplaceCharacters.put(Character.valueOf('\u023b'), "C");
        hmpReplaceCharacters.put(Character.valueOf('\u023c'), "c");
        hmpReplaceCharacters.put(Character.valueOf('\u023d'), "t");
        hmpReplaceCharacters.put(Character.valueOf('\u023e'), "T");
        hmpReplaceCharacters.put(Character.valueOf('\u023f'), "s");
        hmpReplaceCharacters.put(Character.valueOf('\u0240'), "Z");
        hmpReplaceCharacters.put(Character.valueOf('\u0243'), "B");
        hmpReplaceCharacters.put(Character.valueOf('\u0244'), "U");
        hmpReplaceCharacters.put(Character.valueOf('\u0246'), "E");
        hmpReplaceCharacters.put(Character.valueOf('\u0247'), "e");
        hmpReplaceCharacters.put(Character.valueOf('\u0248'), "J");
        hmpReplaceCharacters.put(Character.valueOf('\u0249'), "j");
        hmpReplaceCharacters.put(Character.valueOf('\u024a'), "q");
        hmpReplaceCharacters.put(Character.valueOf('\u024b'), "q");
        hmpReplaceCharacters.put(Character.valueOf('\u024c'), "R");
        hmpReplaceCharacters.put(Character.valueOf('\u024d'), "r");
        hmpReplaceCharacters.put(Character.valueOf('\u024e'), "Y");
        hmpReplaceCharacters.put(Character.valueOf('\u024f'), "y");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextType {
        Letters,
        Digits,
        LettersDigits,
        LettersDigitsWhitespace,
        LettersDigitsSpace,
        AZLetters,
        AZLettersDigits,
        WithoutLeadingDigits,
        FromFirstLetter;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterType {
        Letters,
        Digits,
        LettersDigits,
        OnlyWhitespace,
        OnlySpecial,
        LettersSpecial,
        DigitsSpecial,
        LettersDigitsWhitespace,
        LettersDigitsSpace,
        All,
        None;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CaseSensitiveType {
        LowerCase,
        UpperCase,
        MixedCase,
        NoLetter;

    }
}

