/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.Internalize;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class LocaleUtil {
    private static Locale defaultLocale;
    private static ThreadLocal<Locale> threadDefaultLocale;

    private LocaleUtil() {
    }

    public static Locale forLanguageTag(String string) {
        Locale locale = Internalize.intern(Locale.getDefault());
        if (string == null || string.length() == 0) {
            return Locale.getDefault();
        }
        int n = string.indexOf(95);
        if (n < 0) {
            return Internalize.intern(new Locale(string));
        }
        int n2 = string.indexOf(95, n + 1);
        if (n2 < 0) {
            return Internalize.intern(new Locale(string.substring(0, n), string.substring(n + 1)));
        }
        return Internalize.intern(new Locale(string.substring(0, n), string.substring(n + 1, n2), string.substring(n2 + 1)));
    }

    public static Locale getDefault() {
        Locale locale;
        if (threadDefaultLocale != null && (locale = threadDefaultLocale.get()) != null) {
            return locale;
        }
        if (defaultLocale != null) {
            return defaultLocale;
        }
        return Locale.getDefault();
    }

    public static void setDefault(Locale locale) {
        defaultLocale = locale;
    }

    public static void setThreadDefault(Locale locale) {
        if (threadDefaultLocale == null) {
            threadDefaultLocale = new ThreadLocal();
        }
        threadDefaultLocale.set(locale);
    }

    public static String getListSeparator() {
        return LocaleUtil.getListSeparator(LocaleUtil.getDefault());
    }

    public static String getListSeparator(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        if (decimalFormatSymbols.getDecimalSeparator() == '.') {
            return ",";
        }
        return ";";
    }
}

