/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.FileSearch;
import com.sibvisions.util.type.DateUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            long l = 0L;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                l += (long)n;
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            long l2 = l;
            return l2;
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtil.copy(inputStream, false, outputStream, false);
    }

    public static long copy(InputStream inputStream, boolean bl, OutputStream outputStream, boolean bl2) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        if (bl) {
            inputStream.close();
        }
        if (bl2) {
            outputStream.close();
        }
        return l;
    }

    public static void copy(File file, File file2, String ... stringArray) throws IOException {
        FileUtil.copy(file, file2, CopyMode.Overwrite, stringArray);
    }

    public static void copy(File file, File file2, CopyMode copyMode, String ... stringArray) throws IOException {
        if (file.isFile()) {
            FileUtil.copyFile(file, file2, copyMode);
        } else if (file.isDirectory()) {
            FileUtil.copyDirectory(file, file2, copyMode, stringArray);
        } else {
            throw new IOException("File or directory is required: '" + file.getAbsolutePath() + "'!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2, CopyMode copyMode) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (file2.exists()) {
            if (copyMode == CopyMode.Keep) {
                return;
            }
            if (copyMode == CopyMode.Backup) {
                object3 = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
                object2 = FileUtil.getExtension(file2.getName());
                object = new File(file2.getParent(), FileUtil.removeExtension(file2.getName()) + "_" + (String)object3 + (object2 != null ? "." + (String)object2 : ""));
                if (!file2.renameTo((File)object)) {
                    throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + ((File)object).getAbsolutePath() + "'!");
                }
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            if (!file2.exists()) {
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    file3.mkdirs();
                }
            } else if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            object3 = new FileInputStream(file);
            object2 = new FileOutputStream(file2);
            object = ((FileInputStream)object3).getChannel();
            abstractInterruptibleChannel = ((FileOutputStream)object2).getChannel();
            long l = ((FileChannel)object).size();
            ((FileChannel)object).transferTo(0L, l, (WritableByteChannel)((Object)abstractInterruptibleChannel));
        }
        finally {
            if (object != null) {
                try {
                    ((AbstractInterruptibleChannel)object).close();
                }
                catch (IOException iOException) {}
            }
            if (object3 != null) {
                try {
                    ((FileInputStream)object3).close();
                }
                catch (IOException iOException) {}
            }
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (object2 != null) {
                try {
                    ((FileOutputStream)object2).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void copyDirectory(File file, File file2, CopyMode copyMode, String ... stringArray) throws IOException {
        File file3;
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        int n = file.getAbsolutePath().length();
        for (Map.Entry<String, List<String>> object : fileSearch.getFilesPerDirectory().entrySet()) {
            File file4 = new File(object.getKey());
            file3 = new File(file2, object.getKey().substring(n));
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("Can't create directory '" + file3.getAbsolutePath() + "'!");
            }
            for (String string : object.getValue()) {
                FileUtil.copyFile(new File(file4, string), new File(file3, string), copyMode);
            }
        }
        for (String string : fileSearch.getFoundDirectories()) {
            file3 = new File(file2, string.substring(n));
            if (file3.exists()) continue;
            file3.mkdirs();
        }
    }

    public static void move(File file, File file2) throws IOException {
        FileUtil.move(file, file2, CopyMode.Overwrite);
    }

    public static void move(File file, File file2, CopyMode copyMode) throws IOException {
        if (file.equals(file2)) {
            return;
        }
        if (file.isFile()) {
            FileUtil.moveFile(file, file2, copyMode);
        } else if (file.isDirectory()) {
            FileUtil.moveDirectory(file, file2, copyMode);
        } else {
            throw new IOException("File or directory is required: '" + file.getAbsolutePath() + "'!");
        }
    }

    private static void moveFile(File file, File file2, CopyMode copyMode) throws IOException {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (file2.isDirectory()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to directory '" + file2.getAbsolutePath() + "'!");
            }
            if (copyMode == null || copyMode == CopyMode.Overwrite) {
                if (!file2.delete()) {
                    throw new IOException("Can't overwrite '" + file2.getAbsolutePath() + "'!");
                }
            } else {
                if (copyMode == CopyMode.Keep) {
                    return;
                }
                String string = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
                String string2 = FileUtil.getExtension(file2.getName());
                File file3 = new File(file2.getParent(), FileUtil.removeExtension(file2.getName()) + "_" + string + (string2 != null ? "." + string2 : ""));
                if (!file2.renameTo(file3)) {
                    throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!");
                }
            }
        } else {
            File file4 = file2.getParentFile();
            if (file4 != null) {
                file4.mkdirs();
            }
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Can't move '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'!");
        }
    }

    private static void moveDirectory(File file, File file2, CopyMode copyMode) throws IOException {
        if (file2.exists()) {
            if (file2.isFile()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to file '" + file2.getAbsolutePath() + "'!");
            }
            if (copyMode == null || copyMode == CopyMode.Overwrite || copyMode == CopyMode.Keep) {
                FileUtil.copyDirectory(file, file2, copyMode, new String[0]);
                FileUtil.delete(file, new String[0]);
                return;
            }
            String string = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
            File file3 = new File(file2.getAbsolutePath() + "_" + string);
            if (!file2.renameTo(file3)) {
                throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!");
            }
        } else {
            file2.mkdirs();
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Can't move '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'!");
        }
    }

    public static byte[] getContent(InputStream inputStream) {
        return FileUtil.getContent(inputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(InputStream inputStream, boolean bl) {
        if (inputStream != null) {
            BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            try {
                int n;
                while ((n = bufferedInputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            catch (IOException iOException) {
                byte[] byArray3 = null;
                return byArray3;
            }
            finally {
                if (bl) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static byte[] getContent(File file) throws IOException {
        if (file == null) {
            throw new IOException("File not found: null");
        }
        return FileUtil.getContent(file.getAbsolutePath());
    }

    public static byte[] getContent(String string) throws IOException {
        if (string == null) {
            throw new IOException("File not found: null");
        }
        return FileUtil.getContent(new FileInputStream(string), true);
    }

    public static byte[] getContent(InputStreamReader inputStreamReader) {
        return FileUtil.getContent(inputStreamReader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(InputStreamReader inputStreamReader, boolean bl) {
        if (inputStreamReader != null) {
            OutputStreamWriter outputStreamWriter;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, inputStreamReader.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
            char[] cArray = new char[8192];
            try {
                int n;
                while ((n = inputStreamReader.read(cArray)) >= 0) {
                    outputStreamWriter.write(cArray, 0, n);
                }
                outputStreamWriter.flush();
                outputStreamWriter.close();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                if (bl) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static String removeExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static File getNotExistingFile(File file) {
        String string = FileUtil.getExtension(file.getName());
        String string2 = FileUtil.removeExtension(file.getName());
        int n = 1;
        while (file.exists()) {
            file = new File(file.getParent(), string2 + "[" + n + "]." + string);
            ++n;
        }
        return file;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getDirectory(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String formatAsDirectory(String string) {
        if (string == null) {
            return null;
        }
        char c = string.charAt(string.length() - 1);
        if (c == '\\' || c == '/') {
            return string;
        }
        return string + "/";
    }

    public static boolean delete(File file, String ... stringArray) {
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        for (String string : fileSearch.getFoundFiles()) {
            if (new File(string).delete()) continue;
            return false;
        }
        List<String> list = fileSearch.getFoundDirectories();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (new File((String)list.get(i)).delete()) continue;
            return false;
        }
        return !file.exists() || file.delete();
    }

    public static boolean deleteEmpty(File file, String ... stringArray) {
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        List<String> list = fileSearch.getFoundDirectories();
        for (int i = list.size() - 1; i >= 0; --i) {
            File file2 = new File(list.get(i));
            String[] stringArray2 = file2.list();
            if (stringArray2 == null || stringArray2.length != 0 || file2.delete()) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteIfEmpty(File ... fileArray) {
        for (File file : fileArray) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length != 0 || file.delete()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(OutputStream outputStream, int n, String ... stringArray) throws IOException {
        FileInputStream fileInputStream = null;
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream);
        CRC32 cRC32 = null;
        FileSearch fileSearch = new FileSearch();
        byte[] byArray = new byte[4096];
        zipOutputStream.setMethod(n);
        try {
            for (String string : stringArray) {
                fileSearch.clear();
                fileSearch.search(string, true, new String[0]);
                File file = new File(string);
                int n2 = file.isDirectory() ? file.getAbsolutePath().length() + 1 : file.getParent().length() + 1;
                for (String string2 : fileSearch.getFoundFiles()) {
                    int n3;
                    File file2 = new File(string2);
                    if (n == 0) {
                        cRC32 = new CRC32();
                        try {
                            fileInputStream = new FileInputStream(file2);
                            while ((n3 = fileInputStream.read(byArray)) >= 0) {
                                cRC32.update(byArray, 0, n3);
                            }
                        }
                        finally {
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    ZipEntry zipEntry = new ZipEntry(file2.getAbsolutePath().substring(n2).replace('\\', '/'));
                    if (n == 0) {
                        zipEntry.setSize(file2.length());
                        zipEntry.setTime(file2.lastModified());
                        zipEntry.setCrc(cRC32.getValue());
                    }
                    zipOutputStream.putNextEntry(zipEntry);
                    try {
                        fileInputStream = new FileInputStream(file2);
                        while ((n3 = fileInputStream.read(byArray)) >= 0) {
                            bufferedOutputStream.write(byArray, 0, n3);
                        }
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    bufferedOutputStream.flush();
                    zipOutputStream.closeEntry();
                }
            }
        }
        finally {
            try {
                bufferedOutputStream.close();
            }
            catch (Exception exception) {}
        }
        byArray = null;
        zipOutputStream = null;
        bufferedOutputStream = null;
        fileInputStream = null;
        fileSearch = null;
    }

    public static void unzip(InputStream inputStream, String string) throws IOException {
        FileUtil.unzip(inputStream, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[4096];
        File file2 = file;
        if (file2.exists() || file2.mkdirs()) {
            FilterOutputStream filterOutputStream = null;
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                zipInputStream = new ZipInputStream(inputStream);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    file2 = new File(file, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file2.mkdirs();
                        continue;
                    }
                    try {
                        int n;
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                        while ((n = zipInputStream.read(byArray)) != -1) {
                            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        if (filterOutputStream == null) continue;
                        try {
                            filterOutputStream.close();
                            filterOutputStream = null;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        throw new IOException("Can not create target directory: " + file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listZipEntries(InputStream inputStream) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                arrayUtil.add(zipEntry.getName());
            }
            ArrayUtil<String> arrayUtil2 = arrayUtil;
            return arrayUtil2;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            FileUtil.save(file, byteArrayInputStream);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, InputStream inputStream) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            filterOutputStream = null;
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void replace(File file, File file2, Hashtable<String, String> hashtable, String string) throws IOException {
        FileUtil.replace(file, file2, hashtable, string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(File file, File file2, Hashtable<String, String> hashtable, String string, String string2) throws IOException {
        block28: {
            FileInputStream fileInputStream = null;
            OutputStream outputStream = null;
            File file3 = null;
            try {
                boolean bl;
                fileInputStream = new FileInputStream(file);
                if (file == file2 || file.equals(file2)) {
                    bl = true;
                    if (file.length() <= 1024000L) {
                        outputStream = new ByteArrayOutputStream();
                    } else {
                        file3 = File.createTempFile(FileUtil.class.getName(), "jvx");
                        outputStream = new FileOutputStream(file3);
                    }
                } else {
                    bl = false;
                    outputStream = new FileOutputStream(file2);
                }
                FileUtil.replace(fileInputStream, outputStream, hashtable, string, string2);
                fileInputStream.close();
                fileInputStream = null;
                if (!bl) break block28;
                if (file3 != null && file.delete() && file3.renameTo(file)) {
                    bl = false;
                }
                if (!bl) break block28;
                if (outputStream instanceof ByteArrayOutputStream) {
                    FilterOutputStream filterOutputStream = null;
                    try {
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                        filterOutputStream.write(((ByteArrayOutputStream)outputStream).toByteArray());
                        break block28;
                    }
                    finally {
                        if (filterOutputStream != null) {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                FileUtil.copy(file3, file2, new String[0]);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (file3 != null && !file3.delete()) {
                    file3.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(InputStream inputStream, OutputStream outputStream, Hashtable<String, String> hashtable, String string, String string2) throws IOException {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter(outputStream, string2) : new OutputStreamWriter(outputStream);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            String string3 = System.getProperty("line.separator");
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                for (Map.Entry<String, String> entry : hashtable.entrySet()) {
                    string4 = StringUtil.replace(string4, entry.getKey(), entry.getValue());
                }
                bufferedWriter.write(string4);
                string4 = bufferedReader.readLine();
                if (string4 == null) continue;
                bufferedWriter.write(string3);
            }
            bufferedWriter.write(string3);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean like(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return FileUtil.like(string, 0, string.length(), string2, 0, string2.length());
    }

    private static boolean like(String string, int n, int n2, String string2, int n3, int n4) {
        int n5 = n;
        for (int i = n3; i < n4; ++i) {
            char c = string2.charAt(i);
            if (c == '*') {
                if (i + 1 < n4 && string2.charAt(i + 1) == '*') {
                    if (i + 1 == n4 - 1) {
                        return true;
                    }
                    int n6 = i + 2;
                    while (n5 < n2) {
                        if (FileUtil.like(string, n5, n2, string2, n6, n4)) {
                            return true;
                        }
                        ++n5;
                    }
                    return false;
                }
                int n7 = i + 1;
                int n8 = string.indexOf(47, n5);
                if (n8 < 0) {
                    n8 = string.indexOf(92, n5);
                }
                if (n8 < 0) {
                    if (i == n4 - 1) {
                        return true;
                    }
                    n8 = n2;
                } else {
                    ++n8;
                }
                int n9 = string2.indexOf(47, n7);
                if (n9 < 0) {
                    n9 = string2.indexOf(92, n7);
                }
                n9 = n9 < 0 ? n4 : ++n9;
                while (n5 < n8) {
                    if (FileUtil.like(string, n5, n8, string2, n7, n9) && FileUtil.like(string, n8, n2, string2, n9, n4)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (n5 == n2) {
                return false;
            }
            if (c != '?' && c != string.charAt(n5)) {
                return false;
            }
            ++n5;
        }
        return n5 == n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CopyMode {
        Backup,
        Overwrite,
        Keep;

    }
}

