/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.type.LocaleUtil;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtil {
    private SimpleDateFormat dateFormat;
    private Locale creationLocale = null;
    private String creationPattern = null;

    public DateUtil() {
        this(null);
    }

    public DateUtil(DateFormat dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public Date parse(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.creationLocale != null) {
            this.setDateFormatIntern(LocaleUtil.getDefault(), this.creationPattern);
        }
        return this.parseStringIntern(string);
    }

    public String format(Date date) {
        if (date == null) {
            return null;
        }
        if (this.creationLocale != null) {
            this.setDateFormatIntern(LocaleUtil.getDefault(), this.creationPattern);
        }
        return this.dateFormat.format(date);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    private void setDateFormatIntern(Locale locale, String string) {
        if (string == null) {
            if (locale != this.creationLocale || this.creationPattern != null) {
                this.dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 3, LocaleUtil.getDefault());
                this.creationLocale = locale;
                this.creationPattern = string;
            }
        } else if (locale != this.creationLocale || !string.equals(this.creationPattern)) {
            this.dateFormat = new SimpleDateFormat(string, LocaleUtil.getDefault());
            this.creationLocale = locale;
            this.creationPattern = string;
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            this.setDateFormatIntern(LocaleUtil.getDefault(), null);
        } else if (dateFormat instanceof SimpleDateFormat) {
            this.dateFormat = (SimpleDateFormat)dateFormat;
            this.creationLocale = null;
            this.creationPattern = null;
        } else {
            throw new IllegalArgumentException("Only SimpleDateFormat is supported!");
        }
    }

    public String getDatePattern() {
        return this.dateFormat.toPattern();
    }

    public void setDatePattern(String string) {
        if (string == null) {
            this.setDateFormat(null);
        } else {
            this.setDateFormatIntern(LocaleUtil.getDefault(), string);
        }
    }

    private String getPart(String string, String string2, DateFormatSymbols dateFormatSymbols) {
        block8: {
            try {
                int n = Integer.parseInt(string);
                if (string2.startsWith("MMM")) {
                    if (string2.length() == 3) {
                        return dateFormatSymbols.getShortMonths()[n - 1];
                    }
                    return dateFormatSymbols.getMonths()[n - 1];
                }
            }
            catch (Exception exception) {
                if (!string2.startsWith("M")) break block8;
                String string3 = string.toLowerCase();
                for (int i = 0; i < 12; ++i) {
                    if (!dateFormatSymbols.getMonths()[i].toLowerCase().startsWith(string3) && !dateFormatSymbols.getShortMonths()[i].toLowerCase().startsWith(string3)) continue;
                    int n = i + 1;
                    if (string2.length() == 2 && n < 10) {
                        return "0" + n;
                    }
                    if (string2.length() <= 2) {
                        return String.valueOf(n);
                    }
                    if (string2.length() == 3) {
                        return dateFormatSymbols.getShortMonths()[i];
                    }
                    return dateFormatSymbols.getMonths()[i];
                }
            }
        }
        return string;
    }

    private List<String>[] getParsed(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        boolean bl = Character.isLetterOrDigit(string.charAt(0));
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (bl == Character.isLetterOrDigit(c)) continue;
            String string2 = string.substring(n2, i);
            if (bl) {
                arrayList.add(string2);
            } else {
                arrayList2.add(string2);
            }
            n2 = i;
            bl = !bl;
        }
        String string3 = string.substring(n2);
        if (bl) {
            arrayList.add(string3);
        } else {
            arrayList2.add(string3);
        }
        List[] listArray = new List[]{arrayList, arrayList2};
        return listArray;
    }

    private Date parseStringIntern(String string) throws ParseException {
        try {
            return this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                DateFormatSymbols dateFormatSymbols = this.dateFormat.getDateFormatSymbols();
                String string2 = this.dateFormat.toPattern();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                String string3 = this.dateFormat.format(gregorianCalendar.getTime());
                List<String>[] listArray = this.getParsed(string2);
                List<String>[] listArray2 = this.getParsed(string);
                List<String>[] listArray3 = this.getParsed(string3);
                int n = listArray2[0].size();
                int n2 = listArray[1].size();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < listArray[0].size(); ++i) {
                    if (i < n) {
                        stringBuffer.append(this.getPart(listArray2[0].get(i), listArray[0].get(i), dateFormatSymbols));
                    } else {
                        stringBuffer.append(listArray3[0].get(i));
                    }
                    if (i >= n2) continue;
                    stringBuffer.append(listArray[1].get(i));
                }
                return this.dateFormat.parse(stringBuffer.toString());
            }
            catch (Exception exception) {
                throw new ParseException("Wrong Dateformat", 0);
            }
        }
    }

    public static String format(long l, String string) {
        return DateUtil.format(new Date(l), string);
    }

    public static String format(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static Date getDate(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, n);
        calendar.set(2, n2 - 1);
        calendar.set(1, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

