/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtil {
    private CommonUtil() {
    }

    public static String dump(Throwable throwable, boolean bl) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter(512);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (bl) {
            throwable.printStackTrace(printWriter);
        } else {
            printWriter.println(throwable);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                printWriter.println("\tat " + stackTraceElementArray[i]);
            }
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static Throwable getFirstCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static List<Throwable> getCauseList(Throwable throwable) {
        ArrayUtil<Throwable> arrayUtil = new ArrayUtil<Throwable>();
        if (throwable == null) {
            return arrayUtil;
        }
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            arrayUtil.add(throwable2);
            throwable2 = throwable2.getCause();
        }
        if (throwable2 != null) {
            arrayUtil.add(throwable2);
        }
        return arrayUtil;
    }

    public static <T> T nvl(T t, T t2) {
        if (t == null) {
            return t2;
        }
        return t;
    }

    public static boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort(int n, int n2) {
        ServerSocket serverSocket = null;
        for (int i = n; i <= n2; ++i) {
            try {
                serverSocket = new ServerSocket(i);
                serverSocket.setReuseAddress(true);
                int n3 = i;
                return n3;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(String string, int n) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(3000);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            socket.connect(inetSocketAddress, 3000);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

