/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class CodecUtil {
    private CodecUtil() {
    }

    public static String encodeURLPart(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (byte by : string.getBytes("ISO-8859-1")) {
                if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57 || by == 36 || by == 45 || by == 95 || by == 46 || by == 33 || by == 39 || by == 40 || by == 41 || by == 44 || by == 47) {
                    stringBuffer.append((char)by);
                    continue;
                }
                stringBuffer.append('%');
                stringBuffer.append(String.valueOf(Integer.toHexString((by & 0xFF) + 256)).substring(1));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encodeURLParameter(String string) {
        return CodecUtil.encodeURLParameter(string, "ISO-8859-1");
    }

    public static String encodeURLParameter(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decodeURLPart(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                ++n;
                if (c == '%') {
                    String string2 = string.substring(n, n + 2);
                    n += 2;
                    byteArrayOutputStream.write((byte)(Integer.parseInt(string2, 16) - 256 & 0xFF));
                    continue;
                }
                byteArrayOutputStream.write(c);
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return new String(byteArrayOutputStream.toByteArray(), "ISO-8859-1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decodeURLParameter(String string) {
        return CodecUtil.decodeURLParameter(string, "ISO-8859-1");
    }

    public static String decodeURLParameter(String string, String string2) {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String encodeHtml(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replace("&", "&amp;");
        string2 = string2.replace("\"", "&quot;");
        string2 = string2.replace("/", "&frasl;");
        string2 = string2.replace("<", "&lt;");
        string2 = string2.replace(">", "&gt;");
        string2 = string2.replace("\u00f6", "&ouml;");
        string2 = string2.replace("\u00fc", "&uuml;");
        string2 = string2.replace("\u00e4", "&auml;");
        string2 = string2.replace("\u00d6", "&Ouml;");
        string2 = string2.replace("\u00dc", "&Uuml;");
        string2 = string2.replace("\u00c4", "&Auml;");
        string2 = string2.replace("\u00df", "&szlig;");
        return string2;
    }

    public static String encodeHex(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return CodecUtil.encodeHex(string.getBytes("UTF-8"));
    }

    public static String encodeHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(String.valueOf(Integer.toHexString((byArray[i] & 0xFF) + 256)).substring(1));
        }
        return stringBuilder.toString();
    }

    public static String encodeHex(InputStream inputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        byte[] byArray = new byte[8192];
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(String.valueOf(Integer.toHexString((byArray[i] & 0xFF) + 256)).substring(1));
            }
        }
        return stringBuilder.toString();
    }

    public static String decodeHex(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(CodecUtil.decodeHexAsBytes(string), "UTF-8");
    }

    public static byte[] decodeHexAsBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n < n3) {
            byArray[n2] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            n += 2;
            ++n2;
        }
        return byArray;
    }
}

