/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.log.jdk;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.log.jdk.JdkLogger;
import com.sibvisions.util.log.jdk.JdkStandardLogger;
import com.sibvisions.util.type.ResourceUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class JdkLoggerFactory
extends LoggerFactory {
    private boolean bInit;

    public ILogger createLogger(String string) {
        if (this.bInit) {
            return new JdkLogger(string);
        }
        return new JdkStandardLogger(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        block13: {
            this.bInit = false;
            try {
                InputStream inputStream = ResourceUtil.getResourceAsStream("logging.properties");
                if (inputStream == null) break block13;
                try {
                    LogManager.getLogManager().readConfiguration(new BufferedInputStream(inputStream));
                    String string = LogManager.getLogManager().getProperty(".level");
                    try {
                        Level level = Level.parse(string);
                        Logger logger = Logger.getLogger("");
                        if (logger != null && level != null && logger.getLevel() != level) {
                            logger.setLevel(level);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                this.bInit = true;
            }
            catch (SecurityException securityException) {
                this.handleException(securityException);
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
    }

    protected void handleException(Exception exception) {
        if (exception instanceof IOException) {
            exception.printStackTrace();
        }
    }

    protected boolean isInitialized() {
        return this.bInit;
    }
}

