/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadHandler {
    private static ArrayUtil<WeakReference<Thread>> auCached = new ArrayUtil();
    private static ArrayUtil<WeakReference<Thread>> auStopped = new ArrayUtil();

    protected ThreadHandler() {
    }

    public static boolean add(Thread thread) {
        if (ThreadHandler.addIntern(thread)) {
            String string = thread.getName();
            thread.setName((string != null ? string + ": " : "") + thread.getClass().getName() + " -> " + new Exception().getStackTrace()[1]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addIntern(Thread thread) {
        ArrayUtil<WeakReference<Thread>> arrayUtil = auCached;
        synchronized (arrayUtil) {
            ThreadHandler.check(auCached);
            if (auCached.indexOf(thread) >= 0) {
                return false;
            }
            auCached.add(new WeakReference<Thread>(thread));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Thread thread) {
        ArrayUtil<WeakReference<Thread>> arrayUtil = auCached;
        synchronized (arrayUtil) {
            auCached.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread start(Runnable runnable) {
        if (runnable != null) {
            Object object;
            Thread thread;
            if (runnable instanceof Thread) {
                thread = (Thread)runnable;
                object = auCached;
                synchronized (object) {
                    if (thread.isAlive() || auCached.indexOf(thread) >= 0) {
                        return thread;
                    }
                }
                if (thread.getState() == Thread.State.TERMINATED) {
                    throw new IllegalStateException("Thread may not be restarted!");
                }
            } else {
                thread = new Thread(runnable);
            }
            if (ThreadHandler.addIntern(thread)) {
                object = thread.getName();
                thread.setName((object != null ? (String)object + ": " : "") + thread.getClass().getName() + " -> " + new Exception().getStackTrace()[1]);
                thread.start();
                return thread;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread stop(Thread thread) {
        if (thread == null) {
            return null;
        }
        ArrayUtil<WeakReference<Thread>> arrayUtil = auStopped;
        synchronized (arrayUtil) {
            auStopped.add(new WeakReference<Thread>(thread));
        }
        thread.interrupt();
        ThreadHandler.remove(thread);
        ThreadHandler.check(auStopped);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ArrayUtil<WeakReference<Thread>> arrayUtil;
        Object object = auCached;
        synchronized (object) {
            arrayUtil = new ArrayUtil<WeakReference<Thread>>((Collection<WeakReference<Thread>>)auCached);
        }
        for (WeakReference weakReference : arrayUtil) {
            object = (Thread)weakReference.get();
            if (object == null) continue;
            ThreadHandler.stop((Thread)object);
        }
    }

    public static boolean isStopped() {
        return ThreadHandler.isStopped(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStopped(Thread thread) {
        if (thread == null) {
            return true;
        }
        ArrayUtil<WeakReference<Thread>> arrayUtil = auStopped;
        synchronized (arrayUtil) {
            return auStopped.indexOf(thread) >= 0 || !thread.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void check(ArrayUtil<WeakReference<Thread>> arrayUtil) {
        ArrayUtil<WeakReference<Thread>> arrayUtil2;
        Object object = auCached;
        synchronized (object) {
            arrayUtil2 = new ArrayUtil<WeakReference<Thread>>((Collection<WeakReference<Thread>>)arrayUtil);
        }
        for (WeakReference weakReference : arrayUtil2) {
            object = (Thread)weakReference.get();
            if (object != null) continue;
            arrayUtil.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Thread> getAlive(ArrayUtil<WeakReference<Thread>> arrayUtil) {
        ArrayUtil<WeakReference<Thread>> arrayUtil2;
        Object object = arrayUtil;
        synchronized (object) {
            arrayUtil2 = new ArrayUtil<WeakReference<Thread>>((Collection<WeakReference<Thread>>)arrayUtil);
        }
        ArrayUtil<Thread> arrayUtil3 = new ArrayUtil<Thread>();
        Iterator iterator = arrayUtil2.iterator();
        while (iterator.hasNext()) {
            object = (Thread)((WeakReference)iterator.next()).get();
            if (object == null || !((Thread)object).isAlive()) {
                auStopped.remove(object);
                continue;
            }
            arrayUtil3.add((Thread)object);
        }
        return arrayUtil3;
    }

    public static List<Thread> getPendingStoppedThreads() {
        return ThreadHandler.getAlive(auStopped);
    }

    public static List<Thread> getRunningThreads() {
        return ThreadHandler.getAlive(auCached);
    }
}

