/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.StringUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflective {
    private Object oThreadFactory = null;
    private static ILogger log = LoggerFactory.getInstance(Reflective.class);
    private static Hashtable primitiveTypeClass = new Hashtable();
    private static Hashtable<Long, WeakReference<Constructor<?>>> htConstructorCache = null;
    private static Hashtable<Long, WeakReference<Method>> htMethodCache = null;

    public Reflective() {
        try {
            Class<?> clazz = Class.forName("javax.rad.genui.UIFactoryManager");
            try {
                Method method = clazz.getMethod("getFactory", new Class[0]);
                this.oThreadFactory = method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                log.error("'UIFactoryManager.getFactory()' threw an exception. Invoke direct!", exception);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug("'UIFactoryManager' is not available. Invoke direct!");
        }
    }

    public static final Object construct(String string, Object ... objectArray) throws Throwable {
        return Reflective.construct(Class.forName(string), objectArray);
    }

    public static final Object construct(ClassLoader classLoader, String string, Object ... objectArray) throws Throwable {
        return Reflective.construct(Class.forName(string, true, classLoader), objectArray);
    }

    public static final Object construct(Class<?> clazz, Object ... objectArray) throws Throwable {
        return Reflective.construct(clazz, false, objectArray);
    }

    public static final Object construct(Class<?> clazz, boolean bl, Object ... objectArray) throws Throwable {
        try {
            Constructor<?> constructor;
            long l = clazz.hashCode();
            if (objectArray == null || objectArray.length == 0) {
                constructor = Reflective.getConstructor(l);
                if (constructor == null) {
                    constructor = bl ? clazz.getDeclaredConstructor(new Class[0]) : clazz.getConstructor(new Class[0]);
                    Reflective.putConstructor(l, constructor);
                }
            } else {
                long l2 = l | (long)(objectArray == null ? 0 : objectArray.length) << 32;
                constructor = Reflective.getConstructor(l2);
                if (constructor == null || !Reflective.isParamListValid(constructor.getParameterTypes(), objectArray, constructor.isVarArgs())) {
                    Constructor<?>[] constructorArray = bl ? clazz.getDeclaredConstructors() : clazz.getConstructors();
                    constructor = null;
                    int n = constructorArray.length;
                    for (int i = 0; i < n && constructor == null; ++i) {
                        if (!Reflective.isParamListValid(constructorArray[i].getParameterTypes(), objectArray, constructorArray[i].isVarArgs())) continue;
                        constructor = constructorArray[i];
                        Reflective.putConstructor(l2, constructor);
                    }
                }
            }
            if (constructor != null) {
                return constructor.newInstance(Reflective.convertParameters(constructor.getParameterTypes(), objectArray, constructor.isVarArgs()));
            }
            throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, null, objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public static final Object call(Object object, String string, Object ... objectArray) throws Throwable {
        return Reflective.call(object, false, string, objectArray);
    }

    public static final Object call(Object object, boolean bl, String string, Object ... objectArray) throws Throwable {
        return Reflective.call(object, object.getClass(), bl, string, objectArray);
    }

    public static final Object call(Object object, Class<?> clazz, boolean bl, String string, Object ... objectArray) throws Throwable {
        try {
            Method method;
            long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 & 0xFFFFFF00000000L;
            if (objectArray == null || objectArray.length == 0) {
                method = Reflective.getMethod(l);
                if (method == null) {
                    method = bl ? clazz.getDeclaredMethod(string, new Class[0]) : clazz.getMethod(string, new Class[0]);
                    Reflective.putMethod(l, method);
                }
            } else {
                long l2 = l | (long)(objectArray == null ? 0 : objectArray.length) << 56;
                method = Reflective.getMethod(l2);
                if (method == null || !method.getName().equals(string) || !Reflective.isParamListValid(method.getParameterTypes(), objectArray, method.isVarArgs())) {
                    Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
                    method = null;
                    int n = methodArray.length;
                    for (int i = 0; i < n && method == null; ++i) {
                        if (!methodArray[i].getName().equals(string) || !Reflective.isParamListValid(methodArray[i].getParameterTypes(), objectArray, methodArray[i].isVarArgs())) continue;
                        method = methodArray[i];
                        Reflective.putMethod(l2, method);
                    }
                }
            }
            if (method != null) {
                return method.invoke(object, Reflective.convertParameters(method.getParameterTypes(), objectArray, method.isVarArgs()));
            }
            throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, string, objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static final boolean isParamListValid(Class<?>[] classArray, Object[] objectArray, boolean bl) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = classArray == null ? 0 : classArray.length;
        boolean bl2 = bl = bl || n2 > 0 && Object[].class.isAssignableFrom(classArray[n2 - 1]);
        if (bl) {
            --n2;
        }
        if (n == n2 || bl && n > n2) {
            int n3;
            for (n3 = 0; n3 < n2 && (classArray[n3].isPrimitive() && (objectArray[n3] != null && classArray[n3] == primitiveTypeClass.get(objectArray[n3].getClass()) || objectArray[n3] instanceof Parameter && ((Parameter)objectArray[n3]).clazz != null && classArray[n3] == primitiveTypeClass.get(((Parameter)objectArray[n3]).clazz)) || !classArray[n3].isPrimitive() && (objectArray[n3] == null || classArray[n3].isInstance(objectArray[n3])) || objectArray[n3] instanceof Parameter && ((Parameter)objectArray[n3]).clazz != null && classArray[n3].isAssignableFrom(((Parameter)objectArray[n3]).clazz)); ++n3) {
            }
            if (bl && n3 == n2) {
                if (n == n2 + 1 && classArray[n2].isInstance(objectArray[n3])) {
                    ++n3;
                } else {
                    Class<?> clazz = classArray[n2].getComponentType();
                    boolean bl3 = clazz.isPrimitive();
                    while (n3 < n && (bl3 && objectArray[n3] != null && clazz == primitiveTypeClass.get(objectArray[n3].getClass()) || !bl3 && (objectArray[n3] == null || clazz.isInstance(objectArray[n3])))) {
                        ++n3;
                    }
                }
            }
            return n3 == n;
        }
        return false;
    }

    private static final Object[] convertParameters(Class<?>[] classArray, Object[] objectArray, boolean bl) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = classArray == null ? 0 : classArray.length;
        boolean bl2 = bl = bl || n2 > 0 && Object[].class.isAssignableFrom(classArray[n2 - 1]);
        if (bl) {
            if (n != --n2 + 1 || !classArray[n2].isInstance(objectArray[n2])) {
                Object[] objectArray2 = new Object[n2 + 1];
                for (int i = 0; i < n2; ++i) {
                    objectArray2[i] = objectArray[i];
                }
                Class<?> clazz = classArray[n2].getComponentType();
                Object object = Array.newInstance(clazz, n - n2);
                int n3 = 0;
                for (int i = n2; i < n; ++i) {
                    Array.set(object, n3, objectArray[i]);
                    ++n3;
                }
                objectArray2[n2] = object;
                return objectArray2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Parameter)) continue;
                objectArray[i] = ((Parameter)objectArray[i]).value;
            }
        }
        return objectArray;
    }

    public static final String getMethodDeclaration(Class clazz, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            stringBuilder.append("new ");
        }
        stringBuilder.append(clazz.getCanonicalName());
        if (string != null) {
            stringBuilder.append('.');
            stringBuilder.append(string);
        }
        stringBuilder.append('(');
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (objectArray instanceof Class[]) {
                stringBuilder.append(((Class[])objectArray)[i].getName());
                continue;
            }
            if (objectArray[i] == null) {
                stringBuilder.append("null");
                continue;
            }
            if (objectArray[i] instanceof Parameter) {
                if (((Parameter)objectArray[i]).clazz != null) {
                    stringBuilder.append(((Parameter)objectArray[i]).clazz.getName());
                    continue;
                }
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(objectArray[i].getClass().getName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static void setValue(Object object, String string, Object object2) throws Throwable {
        Field field = object.getClass().getDeclaredField(string);
        Reflective.setValue(object, field, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(Object object, Field field, Object object2) throws Throwable {
        boolean bl = field.isAccessible();
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            field.set(object, object2);
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    public static Object getValue(Object object, String string) throws Throwable {
        Field field = object.getClass().getDeclaredField(string);
        return Reflective.getValue(object, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(Object object, Field field) throws Throwable {
        boolean bl = field.isAccessible();
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            Object object2 = field.get(object);
            return object2;
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Object object, Method method, Object ... objectArray) throws Throwable {
        boolean bl = method.isAccessible();
        if (!bl) {
            method.setAccessible(true);
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            return object2;
        }
        finally {
            if (!bl) {
                method.setAccessible(false);
            }
        }
    }

    public static Object get(Object object, String string) throws Throwable {
        Class<?> clazz = object.getClass();
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 & 0x7FFFFFFF00000000L;
        Method method = Reflective.getMethod(l);
        try {
            if (method == null) {
                method = clazz.getMethod(StringUtil.formatMethodName("get", string), new Class[0]);
                Reflective.putMethod(l, method);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public static void set(Object object, String string, Object object2) throws Throwable {
        Class<?> clazz = object.getClass();
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 | Long.MIN_VALUE;
        Method method = Reflective.getMethod(l);
        try {
            if (method == null) {
                method = clazz.getMethod(StringUtil.formatMethodName("set", string), clazz.getMethod(StringUtil.formatMethodName("get", string), new Class[0]).getReturnType());
                Reflective.putMethod(l, method);
            }
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public void invokeLater(Runnable runnable) {
        boolean bl = false;
        if (this.oThreadFactory != null) {
            try {
                Method method = this.oThreadFactory.getClass().getMethod("invokeLater", Runnable.class);
                method.invoke(this.oThreadFactory, runnable);
                log.debug("invokeLater() of '", this.oThreadFactory.getClass().getName(), "' successful called!");
            }
            catch (Exception exception) {
                log.info("An UI factory is available: '", this.oThreadFactory.getClass().getName(), "', but it's not possible to call invokeLater(). Invoke direct!");
                bl = true;
            }
        } else {
            log.info("UI factory is NOT available. Invoke direct!");
            bl = true;
        }
        if (bl) {
            runnable.run();
        }
    }

    private static final Method getMethod(long l) {
        Long l2;
        WeakReference<Method> weakReference;
        if (htMethodCache != null && (weakReference = htMethodCache.get(l2 = Long.valueOf(l))) != null) {
            Method method = (Method)weakReference.get();
            if (method == null) {
                htMethodCache.remove(l2);
            }
            return method;
        }
        return null;
    }

    private static final Constructor<?> getConstructor(long l) {
        Long l2;
        WeakReference<Constructor<?>> weakReference;
        if (htConstructorCache != null && (weakReference = htConstructorCache.get(l2 = Long.valueOf(l))) != null) {
            Constructor constructor = (Constructor)weakReference.get();
            if (constructor == null) {
                htConstructorCache.remove(l2);
            }
            return constructor;
        }
        return null;
    }

    private static final void putMethod(long l, Method method) {
        if (htMethodCache == null) {
            htMethodCache = new Hashtable();
        }
        htMethodCache.put(l, new WeakReference<Method>(method));
    }

    private static final void putConstructor(long l, Constructor<?> constructor) {
        if (htConstructorCache == null) {
            htConstructorCache = new Hashtable();
        }
        htConstructorCache.put(l, new WeakReference(constructor));
    }

    public static final void printFields(Object object, boolean bl) {
        Field[] fieldArray = bl ? (object instanceof Class ? ((Class)object).getDeclaredFields() : object.getClass().getDeclaredFields()) : (object instanceof Class ? ((Class)object).getFields() : object.getClass().getFields());
        for (Field field : fieldArray) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                System.out.println(field.getName() + " = " + field.get(object));
            }
            catch (Throwable throwable) {
                System.out.println(field.getName() + " = " + throwable.getMessage());
            }
        }
    }

    public static final void printMethods(Object object, boolean bl) {
        Method[] methodArray = bl ? (object instanceof Class ? ((Class)object).getDeclaredMethods() : object.getClass().getDeclaredMethods()) : (object instanceof Class ? ((Class)object).getMethods() : object.getClass().getMethods());
        for (Method method : methodArray) {
            if (method.getReturnType() == null || method.getParameterTypes() != null && method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") && !method.getName().startsWith("has")) continue;
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                System.out.println(method.getName() + " = " + method.invoke(object, new Object[0]));
            }
            catch (Throwable throwable) {
                System.out.println(method.getName() + " = " + throwable.getMessage());
            }
        }
    }

    private static final boolean isParamTypeListValid(Class<?>[] classArray, Class[] classArray2, boolean bl) {
        int n = classArray2 == null ? 0 : classArray2.length;
        int n2 = classArray == null ? 0 : classArray.length;
        boolean bl2 = bl = bl || n2 > 0 && Object[].class.isAssignableFrom(classArray[n2 - 1]);
        if (bl) {
            --n2;
        }
        if (n == n2 || bl && n > n2) {
            int n3;
            for (n3 = 0; n3 < n2 && (classArray[n3] == classArray2[n3] || classArray[n3].isAssignableFrom(classArray2[n3]) || primitiveTypeClass.get(classArray[n3]) == classArray2[n3] || classArray[n3] == primitiveTypeClass.get(classArray2[n3])); ++n3) {
            }
            if (bl && n3 == n2) {
                if (n == n2 + 1 && classArray[n2].isAssignableFrom(classArray2[n3])) {
                    ++n3;
                } else {
                    Class<?> clazz = classArray[n2].getComponentType();
                    while (n3 < n && (clazz == classArray2[n3] || clazz.isAssignableFrom(classArray2[n3]) || primitiveTypeClass.get(clazz) == classArray2[n3] || clazz == primitiveTypeClass.get(classArray2[n3]))) {
                        ++n3;
                    }
                }
            }
            return n3 == n;
        }
        return false;
    }

    public static final Method getMethod(Class<?> clazz, String string, Class ... classArray) throws NoSuchMethodException {
        return Reflective.getMethod(clazz, false, string, classArray);
    }

    public static final Method getMethod(Class<?> clazz, boolean bl, String string, Class ... classArray) throws NoSuchMethodException {
        Method method;
        long l = (long)clazz.hashCode() | (long)string.hashCode() << 32 & 0xFFFFFF00000000L;
        if (classArray == null || classArray.length == 0) {
            method = Reflective.getMethod(l);
            if (method == null) {
                method = bl ? clazz.getDeclaredMethod(string, new Class[0]) : clazz.getMethod(string, new Class[0]);
                Reflective.putMethod(l, method);
            }
        } else {
            long l2 = l | (long)(classArray == null ? 0 : classArray.length) << 56;
            method = Reflective.getMethod(l2);
            if (method == null || !method.getName().equals(string) || !Reflective.isParamTypeListValid(method.getParameterTypes(), classArray, method.isVarArgs())) {
                try {
                    method = clazz.getMethod(string, classArray);
                    Reflective.putMethod(l2, method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method[] methodArray = bl ? clazz.getDeclaredMethods() : clazz.getMethods();
                    method = null;
                    int n = methodArray.length;
                    for (int i = 0; i < n && method == null; ++i) {
                        if (!methodArray[i].getName().equals(string) || !Reflective.isParamTypeListValid(methodArray[i].getParameterTypes(), classArray, methodArray[i].isVarArgs())) continue;
                        method = methodArray[i];
                        Reflective.putMethod(l2, method);
                    }
                }
            }
        }
        if (method != null) {
            return method;
        }
        throw new NoSuchMethodException(Reflective.getMethodDeclaration(clazz, string, classArray));
    }

    static {
        primitiveTypeClass.put(Void.class, Void.TYPE);
        primitiveTypeClass.put(Boolean.class, Boolean.TYPE);
        primitiveTypeClass.put(Character.class, Character.TYPE);
        primitiveTypeClass.put(Byte.class, Byte.TYPE);
        primitiveTypeClass.put(Short.class, Short.TYPE);
        primitiveTypeClass.put(Integer.class, Integer.TYPE);
        primitiveTypeClass.put(Long.class, Long.TYPE);
        primitiveTypeClass.put(Float.class, Float.TYPE);
        primitiveTypeClass.put(Double.class, Double.TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameter {
        private Class<?> clazz;
        private Object value;

        public Parameter(Object object) {
            if (object != null) {
                this.clazz = object.getClass();
            }
            this.value = object;
        }

        public Parameter(Class<?> clazz, Object object) {
            if (clazz != null) {
                this.clazz = clazz;
            } else if (object != null) {
                this.clazz = object.getClass();
            }
            this.value = object;
            if (clazz != null && object != null && !clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Type-class class is not assignable from value class!");
            }
        }

        public Class<?> getTypeClass() {
            return this.clazz;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

