/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableArray<V> {
    private V[] array;
    private transient int hashCode = 0;

    public ImmutableArray(V ... VArray) {
        this.array = VArray;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            for (int i = 0; i < this.array.length; ++i) {
                V v = this.array[i];
                this.hashCode = 31 * this.hashCode + (v == null ? 0 : v.hashCode());
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableArray) {
            ImmutableArray immutableArray = (ImmutableArray)object;
            if (this.hashCode != 0 && immutableArray.hashCode != 0 && this.hashCode != immutableArray.hashCode) {
                return false;
            }
            if (this.array.length == immutableArray.array.length) {
                for (int i = 0; i < this.array.length; ++i) {
                    V v = this.array[i];
                    V v2 = immutableArray.array[i];
                    if (v == v2 || v != null && v.equals(v2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    public int size() {
        return this.array.length;
    }

    public V get(int n) {
        return this.array[n];
    }

    public ImmutableArray<V> set(int n, V v) {
        Object[] objectArray = (Object[])this.array.clone();
        objectArray[n] = v;
        return new ImmutableArray<Object>(objectArray);
    }

    public ImmutableArray<V> add(ImmutableArray<V> immutableArray) {
        return this.add(this.array.length, immutableArray);
    }

    public ImmutableArray<V> add(V ... VArray) {
        return this.add(this.array.length, VArray);
    }

    public ImmutableArray<V> add(int n, ImmutableArray<V> immutableArray) {
        if (immutableArray == null) {
            return this;
        }
        return this.add(n, immutableArray.array);
    }

    public ImmutableArray<V> add(int n, V ... VArray) {
        if (VArray == null || VArray.length == 0) {
            return this;
        }
        return new ImmutableArray<V>(ArrayUtil.addAll(this.array, n, VArray));
    }

    public int indexOf(V v) {
        return ArrayUtil.indexOf(this.array, v);
    }

    public boolean contains(V v) {
        return ArrayUtil.indexOf(this.array, v) >= 0;
    }

    public ImmutableArray<V> remove(ImmutableArray<V> immutableArray) {
        if (immutableArray == null) {
            return this;
        }
        return this.remove(immutableArray.array);
    }

    public ImmutableArray<V> remove(V ... VArray) {
        if (VArray == null || VArray.length == 0) {
            return this;
        }
        Object[] objectArray = (Object[])this.array.clone();
        int n = objectArray.length;
        for (int i = 0; i < VArray.length; ++i) {
            int n2 = this.indexOf(VArray[i]);
            if (n2 < 0) continue;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, --n - n2);
        }
        if (n == this.array.length) {
            return this;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(this.array.getClass().getComponentType(), n);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return new ImmutableArray<Object>(objectArray2);
    }

    public ImmutableArray<V> remove(int n) {
        return this.remove(n, 1);
    }

    public ImmutableArray<V> removeAll() {
        return this.remove(0, this.array.length);
    }

    public ImmutableArray<V> removeFirst() {
        return this.remove(0, 1);
    }

    public ImmutableArray<V> removeFirst(int n) {
        return this.remove(0, n);
    }

    public ImmutableArray<V> removeLast() {
        return this.remove(this.array.length - 1, 1);
    }

    public ImmutableArray<V> removeLast(int n) {
        return this.remove(this.array.length - n, n);
    }

    public ImmutableArray<V> remove(int n, int n2) {
        if (n2 == 0) {
            return this;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.array.getClass().getComponentType(), this.array.length - n2);
        System.arraycopy(this.array, 0, objectArray, 0, n);
        System.arraycopy(this.array, n + n2, objectArray, n, objectArray.length - n);
        return new ImmutableArray<Object>(objectArray);
    }

    public V[] toArray() {
        return (Object[])this.array.clone();
    }
}

