/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import java.io.File;
import java.io.IOException;

public final class FileViewer {
    private FileViewer() {
    }

    public static void open(File file) throws IOException {
        FileViewer.open('\"' + file.getAbsolutePath() + '\"');
    }

    public static void open(String string) throws IOException {
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.startsWith("windows")) {
            Runtime.getRuntime().exec(FileViewer.getCommandArray("rundll32 url.dll,FileProtocolHandler " + string));
        } else if (string2.indexOf("linux") >= 0) {
            String string3 = System.getenv("GDMSESSION");
            if (string3 == null) {
                string3 = System.getenv("DESKTOP_SESSION");
            }
            if (string3 == null) {
                throw new IOException("WindowManager detection failed!");
            }
            string3 = string3.toLowerCase();
            int n = -1;
            if (string3.indexOf("gnome") >= 0) {
                Process process = Runtime.getRuntime().exec(FileViewer.getCommandArray("gnome-open " + string));
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    n = -1;
                }
            } else if (string3.indexOf("kde") >= 0) {
                Process process = Runtime.getRuntime().exec(FileViewer.getCommandArray("kde-open " + string));
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    n = -1;
                }
            } else {
                n = -1;
            }
            if (n != 0) {
                Runtime.getRuntime().exec(FileViewer.getCommandArray("xdg-open " + string));
            }
        } else if (string2.indexOf("mac") >= 0) {
            Runtime.getRuntime().exec(FileViewer.getCommandArray("open " + string));
        } else {
            throw new IOException("The document [" + string + "] can not be opened!");
        }
    }

    private static String[] getCommandArray(String string) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl || " \t\n\r\f".indexOf(c) < 0) {
                if (c == '\"') {
                    bl = !bl;
                }
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer.length() <= 0) continue;
            arrayUtil.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (stringBuffer.length() > 0) {
            arrayUtil.add(stringBuffer.toString());
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }
}

