/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxStyledCellEditor;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.ext.text.NumberFormatter;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.ui.celleditor.INumberCellEditor;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxNumberCellEditor
extends JVxStyledCellEditor
implements INumberCellEditor,
ICellRenderer<Component> {
    private String numberFormat;
    private JLabel cellRenderer = null;
    private NumberFormatter numberFormatter = new NumberFormatter();

    public JVxNumberCellEditor() {
        this(null);
    }

    public JVxNumberCellEditor(String string) {
        this.setNumberFormat(string);
        this.setHorizontalAlignment(2);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, (ICellFormatterEditorListener)iCellEditorListener, iDataRow, string);
    }

    @Override
    public boolean isDirectCellEditor() {
        return false;
    }

    @Override
    public String getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setNumberFormat(String string) {
        this.numberFormat = string;
        this.numberFormatter.setNumberPattern(string);
    }

    @Override
    public Component getCellRendererComponent(Component component, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DefaultTableCellRenderer();
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            this.cellRenderer.setText(this.numberFormatter.valueToString(iDataRow.getValue(string)));
        }
        catch (Exception exception) {
            this.cellRenderer.setText(null);
        }
        return this.cellRenderer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    DocumentListener,
    FocusListener,
    KeyListener {
        private JVxNumberCellEditor cellEditor;
        private ICellFormatterEditorListener cellEditorListener;
        private IDataRow dataRow;
        private String columnName;
        private JFormattedTextField cellEditorComponent;
        private boolean ignoreEvent;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxNumberCellEditor jVxNumberCellEditor, ICellFormatterEditorListener iCellFormatterEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxNumberCellEditor;
            this.cellEditorListener = iCellFormatterEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setNumberPattern(this.cellEditor.getNumberFormat());
            try {
                numberFormatter.setDataType(this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            this.cellEditorComponent = new JFormattedTextField(numberFormatter);
            this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
            this.cellEditorComponent.setColumns(5);
            this.cellEditorComponent.getDocument().addDocumentListener(this);
            this.cellEditorComponent.setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addFocusListener(this);
            this.cellEditorComponent.addKeyListener(this);
            JVxUtil.installActions(this.cellEditorComponent);
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.getDocument().removeDocumentListener(this);
            this.cellEditorComponent.removeFocusListener(this);
            this.cellEditorComponent.removeKeyListener(this);
        }

        @Override
        public void updateEditor() {
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            try {
                this.cellEditorComponent.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.dataRow.setValue(this.columnName, this.cellEditorComponent.getValue());
        }

        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                try {
                    Font font;
                    Color color;
                    Object object;
                    boolean bl;
                    ColumnDefinition columnDefinition = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName);
                    this.cellEditorComponent.setValue(this.dataRow.getValue(this.columnName));
                    CellFormat cellFormat = null;
                    Container container = this.cellEditorComponent.getParent();
                    boolean bl2 = bl = container == null || container.isEnabled();
                    if (this.dataRow instanceof IDataBook) {
                        object = (IDataBook)this.dataRow;
                        this.cellEditorComponent.setEditable(bl && object.isUpdateEnabled() && !columnDefinition.isReadOnly() && object.getSelectedRow() >= 0);
                        if (this.cellEditorListener.getCellFormatter() != null) {
                            try {
                                cellFormat = this.cellEditorListener.getCellFormatter().getCellFormat((IDataBook)object, object.getDataPage(), (IDataRow)object, this.columnName, object.getSelectedRow(), -1);
                            }
                            catch (ModelException modelException) {}
                        }
                    } else {
                        this.cellEditorComponent.setEditable(bl && !columnDefinition.isReadOnly());
                    }
                    if (cellFormat == null) {
                        object = null;
                        color = null;
                        font = null;
                    } else {
                        object = cellFormat.getBackground();
                        color = cellFormat.getForeground();
                        font = cellFormat.getFont();
                    }
                    if (font == null) {
                        font = ((Component)((Object)this.cellEditorListener)).getFont();
                    }
                    if (color == null && ((Component)((Object)this.cellEditorListener)).isForegroundSet()) {
                        color = ((Component)((Object)this.cellEditorListener)).getForeground();
                    }
                    if (object == null && ((Component)((Object)this.cellEditorListener)).isBackgroundSet()) {
                        object = ((Component)((Object)this.cellEditorListener)).getBackground();
                    }
                    this.cellEditorComponent.setFont(font);
                    if (this.cellEditorComponent.isEditable()) {
                        if (object == null) {
                            object = columnDefinition.isNullable() ? JVxUtil.getSystemColor("IControl.background") : JVxUtil.getSystemColor("IControl.mandatoryBackground");
                        }
                        if (this.cellEditorComponent.hasFocus()) {
                            this.cellEditorComponent.selectAll();
                        } else {
                            this.cellEditorComponent.select(0, 0);
                        }
                    } else {
                        object = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                        this.cellEditorComponent.select(0, 0);
                    }
                    this.cellEditorComponent.setBackground((Color)object);
                    this.cellEditorComponent.setForeground(color);
                }
                catch (Exception exception) {
                    this.cellEditorComponent.setValue(null);
                    this.cellEditorComponent.setEditable(false);
                    this.cellEditorComponent.setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
                    throw new ModelException("Editor cannot be restored!", exception);
                }
                finally {
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(EventQueue.getCurrentEvent() instanceof FocusEvent)) {
                this.fireEditingStarted();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.cellEditorComponent.isEditable()) {
                this.cellEditorComponent.setText(this.cellEditorComponent.getText());
                this.cellEditorComponent.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.fireEditingComplete("FOCUS_LOST");
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.fireEditingComplete("ESCAPE_KEY");
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY");
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY");
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY");
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY");
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                this.cellEditorListener.editingComplete(string);
            }
        }
    }
}

