/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.swing.ext.JVxChoice;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxStyledCellEditor;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxChoiceRenderer;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.ui.celleditor.IChoiceCellEditor;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxChoiceCellEditor
extends JVxStyledCellEditor
implements IChoiceCellEditor<Component> {
    private Object[] allowedValues;
    private String[] imageNames;
    private String defaultImageName;
    private JVxChoiceRenderer cellRenderer = null;

    public JVxChoiceCellEditor() {
        this(null, null);
    }

    public JVxChoiceCellEditor(Object[] objectArray, String[] stringArray) {
        this.setAllowedValues(objectArray);
        this.setImageNames(stringArray);
        this.setHorizontalAlignment(1);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, iCellEditorListener, iDataRow, string);
    }

    @Override
    public Component getCellRendererComponent(Component component, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new JVxChoiceRenderer();
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        this.cellRenderer.setAllowedValues(this.allowedValues);
        this.cellRenderer.setImages(this.getImages());
        this.cellRenderer.setDefaultImage(this.getDefaultImage());
        try {
            this.cellRenderer.setSelectedItem(iDataRow.getValue(string));
        }
        catch (Exception exception) {
            this.cellRenderer.setSelectedItem(null);
        }
        return this.cellRenderer;
    }

    @Override
    public boolean isDirectCellEditor() {
        return true;
    }

    @Override
    public Object[] getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public void setAllowedValues(Object[] objectArray) {
        this.allowedValues = objectArray;
        this.cellRenderer = null;
    }

    @Override
    public String[] getImageNames() {
        return this.imageNames;
    }

    @Override
    public void setImageNames(String[] stringArray) {
        this.imageNames = stringArray;
        this.cellRenderer = null;
    }

    @Override
    public String getDefaultImageName() {
        return this.defaultImageName;
    }

    @Override
    public void setDefaultImageName(String string) {
        this.defaultImageName = string;
    }

    private Image[] getImages() {
        if (this.imageNames == null) {
            return null;
        }
        Image[] imageArray = new Image[this.imageNames.length];
        for (int i = 0; i < this.imageNames.length; ++i) {
            imageArray[i] = JVxUtil.getImage(this.imageNames[i]);
        }
        return imageArray;
    }

    private Image getDefaultImage() {
        if (this.defaultImageName == null) {
            return null;
        }
        return JVxUtil.getImage(this.defaultImageName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    ItemListener,
    KeyListener,
    FocusListener {
        private JVxChoiceCellEditor cellEditor;
        private ICellEditorListener cellEditorListener;
        private IDataRow dataRow;
        private String columnName;
        private JVxChoice cellEditorComponent;
        private boolean ignoreEvent = false;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxChoiceCellEditor jVxChoiceCellEditor, ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxChoiceCellEditor;
            this.cellEditorListener = iCellEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.cellEditorComponent = new JVxChoice();
            this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
            this.cellEditorComponent.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.cellEditor.getVerticalAlignment()));
            this.cellEditorComponent.setAllowedValues(this.convertAllowedValues(this.cellEditor.getAllowedValues()));
            this.cellEditorComponent.setImages(this.cellEditor.getImages());
            this.cellEditorComponent.setDefaultImage(this.cellEditor.getDefaultImage());
            this.cellEditorComponent.setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addItemListener(this);
            this.cellEditorComponent.addKeyListener(this);
            this.cellEditorComponent.addFocusListener(this);
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.removeItemListener(this);
            this.cellEditorComponent.removeKeyListener(this);
            this.cellEditorComponent.removeFocusListener(this);
        }

        @Override
        public void updateEditor() {
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            this.dataRow.setValue(this.columnName, this.cellEditorComponent.getSelectedItem());
        }

        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                Container container = this.cellEditorComponent.getParent();
                boolean bl = container == null || container.isEnabled();
                try {
                    this.cellEditorComponent.setSelectedItem(this.dataRow.getValue(this.columnName));
                    if (this.dataRow instanceof IDataBook) {
                        IDataBook iDataBook = (IDataBook)this.dataRow;
                        this.cellEditorComponent.setEditable(bl && iDataBook.isUpdateEnabled() && !iDataBook.getRowDefinition().getColumnDefinition(this.columnName).isReadOnly() && iDataBook.getSelectedRow() >= 0);
                    } else {
                        this.cellEditorComponent.setEditable(bl && !this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).isReadOnly());
                    }
                }
                catch (Exception exception) {
                    this.cellEditorComponent.setSelectedItem(null);
                    this.cellEditorComponent.setEditable(false);
                    throw new ModelException("Editor cannot be restored!", exception);
                }
                finally {
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.fireEditingStarted();
                this.fireEditingComplete("ACTION_KEY");
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.fireEditingComplete("ESCAPE_KEY");
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY");
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY");
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY");
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY");
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.fireEditingComplete("FOCUS_LOST");
            }
        }

        private Object[] convertAllowedValues(Object[] objectArray) {
            try {
                IDataType iDataType = this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getDataType();
                Object[] objectArray2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray2.length; ++i) {
                    try {
                        objectArray2[i] = iDataType.convertToTypeClass(objectArray[i]);
                        continue;
                    }
                    catch (ModelException modelException) {
                        objectArray2[i] = objectArray[i];
                    }
                }
                return objectArray2;
            }
            catch (Exception exception) {
                return objectArray;
            }
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                this.cellEditorListener.editingComplete(string);
            }
        }
    }
}

