/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxScrollPane;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.format.ICellFormatter;
import com.sibvisions.rad.ui.swing.ext.format.INodeFormatter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ITreeControl;
import javax.rad.ui.control.ITree;
import javax.rad.util.ExceptionHandler;
import javax.rad.util.TranslationMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JVxTree
extends JVxScrollPane
implements ITreeControl,
ICellFormatterEditorListener,
Runnable,
TreeSelectionListener {
    private JTree tree = new JTree();
    private IDataBook[] dataBooks = null;
    private IDataBook selfJoinedDataBook = null;
    private int maxLength = 0;
    private ICellFormatter cellFormatter = null;
    private INodeFormatter nodeFormatter = null;
    private TranslationMap translation = null;
    private boolean editable = true;
    private boolean detectEndNode = false;
    private boolean firstNotifyRepaintCall = true;
    private boolean ignoreEvent = false;
    private boolean isNotified = false;

    public JVxTree() {
        this.setViewportView(this.tree);
        DataRowTreeCellRenderer dataRowTreeCellRenderer = new DataRowTreeCellRenderer();
        this.tree.setCellRenderer(dataRowTreeCellRenderer);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellEditor(new DataRowTreeCellEditor(this.tree, dataRowTreeCellRenderer));
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(20);
        this.tree.addMouseListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.ignoreEvent = true;
        this.tree.scrollRectToVisible(new Rectangle());
        this.tree.getSelectionModel().clearSelection();
        this.ignoreEvent = false;
        this.isNotified = true;
        this.notifyRepaint();
    }

    public void removeNotify() {
        this.isNotified = false;
        super.removeNotify();
    }

    public ICellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public void setCellFormatter(ICellFormatter iCellFormatter) {
        this.cellFormatter = iCellFormatter;
    }

    public INodeFormatter getNodeFormatter() {
        return this.nodeFormatter;
    }

    public void setNodeFormatter(INodeFormatter iNodeFormatter) {
        this.nodeFormatter = iNodeFormatter;
    }

    private static boolean isAllValid(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (((DataPageNode)objectArray[i]).isValidNode()) continue;
            return false;
        }
        return true;
    }

    private void doRepaint() {
        if (!this.ignoreEvent && this.dataBooks != null) {
            Object object;
            for (int i = 0; i < this.dataBooks.length; ++i) {
                object = this.dataBooks[i];
                if (object != null && object.isOpen()) continue;
                return;
            }
            this.ignoreEvent = true;
            try {
                int n;
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
                object = (DataPageNode)defaultTreeModel.getRoot();
                ((DataPageNode)object).dataPage = this.dataBooks[0].getDataPage();
                TreePath treePath = new TreePath(object);
                Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
                defaultTreeModel.reload((TreeNode)object);
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        TreePath treePath2 = enumeration.nextElement();
                        if (!JVxTree.isAllValid(treePath2.getPath())) continue;
                        this.tree.expandPath(treePath2);
                    }
                }
                boolean bl = true;
                int n2 = -1;
                for (int i = 0; i < this.maxLength; ++i) {
                    n = this.dataBooks[i].getSelectedRow();
                    if (bl) {
                        boolean bl2 = bl = n >= 0;
                        if (!bl) continue;
                        n2 = i;
                        object = (DataPageNode)((DataPageNode)object).getChildAt(n);
                        treePath = treePath.pathByAddingChild(object);
                        continue;
                    }
                    this.dataBooks[i].setSelectedRow(-1);
                }
                if (this.selfJoinedDataBook != null) {
                    if (bl) {
                        javax.rad.model.TreePath treePath3 = this.selfJoinedDataBook.getTreePath();
                        for (n = 0; n < treePath3.length(); ++n) {
                            object = (DataPageNode)((DataPageNode)object).getChildAt(treePath3.get(n));
                            treePath = treePath.pathByAddingChild(object);
                        }
                        if (this.selfJoinedDataBook.getSelectedRow() < 0) {
                            if (treePath3.length() > 0) {
                                this.selfJoinedDataBook.setTreePath(treePath3.getParentPath());
                                this.selfJoinedDataBook.setSelectedRow(treePath3.getLast());
                            }
                        } else {
                            object = (DataPageNode)((DataPageNode)object).getChildAt(this.selfJoinedDataBook.getSelectedRow());
                            treePath = treePath.pathByAddingChild(object);
                        }
                    } else {
                        this.selfJoinedDataBook.setTreePath(null);
                        this.selfJoinedDataBook.setSelectedRow(-1);
                    }
                }
                this.tree.setEditable(this.editable && n2 >= 0 && !this.dataBooks[n2].isReadonly());
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
                this.ignoreEvent = false;
            }
            catch (Exception exception) {
                this.ignoreEvent = false;
                exception.printStackTrace();
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.ignoreEvent) {
            this.ignoreEvent = true;
            try {
                int n;
                TreePath treePath = treeSelectionEvent.getPath();
                Object[] objectArray = treePath.getPath();
                int n2 = Math.min(this.maxLength, objectArray.length - 1);
                for (n = 0; n < n2; ++n) {
                    this.dataBooks[n].setSelectedRow(((DataPageNode)objectArray[n + 1]).rowIndex);
                }
                for (n = n2; n < this.maxLength; ++n) {
                    this.dataBooks[n].setSelectedRow(-1);
                }
                if (this.selfJoinedDataBook != null) {
                    n = objectArray.length - 1 - this.dataBooks.length;
                    javax.rad.model.TreePath treePath2 = new javax.rad.model.TreePath(new int[0]);
                    int n3 = -1;
                    if (n >= 0) {
                        for (int i = 0; i < n; ++i) {
                            treePath2 = treePath2.getChildPath(((DataPageNode)objectArray[this.dataBooks.length + i]).rowIndex);
                        }
                        n3 = ((DataPageNode)objectArray[objectArray.length - 1]).rowIndex;
                    }
                    this.selfJoinedDataBook.setTreePath(treePath2);
                    this.selfJoinedDataBook.setSelectedRow(n3);
                }
                this.tree.setEditable(this.editable && n2 > 0 && !this.dataBooks[n2 - 1].isReadonly());
                this.ignoreEvent = false;
            }
            catch (ModelException modelException) {
                this.ignoreEvent = false;
                this.notifyRepaint();
                ExceptionHandler.raise(modelException);
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isDetectEndNode() {
        return this.detectEndNode;
    }

    public void setDetectEndNode(boolean bl) {
        this.detectEndNode = bl;
        if (this.isNotified) {
            this.notifyRepaint();
        }
    }

    public void run() {
        this.firstNotifyRepaintCall = true;
        if (this.isNotified) {
            this.doRepaint();
        }
    }

    public void notifyRepaint() {
        if (this.firstNotifyRepaintCall && !this.ignoreEvent) {
            this.firstNotifyRepaintCall = false;
            JVxUtil.invokeLater(this);
        }
    }

    public void startEditing() {
    }

    public void saveEditing() throws ModelException {
    }

    public void cancelEditing() {
    }

    public void editingComplete(String string) {
    }

    public void editingStarted() {
    }

    public boolean isSavingImmediate() {
        return false;
    }

    public void setTranslation(TranslationMap translationMap) {
        if (this.translation != translationMap) {
            this.translation = translationMap;
            this.notifyRepaint();
        }
    }

    public TranslationMap getTranslation() {
        return this.translation;
    }

    public IDataBook[] getDataBooks() {
        return this.dataBooks;
    }

    public void setDataBooks(IDataBook ... iDataBookArray) {
        int n;
        if (this.dataBooks != null) {
            this.tree.getSelectionModel().removeTreeSelectionListener(this);
            this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            for (n = 0; n < this.dataBooks.length; ++n) {
                this.dataBooks[n].removeControl(this);
            }
            this.selfJoinedDataBook = null;
            this.maxLength = 0;
        }
        this.dataBooks = iDataBookArray == null || iDataBookArray.length == 0 ? null : iDataBookArray;
        if (this.dataBooks != null) {
            for (n = 0; n < this.dataBooks.length; ++n) {
                this.dataBooks[n].addControl(this);
            }
            this.tree.setModel(new DefaultTreeModel(new DataPageNode(this, this.dataBooks)));
            this.tree.getSelectionModel().addTreeSelectionListener(this);
            IDataBook iDataBook = this.dataBooks[this.dataBooks.length - 1];
            if (iDataBook.isSelfJoined()) {
                this.selfJoinedDataBook = iDataBook;
                this.maxLength = this.dataBooks.length - 1;
            } else {
                this.maxLength = this.dataBooks.length;
            }
        }
    }

    public class DataRowTreeCellEditor
    extends DefaultTreeCellEditor {
        public DataRowTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            this(jTree, defaultTreeCellRenderer, null);
        }

        public DataRowTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
            super(jTree, defaultTreeCellRenderer, treeCellEditor);
        }

        protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            if (this.renderer != null) {
                DataRowTreeCellRenderer dataRowTreeCellRenderer = (DataRowTreeCellRenderer)this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
                if (JVxTree.this.nodeFormatter != null) {
                    try {
                        DataPageNode dataPageNode = (DataPageNode)object;
                        if (dataPageNode.parent != null) {
                            IDataPage iDataPage = dataPageNode.parent.dataPage;
                            IDataBook iDataBook = iDataPage.getDataBook();
                            IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(dataPageNode.rowIndex);
                            Icon icon = JVxTree.this.nodeFormatter.getNodeImage(iDataBook, iDataPage, iChangeableDataRow, iDataBook.getRowDefinition().getColumnView(ITree.class).getColumnName(0), dataPageNode.rowIndex, bl2, bl3);
                            if (icon != null) {
                                dataRowTreeCellRenderer.setIcon(icon);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.editingIcon = dataRowTreeCellRenderer.getIcon();
                this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
            } else {
                this.editingIcon = null;
                this.offset = 0;
            }
        }
    }

    public class DataRowTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DataRowTreeCellRenderer dataRowTreeCellRenderer = (DataRowTreeCellRenderer)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (JVxTree.this.nodeFormatter != null) {
                try {
                    DataPageNode dataPageNode = (DataPageNode)object;
                    if (dataPageNode.parent != null) {
                        IDataPage iDataPage = dataPageNode.parent.dataPage;
                        IDataBook iDataBook = iDataPage.getDataBook();
                        IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(dataPageNode.rowIndex);
                        Icon icon = JVxTree.this.nodeFormatter.getNodeImage(iDataBook, iDataPage, iChangeableDataRow, iDataBook.getRowDefinition().getColumnView(ITree.class).getColumnName(0), dataPageNode.rowIndex, bl2, bl3);
                        if (icon != null) {
                            dataRowTreeCellRenderer.setIcon(icon);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return dataRowTreeCellRenderer;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    public static class DataPageNode
    implements MutableTreeNode {
        private JVxTree jvxTree;
        private IDataBook[] dataBooks;
        private int level;
        private DataPageNode parent;
        private int rowIndex;
        private IDataPage dataPage;
        private IDataRow primaryKey;

        public DataPageNode(JVxTree jVxTree, IDataBook[] iDataBookArray) {
            this(jVxTree, iDataBookArray, 0, null, 0);
        }

        private DataPageNode(JVxTree jVxTree, IDataBook[] iDataBookArray, int n, DataPageNode dataPageNode, int n2) {
            this.jvxTree = jVxTree;
            this.dataBooks = iDataBookArray;
            this.level = n;
            this.parent = dataPageNode;
            this.rowIndex = n2;
            this.initDataPage();
        }

        private void initDataPage() {
            try {
                if (this.parent == null) {
                    if (this.dataBooks[0].isSelfJoined()) {
                        this.dataBooks[0].getSelectedRow();
                        this.dataPage = this.dataBooks[0].getDataPage(new javax.rad.model.TreePath(new int[0]));
                    } else {
                        this.dataPage = this.dataBooks[0].getDataPage();
                    }
                    this.primaryKey = null;
                } else {
                    IDataBook iDataBook = this.getDataBook(this.level);
                    this.primaryKey = this.getDataRow();
                    this.dataPage = iDataBook == null || this.primaryKey == null ? null : (iDataBook.isSelfJoined() && this.level == this.dataBooks.length - 1 ? iDataBook.getDataPageWithRootRow(this.primaryKey) : iDataBook.getDataPage(this.primaryKey));
                    this.primaryKey = this.getPrimaryKey(this.primaryKey);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dataPage = null;
                this.primaryKey = null;
            }
        }

        public IChangeableDataRow getDataRow() {
            try {
                return this.parent.dataPage.getDataRow(this.rowIndex);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public IDataRow getPrimaryKey(IDataRow iDataRow) {
            try {
                return iDataRow.createDataRow(iDataRow.getRowDefinition().getPrimaryKeyColumnNames());
            }
            catch (Exception exception) {
                return null;
            }
        }

        public boolean isValidNode() {
            if (this.parent == null) {
                return true;
            }
            if (this.primaryKey == null) {
                return false;
            }
            return this.primaryKey.equals(this.getPrimaryKey(this.getDataRow()));
        }

        public TreeNode getChildAt(int n) {
            return new DataPageNode(this.jvxTree, this.dataBooks, this.level + 1, this, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getChildCount() {
            if (this.dataPage != null) {
                try {
                    if (!this.dataPage.isAllFetched()) {
                        int n;
                        Rectangle rectangle;
                        if (this.jvxTree.tree.getParent() instanceof JViewport) {
                            rectangle = ((JViewport)this.jvxTree.tree.getParent()).getViewRect();
                            n = (rectangle.y + rectangle.height) * 10 / this.jvxTree.tree.getRowHeight() / 9 + 1;
                        } else {
                            rectangle = this.jvxTree.tree.getBounds();
                            n = rectangle.height * 10 / this.jvxTree.tree.getRowHeight() / 9 + 1;
                        }
                        if (n >= this.dataPage.getRowCount()) {
                            boolean bl = JVxUtil.getGlobalCursor(this.jvxTree).getType() != 3;
                            JVxUtil.setGlobalCursor(this.jvxTree, Cursor.getPredefinedCursor(3));
                            try {
                                this.dataPage.getDataRow(n);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)DataPageNode.this.jvxTree.tree.getModel();
                                        DataPageNode dataPageNode = (DataPageNode)defaultTreeModel.getRoot();
                                        TreePath treePath = new TreePath(dataPageNode);
                                        Enumeration<TreePath> enumeration = DataPageNode.this.jvxTree.tree.getExpandedDescendants(treePath);
                                        defaultTreeModel.reload(dataPageNode);
                                        if (enumeration != null) {
                                            while (enumeration.hasMoreElements()) {
                                                TreePath treePath2 = enumeration.nextElement();
                                                if (!JVxTree.isAllValid(treePath2.getPath())) continue;
                                                DataPageNode.this.jvxTree.tree.expandPath(treePath2);
                                            }
                                        }
                                    }
                                });
                            }
                            finally {
                                if (bl) {
                                    JVxUtil.setGlobalCursor(this.jvxTree, null);
                                }
                            }
                        }
                    }
                    return this.dataPage.getRowCount();
                }
                catch (ModelException modelException) {
                    ExceptionHandler.raise(modelException);
                }
            }
            return 0;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode treeNode) {
            return ((DataPageNode)treeNode).rowIndex;
        }

        public boolean getAllowsChildren() {
            return this.dataPage != null;
        }

        public boolean isLeaf() {
            try {
                if (this.jvxTree.detectEndNode && !this.dataPage.isAllFetched() && this.dataPage.getRowCount() == 0) {
                    this.dataPage.getDataRow(0);
                }
                return this.getDataRow().isInserting() || this.dataPage.isAllFetched() && this.dataPage.getRowCount() == 0;
            }
            catch (Exception exception) {
                return this.getChildCount() == 0;
            }
        }

        public Enumeration children() {
            return new Enumeration(){
                private int index = 0;

                public boolean hasMoreElements() {
                    return this.index < DataPageNode.this.getChildCount();
                }

                public Object nextElement() {
                    return DataPageNode.this.getChildAt(this.index++);
                }
            };
        }

        public String toString() {
            if (this.parent == null) {
                return null;
            }
            try {
                Object object = this.getDataRow().getValue(this.parent.dataPage.getDataBook().getRowDefinition().getColumnView(ITree.class).getColumnName(0));
                if (object == null) {
                    return null;
                }
                return object.toString();
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DataPageNode) {
                DataPageNode dataPageNode = (DataPageNode)object;
                return this.level == dataPageNode.level && (this.primaryKey == dataPageNode.primaryKey || this.primaryKey != null && this.primaryKey.equals(dataPageNode.primaryKey));
            }
            return false;
        }

        public int hashCode() {
            int n = (this.level + 13) * 17;
            if (this.primaryKey != null) {
                n += this.primaryKey.hashCode();
            }
            return n;
        }

        public void insert(MutableTreeNode mutableTreeNode, int n) {
        }

        public void remove(int n) {
        }

        public void remove(MutableTreeNode mutableTreeNode) {
        }

        public void removeFromParent() {
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
        }

        public void setUserObject(Object object) {
            try {
                IDataBook iDataBook = this.parent.dataPage.getDataBook();
                this.parent.dataPage = iDataBook.getDataPage();
                iDataBook.setValue(iDataBook.getRowDefinition().getColumnView(ITree.class).getColumnName(0), object);
            }
            catch (Exception exception) {
                ExceptionHandler.raise(exception);
            }
        }

        private IDataBook getDataBook(int n) {
            if (n < this.dataBooks.length) {
                return this.dataBooks[n];
            }
            IDataBook iDataBook = this.dataBooks[this.dataBooks.length - 1];
            if (iDataBook.isSelfJoined()) {
                return this.dataBooks[this.dataBooks.length - 1];
            }
            return null;
        }
    }
}

