/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;

public class JVxScrollPane
extends JScrollPane
implements MouseListener {
    public JVxScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
    }

    public JVxScrollPane(Component component) {
        super(component, 20, 30);
    }

    public JVxScrollPane(int n, int n2) {
        super(null, n, n2);
    }

    public JVxScrollPane() {
        super(null, 20, 30);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component;
        Component component2 = mouseEvent.getComponent();
        if (component2 == (component = this.getViewportView())) {
            if ((mouseEvent.getModifiers() & 0x1004) != 0 && mouseEvent.getClickCount() == 1) {
                MouseEvent mouseEvent2 = this.createForwardMouseEvent(mouseEvent);
                MouseListener mouseListener = this.getPlafMouseListener(component);
                if (mouseListener != null) {
                    mouseListener.mousePressed(mouseEvent2);
                }
            }
        } else if (component != null && !component.hasFocus()) {
            component.requestFocus();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Component component;
        Component component2 = mouseEvent.getComponent();
        if (component2 == (component = this.getViewportView()) && (mouseEvent.getModifiers() & 0x1004) != 0 && mouseEvent.getClickCount() == 1) {
            MouseEvent mouseEvent2 = this.createForwardMouseEvent(mouseEvent);
            MouseListener mouseListener = this.getPlafMouseListener(component);
            if (mouseListener != null) {
                mouseListener.mouseReleased(mouseEvent2);
            }
        }
    }

    private MouseListener getPlafMouseListener(Component component) {
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (!mouseListenerArray[i].getClass().getName().endsWith("$Handler")) continue;
            return mouseListenerArray[i];
        }
        return null;
    }

    private MouseEvent createForwardMouseEvent(MouseEvent mouseEvent) {
        return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() & 0xFFFFFFFB | 0x10, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 1);
    }

    public void setViewport(JViewport jViewport) {
        if (this.getViewport() != null) {
            this.getViewport().removeMouseListener(this);
        }
        super.setViewport(jViewport);
        if (this.getViewport() != null) {
            this.getViewport().addMouseListener(this);
        }
    }

    protected Dimension getPreferredComponentSize(Component component) {
        if (component instanceof JTextArea) {
            int n;
            int n2;
            JTextArea jTextArea = (JTextArea)component;
            FontMetrics fontMetrics = jTextArea.getFontMetrics(jTextArea.getFont());
            Insets insets = jTextArea.getInsets();
            Dimension dimension = null;
            int n3 = jTextArea.getColumns();
            if (n3 == 0) {
                if (dimension == null) {
                    Dimension dimension2 = jTextArea.getSize();
                    if (dimension2.width == 0 && dimension2.height == 0 && jTextArea.getLineWrap()) {
                        jTextArea.setLineWrap(false);
                        dimension = jTextArea.getPreferredSize();
                        jTextArea.setLineWrap(true);
                    } else {
                        dimension = jTextArea.getPreferredSize();
                    }
                }
                n2 = dimension.width;
            } else {
                n2 = n3 * fontMetrics.charWidth('m') + insets.left + insets.right;
            }
            int n4 = jTextArea.getRows();
            if (n4 == 0) {
                if (dimension == null) {
                    Dimension dimension3 = jTextArea.getSize();
                    if (dimension3.width == 0 && dimension3.height == 0 && jTextArea.getLineWrap()) {
                        jTextArea.setLineWrap(false);
                        dimension = jTextArea.getPreferredSize();
                        jTextArea.setLineWrap(true);
                    } else {
                        dimension = jTextArea.getPreferredSize();
                    }
                }
                n = dimension.height;
            } else {
                n = n4 * fontMetrics.getHeight() + insets.top + insets.bottom;
            }
            return new Dimension(n2, n);
        }
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            Insets insets = jTextField.getInsets();
            FontMetrics fontMetrics = jTextField.getFontMetrics(jTextField.getFont());
            int n = jTextField.getColumns();
            int n5 = n == 0 ? jTextField.getPreferredSize().width : n * fontMetrics.charWidth('m') + insets.left + insets.right;
            return new Dimension(n5, fontMetrics.getHeight() + insets.top + insets.bottom);
        }
        return component.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Object object;
        Serializable serializable;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            serializable = this.viewport.getView();
            object = serializable == null ? this.viewport.getPreferredSize() : this.getPreferredComponentSize((Component)serializable);
            n += ((Dimension)object).width;
            n2 += ((Dimension)object).height;
        }
        if ((object = this.getViewportBorder()) != null) {
            serializable = object.getBorderInsets(this);
            n += ((Insets)serializable).left + ((Insets)serializable).right;
            n2 += ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        if (this.rowHeader != null && this.rowHeader.isVisible()) {
            serializable = this.rowHeader.getView();
            dimension = null;
            if (serializable != null) {
                dimension = ((Component)serializable).getPreferredSize();
                n += dimension.width;
            }
            if (this.rowHeader.isShowing()) {
                this.rowHeader.setPreferredSize(dimension);
            }
        }
        if (this.columnHeader != null && this.columnHeader.isVisible()) {
            serializable = this.columnHeader.getView();
            dimension = null;
            if (serializable != null) {
                dimension = ((Component)serializable).getPreferredSize();
                n2 += dimension.height;
            }
            if (this.columnHeader.isShowing()) {
                this.columnHeader.setPreferredSize(dimension);
            }
        }
        if (this.verticalScrollBarPolicy == 22) {
            n += this.verticalScrollBar.getPreferredSize().width;
        }
        if (this.horizontalScrollBarPolicy == 32) {
            n2 += this.horizontalScrollBar.getPreferredSize().height;
        }
        return new Dimension(n, n2);
    }

    public Component getViewportView() {
        if (this.getViewport() == null) {
            return null;
        }
        return this.getViewport().getView();
    }
}

