/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxDesktopManager;
import com.sibvisions.rad.ui.swing.ext.JVxInternalFrame;
import com.sibvisions.rad.ui.swing.ext.JVxTabbedPane;
import com.sibvisions.rad.ui.swing.ext.event.ITabListener;
import com.sibvisions.rad.ui.swing.ext.event.TabEvent;
import com.sibvisions.rad.ui.swing.ext.layout.JVxFormLayout;
import com.sibvisions.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameListener;

public class JVxDesktopPane
extends JDesktopPane
implements ITabListener {
    private static final Integer TAB_LAYER = FRAME_CONTENT_LAYER + 1;
    private static int iDesktopCount = 0;
    private InternalContentPanel icpContent;
    private InternalContentLayout layout;
    private JVxTabbedPane tabs = null;
    private ArrayUtil<WeakReference<JInternalFrame>> auFrameCache = null;
    private Hashtable<JVxInternalFrame, Component> htFrameContent = null;
    private Hashtable<Component, JVxInternalFrame> htContentFrame = null;
    private boolean bDragableTabs = false;
    private int iIgnoreFrameCalls = 0;
    private int iIgnoreToFront = 0;
    private boolean bSetFocusOnlyOnce = false;
    private boolean bIgnoreTabSelection = false;
    private boolean bIgnoreTabFocus = false;
    private long lAltWhen;
    private long lCtrlWhen;
    private boolean bFrameSwitchAllowed;
    private boolean bNavigationKeyEnabled = false;

    public JVxDesktopPane() {
        this.setName("Desktop: " + ++iDesktopCount);
        if (this.getLayout() != null) {
            this.setLayout(new BorderLayout());
        }
        this.setDesktopManager(new JVxDesktopManager());
    }

    public void closeTab(TabEvent tabEvent) throws Exception {
        Component component;
        JVxInternalFrame jVxInternalFrame;
        if (this.isTabMode() && (jVxInternalFrame = this.htContentFrame.get(component = this.tabs.getComponentAt(tabEvent.getOldTabIndex()))) != null) {
            jVxInternalFrame.doDefaultCloseAction();
            if (!jVxInternalFrame.isClosed()) {
                throw new Exception("Frame '" + jVxInternalFrame.getTitle() + "' is not closable!");
            }
            this.htContentFrame.remove(component);
            this.htFrameContent.remove(jVxInternalFrame);
            if (this.htFrameContent.size() == 0) {
                this.tabs.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselectTab(TabEvent tabEvent) {
        JVxInternalFrame jVxInternalFrame;
        int n;
        if (!this.bIgnoreTabSelection && (n = tabEvent.getOldTabIndex()) >= 0 && (jVxInternalFrame = this.htContentFrame.get(this.tabs.getComponentAt(n))) != null) {
            if (!this.bIgnoreTabFocus) {
                jVxInternalFrame.storeFocus();
            }
            ++this.iIgnoreFrameCalls;
            try {
                jVxInternalFrame.setVisible(true);
                jVxInternalFrame.setSelected(false);
                jVxInternalFrame.setVisible(false);
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            finally {
                --this.iIgnoreFrameCalls;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectTab(TabEvent tabEvent) {
        JVxInternalFrame jVxInternalFrame;
        int n;
        if (!this.bIgnoreTabSelection && (n = tabEvent.getNewTabIndex()) >= 0 && (jVxInternalFrame = this.htContentFrame.get(this.tabs.getComponentAt(n))) != null) {
            ++this.iIgnoreFrameCalls;
            try {
                jVxInternalFrame.setVisible(true);
                jVxInternalFrame.setSelected(true);
                jVxInternalFrame.setVisible(false);
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            finally {
                --this.iIgnoreFrameCalls;
            }
            if (!this.bSetFocusOnlyOnce) {
                if (!this.bIgnoreTabFocus && jVxInternalFrame.isFocusStored()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JVxDesktopPane.this.bSetFocusOnlyOnce = false;
                            jVxInternalFrame.restoreFocus();
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JVxDesktopPane.this.bSetFocusOnlyOnce = false;
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(JVxDesktopPane.this.tabs);
                        }
                    });
                }
            }
        }
    }

    public void moveTab(TabEvent tabEvent) {
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager != null || this.icpContent != null) {
            this.attachContentPane();
            this.icpContent.setLayout(layoutManager);
        }
        if (this.layout == null) {
            this.layout = new InternalContentLayout();
            super.setLayout(this.layout);
        }
    }

    public LayoutManager getLayout() {
        if (this.icpContent != null) {
            return this.icpContent.getLayout();
        }
        return null;
    }

    protected void addImpl(Component component, Object object, int n) {
        JInternalFrame jInternalFrame = null;
        if (component instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
        } else if (component instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)component;
        }
        if (jInternalFrame != null) {
            String string;
            Integer n2;
            if (this.auFrameCache == null) {
                this.auFrameCache = new ArrayUtil();
            }
            if ((n2 = (Integer)jInternalFrame.getClientProperty(string = this.getName())) != null) {
                this.auFrameCache.add(n2, new WeakReference<JInternalFrame>(jInternalFrame));
                jInternalFrame.putClientProperty(string, null);
            } else {
                this.auFrameCache.add(new WeakReference<JInternalFrame>(jInternalFrame));
            }
        }
        if (object != null && object instanceof Integer || component instanceof JInternalFrame || component instanceof JInternalFrame.JDesktopIcon) {
            super.addImpl(component, object, n);
            if (component instanceof JVxInternalFrame && this.isTabMode() && component.isVisible() && !((JVxInternalFrame)component).isModal()) {
                this.addTab((JVxInternalFrame)component);
            }
        } else {
            this.attachContentPane();
            this.icpContent.add(component, object, n);
            this.icpContent.validate();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.setSelectedFrame(null);
    }

    public void removeAll() {
        super.removeAll();
        if (this.icpContent != null) {
            this.icpContent.removeAll();
        }
        this.htContentFrame = null;
        this.htFrameContent = null;
        this.auFrameCache = null;
    }

    public void remove(Component component) {
        int n;
        Container container;
        if (this.auFrameCache != null) {
            container = null;
            if (component instanceof JInternalFrame) {
                container = (JInternalFrame)component;
            } else if (component instanceof JInternalFrame.JDesktopIcon) {
                container = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
            }
            if (container != null && (n = this.auFrameCache.indexOf(container)) >= 0) {
                this.auFrameCache.remove(n);
                ((JComponent)container).putClientProperty(this.getName(), n);
                if (this.auFrameCache.size() == 0) {
                    this.auFrameCache = null;
                }
            }
        }
        if ((container = component.getParent()) == null) {
            return;
        }
        if (container == this) {
            n = 0;
            if (component instanceof JVxInternalFrame && this.isTabMode() && this.isVisible((JVxInternalFrame)component)) {
                n = 1;
            }
            super.remove(component);
            if (this.auFrameCache != null) {
                int n2 = 0;
                int n3 = this.auFrameCache.size();
                for (int i = 0; i < n3 && n2 == 0; ++i) {
                    JInternalFrame jInternalFrame = (JInternalFrame)this.auFrameCache.get(i).get();
                    if (jInternalFrame == null || !jInternalFrame.isVisible() || jInternalFrame.isIcon()) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    this.requestFocus();
                }
            }
            if (n != 0) {
                ((JVxInternalFrame)component).setVisibleIntern(true);
            }
        } else if (container == this.tabs) {
            this.tabs.remove(component);
            JInternalFrame jInternalFrame = this.htContentFrame.remove(component);
            this.htFrameContent.remove(jInternalFrame);
            if (this.htContentFrame.size() == 0) {
                this.htFrameContent = null;
                this.htContentFrame = null;
            }
        } else if (container == this.icpContent) {
            this.icpContent.remove(component);
        }
        if (this.getAllFrames().length == 0) {
            this.setSelectedFrame(null);
        }
    }

    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (!this.bNavigationKeyEnabled || JVxInternalFrame.isModalPanelVisible()) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        if (bl) {
            if (keyEvent.isAltDown() && keyEvent.isControlDown()) {
                this.bFrameSwitchAllowed = this.lCtrlWhen != keyEvent.getWhen() && this.lAltWhen == 0L || this.lAltWhen != keyEvent.getWhen() && this.lCtrlWhen == 0L;
            } else if (keyEvent.getKeyCode() == 18) {
                this.lAltWhen = keyEvent.getWhen();
                this.bFrameSwitchAllowed = true;
            } else if (keyEvent.getKeyCode() == 17) {
                this.lCtrlWhen = keyEvent.getWhen();
                this.bFrameSwitchAllowed = true;
            }
        } else {
            if (keyEvent.getKeyCode() == 18) {
                this.bFrameSwitchAllowed = true;
                this.lAltWhen = 0L;
            } else if (keyEvent.getKeyCode() == 17) {
                this.bFrameSwitchAllowed = true;
                this.lCtrlWhen = 0L;
            }
            boolean bl2 = this.bFrameSwitchAllowed = !keyEvent.isAltDown() && !keyEvent.isControlDown();
        }
        if (this.auFrameCache != null && bl && keyEvent.getKeyCode() == 18 && keyEvent.isControlDown() && this.bFrameSwitchAllowed) {
            int n2 = keyEvent.isShiftDown() ? -1 : 1;
            if (this.isTabMode()) {
                int n3 = this.tabs.getSelectedIndex();
                if (n3 >= 0) {
                    if ((n3 += n2) < 0) {
                        n3 = this.tabs.getTabCount() - 1;
                    } else if (n3 >= this.tabs.getTabCount()) {
                        n3 = 0;
                    }
                    this.tabs.setSelectedIndex(n3);
                }
            } else {
                int n4;
                int n5 = n4 = this.auFrameCache.indexOf(this.getSelectedFrame());
                int n6 = this.auFrameCache.size();
                int n7 = 0;
                if (n4 != -1) {
                    JInternalFrame jInternalFrame;
                    do {
                        ++n7;
                        if ((n5 += n2) < 0) {
                            n5 = this.auFrameCache.size() - 1;
                        } else if (n5 >= this.auFrameCache.size()) {
                            n5 = 0;
                        }
                        jInternalFrame = (JInternalFrame)this.auFrameCache.get(n5).get();
                        if (jInternalFrame == null) {
                            this.auFrameCache.remove(n5);
                            continue;
                        }
                        if (jInternalFrame.isVisible() || jInternalFrame.isIcon()) continue;
                        jInternalFrame = null;
                    } while (jInternalFrame == null && n5 != n4 && n7 <= n6);
                    if (jInternalFrame != null) {
                        try {
                            if (jInternalFrame.isIcon()) {
                                jInternalFrame.setIcon(false);
                            }
                            jInternalFrame.toFront();
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void attachContentPane() {
        if (this.icpContent == null) {
            this.icpContent = new InternalContentPanel();
            super.addImpl(this.icpContent, JLayeredPane.FRAME_CONTENT_LAYER, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabMode(boolean bl) {
        if (bl) {
            if (!this.isTabMode()) {
                this.tabs = new JVxTabbedPane();
                this.tabs.setTabLayoutPolicy(1);
                this.tabs.setDragable(this.bDragableTabs);
                this.tabs.addTabListener(this);
                this.htFrameContent = new Hashtable();
                this.htContentFrame = new Hashtable();
                JInternalFrame[] jInternalFrameArray = super.getAllFrames();
                int n = -1;
                int n2 = jInternalFrameArray.length;
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!(jInternalFrameArray[i] instanceof JVxInternalFrame) || !jInternalFrameArray[i].isVisible() || ((JVxInternalFrame)jInternalFrameArray[i]).isModal()) continue;
                    if (jInternalFrameArray[i].isSelected()) {
                        n = n3;
                    }
                    this.addTab((JVxInternalFrame)jInternalFrameArray[i]);
                    ++n3;
                }
                this.tabs.setSize(this.getSize());
                this.tabs.setVisible(false);
                super.add(this.tabs, TAB_LAYER, 0);
                this.bIgnoreTabFocus = true;
                try {
                    this.tabs.setVisible(this.tabs.getTabCount() > 0);
                    this.tabs.setSelectedIndex(n < 0 ? this.tabs.getTabCount() - 1 : n);
                }
                finally {
                    this.bIgnoreTabFocus = false;
                }
                this.tabs.requestFocusInWindow();
            }
        } else if (this.isTabMode()) {
            JVxInternalFrame jVxInternalFrame;
            Component component = this.tabs.getSelectedComponent();
            super.remove(this.tabs);
            this.repaint();
            this.tabs = null;
            for (Map.Entry<JVxInternalFrame, Component> entry : this.htFrameContent.entrySet()) {
                jVxInternalFrame = entry.getKey();
                JRootPane jRootPane = (JRootPane)((Container)entry.getValue()).getComponent(0);
                jRootPane.setPreferredSize(new Dimension(0, 0));
                jVxInternalFrame.setRootPane(jRootPane);
                jVxInternalFrame.setVisible(true);
            }
            if (component != null && (jVxInternalFrame = this.htContentFrame.get(component)) != null) {
                try {
                    jVxInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.htFrameContent = null;
            this.htContentFrame = null;
        }
    }

    public boolean isTabMode() {
        return this.tabs != null;
    }

    public void setTabsDragable(boolean bl) {
        this.bDragableTabs = bl;
        if (this.isTabMode()) {
            this.tabs.setDragable(bl);
        }
    }

    public boolean isTabsDragable() {
        return this.bDragableTabs;
    }

    private void setPreferredSizeAnchors(JVxFormLayout.Constraint constraint, boolean bl) {
        constraint.getTopAnchor().setAutoSize(bl);
        constraint.getLeftAnchor().setAutoSize(bl);
        constraint.getBottomAnchor().setAutoSize(bl);
        constraint.getRightAnchor().setAutoSize(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTab(JVxInternalFrame jVxInternalFrame) {
        boolean bl;
        JRootPane jRootPane = jVxInternalFrame.getRootPane();
        Container container = new Container();
        JVxFormLayout jVxFormLayout = new JVxFormLayout();
        jVxFormLayout.setMargins(new Insets(0, 0, 0, 0));
        container.setLayout(jVxFormLayout);
        container.add((Component)jRootPane, new JVxFormLayout.Constraint(jVxFormLayout.getTopMarginAnchor(), jVxFormLayout.getLeftMarginAnchor(), jVxFormLayout.getBottomMarginAnchor(), jVxFormLayout.getRightMarginAnchor()));
        this.htFrameContent.put(jVxInternalFrame, container);
        this.htContentFrame.put(container, jVxInternalFrame);
        boolean bl2 = bl = !jVxInternalFrame.isMaximum() && !jVxInternalFrame.isResizable();
        if (bl) {
            ((Component)jRootPane).setPreferredSize(jRootPane.getSize());
        }
        this.setPreferredSizeAnchors(jVxFormLayout.getConstraint(jRootPane), bl);
        this.bIgnoreTabFocus = true;
        try {
            this.tabs.addTab(jVxInternalFrame.getTitle(), jVxInternalFrame.getFrameIcon(), container);
            int n = this.tabs.getTabCount() - 1;
            this.tabs.setClosableAt(n, jVxInternalFrame.isClosable());
            this.tabs.setSelectedIndex(n);
            this.tabs.setVisible(true);
        }
        finally {
            this.bIgnoreTabFocus = false;
        }
        ++this.iIgnoreFrameCalls;
        this.iIgnoreToFront += 2;
        try {
            int n;
            int n2;
            InternalFrameListener[] internalFrameListenerArray = jVxInternalFrame.getInternalFrameListeners();
            if (internalFrameListenerArray != null) {
                n2 = internalFrameListenerArray.length;
                for (n = 0; n < n2; ++n) {
                    jVxInternalFrame.removeInternalFrameListener(internalFrameListenerArray[n]);
                }
            }
            try {
                jVxInternalFrame.setVisible(true);
                jVxInternalFrame.setVisible(false);
            }
            finally {
                if (internalFrameListenerArray != null) {
                    n2 = internalFrameListenerArray.length;
                    for (n = 0; n < n2; ++n) {
                        jVxInternalFrame.addInternalFrameListener(internalFrameListenerArray[n]);
                    }
                }
            }
        }
        finally {
            this.iIgnoreToFront -= 2;
            --this.iIgnoreFrameCalls;
        }
    }

    private int getTabIndex(JVxInternalFrame jVxInternalFrame) {
        Component component;
        if (this.isTabMode() && (component = this.htFrameContent.get(jVxInternalFrame)) != null) {
            return this.tabs.indexOfComponent(component);
        }
        return -1;
    }

    public JVxTabbedPane getTabbedPane() {
        return this.tabs;
    }

    public void setNavigationKeysEnabled(boolean bl) {
        this.bNavigationKeyEnabled = bl;
    }

    public boolean isNavigationKeysEnabled() {
        return this.bNavigationKeyEnabled;
    }

    void dispose(JVxInternalFrame jVxInternalFrame) {
        this.setVisible(jVxInternalFrame, false);
    }

    boolean isVisible(JVxInternalFrame jVxInternalFrame) {
        return this.iIgnoreFrameCalls == 0 && this.getTabIndex(jVxInternalFrame) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setVisible(JVxInternalFrame jVxInternalFrame, boolean bl) {
        if (this.iIgnoreFrameCalls == 0 && this.isTabMode() && !jVxInternalFrame.isModal()) {
            if (bl) {
                Component component = this.htFrameContent.get(jVxInternalFrame);
                if (component == null) {
                    this.addTab(jVxInternalFrame);
                }
                return true;
            }
            Component component = this.htFrameContent.get(jVxInternalFrame);
            if (component != null) {
                this.bIgnoreTabSelection = true;
                try {
                    this.tabs.remove(component);
                }
                finally {
                    this.bIgnoreTabSelection = false;
                }
                if (this.tabs.getTabCount() == 0) {
                    this.tabs.setVisible(false);
                }
                jVxInternalFrame.setRootPane((JRootPane)((Container)component).getComponent(0));
                this.htFrameContent.remove(jVxInternalFrame);
                this.htContentFrame.remove(component);
                return true;
            }
        }
        return false;
    }

    boolean setSelected(JVxInternalFrame jVxInternalFrame, boolean bl) {
        int n;
        if (this.iIgnoreFrameCalls == 0 && (n = this.getTabIndex(jVxInternalFrame)) >= 0) {
            this.tabs.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean toFront(JVxInternalFrame jVxInternalFrame) {
        if (this.isTabMode()) {
            int n = this.getTabIndex(jVxInternalFrame);
            if (this.iIgnoreToFront <= 1 && this.tabs.getSelectedIndex() != n) {
                ++this.iIgnoreToFront;
                try {
                    if (n >= 0) {
                        this.tabs.setSelectedIndex(n);
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    --this.iIgnoreToFront;
                }
            }
        }
        return false;
    }

    void setEnabled(JVxInternalFrame jVxInternalFrame, boolean bl) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setEnabledAt(n, bl);
        }
    }

    void setResizable(JVxInternalFrame jVxInternalFrame, boolean bl) {
        Container container;
        if (this.isTabMode() && (container = (Container)this.htFrameContent.get(jVxInternalFrame)) != null) {
            JVxFormLayout jVxFormLayout = (JVxFormLayout)container.getLayout();
            this.setPreferredSizeAnchors(jVxFormLayout.getConstraint(container.getComponent(0)), !bl);
            if (bl) {
                jVxFormLayout.setMargins(new Insets(0, 0, 0, 0));
            }
        }
    }

    void setIcon(JVxInternalFrame jVxInternalFrame, Icon icon) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setIconAt(n, icon);
        }
    }

    void setTitle(JVxInternalFrame jVxInternalFrame, String string) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setTitleAt(n, string);
        }
    }

    void setClosable(JVxInternalFrame jVxInternalFrame, boolean bl) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setClosableAt(n, bl);
        }
    }

    private class InternalContentLayout
    implements LayoutManager {
        private Dimension dimDefault = new Dimension(0, 0);

        private InternalContentLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            if (JVxDesktopPane.this.icpContent != null) {
                return JVxDesktopPane.this.icpContent.getPreferredSize();
            }
            return this.dimDefault;
        }

        public void layoutContainer(Container container) {
            if (JVxDesktopPane.this.icpContent != null) {
                JVxDesktopPane.this.icpContent.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            if (JVxDesktopPane.this.tabs != null) {
                JVxDesktopPane.this.tabs.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
        }
    }

    private final class InternalContentPanel
    extends JPanel {
        private InternalContentPanel() {
            this.setLayout(new BorderLayout(0, 0));
        }

        public Color getBackground() {
            return JVxDesktopPane.this.getBackground();
        }
    }
}

