/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.rad.model.ui.ITranslatable;
import javax.rad.util.TranslationMap;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;

public class JVxComboBase
extends JComboBox
implements PopupMenuListener,
MouseListener,
KeyListener,
WindowListener,
ITranslatable {
    private JPopupMenu internalPopup;
    private boolean ignorePopupMenuEvents = false;
    private JButton internalButton;
    private boolean buttonEnabled = true;
    private List<JComponent> doNotCancelPopupComponents = new ArrayList<JComponent>();
    private Window windowAncestor = null;
    private boolean isPermanentDeactivated;
    private Object doNotCancelPopup = null;
    private JComponent popupComponent = null;
    private JTextComponent editorComponent = null;
    private Dimension popupSize = null;
    private Object selectedItem = null;
    private TranslationMap translation = null;
    private boolean justClosed = false;
    private boolean popupCanceled = false;
    private boolean forceFocusOnPopup = false;

    public JVxComboBase() {
        this.setEditor(new GenericComboBoxEditor());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (!(object != this.editorComponent || this.justClosed || this.isEditorEditable() || this.isPopupVisible())) {
            this.setPopupVisible(true);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.internalButton) {
            if (!this.isPopupVisible()) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (component != null && component != this.editorComponent) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(new FocusEvent(component, 1005));
                }
                if (this.editorComponent.isFocusable()) {
                    this.editorComponent.requestFocus();
                } else {
                    this.requestFocus();
                }
            }
            this.setPopupVisible(!this.isPopupVisible());
        } else if (object == this.editorComponent) {
            this.justClosed = false;
            if (!this.isEditorEditable() && this.isPopupVisible()) {
                this.setPopupVisible(false);
                this.justClosed = true;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 40 && !this.isPopupVisible()) {
            keyEvent.consume();
            this.setPopupVisible(true);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.isPermanentDeactivated = false;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.isPermanentDeactivated = true;
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(50L);
                    if (JVxComboBase.this.isPermanentDeactivated) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JVxComboBase.this.internalPopup.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
                                MenuSelectionManager.defaultManager().clearSelectedPath();
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (!(aWTEvent instanceof FocusEvent) || !this.isPopupFocusEvent((FocusEvent)aWTEvent)) {
            this.setPopupVisible(false);
            this.setSelectedItem(this.getEditor().getItem());
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (!this.ignorePopupMenuEvents) {
            Container container = this;
            while (container.getParent() != null) {
                container = container.getParent();
            }
            this.removeDoNotCancelPopupComponents(container);
            this.popupCanceled = false;
            this.firePopupMenuWillBecomeVisible();
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.windowAncestor != null) {
            this.windowAncestor.removeWindowListener(this);
        }
        this.windowAncestor = null;
        if (!this.ignorePopupMenuEvents) {
            this.addDoNotCancelPopupComponents();
            if (this.isChild(this.internalPopup, KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(new FocusEvent(this.editorComponent, 1004));
            }
            Object object = this.getModel().getSelectedItem();
            if (!this.popupCanceled) {
                this.setSelectedItem(object);
            }
            this.firePopupMenuWillBecomeInvisible();
        }
    }

    public boolean isPopupCanceled() {
        return this.popupCanceled;
    }

    public void setPopupCanceled(boolean bl) {
        this.popupCanceled = bl;
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        if (!this.ignorePopupMenuEvents) {
            this.popupCanceled = true;
            this.firePopupMenuCanceled();
        }
    }

    public void setTranslation(TranslationMap translationMap) {
        if (this.translation != translationMap) {
            this.translation = translationMap;
            if (this.popupComponent instanceof ITranslatable) {
                ((ITranslatable)((Object)this.popupComponent)).setTranslation(this.translation);
            }
        }
    }

    public TranslationMap getTranslation() {
        return this.translation;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object object) {
        if (this.selectedItem == null && object != null || this.selectedItem != null && !this.selectedItem.equals(object)) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItem, 2));
            this.selectedItem = object;
            this.getEditor().setItem(object);
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItem, 1));
        } else {
            this.getEditor().setItem(this.selectedItem);
        }
        this.fireActionEvent();
    }

    protected void selectedItemChanged() {
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public int getSelectedIndex() {
        return -1;
    }

    public void setSelectedIndex(int n) {
    }

    public int getItemCount() {
        return 0;
    }

    public Object getItemAt(int n) {
        return null;
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        this.setEditable(true);
        super.setUI(comboBoxUI);
        JPopupMenu jPopupMenu = (JPopupMenu)this.getUI().getAccessibleChild(this, 0);
        jPopupMenu.updateUI();
        if (this.internalPopup == null) {
            this.internalPopup = new JPopupMenu(){
                private boolean ignore = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setVisible(boolean bl) {
                    if (!this.ignore) {
                        try {
                            this.ignore = true;
                            super.setVisible(bl);
                        }
                        finally {
                            this.ignore = false;
                        }
                    }
                }
            };
            this.internalPopup.setLayout(new BorderLayout());
            this.internalPopup.addPopupMenuListener(this);
        }
        this.internalPopup.setName(jPopupMenu.getName());
        this.internalPopup.setBorder(jPopupMenu.getBorder());
        SwingUtilities.updateComponentTreeUI(this.internalPopup);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (component instanceof JButton) {
                this.internalButton = (JButton)component;
                continue;
            }
            if (component == this.editorComponent) continue;
            this.remove(component);
        }
        this.removeComboListeners(this.internalButton);
        this.internalButton.removeMouseListener(this);
        this.internalButton.addMouseListener(this);
        this.removeComboListeners(this);
        this.removeComboActionMap();
        if (this.editorComponent != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JVxComboBase.this.updateEditorComponent();
                }
            });
        }
    }

    public void setEditable(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("JVxComboBase is always editable");
        }
        super.setEditable(bl);
    }

    public boolean isEditorEditable() {
        if (this.editorComponent == null) {
            return true;
        }
        return this.editorComponent.isEditable();
    }

    public void setEditorEditable(boolean bl) {
        if (this.editorComponent != null) {
            this.editorComponent.setEditable(bl);
            this.internalButton.setEnabled(bl && this.buttonEnabled);
            this.updateEditorComponent();
        }
    }

    public void setButtonEnabled(boolean bl) {
        this.buttonEnabled = bl;
        if (this.editorComponent == null || this.editorComponent.isEditable() != this.buttonEnabled) {
            this.internalButton.setEnabled(bl);
        }
    }

    public void setPopupVisible(boolean bl) {
        if (bl && this.isShowing() && this.isEditorEditable() && this.buttonEnabled) {
            Object object;
            this.ignorePopupMenuEvents = this.internalPopup.isShowing();
            if (this.ignorePopupMenuEvents) {
                this.internalPopup.setVisible(false);
            }
            Dimension dimension = this.getSize();
            this.internalPopup.setPreferredSize(null);
            this.getModel().setSelectedItem(this.getEditor().getItem());
            Dimension dimension2 = this.internalPopup.getPreferredSize();
            if (this.popupSize != null) {
                if (dimension2.width > this.popupSize.width) {
                    dimension2.width = this.popupSize.width;
                }
                if (dimension2.height > this.popupSize.height) {
                    dimension2.height = this.popupSize.height;
                }
            }
            if (dimension2.width < dimension.width) {
                dimension2.width = dimension.width;
            }
            this.internalPopup.setPreferredSize(dimension2);
            this.internalPopup.setSize(dimension2);
            this.internalPopup.validate();
            this.internalPopup.show(this, 0, dimension.height);
            this.windowAncestor = SwingUtilities.getWindowAncestor(this);
            if (this.windowAncestor != null) {
                object = this.windowAncestor.getWindowListeners();
                for (int i = 0; i < ((WindowListener[])object).length; ++i) {
                    if (!object[i].getClass().getName().contains("MouseGrabber")) continue;
                    this.windowAncestor.removeWindowListener((WindowListener)object[i]);
                }
                this.windowAncestor.addWindowListener(this);
            }
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy().getFirstComponent(this.popupComponent);
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (object != null && (this.forceFocusOnPopup || aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 40)) {
                ((Component)object).requestFocus();
            } else if (this.editorComponent.isFocusable()) {
                this.editorComponent.requestFocus();
            } else {
                this.requestFocus();
            }
            this.ignorePopupMenuEvents = false;
        } else if (!bl && this.internalPopup.isShowing()) {
            try {
                this.internalPopup.setVisible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        if (this.editorComponent != null) {
            this.editorComponent.removeMouseListener(this);
            this.editorComponent.removeKeyListener(this);
        }
        super.setEditor(comboBoxEditor);
        if (comboBoxEditor == null) {
            this.editorComponent = null;
        } else {
            this.editorComponent = (JTextComponent)comboBoxEditor.getEditorComponent();
            this.updateEditorComponent();
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.isPopupVisible()) {
            this.setPopupVisible(false);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.isPopupVisible()) {
            this.setPopupVisible(false);
        }
    }

    public Dimension getPopupSize() {
        return this.popupSize;
    }

    public void setPopupSize(Dimension dimension) {
        this.popupSize = dimension;
    }

    public boolean isForceFocusOnPopup() {
        return this.forceFocusOnPopup;
    }

    public void setForceFocusOnPopup(boolean bl) {
        this.forceFocusOnPopup = bl;
    }

    private void removeComboListeners(Component component) {
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (mouseListenerArray[i].getClass().getName().indexOf("Combo") < 0) continue;
            component.removeMouseListener(mouseListenerArray[i]);
        }
        MouseMotionListener[] mouseMotionListenerArray = component.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            if (mouseMotionListenerArray[i].getClass().getName().indexOf("Combo") < 0) continue;
            component.removeMouseMotionListener(mouseMotionListenerArray[i]);
        }
        KeyListener[] keyListenerArray = component.getKeyListeners();
        for (int i = 0; i < keyListenerArray.length; ++i) {
            if (keyListenerArray[i].getClass().getName().indexOf("Combo") < 0) continue;
            component.removeKeyListener(keyListenerArray[i]);
        }
        FocusListener[] focusListenerArray = component.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            if (focusListenerArray[i].getClass().getName().indexOf("Combo") < 0) continue;
            component.removeFocusListener(focusListenerArray[i]);
        }
    }

    private void removeComboActionMap() {
        ActionMap actionMap = this.getActionMap();
        while (actionMap.getParent() != null) {
            if (actionMap.getParent().getParent() == null) {
                actionMap.setParent(null);
                continue;
            }
            actionMap = actionMap.getParent();
        }
    }

    private void updateEditorComponent() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        jTextComponent.setEditable(this.isEditorEditable());
        jTextComponent.addNotify();
        jTextComponent.updateUI();
        if (this.editorComponent != null) {
            this.editorComponent.setBorder(jTextComponent.getBorder());
            if (this.editorComponent.getBackground() instanceof UIResource) {
                this.editorComponent.setBackground(jTextComponent.getBackground());
            }
            this.editorComponent.removeMouseListener(this);
            this.editorComponent.addMouseListener(this);
            this.editorComponent.removeKeyListener(this);
            this.editorComponent.addKeyListener(this);
        }
    }

    public boolean isPopupVisible() {
        return this.internalPopup.isShowing();
    }

    public boolean isPopupFocusEvent(FocusEvent focusEvent) {
        return this.isChild(this.internalPopup, focusEvent.getOppositeComponent()) || this.isChild(this, focusEvent.getOppositeComponent());
    }

    private boolean isChild(Component component, Component component2) {
        while (component2 != null) {
            if (component2 == component) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    private void removeDoNotCancelPopupComponents(Component component) {
        if (component instanceof Container) {
            Container container;
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)(container = (JComponent)component)).getClientProperty("doNotCancelPopup")) != null && !this.isChild(this, container)) {
                this.doNotCancelPopup = object;
                this.doNotCancelPopupComponents.add((JComponent)container);
                ((JComponent)container).putClientProperty("doNotCancelPopup", null);
            }
            container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.removeDoNotCancelPopupComponents(container.getComponent(i));
            }
        }
    }

    private void addDoNotCancelPopupComponents() {
        for (int i = 0; i < this.doNotCancelPopupComponents.size(); ++i) {
            this.doNotCancelPopupComponents.get(i).putClientProperty("doNotCancelPopup", this.doNotCancelPopup);
        }
        this.doNotCancelPopupComponents.clear();
    }

    public JTextComponent getEditorComponent() {
        return this.editorComponent;
    }

    public void setEditorComponent(JTextComponent jTextComponent) {
        this.setEditor(new GenericComboBoxEditor(jTextComponent));
    }

    public JComponent getPopupComponent() {
        return this.popupComponent;
    }

    public void setPopupComponent(JComponent jComponent) {
        if (this.popupComponent != null) {
            this.internalPopup.remove(this.popupComponent);
        }
        this.popupComponent = jComponent;
        if (this.popupComponent != null) {
            if (this.popupComponent instanceof ITranslatable) {
                ((ITranslatable)((Object)this.popupComponent)).setTranslation(this.translation);
            }
            this.internalPopup.add((Component)this.popupComponent, "Center");
            this.internalPopup.validate();
        }
    }

    public static class GenericComboBoxEditor
    implements ComboBoxEditor {
        private JTextComponent editorComponent;

        public GenericComboBoxEditor() {
            this(null);
        }

        public GenericComboBoxEditor(JTextComponent jTextComponent) {
            this.editorComponent = jTextComponent == null ? new JTextField("", 9) : jTextComponent;
            this.editorComponent.setName("ComboBox.textField");
            JVxUtil.installActions(this.editorComponent);
        }

        public Component getEditorComponent() {
            return this.editorComponent;
        }

        public Object getItem() {
            if (this.editorComponent instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)this.editorComponent).commitEdit();
                }
                catch (ParseException parseException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.editorComponent);
                }
                return ((JFormattedTextField)this.editorComponent).getValue();
            }
            String string = this.editorComponent.getText();
            if (string == null || string.length() == 0) {
                return null;
            }
            return string;
        }

        public void setItem(Object object) {
            int n;
            AbstractDocument abstractDocument = (AbstractDocument)this.editorComponent.getDocument();
            DocumentListener[] documentListenerArray = abstractDocument.getDocumentListeners();
            for (n = 0; n < documentListenerArray.length; ++n) {
                abstractDocument.removeDocumentListener(documentListenerArray[n]);
            }
            if (this.editorComponent instanceof JFormattedTextField) {
                ((JFormattedTextField)this.editorComponent).setValue(object);
            } else if (object == null) {
                this.editorComponent.setText("");
            } else {
                this.editorComponent.setText(String.valueOf(object));
            }
            this.editorComponent.repaint();
            for (n = 0; n < documentListenerArray.length; ++n) {
                abstractDocument.addDocumentListener(documentListenerArray[n]);
            }
        }

        public void selectAll() {
            this.editorComponent.selectAll();
            this.editorComponent.requestFocus();
        }

        public void addActionListener(ActionListener actionListener) {
            if (this.editorComponent instanceof JTextField) {
                ((JTextField)this.editorComponent).addActionListener(actionListener);
            }
        }

        public void removeActionListener(ActionListener actionListener) {
            if (this.editorComponent instanceof JTextField) {
                ((JTextField)this.editorComponent).removeActionListener(actionListener);
            }
        }
    }
}

