/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InvalidObjectException;
import java.math.BigDecimal;
import java.util.Date;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ITableControl;
import javax.rad.util.TranslationMap;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;

public class JVxChart
extends JPanel
implements ITableControl,
Runnable {
    public static final int STYLE_LINES = 0;
    public static final int STYLE_AREA = 1;
    public static final int STYLE_BARS = 2;
    private ChartPanel chartPanel = null;
    private DataBookXYDataset dataset = null;
    private ValueAxis vaX = null;
    private ValueAxis vaY = null;
    private IDataBook dataBook = null;
    private int chartStyle = 0;
    private String sTitle = null;
    private String sXTitle = null;
    private String sYTitle = null;
    private String sXColumnName = null;
    private String[] saYColumnNames = null;
    private TranslationMap tmpTranslation = null;
    private boolean bFirstNotifyRepaintCall = true;

    public JVxChart() {
        this.setLayout(new BorderLayout());
    }

    public void notifyRepaint() {
        if (this.bFirstNotifyRepaintCall) {
            this.bFirstNotifyRepaintCall = false;
            JVxUtil.invokeLater(this);
        }
    }

    public void startEditing() {
    }

    public void cancelEditing() {
        if (this.dataset != null) {
            try {
                this.dataset.validateObject();
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    }

    public void saveEditing() throws ModelException {
    }

    public void setTranslation(TranslationMap translationMap) {
        if (this.tmpTranslation != translationMap) {
            this.tmpTranslation = translationMap;
            if (this.vaX != null) {
                this.vaX.setLabel(this.getTranslation(this.sXTitle));
            }
            if (this.vaY != null) {
                this.vaY.setLabel(this.getTranslation(this.sYTitle));
            }
            if (this.chartPanel != null) {
                this.chartPanel.getChart().setTitle(this.getTranslation(this.sTitle));
            }
            this.notifyRepaint();
        }
    }

    public TranslationMap getTranslation() {
        return this.tmpTranslation;
    }

    public void run() {
        this.cancelEditing();
        this.bFirstNotifyRepaintCall = true;
    }

    public IDataBook getDataBook() {
        return this.dataBook;
    }

    public void setDataBook(IDataBook iDataBook) {
        this.uninstallChart();
        this.dataBook = iDataBook;
        this.installChart();
    }

    public int getChartStyle() {
        return this.chartStyle;
    }

    public void setChartStyle(int n) {
        if (n != this.chartStyle) {
            this.uninstallChart();
            this.chartStyle = n;
            this.installChart();
        }
    }

    public String getTitle() {
        return this.sTitle;
    }

    public void setTitle(String string) {
        this.sTitle = string;
    }

    public String getXAxisTitle() {
        return this.sXTitle;
    }

    public void setXAxisTitle(String string) {
        this.sXTitle = string;
    }

    public String getYAxisTitle() {
        return this.sYTitle;
    }

    public void setYAxisTitle(String string) {
        this.sYTitle = string;
    }

    public String getXColumnName() {
        return this.sXColumnName;
    }

    public void setXColumnName(String string) {
        this.uninstallChart();
        this.sXColumnName = string;
        this.installChart();
    }

    public String[] getYColumnNames() {
        return this.saYColumnNames;
    }

    public void setYColumnNames(String[] stringArray) {
        this.uninstallChart();
        this.saYColumnNames = stringArray;
        this.installChart();
    }

    private void uninstallChart() {
        if (this.chartPanel != null) {
            this.dataBook.removeControl(this);
            this.remove((Component)this.chartPanel);
            this.chartPanel = null;
            this.dataset = null;
        }
    }

    public String getTranslation(String string) {
        if (this.tmpTranslation == null || string == null) {
            return string;
        }
        return this.tmpTranslation.translate(string);
    }

    private void installChart() {
        if (this.dataBook != null && this.sXColumnName != null && this.saYColumnNames != null) {
            try {
                this.dataset = new DataBookXYDataset(this.dataBook, this.sXColumnName, this.saYColumnNames, this);
                Object object = this.chartStyle == 1 ? new XYAreaRenderer(4) : (this.chartStyle == 2 ? new ClusteredXYBarRenderer(0.0, true) : new XYLineAndShapeRenderer(true, true));
                if (this.dataset.isDateAxis()) {
                    this.vaX = new DateAxis(this.getTranslation(this.sXTitle));
                } else {
                    this.vaX = new NumberAxis(this.getTranslation(this.sXTitle));
                    ((NumberAxis)this.vaX).setAutoRangeIncludesZero(false);
                }
                this.vaY = new NumberAxis(this.getTranslation(this.sYTitle));
                XYPlot xYPlot = new XYPlot((XYDataset)this.dataset, this.vaX, this.vaY, (XYItemRenderer)object);
                if (this.chartStyle == 1) {
                    xYPlot.setForegroundAlpha(0.65f);
                }
                object.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
                object.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
                JFreeChart jFreeChart = new JFreeChart(this.getTranslation(this.sTitle), JFreeChart.DEFAULT_TITLE_FONT, (Plot)xYPlot, true);
                this.chartPanel = new ChartPanel(jFreeChart);
                this.add((Component)this.chartPanel, "Center");
                this.dataBook.addControl(this);
                this.notifyRepaint();
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public static class DataBookXYDataset
    extends AbstractIntervalXYDataset
    implements XYDataset,
    TableXYDataset {
        private static BigDecimal percentage = new BigDecimal("0.9");
        private JVxChart chart;
        private IDataBook dataBook = null;
        private String xColumnName = null;
        private String[] yColumnNames = null;
        private boolean bDateAxis;

        public DataBookXYDataset(IDataBook iDataBook, String string, String[] stringArray, JVxChart jVxChart) throws ModelException {
            this.dataBook = iDataBook;
            this.xColumnName = string;
            this.yColumnNames = stringArray;
            this.chart = jVxChart;
            this.bDateAxis = Date.class.isAssignableFrom(this.dataBook.getRowDefinition().getColumnDefinition(this.xColumnName).getDataType().getTypeClass());
        }

        public Number getX(int n, int n2) {
            try {
                IChangeableDataRow iChangeableDataRow = this.dataBook.getDataRow(n2);
                if (this.bDateAxis) {
                    return ((Date)iChangeableDataRow.getValue(this.xColumnName)).getTime();
                }
                return (Number)iChangeableDataRow.getValue(this.xColumnName);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Number getY(int n, int n2) {
            try {
                IChangeableDataRow iChangeableDataRow = this.dataBook.getDataRow(n2);
                return (Number)iChangeableDataRow.getValue(this.yColumnNames[n]);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Number getStartX(int n, int n2) {
            return this.getX(n, n2);
        }

        public Number getEndX(int n, int n2) {
            BigDecimal bigDecimal = (BigDecimal)this.getX(n, n2);
            BigDecimal bigDecimal2 = n2 < this.getItemCount() - 1 ? ((BigDecimal)this.getX(n, n2 + 1)).subtract(bigDecimal) : (n2 == 0 ? (BigDecimal.ZERO.equals(bigDecimal) ? bigDecimal : BigDecimal.ONE) : bigDecimal.subtract((BigDecimal)this.getX(n, n2 - 1)));
            return bigDecimal.add(bigDecimal2.multiply(percentage));
        }

        public Number getStartY(int n, int n2) {
            return this.getY(n, n2);
        }

        public Number getEndY(int n, int n2) {
            BigDecimal bigDecimal = (BigDecimal)this.getY(n, n2);
            BigDecimal bigDecimal2 = n2 < this.getItemCount() - 1 ? ((BigDecimal)this.getY(n, n2 + 1)).subtract(bigDecimal) : (n2 == 0 ? (BigDecimal.ZERO.equals(bigDecimal) ? bigDecimal : BigDecimal.ONE) : bigDecimal.subtract((BigDecimal)this.getY(n, n2 - 1)));
            return bigDecimal.add(bigDecimal2.multiply(percentage));
        }

        public int getItemCount(int n) {
            return this.getItemCount();
        }

        public int getItemCount() {
            try {
                this.dataBook.fetchAll();
                return this.dataBook.getRowCount();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }

        public int getSeriesCount() {
            return this.yColumnNames.length;
        }

        public Comparable getSeriesKey(int n) {
            try {
                return this.chart.getTranslation(this.dataBook.getRowDefinition().getColumnDefinition(this.yColumnNames[n]).getLabel());
            }
            catch (Exception exception) {
                return this.chart.getTranslation(this.yColumnNames[n]);
            }
        }

        public boolean isDateAxis() {
            return this.bDateAxis;
        }
    }
}

