/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.awt.impl;

import com.sibvisions.rad.ui.awt.impl.AwtResource;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.rad.ui.IImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwtImage
extends AwtResource<Image>
implements IImage {
    public AwtImage(Image image) {
        super(image);
    }

    @Override
    public int getWidth() {
        return ((Image)this.resource).getWidth(null);
    }

    @Override
    public int getHeight() {
        return ((Image)this.resource).getHeight(null);
    }

    @Override
    public void saveAs(OutputStream outputStream, IImage.ImageType imageType) throws IOException {
        String string;
        if (imageType == null) {
            string = "png";
        } else {
            switch (imageType) {
                case JPG: {
                    string = "jpg";
                    break;
                }
                case GIF: {
                    string = "gif";
                    break;
                }
                case BMP: {
                    string = "bmp";
                    break;
                }
                default: {
                    string = "png";
                }
            }
        }
        if (this.resource instanceof RenderedImage) {
            ImageIO.write((RenderedImage)this.resource, string, outputStream);
        } else {
            BufferedImage bufferedImage = new BufferedImage(((Image)this.resource).getWidth(null), ((Image)this.resource).getHeight(null), 2);
            bufferedImage.getGraphics().drawImage((Image)this.resource, 0, 0, null);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
    }
}

