/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public class XmlSecurityManager
extends AbstractSecurityManager {
    private XmlNode xmnUsers = null;
    private File fiUsers = null;

    public synchronized void validateAuthentication(ISession iSession) throws Exception {
        this.getAuthenticatedUserNode(iSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changePassword(ISession iSession) throws Exception {
        String string = (String)iSession.getProperty("client.oldpassword");
        String string2 = (String)iSession.getProperty("client.newpassword");
        IConfiguration iConfiguration = iSession.getConfig();
        this.validatePassword(iSession, string, string2);
        XmlNode xmlNode = this.getAuthenticatedUserNode(iSession);
        if (this.comparePassword(iConfiguration, string, xmlNode.getNode("/password").getValue())) {
            xmlNode.setNode("/password", XmlSecurityManager.getEncryptedPassword(iConfiguration, string2));
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.fiUsers);
                XmlWorker xmlWorker = new XmlWorker();
                xmlWorker.write(fileOutputStream, this.xmnUsers);
            }
            catch (Throwable throwable) {
                xmlNode.setNode("/password", XmlSecurityManager.getEncryptedPassword(iConfiguration, string));
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            throw new SecurityException("Invalid password for '" + iSession.getUserName() + "' and application '" + iSession.getApplicationName() + "'");
        }
    }

    public synchronized void logout(ISession iSession) {
    }

    public synchronized IAccessController getAccessController(ISession iSession) {
        return null;
    }

    public synchronized void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers(ISession iSession) throws Exception {
        if (this.xmnUsers == null) {
            IConfiguration iConfiguration = iSession.getConfig();
            String string = iConfiguration.getProperty("/application/securitymanager/userfile");
            if (string == null) {
                throw new SecurityException("Parameter 'userfile' is missing for application '" + iSession.getApplicationName() + "'");
            }
            File file = new File(string);
            FileInputStream fileInputStream = null;
            if (!file.exists()) {
                file = iConfiguration instanceof Zone ? new File(((Zone)((Object)iConfiguration)).getDirectory(), string) : new File(Configuration.getApplicationZone(iSession.getApplicationName()).getDirectory(), string);
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                }
            } else {
                fileInputStream = new FileInputStream(file);
            }
            if (fileInputStream == null) {
                throw new SecurityException("Userfile '" + string + "' does not exist!");
            }
            XmlWorker xmlWorker = new XmlWorker();
            try {
                this.xmnUsers = xmlWorker.read(fileInputStream);
                this.fiUsers = file;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private XmlNode getAuthenticatedUserNode(ISession iSession) throws Exception {
        this.loadUsers(iSession);
        List<XmlNode> list = this.xmnUsers.getNodes("/users/user");
        String string = iSession.getUserName();
        IConfiguration iConfiguration = iSession.getConfig();
        for (XmlNode xmlNode : list) {
            if (!string.equals(xmlNode.getNode("/name").getValue())) continue;
            if (this.comparePassword(iConfiguration, iSession.getPassword(), xmlNode.getNode("/password").getValue())) {
                return xmlNode;
            }
            throw new SecurityException("Invalid password for '" + iSession.getUserName() + "' and application '" + iSession.getApplicationName() + "'");
        }
        throw new SecurityException("User '" + string + "' was not found for application '" + iSession.getApplicationName() + "'");
    }
}

