/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.DBCredentials;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.config.DBObjects;
import com.sibvisions.rad.server.config.Zone;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.DataSourceHandler;
import com.sibvisions.rad.server.security.IAccessController;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.xml.XmlNode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.UUID;
import javax.rad.remote.ChangePasswordException;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public class DBSecurityManager
extends AbstractSecurityManager {
    protected static final String TABLE_USERS = "USERS";
    protected static final String TABLE_AUTOLOGIN = "AUTOLOGIN";
    protected static final String VIEW_ACCESSRULES = "V_ACCESSRULES";
    private static ILogger log = LoggerFactory.getInstance(DBSecurityManager.class);
    private DBCredentials credentials = null;
    private Connection con = null;
    private PreparedStatement psAutoLogin;
    private PreparedStatement psInsertAutoLogin;
    private PreparedStatement psDeleteAutoLoginKey;
    private PreparedStatement psDeleteAutoLoginUser;
    private PreparedStatement psUserId;
    private PreparedStatement psUserName;
    private PreparedStatement psAccessRule;
    private PreparedStatement psChangePwd;
    private PreparedStatement psChangePwdUnset;
    String sUsersTable;
    String sUsersId;
    String sUsersName;
    String sUsersChgPwd;
    String sUsersPwd;
    String sAutoLoginTable;
    String sAutoLoginId;
    String sAutoLoginKey;
    String sAccessTable;
    String sAccessUser;
    private long lConfigModified = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void validateAuthentication(ISession iSession) throws Exception {
        block49: {
            String string = iSession.getApplicationName();
            String string2 = iSession.getUserName();
            IConfiguration iConfiguration = iSession.getConfig();
            ResultSet resultSet = null;
            boolean bl = false;
            this.openConnection(iSession);
            try {
                Object object;
                String string3 = (String)iSession.getProperty("client.login.key");
                if (this.psAutoLogin != null && string3 != null) {
                    object = null;
                    try {
                        this.psAutoLogin.clearParameters();
                        this.psAutoLogin.setString(1, string3);
                        object = this.psAutoLogin.executeQuery();
                        if (object.next()) {
                            this.psUserId.clearParameters();
                            this.psUserId.setBigDecimal(1, object.getBigDecimal(1));
                            resultSet = this.psUserId.executeQuery();
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        log.debug(exception);
                    }
                    finally {
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                if (resultSet == null) {
                    this.psUserName.clearParameters();
                    this.psUserName.setString(1, string2);
                    resultSet = this.psUserName.executeQuery();
                }
                this.validateUser(iSession, resultSet);
                if (!bl) {
                    try {
                        object = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD"));
                    }
                    catch (SQLException sQLException) {
                        object = null;
                    }
                    if (!this.isPasswordValid(iSession, (String)object)) {
                        throw new SecurityException("Invalid password for '" + string2 + "' and application '" + string + "'");
                    }
                }
                try {
                    object = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD"));
                }
                catch (SQLException sQLException) {
                    object = null;
                }
                if (this.isChangePassword(iSession, (String)object)) {
                    throw new ChangePasswordException("Please change your password");
                }
                boolean bl2 = Boolean.valueOf((String)iSession.getProperty("client.login.auto"));
                if (string3 == null && bl2 && this.psAutoLogin != null && this.psDeleteAutoLoginUser != null && this.psInsertAutoLogin != null) {
                    string3 = UUID.randomUUID().toString();
                    try {
                        BigDecimal bigDecimal = resultSet.getBigDecimal(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ID"));
                        this.psDeleteAutoLoginUser.clearParameters();
                        this.psDeleteAutoLoginUser.setBigDecimal(1, bigDecimal);
                        if (this.psDeleteAutoLoginUser.execute()) {
                            this.psDeleteAutoLoginUser.getResultSet().close();
                        }
                        this.psInsertAutoLogin.clearParameters();
                        this.psInsertAutoLogin.setBigDecimal(1, bigDecimal);
                        this.psInsertAutoLogin.setString(2, string3);
                        if (this.psInsertAutoLogin.execute()) {
                            this.psInsertAutoLogin.getResultSet().close();
                        }
                        this.con.commit();
                        iSession.setProperty("client.login.key", string3);
                    }
                    catch (Exception exception) {
                        try {
                            this.con.rollback();
                        }
                        catch (SQLException sQLException) {
                            log.error(sQLException);
                        }
                        log.error(exception);
                    }
                }
                if (bl) {
                    if (!(iSession instanceof AbstractSession)) break block49;
                    try {
                        ((AbstractSession)iSession).setUserName(resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "USERNAME")));
                        break block49;
                    }
                    catch (SQLException sQLException) {
                        throw new SecurityException("USERNAME column for application '" + string + "' was not found!");
                    }
                }
                if (!bl2) {
                    iSession.setProperty("client.login.key", null);
                }
            }
            catch (SQLException sQLException) {
                log.error(sQLException);
                throw new SecurityException("Authentication for user '" + string2 + "' and application '" + string + "' is not possible");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        resultSet = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changePassword(ISession iSession) throws Exception {
        block24: {
            String string = (String)iSession.getProperty("client.oldpassword");
            String string2 = (String)iSession.getProperty("client.newpassword");
            this.validatePassword(iSession, string, string2);
            String string3 = iSession.getApplicationName();
            String string4 = iSession.getUserName();
            IConfiguration iConfiguration = iSession.getConfig();
            this.openConnection(iSession);
            ResultSet resultSet = null;
            try {
                String string5;
                this.psUserName.clearParameters();
                this.psUserName.setString(1, string4);
                resultSet = this.psUserName.executeQuery();
                this.validateUser(iSession, resultSet);
                try {
                    string5 = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD"));
                }
                catch (SQLException sQLException) {
                    string5 = null;
                }
                if ((iSession.getProperty("client.login.key") != null && iSession.getPassword() == null || this.comparePassword(iConfiguration, iSession.getPassword(), string)) && this.comparePassword(iConfiguration, string, string5)) {
                    boolean bl;
                    try {
                        resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD"));
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                    PreparedStatement preparedStatement = bl ? this.psChangePwdUnset : this.psChangePwd;
                    preparedStatement.clearParameters();
                    preparedStatement.setString(1, DBSecurityManager.getEncryptedPassword(iConfiguration, string2));
                    preparedStatement.setString(2, string4);
                    if (preparedStatement.execute()) {
                        preparedStatement.getResultSet().close();
                    }
                    this.con.commit();
                    if (preparedStatement.getUpdateCount() != 1) {
                        throw new SecurityException("User '" + string4 + "' was not found for application '" + string3 + "'");
                    }
                    break block24;
                }
                throw new SecurityException("Invalid password for '" + string4 + "' and application '" + string3 + "'");
            }
            catch (SQLException sQLException) {
                log.debug(sQLException);
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException2) {
                    log.error(sQLException2);
                }
                throw new SecurityException("Error while changing password of '" + string4 + "' for application '" + string3 + "'");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        resultSet = null;
                    }
                }
            }
        }
    }

    public synchronized void logout(ISession iSession) {
        if (Boolean.valueOf((String)iSession.getProperty("userlogout")).booleanValue()) {
            try {
                String string = (String)iSession.getProperty("client.login.key");
                if (string != null) {
                    this.openConnection(iSession);
                    this.psDeleteAutoLoginKey.clearParameters();
                    this.psDeleteAutoLoginKey.setString(1, string);
                    if (this.psDeleteAutoLoginKey.execute()) {
                        this.psDeleteAutoLoginKey.getResultSet().close();
                    }
                    this.con.commit();
                    iSession.setProperty("client.login.key", null);
                }
            }
            catch (Exception exception) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    log.error(sQLException);
                }
                log.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IAccessController getAccessController(ISession iSession) throws Exception {
        IConfiguration iConfiguration = iSession.getConfig();
        ResultSet resultSet = null;
        this.openConnection(iSession);
        if (this.psAccessRule == null) {
            return null;
        }
        try {
            this.psAccessRule.clearParameters();
            this.psAccessRule.setObject(1, iSession.getUserName());
            resultSet = this.psAccessRule.executeQuery();
            IAccessController iAccessController = this.createAccessController(iSession);
            while (resultSet.next()) {
                iAccessController.addAccess(resultSet.getString(DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "LIFECYCLENAME")));
            }
            IAccessController iAccessController2 = iAccessController;
            return iAccessController2;
        }
        catch (SQLException sQLException) {
            log.debug(sQLException);
            IAccessController iAccessController = null;
            return iAccessController;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
    }

    public synchronized void release() {
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            log.error(exception);
        }
    }

    protected void finalize() throws Throwable {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection openConnection(ISession iSession) throws Exception {
        Object object;
        String string = iSession.getApplicationName();
        IConfiguration iConfiguration = iSession.getConfig();
        DBCredentials dBCredentials = DBSecurityManager.getCredentials(iConfiguration);
        if (dBCredentials == null) {
            throw new IllegalArgumentException("Database credentials were not found!");
        }
        if (dBCredentials.getDriver() == null) {
            DBAccess dBAccess = DBAccess.getDBAccess(dBCredentials.getUrl());
            if (dBAccess != null) {
                dBCredentials = new DBCredentials(dBAccess.getDriver(), dBCredentials.getUrl(), dBCredentials.getUserName(), dBCredentials.getPassword());
                if (dBCredentials.getDriver() == null) {
                    throw new IllegalArgumentException("Parameter 'driver' is missing for application '" + string + "'");
                }
            } else {
                throw new IllegalArgumentException("Parameter 'url' is missing for application '" + string + "'");
            }
        }
        if (dBCredentials.getUrl() == null) {
            throw new IllegalArgumentException("Parameter 'url' is missing for application '" + string + "'");
        }
        if (dBCredentials.getUserName() == null) {
            throw new IllegalArgumentException("Parameter 'username' is missing for application '" + string + "'");
        }
        if (dBCredentials.getPassword() == null) {
            throw new IllegalArgumentException("Parameter 'password' is missing for application '" + string + "'");
        }
        boolean bl = false;
        long l = iConfiguration instanceof Zone ? ((Zone)((Object)iConfiguration)).getFile().lastModified() : Configuration.getApplicationZone(string).getFile().lastModified();
        if (this.con == null || !this.credentials.equals(dBCredentials) || this.lConfigModified != l) {
            bl = true;
        } else {
            object = null;
            ResultSet resultSet = null;
            try {
                object = this.con.createStatement();
                resultSet = object.executeQuery("select ID from " + DBObjects.getTableName(iConfiguration, TABLE_USERS));
                resultSet.next();
            }
            catch (Throwable throwable) {
                bl = true;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        if (bl) {
            this.closeConnection();
            try {
                Class.forName(dBCredentials.getDriver());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException("JDBC driver '" + dBCredentials.getDriver() + "' for application '" + string + "' was not found!", classNotFoundException);
            }
            try {
                object = DBAccess.getDBAccess(dBCredentials);
                ((DBAccess)object).open();
                this.con = ((DBAccess)object).getConnection();
                this.con.setAutoCommit(false);
                this.initStatements(iConfiguration);
            }
            catch (SQLException sQLException) {
                this.closeConnection();
                throw new Exception("Can not open database connection with '" + dBCredentials.getUrl() + "' for application '" + string + "'", sQLException);
            }
            this.credentials = dBCredentials;
            this.lConfigModified = l;
        }
        return this.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() throws Exception {
        if (this.con != null) {
            for (Field field : DBSecurityManager.class.getDeclaredFields()) {
                int n = field.getModifiers();
                if (Modifier.isFinal(n) || Modifier.isStatic(n)) continue;
                try {
                    Object object = field.get(this);
                    if (object == null || !(object instanceof PreparedStatement)) continue;
                    try {
                        ((PreparedStatement)object).close();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    log.debug(field.getName(), exception);
                }
            }
            try {
                this.con.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.con = null;
            }
        }
    }

    private void initStatements(IConfiguration iConfiguration) throws Exception {
        this.sUsersTable = DBObjects.getTableName(iConfiguration, TABLE_USERS);
        this.sUsersId = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ID");
        this.sUsersName = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "USERNAME");
        this.sUsersChgPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "CHANGE_PASSWORD");
        this.sUsersPwd = DBObjects.getColumnName(iConfiguration, TABLE_USERS, "PASSWORD");
        this.sAutoLoginTable = DBObjects.getTableName(iConfiguration, TABLE_AUTOLOGIN);
        this.sAutoLoginId = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "USER_ID");
        this.sAutoLoginKey = DBObjects.getColumnName(iConfiguration, TABLE_AUTOLOGIN, "LOGINKEY");
        this.sAccessTable = DBObjects.getTableName(iConfiguration, VIEW_ACCESSRULES);
        this.sAccessUser = DBObjects.getColumnName(iConfiguration, VIEW_ACCESSRULES, "USERNAME");
        this.initStatements(this.con);
    }

    protected void initStatements(Connection connection) throws Exception {
        block15: {
            this.psUserId = connection.prepareStatement("select * from " + this.sUsersTable + " u where u." + this.sUsersId + " = ?");
            this.psUserName = connection.prepareStatement("select * from " + this.sUsersTable + " u where u." + this.sUsersName + " = ?");
            this.psChangePwd = connection.prepareStatement("update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ? " + " where u." + this.sUsersName + " = ?");
            this.psChangePwdUnset = connection.prepareStatement("update " + this.sUsersTable + " u set u." + this.sUsersPwd + " = ?, " + "u." + this.sUsersChgPwd + " = 'N' " + " where u." + this.sUsersName + " = ?");
            try {
                this.psAutoLogin = connection.prepareStatement("select al." + this.sAutoLoginId + " from " + this.sAutoLoginTable + " al where al." + this.sAutoLoginKey + " = ?");
                this.psInsertAutoLogin = connection.prepareStatement("insert into " + this.sAutoLoginTable + "(" + this.sAutoLoginId + ", " + this.sAutoLoginKey + ") values (?, ?)");
                this.psDeleteAutoLoginKey = connection.prepareStatement("delete from " + this.sAutoLoginTable + " al where al." + this.sAutoLoginKey + " = ?");
                this.psDeleteAutoLoginUser = connection.prepareStatement("delete from " + this.sAutoLoginTable + " al where al." + this.sAutoLoginId + " = ?");
            }
            catch (SQLException sQLException) {
                if (this.psAutoLogin != null) {
                    try {
                        this.psAutoLogin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.psAutoLogin = null;
                }
                if (this.psInsertAutoLogin != null) {
                    try {
                        this.psInsertAutoLogin.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.psInsertAutoLogin = null;
                }
                if (this.psDeleteAutoLoginKey != null) {
                    try {
                        this.psDeleteAutoLoginKey.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.psDeleteAutoLoginKey = null;
                }
                if (this.psDeleteAutoLoginUser == null) break block15;
                try {
                    this.psDeleteAutoLoginUser.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.psDeleteAutoLoginUser = null;
            }
        }
        try {
            this.psAccessRule = connection.prepareStatement("select * from " + this.sAccessTable + " where " + this.sAccessUser + " = ?");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateUser(ISession iSession, ResultSet resultSet) throws Exception {
        Timestamp timestamp;
        Timestamp timestamp2;
        String string;
        String string2 = iSession.getApplicationName();
        String string3 = iSession.getUserName();
        if (!resultSet.next()) throw new SecurityException("User '" + string3 + "' was not found for application '" + string2 + "'");
        IConfiguration iConfiguration = iSession.getConfig();
        try {
            string = resultSet.getString(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "ACTIVE"));
        }
        catch (SQLException sQLException) {
            string = null;
        }
        if (!this.isActive(iSession, string)) throw new SecurityException("User '" + string3 + "' is inactive for application '" + string2 + "'");
        try {
            timestamp2 = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_FROM"));
        }
        catch (SQLException sQLException) {
            timestamp2 = null;
        }
        try {
            timestamp = resultSet.getTimestamp(DBObjects.getColumnName(iConfiguration, TABLE_USERS, "VALID_TO"));
        }
        catch (SQLException sQLException) {
            timestamp = null;
        }
        if (this.isValid(iSession, timestamp2, timestamp)) return;
        throw new SecurityException("User '" + string3 + "' is expired for application '" + string2 + "'");
    }

    protected boolean isActive(ISession iSession, String string) throws Exception {
        if (string == null) {
            return true;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected boolean isValid(ISession iSession, Timestamp timestamp, Timestamp timestamp2) {
        long l = System.currentTimeMillis();
        return !(timestamp != null && timestamp.getTime() > l || timestamp2 != null && timestamp2.getTime() <= l);
    }

    protected boolean isPasswordValid(ISession iSession, String string) throws Exception {
        return this.comparePassword(iSession.getConfig(), iSession.getPassword(), string);
    }

    protected boolean isChangePassword(ISession iSession, String string) throws Exception {
        if (string == null) {
            return false;
        }
        return DBObjects.getYesValue(iSession.getConfig()).equals(string);
    }

    protected IAccessController createAccessController(ISession iSession) {
        String string = iSession.getConfig().getProperty("/application/securitymanager/accesscontroller");
        if (string != null && string.trim().length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                return (IAccessController)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SecurityException("Access controller '" + string + "' was not found!");
            }
            catch (InstantiationException instantiationException) {
                throw new SecurityException("Can't instantiate access controller '" + string + "'!");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SecurityException("Access controller '" + string + "' not accessible!");
            }
        }
        return new DBAccessController();
    }

    public static DBCredentials getCredentials(IConfiguration iConfiguration) {
        try {
            XmlNode xmlNode = iConfiguration.getNode("/application/securitymanager/database");
            if (xmlNode == null) {
                return DataSourceHandler.createDBCredentials(iConfiguration, "default");
            }
            XmlNode xmlNode2 = xmlNode.getNode("/datasource");
            if (xmlNode2 == null) {
                return DataSourceHandler.createDBCredentials(xmlNode);
            }
            return DataSourceHandler.createDBCredentials(iConfiguration, xmlNode2.getValue());
        }
        catch (Exception exception) {
            log.error(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws Exception {
        if (this.con != null) {
            boolean bl = false;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.con.createStatement();
                resultSet = statement.executeQuery("select ID from " + this.sUsersTable);
                resultSet.next();
            }
            catch (Throwable throwable) {
                bl = true;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (bl) {
                try {
                    DBAccess dBAccess = DBAccess.getDBAccess(this.credentials);
                    this.con = dBAccess.getConnection();
                    this.con.setAutoCommit(false);
                    this.initStatements(this.con);
                }
                catch (SQLException sQLException) {
                    this.closeConnection();
                    throw new Exception("Can not open database connection with '" + this.credentials.getUrl() + "'", sQLException);
                }
            }
        }
        return this.con;
    }

    public Connection getConnection(ISession iSession) throws Exception {
        return this.openConnection(iSession);
    }

    public static final class DBAccessController
    implements IAccessController {
        private ArrayUtil<String> auAllowedLCO = null;

        public boolean isAllowed(String string) {
            if (this.auAllowedLCO != null) {
                return this.auAllowedLCO.contains(string);
            }
            return false;
        }

        public void addAccess(String string) {
            if (string == null) {
                return;
            }
            if (this.auAllowedLCO == null) {
                this.auAllowedLCO = new ArrayUtil();
            }
            if (!this.auAllowedLCO.contains(string)) {
                this.auAllowedLCO.add(string);
            }
        }

        public void removeAccess(String string) {
            if (string == null || this.auAllowedLCO == null) {
                return;
            }
            this.auAllowedLCO.remove(string);
        }

        public String[] getAllowedLifeCycleNames() {
            if (this.auAllowedLCO == null) {
                return new String[0];
            }
            return this.auAllowedLCO.toArray(new String[this.auAllowedLCO.size()]);
        }
    }
}

