/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.rad.server.security.validation.IPasswordValidator;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

public abstract class AbstractSecurityManager
implements ISecurityManager,
IPasswordValidator {
    private static ArrayUtil<String> auHiddenPackages = null;

    public void checkPassword(ISession iSession, String string) {
        if (string == null || string.trim().length() == 0) {
            throw new SecurityException("The new password is empty");
        }
    }

    protected boolean comparePassword(IConfiguration iConfiguration, String string, String string2) throws Exception {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = AbstractSecurityManager.getEncryptedPassword(iConfiguration, string);
        String string4 = AbstractSecurityManager.isPasswordEncryptionEnabled(iConfiguration) && string2.charAt(0) != '\u007f' ? AbstractSecurityManager.getEncryptedPassword(iConfiguration, string2) : string2;
        return string3.equals(string4);
    }

    protected IPasswordValidator getPasswordValidator(IConfiguration iConfiguration) {
        String string = iConfiguration.getProperty("/application/securitymanager/passwordvalidator/class");
        if (string != null && string.trim().length() > 0) {
            try {
                return (IPasswordValidator)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SecurityException("Password validator '" + string + "' was not found!");
            }
            catch (InstantiationException instantiationException) {
                throw new SecurityException("Can't instantiate password validator '" + string + "'!");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SecurityException("Password validator '" + string + "' not accessible!");
            }
        }
        return null;
    }

    protected void validatePassword(ISession iSession, String string, String string2) throws Exception {
        if (string != null && string.equals(string2)) {
            throw new SecurityException("The old and new password are the same");
        }
        IPasswordValidator iPasswordValidator = this.getPasswordValidator(iSession.getConfig());
        if (iPasswordValidator != null) {
            iPasswordValidator.checkPassword(iSession, string2);
        } else {
            this.checkPassword(iSession, string2);
        }
    }

    public static String getEncryptedPassword(IConfiguration iConfiguration, String string) throws Exception {
        String string2 = iConfiguration.getProperty("/application/securitymanager/passwordalgorithm");
        if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("PLAIN")) {
            return '\u007f' + SecureHash.getHash(string2, string.getBytes());
        }
        return string;
    }

    public static boolean isPasswordEncryptionEnabled(IConfiguration iConfiguration) {
        String string = iConfiguration.getProperty("/application/securitymanager/passwordalgorithm");
        return string != null && string.length() > 0 && !string.equalsIgnoreCase("PLAIN");
    }

    public static ISecurityManager createSecurityManager(ISession iSession) throws Exception {
        String string = iSession.getConfig().getProperty("/application/securitymanager/class");
        if (string == null) {
            throw new SecurityException("Security manager is not set!");
        }
        return (ISecurityManager)Class.forName(string).newInstance();
    }

    public static ISecurityManager createSecurityManager(String string) throws Exception {
        String string2 = Configuration.getApplicationZone(string).getProperty("/application/securitymanager/class");
        if (string2 == null) {
            throw new SecurityException("Security manager is not set!");
        }
        return (ISecurityManager)Class.forName(string2).newInstance();
    }

    public static Throwable prepareException(Throwable throwable) {
        return AbstractSecurityManager.prepareException(throwable, false);
    }

    public static Throwable prepareException(Throwable throwable, boolean bl) {
        if (throwable instanceof SecurityException && (bl || !LoggerFactory.getInstance(AbstractSecurityManager.class).isEnabled(ILogger.LogLevel.DEBUG))) {
            ArrayUtil<StackTraceElement> arrayUtil = new ArrayUtil<StackTraceElement>();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray != null) {
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (stackTraceElementArray[i].getClassName().startsWith("com.sibvisions.rad") || AbstractSecurityManager.isHiddenPackage(stackTraceElementArray[i].getClassName())) continue;
                    arrayUtil.add(stackTraceElementArray[i]);
                }
            }
            stackTraceElementArray = arrayUtil.toArray(new StackTraceElement[arrayUtil.size()]);
            throwable.setStackTrace(stackTraceElementArray);
        }
        return throwable;
    }

    public static void addHiddenPackage(String string) {
        if (string != null) {
            if (auHiddenPackages == null) {
                auHiddenPackages = new ArrayUtil();
            }
            auHiddenPackages.add(string);
        }
    }

    public static void removeHiddenPackage(String string) {
        if (string != null && auHiddenPackages != null) {
            auHiddenPackages.remove(string);
            if (auHiddenPackages.size() == 0) {
                auHiddenPackages = null;
            }
        }
    }

    public static boolean isHiddenPackage(String string) {
        if (string == null || auHiddenPackages == null) {
            return false;
        }
        int n = auHiddenPackages.size();
        for (int i = 0; i < n; ++i) {
            if (!string.startsWith(auHiddenPackages.get(i))) continue;
            return true;
        }
        return false;
    }
}

