/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.http.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONUtil {
    private static ObjectMapper mapper = JSONUtil.createObjectMapper();
    private static PrintStream stream = System.out;
    private static boolean bDump = false;

    private JSONUtil() {
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationConfig.Feature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        objectMapper.configure(DeserializationConfig.Feature.USE_BIG_INTEGER_FOR_INTS, true);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    public static Object getObject(Representation representation) throws IOException {
        return JSONUtil.getObject(representation, Object.class);
    }

    public static <T> T getObject(Representation representation, Class clazz) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        representation.write((OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 0) {
            Object object = mapper.readValue(byArray, clazz);
            if (bDump) {
                stream.println(mapper.writer().withDefaultPrettyPrinter().writeValueAsString(object));
            }
            return (T)object;
        }
        return null;
    }

    public static void setDumpStreamEnabled(boolean bl) {
        bDump = bl;
    }

    public static boolean isDumpStreamEnabled() {
        return bDump;
    }

    public static void setDumpStream(PrintStream printStream) {
        stream = printStream != null ? printStream : System.out;
    }

    public static PrintStream getDumpStream() {
        return stream;
    }
}

