/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.xml.XmlNode;
import com.sibvisions.util.xml.XmlWorker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpToDateConfigFile
implements Cloneable {
    private File fiConfig;
    private XmlNode xmnConfig = null;
    private boolean bUpdateEnabled = true;
    private boolean bSaveImmediate = true;
    private boolean bChanged = false;
    private long lLastModified = -1L;

    public UpToDateConfigFile(File file, String string) throws Exception {
        if (file != null && string != null) {
            this.fiConfig = new File(file, string);
        }
        this.update();
    }

    public UpToDateConfigFile(File file) throws Exception {
        this.fiConfig = file;
        this.update();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            this.update();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        UpToDateConfigFile upToDateConfigFile = (UpToDateConfigFile)super.clone();
        upToDateConfigFile.xmnConfig = (XmlNode)this.xmnConfig.clone();
        return upToDateConfigFile;
    }

    public File getFile() {
        return this.fiConfig;
    }

    public boolean isValid() {
        return UpToDateConfigFile.isValid(this.fiConfig);
    }

    static boolean isValid(File file) {
        return file != null && file.exists();
    }

    protected void update() throws Exception {
        if (this.isValid()) {
            if (this.isUpdateEnabled() && (this.lLastModified <= 0L || this.lLastModified != this.fiConfig.lastModified())) {
                this.reload();
            }
        } else {
            throw new Exception("Invalid configuration file: " + (this.fiConfig != null ? this.fiConfig.getAbsolutePath() : null));
        }
    }

    public synchronized void setProperty(String string, String string2) throws Exception {
        this.update();
        if (string2 == null) {
            this.xmnConfig.removeNode(string);
        } else {
            this.xmnConfig.setNode(string, string2);
        }
        this.bChanged = true;
        if (this.bSaveImmediate) {
            this.save();
        }
    }

    public synchronized void setNode(String string, XmlNode xmlNode) throws Exception {
        this.update();
        if (xmlNode == null) {
            this.xmnConfig.removeNode(string);
        } else {
            this.xmnConfig.setNode(string, xmlNode);
        }
        this.bChanged = true;
        if (this.bSaveImmediate) {
            this.save();
        }
    }

    public synchronized String getProperty(String string) throws Exception {
        return this.getProperty(string, null);
    }

    public synchronized String getProperty(String string, String string2) throws Exception {
        this.update();
        XmlNode xmlNode = this.xmnConfig.getNode(string);
        if (xmlNode != null) {
            return CommonUtil.nvl(xmlNode.getValue(), "");
        }
        return string2;
    }

    public synchronized List<String> getProperties(String string) throws Exception {
        this.update();
        List<XmlNode> list = this.xmnConfig.getNodes(string);
        if (list == null) {
            return null;
        }
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (XmlNode xmlNode : list) {
            arrayUtil.add(CommonUtil.nvl(xmlNode.getValue(), ""));
        }
        return arrayUtil;
    }

    public synchronized List<XmlNode> getNodes(String string) throws Exception {
        this.update();
        List<XmlNode> list = this.xmnConfig.getNodes(string);
        if (list != null) {
            ArrayUtil<XmlNode> arrayUtil = new ArrayUtil<XmlNode>(list.size());
            for (XmlNode xmlNode : list) {
                arrayUtil.add((XmlNode)xmlNode.clone());
            }
            return arrayUtil;
        }
        return null;
    }

    public synchronized XmlNode getNode(String string) throws Exception {
        this.update();
        XmlNode xmlNode = this.xmnConfig.getNode(string);
        if (xmlNode != null) {
            return (XmlNode)xmlNode.clone();
        }
        return null;
    }

    public void setUpdateEnabled(boolean bl) {
        this.bUpdateEnabled = bl;
    }

    public boolean isUpdateEnabled() {
        return this.bUpdateEnabled;
    }

    public synchronized void setSaveImmediate(boolean bl) {
        this.bSaveImmediate = bl;
    }

    public boolean isSaveImmediate() {
        return this.bSaveImmediate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        if (this.bChanged) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.fiConfig);
                XmlWorker xmlWorker = this.createXmlWorker();
                xmlWorker.write(fileOutputStream, this.xmnConfig);
                this.lLastModified = this.fiConfig.lastModified();
                this.bChanged = false;
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reload() throws Exception {
        FileInputStream fileInputStream;
        this.bChanged = false;
        try {
            fileInputStream = new FileInputStream(this.fiConfig);
        }
        catch (IOException iOException) {
            throw new Exception("Invalid configuration file: " + this.fiConfig.getAbsolutePath(), iOException);
        }
        try {
            XmlWorker xmlWorker = this.createXmlWorker();
            this.xmnConfig = xmlWorker.read(fileInputStream);
            this.lLastModified = this.fiConfig.lastModified();
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected XmlWorker createXmlWorker() {
        return new XmlWorker();
    }
}

