/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.config;

import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.ServerZone;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ResourceUtil;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private static final String NAME_RAD = "rad";
    private static final String NAME_APPS = "apps";
    private static final String NAME_SERVER = "server";
    private static String sOldBaseDir = null;
    private static File fiBaseDir = null;
    private static File fiConfigDir = null;
    private static File fiAppsDir = null;
    private static File fiServerDir = null;
    private static Hashtable<String, ApplicationZone> htAppZones = null;
    private static ServerZone zoServer = null;

    private Configuration() {
    }

    private static void initDirectories() {
        String string;
        String string2;
        String string3 = ResourceUtil.getAccessibleProperty("Configuration.basedir", "");
        if (!(sOldBaseDir != null && string3.equals(sOldBaseDir) || (string2 = ResourceUtil.getLocationForClass(string = ResourceUtil.getFqClassName(Configuration.class))) == null)) {
            Object object;
            File file;
            boolean bl = true;
            if (string3.trim().length() == 0 || !new File(string3).exists()) {
                file = new File(string2);
                if (!file.isDirectory()) {
                    file = new File(file.getParentFile().getParentFile(), "classes");
                }
                if (!(fiBaseDir = file.getParentFile()).exists()) {
                    object = ResourceUtil.getResource(ResourceUtil.getFqClassName(Configuration.class));
                    String string4 = ((URL)object).toExternalForm();
                    string4 = string4.substring(0, string4.indexOf(string));
                    try {
                        int n = string4.lastIndexOf(47);
                        n = string4.lastIndexOf(47, n - 1);
                        string4 = string4.substring(0, n) + "/rad.zip";
                        URL uRL = new URL(string4);
                        String string5 = SecureHash.getHash("MD5", uRL.openStream());
                        File file2 = new File(System.getProperty("java.io.tmpdir"), "rad_" + string5);
                        if (!file2.exists()) {
                            FileUtil.unzip(uRL.openStream(), file2);
                        }
                        fiBaseDir = file2;
                        bl = false;
                    }
                    catch (Exception exception) {
                        LoggerFactory.getInstance(Configuration.class).error("Base directory is not available!", exception);
                    }
                }
            } else {
                fiBaseDir = new File(string3);
            }
            if (bl) {
                file = fiBaseDir;
                while (file != null) {
                    object = file.getName();
                    if (((String)object).equalsIgnoreCase(NAME_APPS) || ((String)object).equalsIgnoreCase(NAME_SERVER)) {
                        if ((file = file.getParentFile()) == null || !file.getName().equals(NAME_RAD)) continue;
                        fiBaseDir = file.getParentFile();
                        file = null;
                        continue;
                    }
                    file = file.getParentFile();
                }
            }
            fiConfigDir = new File(fiBaseDir, NAME_RAD);
            fiAppsDir = new File(fiConfigDir, NAME_APPS);
            fiServerDir = new File(fiConfigDir, NAME_SERVER);
            sOldBaseDir = string3;
        }
    }

    public static File getConfigurationDir() {
        Configuration.initDirectories();
        return fiConfigDir;
    }

    public static File getApplicationsDir() {
        Configuration.initDirectories();
        return fiAppsDir;
    }

    public static File getServerDir() {
        Configuration.initDirectories();
        return fiServerDir;
    }

    public static ApplicationZone getApplicationZone(String string) throws Exception {
        ApplicationZone applicationZone = null;
        if (string == null || string.trim().length() == 0) {
            applicationZone = new ApplicationZone((File)null);
        } else {
            if (htAppZones != null) {
                applicationZone = htAppZones.get(string);
            }
            if (applicationZone != null && !applicationZone.isValid()) {
                htAppZones.remove(string);
                applicationZone = null;
            }
            if (applicationZone == null) {
                File file = new File(Configuration.getApplicationsDir(), string);
                applicationZone = new ApplicationZone(file);
                if (htAppZones == null) {
                    htAppZones = new Hashtable();
                }
                htAppZones.put(string, applicationZone);
            }
        }
        return applicationZone;
    }

    public static ServerZone getServerZone() throws Exception {
        if (zoServer == null) {
            zoServer = new ServerZone(Configuration.getServerDir());
        } else if (!zoServer.isValid()) {
            return null;
        }
        return zoServer;
    }

    public static List<String> listApplicationNames(ApplicationListOption applicationListOption) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        File[] fileArray = Configuration.getApplicationsDir().listFiles();
        if (fileArray != null) {
            if (applicationListOption == null) {
                applicationListOption = ApplicationListOption.Visible;
            }
            block4: for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                switch (applicationListOption) {
                    case Hidden: {
                        if (!file.isHidden() && file.getName().charAt(0) != '.') continue block4;
                        arrayUtil.add(file.getName());
                        continue block4;
                    }
                    case Visible: {
                        if (file.isHidden() || file.getName().charAt(0) == '.') continue block4;
                        arrayUtil.add(file.getName());
                        continue block4;
                    }
                    default: {
                        arrayUtil.add(file.getName());
                    }
                }
            }
        }
        return arrayUtil;
    }

    public static boolean isApplication(String string) {
        if (string != null) {
            return ApplicationZone.isValid(new File(Configuration.getApplicationsDir(), string));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplicationListOption {
        All,
        Visible,
        Hidden;

    }
}

