/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.DirectServerConnection;
import com.sibvisions.rad.server.IDirectServer;
import java.util.Hashtable;
import javax.rad.remote.IConnection;
import javax.rad.server.IConfiguration;
import javax.rad.server.IServer;
import javax.rad.server.ISession;
import javax.rad.server.InjectObject;
import javax.rad.server.SessionContext;

final class SessionContextImpl
extends SessionContext {
    private WrappedSession wsessCurrent;
    private String sObjectName = null;
    private String sMethodName = null;

    SessionContextImpl(AbstractSession abstractSession) {
        this.wsessCurrent = new WrappedSession(abstractSession);
        this.setCurrentInstance(this);
    }

    public void destroy() {
        this.setCurrentInstance(null);
        this.wsessCurrent = null;
    }

    public ISession getSession() {
        return this.wsessCurrent;
    }

    public IConfiguration getSessionConfig() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return this.wsessCurrent.getConfig();
    }

    public IConfiguration getServerConfig() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return this.wsessCurrent.getServerConfig();
    }

    public IConnection getServerConnection() {
        if (this.wsessCurrent == null) {
            return null;
        }
        return new DirectServerConnection((IDirectServer)this.wsessCurrent.getServer());
    }

    public String getObjectName() {
        return this.sObjectName;
    }

    public String getMethodName() {
        return this.sMethodName;
    }

    public InjectObject putObject(InjectObject injectObject) {
        return this.wsessCurrent.session.putObject(injectObject);
    }

    public InjectObject removeObject(InjectObject injectObject) {
        return this.wsessCurrent.session.removeObject(injectObject);
    }

    public InjectObject getObject(String string) {
        return this.wsessCurrent.session.getObject(string);
    }

    void setObjectName(String string) {
        this.sObjectName = string;
    }

    void setMethodName(String string) {
        this.sMethodName = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrappedSession
    implements ISession {
        private final AbstractSession session;

        private WrappedSession(AbstractSession abstractSession) {
            this.session = abstractSession;
        }

        @Override
        public Object getId() {
            return this.session.getId();
        }

        @Override
        public String getLifeCycleName() {
            return this.session.getLifeCycleName();
        }

        @Override
        public String getApplicationName() {
            return this.session.getApplicationName();
        }

        @Override
        public String getUserName() {
            return this.session.getUserName();
        }

        @Override
        public String getPassword() {
            return this.session.getPassword();
        }

        @Override
        public Object getProperty(String string) {
            return this.session.getProperty(string);
        }

        @Override
        public Hashtable<String, Object> getProperties() {
            return (Hashtable)this.session.getProperties().clone();
        }

        @Override
        public void setProperty(String string, Object object) {
            if (string != null && string.startsWith("client.")) {
                throw new SecurityException("It's not allowed to change client properties through the SessionContext!");
            }
            this.session.setProperty(string, object);
        }

        @Override
        public long getStartTime() {
            return this.session.getStartTime();
        }

        @Override
        public long getLastAccessTime() {
            return this.session.getLastAccessTime();
        }

        @Override
        public long getLastAliveTime() {
            return this.session.getLastAliveTime();
        }

        @Override
        public void setAliveInterval(long l) {
            this.session.setAliveInterval(l);
        }

        @Override
        public long getAliveInterval() {
            return this.session.getAliveInterval();
        }

        @Override
        public boolean isAlive(long l) {
            return this.session.isAlive(l);
        }

        @Override
        public void setMaxInactiveInterval(int n) {
            this.session.setMaxInactiveInterval(n);
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.session.getMaxInactiveInterval();
        }

        @Override
        public boolean isInactive(long l) {
            return this.session.isInactive(l);
        }

        @Override
        public Object call(String string, String string2, Object ... objectArray) throws Throwable {
            return this.session.call(string, string2, objectArray);
        }

        @Override
        public Object callAction(String string, Object ... objectArray) throws Throwable {
            return this.session.callAction(string, objectArray);
        }

        @Override
        public Object get(String string) throws Throwable {
            return this.session.get(string);
        }

        @Override
        public Object put(String string, Object object) throws Throwable {
            return this.session.put(string, object);
        }

        @Override
        public IConfiguration getConfig() {
            return this.session.getApplicationZone().getConfig();
        }

        private IConfiguration getServerConfig() {
            return this.session.getApplicationZone().getServerZone().getConfig();
        }

        private IServer getServer() {
            return this.session.getSessionManager().getServer();
        }
    }
}

