/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Call;
import com.sibvisions.rad.server.DefaultObjectProvider;
import com.sibvisions.rad.server.DefaultSessionManager;
import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.IResponse;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Monitoring;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.rad.remote.IConnectionConstants;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.AbstractObjectProvider;
import javax.rad.server.ISession;
import javax.rad.server.ResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IDirectServer {
    private ILogger log;
    private static Server instance = null;
    private DefaultSessionManager sessman = null;
    private AbstractObjectProvider objectprov = null;
    private Monitoring monitoring = null;

    public Server() {
        String string;
        String string2;
        try {
            string2 = Configuration.getServerZone().getProperty("logfactory");
        }
        catch (Exception exception) {
            string2 = null;
        }
        LoggerFactory.init(string2);
        this.log = LoggerFactory.getInstance(Server.class);
        try {
            string = Configuration.getServerZone().getProperty("/server/sessionmanager/class");
            this.sessman = (DefaultSessionManager)Reflective.construct(string, this);
            this.log.debug("Use ", string, " as SessionManager");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default SessionManager", throwable);
            this.sessman = new DefaultSessionManager(this);
        }
        try {
            string = Configuration.getServerZone().getProperty("/server/objectprovider/class");
            this.objectprov = (AbstractObjectProvider)Reflective.construct(string, this);
            this.log.debug("Use ", string, " as ObjectProvider");
        }
        catch (Throwable throwable) {
            this.log.debug("NO PROBLEM! Use default ObjectProvider", throwable);
            this.objectprov = new DefaultObjectProvider(this);
        }
        this.monitoring = new Monitoring(this);
    }

    public static synchronized Server getInstance() {
        if (instance == null) {
            try {
                InitialContext initialContext = new InitialContext();
                if (initialContext != null) {
                    instance = (Server)initialContext.lookup("java:/comp/env/jvx/server");
                }
            }
            catch (Exception exception) {
                LoggerFactory.getInstance(Server.class).info("Server is not configured as JNDI resource", exception);
            }
            if (instance == null) {
                instance = new Server();
            }
        }
        return instance;
    }

    @Override
    public final DefaultSessionManager getSessionManager() {
        return this.sessman;
    }

    @Override
    public final AbstractObjectProvider getObjectProvider() {
        return this.objectprov;
    }

    @Override
    public Object createSession(ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object;
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            object = object2 = this.createSessionIntern(null, null, changedHashtable);
        }
        catch (Throwable throwable2) {
            try {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            catch (Throwable throwable3) {
                this.log(null, "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
                throw throwable3;
            }
        }
        this.log(null, "Session!", "createSession", new Object[]{changedHashtable}, null, object2, throwable, System.currentTimeMillis() - l);
        return object;
    }

    @Override
    public Object createSubSession(Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object2;
        Throwable throwable = null;
        Object object3 = null;
        long l = System.currentTimeMillis();
        try {
            object2 = object3 = this.createSubSessionIntern(null, this.sessman.get(object), changedHashtable);
        }
        catch (Throwable throwable2) {
            try {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            catch (Throwable throwable3) {
                this.log(object, "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
                throw throwable3;
            }
        }
        this.log(object, "Session!", "createSubSession", new Object[]{changedHashtable}, null, object3, throwable, System.currentTimeMillis() - l);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(Object object) {
        long l = System.currentTimeMillis();
        try {
            this.destroySessionIntern(object);
        }
        finally {
            this.log(object, "Session!", "destroySession", null, null, null, null, System.currentTimeMillis() - l);
        }
    }

    @Override
    public Object execute(Object object, String string, String string2, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            Object object3 = object2 = this.executeIntern(this.sessman.get(object), new Call(null, string, string2, objectArray));
            return object3;
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, string, string2, objectArray, null, object2, throwable, System.currentTimeMillis() - l);
        }
    }

    @Override
    public void executeCallBack(Object object, Object object2, String string, String string2, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            this.executeIntern(this.sessman.get(object), new Call(object2, string, string2, objectArray));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, string, string2, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
        }
    }

    @Override
    public void executeCallBack(Object object, ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            this.executeIntern(this.sessman.get(object), new Call(iCallBackListener, string, string2, objectArray));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, string, string2, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
        }
    }

    @Override
    public Object executeAction(Object object, String string, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            Object object3 = object2 = this.executeIntern(this.sessman.get(object), new Call(null, null, string, objectArray));
            return object3;
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, null, string, objectArray, null, object2, throwable, System.currentTimeMillis() - l);
        }
    }

    @Override
    public void executeActionCallBack(Object object, Object object2, String string, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            this.executeIntern(this.sessman.get(object), new Call(object2, null, string, objectArray));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, null, string, objectArray, object2, null, throwable, System.currentTimeMillis() - l);
        }
    }

    @Override
    public void executeActionCallBack(Object object, ICallBackListener iCallBackListener, String string, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            this.executeIntern(this.sessman.get(object), new Call(iCallBackListener, null, string, objectArray));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, null, string, objectArray, iCallBackListener, null, throwable, System.currentTimeMillis() - l);
        }
    }

    @Override
    public void setProperty(Object object, String string, Object object2) throws Throwable {
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            this.setPropertyIntern(this.sessman.get(object), string, object2);
        }
        catch (Throwable throwable2) {
            try {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            catch (Throwable throwable3) {
                this.log(object, "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
                throw throwable3;
            }
        }
        this.log(object, "Session!", "setProperty", new Object[]{string, object2}, null, null, throwable, System.currentTimeMillis() - l);
    }

    @Override
    public Object getProperty(Object object, String string) throws Throwable {
        Throwable throwable = null;
        Object object2 = null;
        long l = System.currentTimeMillis();
        try {
            object2 = this.getPropertyIntern(this.sessman.get(object), string);
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, "Session!", "getProperty", null, null, object2, throwable, System.currentTimeMillis() - l);
        }
        return object2;
    }

    @Override
    public ChangedHashtable<String, Object> getProperties(Object object) throws Throwable {
        Throwable throwable = null;
        ChangedHashtable<String, Object> changedHashtable = null;
        long l = System.currentTimeMillis();
        try {
            changedHashtable = this.getPropertiesIntern(this.sessman.get(object));
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, "Session!", "getProperties", null, null, changedHashtable, throwable, System.currentTimeMillis() - l);
        }
        return changedHashtable;
    }

    @Override
    public List<ResultObject> getCallBackResults(Object object) throws Throwable {
        Throwable throwable = null;
        ArrayUtil<ResultObject> arrayUtil = null;
        long l = System.currentTimeMillis();
        try {
            arrayUtil = this.getCallBackResultsIntern(this.sessman.get(object));
        }
        catch (Throwable throwable2) {
            try {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            catch (Throwable throwable3) {
                this.log(object, "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
                throw throwable3;
            }
        }
        this.log(object, "Session!", "getCallBackResults", new Object[]{object}, null, arrayUtil, throwable, System.currentTimeMillis() - l);
        return arrayUtil;
    }

    @Override
    public Object[] setAndCheckAlive(Object object, Object ... objectArray) throws Throwable {
        Throwable throwable = null;
        Object[] objectArray2 = null;
        long l = System.currentTimeMillis();
        try {
            objectArray2 = this.setAndCheckAliveIntern(this.sessman.get(object), objectArray);
        }
        catch (Throwable throwable2) {
            throwable = AbstractSecurityManager.prepareException(throwable2);
            throw throwable2;
        }
        finally {
            this.log(object, "Session!", "setAndCheckAlive", objectArray, null, objectArray2, throwable, System.currentTimeMillis() - l);
        }
        return objectArray2;
    }

    @Override
    public void setNewPassword(Object object, String string, String string2) throws Throwable {
        Throwable throwable = null;
        long l = System.currentTimeMillis();
        try {
            this.setNewPasswordInternal(this.sessman.get(object), string, string2);
        }
        catch (Throwable throwable2) {
            try {
                throwable = AbstractSecurityManager.prepareException(throwable2);
                throw throwable2;
            }
            catch (Throwable throwable3) {
                this.log(object, "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
                throw throwable3;
            }
        }
        this.log(object, "Session!", "setNewPassword", new Object[]{"****"}, null, null, throwable, System.currentTimeMillis() - l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public ISession process(IRequest iRequest, IResponse iResponse) throws Exception {
        AbstractSession abstractSession;
        block103: {
            boolean bl;
            Object object;
            Object object2;
            String string;
            abstractSession = null;
            ISerializer iSerializer = null;
            ArrayUtil<ResultObject> arrayUtil = null;
            ChangedHashtable changedHashtable = null;
            InputStream inputStream = iRequest.getInputStream();
            char c = (char)inputStream.read();
            if (c != 'A' && c != 'E') {
                throw new IOException("Invalid stream identifier '" + c + "'");
            }
            int n = inputStream.read();
            InputStream inputStream2 = n == 2 ? new GZIPInputStream(inputStream) : inputStream;
            DataInputStream dataInputStream = new DataInputStream(inputStream2);
            String string2 = null;
            if (c == 'A') {
                string2 = dataInputStream.readUTF();
                iSerializer = (ISerializer)Class.forName(string2).newInstance();
            }
            if ((string = dataInputStream.readUTF()).trim().length() == 0) {
                string = null;
            }
            if (string != null) {
                abstractSession = this.sessman.get(string);
                iSerializer = abstractSession.getSerializer();
            }
            if (iSerializer == null) {
                throw new SecurityException("Invalid serializer '" + string2 + "'");
            }
            int n2 = (Integer)iSerializer.read(dataInputStream);
            arrayUtil = new ArrayUtil(n2);
            for (int i = 0; i < n2; ++i) {
                long l = System.currentTimeMillis();
                Object[] objectArray = (Object[])iSerializer.read(dataInputStream);
                if (!(objectArray.length != 4 || objectArray[0] != null && objectArray[0].getClass() != String.class || objectArray[1].getClass() != String.class || objectArray[2] != null && !(objectArray[2] instanceof Object[]))) {
                    Throwable throwable = null;
                    Object object3 = null;
                    try {
                        object3 = this.process(iRequest, iSerializer, abstractSession, (String)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], objectArray[3], changedHashtable);
                        this.log(abstractSession != null ? abstractSession.getId() : null, (String)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], objectArray[3], object3, throwable, System.currentTimeMillis() - l);
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            this.log(abstractSession != null ? abstractSession.getId() : null, (String)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], objectArray[3], object3, throwable, System.currentTimeMillis() - l);
                            throw throwable3;
                        }
                    }
                    if ("Session!".equals((String)objectArray[0]) && "setProperty".equals((String)objectArray[1])) {
                        List list = (List)object3;
                        if (list == null) continue;
                        changedHashtable = new ChangedHashtable();
                        int n3 = list.size();
                        for (int j = 0; j < n3; ++j) {
                            Object[] objectArray2 = (Object[])list.get(j);
                            changedHashtable.put((String)objectArray2[0], objectArray2[1], false);
                        }
                        continue;
                    }
                    if (abstractSession == null) {
                        abstractSession = this.sessman.get(object3);
                    }
                    arrayUtil.add(new ResultObject(3, object3));
                    continue;
                }
                this.log.debug("Invalid request parameters!", objectArray);
                throw new SecurityException("Invalid request parameters!");
            }
            Object var27_29 = null;
            try {
                iRequest.close();
            }
            catch (Throwable serializable) {
                this.log.error(serializable);
            }
            OutputStream outputStream = iResponse.getOutputStream();
            if (iSerializer == null) {
                outputStream.write(66);
                outputStream.write(1);
                serializable = new DataOutputStream(outputStream);
                try {
                    int n4 = arrayUtil.size();
                    int n5 = 0;
                    for (int i = 0; i < n4 && n5 == 0; ++i) {
                        if (((ResultObject)arrayUtil.get(i)).getType() != 4) continue;
                        Throwable throwable = (Throwable)((ResultObject)arrayUtil.get(i)).getObject();
                        if (throwable != null) {
                            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                            ((DataOutputStream)((Object)serializable)).writeUTF(throwable.getClass().getName());
                            ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(throwable.getMessage(), ""));
                            if (stackTraceElementArray != null) {
                                ((DataOutputStream)((Object)serializable)).write(stackTraceElementArray.length);
                                int n6 = stackTraceElementArray.length;
                                for (int j = 0; j < n6; ++j) {
                                    ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getClassName(), ""));
                                    ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getMethodName(), ""));
                                    ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getFileName(), ""));
                                    ((DataOutputStream)((Object)serializable)).writeInt(stackTraceElementArray[j].getLineNumber());
                                }
                            } else {
                                ((DataOutputStream)((Object)serializable)).write(0);
                            }
                        } else {
                            ((DataOutputStream)((Object)serializable)).writeUTF("");
                        }
                        ++n5;
                    }
                }
                finally {
                    ((DataOutputStream)((Object)serializable)).flush();
                }
            }
            serializable = null;
            List list = abstractSession != null ? ((ChangedHashtable)abstractSession.getProperties()).getChanges(IConnectionConstants.PROPERTY_CLASSES) : (changedHashtable != null ? changedHashtable.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
            if (list != null && list.size() > 0) {
                object2 = new ArrayUtil(list.size());
                for (Object object4 : list) {
                    object2.add(new Object[]{object4.getKey(), object4.getValue()});
                    iResponse.setProperty((String)object4.getKey(), object4.getValue());
                }
                if (serializable == null) {
                    serializable = new ArrayUtil();
                }
                ((ArrayUtil)serializable).add(new ResultObject(5, object2));
            }
            if (abstractSession != null) {
                if (serializable == null) {
                    serializable = new ArrayUtil<ResultObject>();
                }
                if ((object2 = this.getCallBackResultsIntern(abstractSession)) != null) {
                    ((ArrayUtil)serializable).addAll(object2);
                }
            }
            if (arrayUtil != null) {
                if (serializable == null) {
                    serializable = new ArrayUtil();
                }
                ((ArrayUtil)serializable).addAll(arrayUtil);
            }
            n2 = serializable != null ? ((ArrayUtil)serializable).size() : 0;
            object2 = new ByteArrayOutputStream(256);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object2);
            try {
                iSerializer.write(dataOutputStream, n2);
                if (serializable != null) {
                    Object object4;
                    object4 = ((AbstractList)((Object)serializable)).iterator();
                    while (object4.hasNext()) {
                        object = (ResultObject)object4.next();
                        iSerializer.write(dataOutputStream, ((ResultObject)object).getType());
                        iSerializer.write(dataOutputStream, ((ResultObject)object).getObject());
                        if (((ResultObject)object).getType() != 2 && ((ResultObject)object).getType() != 1) continue;
                        iSerializer.write(dataOutputStream, ((ResultObject)object).getCallBackId());
                    }
                }
            }
            finally {
                ((ByteArrayOutputStream)object2).close();
                dataOutputStream.close();
            }
            outputStream.write(69);
            boolean bl2 = bl = abstractSession != null && Boolean.parseBoolean((String)abstractSession.getProperties().get("client.session.compression"));
            if (bl && ((ByteArrayOutputStream)object2).size() > 256) {
                outputStream.write(2);
                object = new GZIPOutputStream(outputStream);
                ((FilterOutputStream)object).write(((ByteArrayOutputStream)object2).toByteArray());
                ((DeflaterOutputStream)object).flush();
                ((GZIPOutputStream)object).finish();
            } else {
                outputStream.write(1);
                outputStream.write(((ByteArrayOutputStream)object2).toByteArray());
            }
            outputStream.flush();
            try {
                iResponse.close();
            }
            catch (Throwable serializable) {
                this.log.error(serializable);
            }
            break block103;
            {
                catch (Throwable throwable) {
                    boolean bl3;
                    Object object5;
                    Object object6;
                    this.log.error(throwable);
                    if (arrayUtil == null) {
                        arrayUtil = new ArrayUtil<ResultObject>(1);
                    }
                    arrayUtil.add(new ResultObject(4, AbstractSecurityManager.prepareException(throwable)));
                    Object var27_30 = null;
                    try {
                        iRequest.close();
                    }
                    catch (Throwable serializable) {
                        this.log.error(serializable);
                    }
                    OutputStream outputStream2 = iResponse.getOutputStream();
                    if (iSerializer == null) {
                        outputStream2.write(66);
                        outputStream2.write(1);
                        serializable = new DataOutputStream(outputStream2);
                        try {
                            int n7 = arrayUtil.size();
                            int n8 = 0;
                            for (int i = 0; i < n7 && n8 == 0; ++i) {
                                if (((ResultObject)arrayUtil.get(i)).getType() != 4) continue;
                                Throwable throwable4 = (Throwable)((ResultObject)arrayUtil.get(i)).getObject();
                                if (throwable4 != null) {
                                    StackTraceElement[] stackTraceElementArray = throwable4.getStackTrace();
                                    ((DataOutputStream)((Object)serializable)).writeUTF(throwable4.getClass().getName());
                                    ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(throwable4.getMessage(), ""));
                                    if (stackTraceElementArray != null) {
                                        ((DataOutputStream)((Object)serializable)).write(stackTraceElementArray.length);
                                        int n9 = stackTraceElementArray.length;
                                        for (int j = 0; j < n9; ++j) {
                                            ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getClassName(), ""));
                                            ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getMethodName(), ""));
                                            ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getFileName(), ""));
                                            ((DataOutputStream)((Object)serializable)).writeInt(stackTraceElementArray[j].getLineNumber());
                                        }
                                    } else {
                                        ((DataOutputStream)((Object)serializable)).write(0);
                                    }
                                } else {
                                    ((DataOutputStream)((Object)serializable)).writeUTF("");
                                }
                                ++n8;
                            }
                        }
                        finally {
                            ((DataOutputStream)((Object)serializable)).flush();
                        }
                    }
                    serializable = null;
                    List list2 = abstractSession != null ? ((ChangedHashtable)abstractSession.getProperties()).getChanges(IConnectionConstants.PROPERTY_CLASSES) : (changedHashtable != null ? changedHashtable.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                    if (list2 != null && list2.size() > 0) {
                        object6 = new ArrayUtil(list2.size());
                        for (Object object7 : list2) {
                            object6.add(new Object[]{object7.getKey(), object7.getValue()});
                            iResponse.setProperty((String)object7.getKey(), object7.getValue());
                        }
                        if (serializable == null) {
                            serializable = new ArrayUtil();
                        }
                        ((ArrayUtil)serializable).add(new ResultObject(5, object6));
                    }
                    if (abstractSession != null) {
                        if (serializable == null) {
                            serializable = new ArrayUtil<ResultObject>();
                        }
                        if ((object6 = this.getCallBackResultsIntern(abstractSession)) != null) {
                            ((ArrayUtil)serializable).addAll(object6);
                        }
                    }
                    if (arrayUtil != null) {
                        if (serializable == null) {
                            serializable = new ArrayUtil();
                        }
                        ((ArrayUtil)serializable).addAll(arrayUtil);
                    }
                    int n10 = serializable != null ? ((ArrayUtil)serializable).size() : 0;
                    object6 = new ByteArrayOutputStream(256);
                    DataOutputStream dataOutputStream2 = new DataOutputStream((OutputStream)object6);
                    try {
                        iSerializer.write(dataOutputStream2, n10);
                        if (serializable != null) {
                            Object object7;
                            object7 = ((AbstractList)((Object)serializable)).iterator();
                            while (object7.hasNext()) {
                                object5 = (ResultObject)object7.next();
                                iSerializer.write(dataOutputStream2, ((ResultObject)object5).getType());
                                iSerializer.write(dataOutputStream2, ((ResultObject)object5).getObject());
                                if (((ResultObject)object5).getType() != 2 && ((ResultObject)object5).getType() != 1) continue;
                                iSerializer.write(dataOutputStream2, ((ResultObject)object5).getCallBackId());
                            }
                        }
                    }
                    finally {
                        ((ByteArrayOutputStream)object6).close();
                        dataOutputStream2.close();
                    }
                    outputStream2.write(69);
                    boolean bl4 = bl3 = abstractSession != null && Boolean.parseBoolean((String)abstractSession.getProperties().get("client.session.compression"));
                    if (bl3 && ((ByteArrayOutputStream)object6).size() > 256) {
                        outputStream2.write(2);
                        object5 = new GZIPOutputStream(outputStream2);
                        ((FilterOutputStream)object5).write(((ByteArrayOutputStream)object6).toByteArray());
                        ((DeflaterOutputStream)object5).flush();
                        ((GZIPOutputStream)object5).finish();
                    } else {
                        outputStream2.write(1);
                        outputStream2.write(((ByteArrayOutputStream)object6).toByteArray());
                    }
                    outputStream2.flush();
                    try {
                        iResponse.close();
                    }
                    catch (Throwable serializable) {
                        this.log.error(serializable);
                    }
                }
            }
            catch (Throwable throwable) {
                boolean bl5;
                Object object8;
                Object object9;
                Object var27_31 = null;
                try {
                    iRequest.close();
                }
                catch (Throwable serializable) {
                    this.log.error(serializable);
                }
                OutputStream outputStream3 = iResponse.getOutputStream();
                if (iSerializer == null) {
                    outputStream3.write(66);
                    outputStream3.write(1);
                    serializable = new DataOutputStream(outputStream3);
                    try {
                        int n11 = arrayUtil.size();
                        int n12 = 0;
                        for (int i = 0; i < n11 && n12 == 0; ++i) {
                            if (((ResultObject)arrayUtil.get(i)).getType() != 4) continue;
                            Throwable throwable5 = (Throwable)((ResultObject)arrayUtil.get(i)).getObject();
                            if (throwable5 != null) {
                                StackTraceElement[] stackTraceElementArray = throwable5.getStackTrace();
                                ((DataOutputStream)((Object)serializable)).writeUTF(throwable5.getClass().getName());
                                ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(throwable5.getMessage(), ""));
                                if (stackTraceElementArray != null) {
                                    ((DataOutputStream)((Object)serializable)).write(stackTraceElementArray.length);
                                    int n13 = stackTraceElementArray.length;
                                    for (int j = 0; j < n13; ++j) {
                                        ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getClassName(), ""));
                                        ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getMethodName(), ""));
                                        ((DataOutputStream)((Object)serializable)).writeUTF(CommonUtil.nvl(stackTraceElementArray[j].getFileName(), ""));
                                        ((DataOutputStream)((Object)serializable)).writeInt(stackTraceElementArray[j].getLineNumber());
                                    }
                                } else {
                                    ((DataOutputStream)((Object)serializable)).write(0);
                                }
                            } else {
                                ((DataOutputStream)((Object)serializable)).writeUTF("");
                            }
                            ++n12;
                        }
                    }
                    finally {
                        ((DataOutputStream)((Object)serializable)).flush();
                    }
                }
                serializable = null;
                List list3 = abstractSession != null ? ((ChangedHashtable)abstractSession.getProperties()).getChanges(IConnectionConstants.PROPERTY_CLASSES) : (changedHashtable != null ? changedHashtable.getChanges(IConnectionConstants.PROPERTY_CLASSES) : null);
                if (list3 != null && list3.size() > 0) {
                    object9 = new ArrayUtil(list3.size());
                    for (Object object10 : list3) {
                        object9.add(new Object[]{object10.getKey(), object10.getValue()});
                        iResponse.setProperty((String)object10.getKey(), object10.getValue());
                    }
                    if (serializable == null) {
                        serializable = new ArrayUtil();
                    }
                    ((ArrayUtil)serializable).add(new ResultObject(5, object9));
                }
                if (abstractSession != null) {
                    if (serializable == null) {
                        serializable = new ArrayUtil<ResultObject>();
                    }
                    if ((object9 = this.getCallBackResultsIntern(abstractSession)) != null) {
                        ((ArrayUtil)serializable).addAll(object9);
                    }
                }
                if (arrayUtil != null) {
                    if (serializable == null) {
                        serializable = new ArrayUtil();
                    }
                    ((ArrayUtil)serializable).addAll(arrayUtil);
                }
                int n14 = serializable != null ? ((ArrayUtil)serializable).size() : 0;
                object9 = new ByteArrayOutputStream(256);
                DataOutputStream dataOutputStream3 = new DataOutputStream((OutputStream)object9);
                try {
                    iSerializer.write(dataOutputStream3, n14);
                    if (serializable != null) {
                        Object object10;
                        object10 = ((AbstractList)((Object)serializable)).iterator();
                        while (object10.hasNext()) {
                            object8 = (ResultObject)object10.next();
                            iSerializer.write(dataOutputStream3, ((ResultObject)object8).getType());
                            iSerializer.write(dataOutputStream3, ((ResultObject)object8).getObject());
                            if (((ResultObject)object8).getType() != 2 && ((ResultObject)object8).getType() != 1) continue;
                            iSerializer.write(dataOutputStream3, ((ResultObject)object8).getCallBackId());
                        }
                    }
                }
                finally {
                    ((ByteArrayOutputStream)object9).close();
                    dataOutputStream3.close();
                }
                outputStream3.write(69);
                boolean bl6 = bl5 = abstractSession != null && Boolean.parseBoolean((String)abstractSession.getProperties().get("client.session.compression"));
                if (bl5 && ((ByteArrayOutputStream)object9).size() > 256) {
                    outputStream3.write(2);
                    object8 = new GZIPOutputStream(outputStream3);
                    ((FilterOutputStream)object8).write(((ByteArrayOutputStream)object9).toByteArray());
                    ((DeflaterOutputStream)object8).flush();
                    ((GZIPOutputStream)object8).finish();
                } else {
                    outputStream3.write(1);
                    outputStream3.write(((ByteArrayOutputStream)object9).toByteArray());
                }
                outputStream3.flush();
                try {
                    iResponse.close();
                }
                catch (Throwable serializable) {
                    this.log.error(serializable);
                }
                throw throwable;
            }
        }
        return abstractSession;
    }

    private Object process(IRequest iRequest, ISerializer iSerializer, AbstractSession abstractSession, String string, String string2, Object[] objectArray, Object object, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        if (abstractSession == null && object != null) {
            throw new SecurityException("Call back is not allowed!");
        }
        if (string != null && "Session!".equals(string)) {
            if (object != null) {
                throw new SecurityException("Call back is not allowed!");
            }
            if ("createSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSessionIntern(iRequest, iSerializer, changedHashtable);
            }
            if ("createSubSession".equals(string2)) {
                if (abstractSession != null) {
                    throw new SecurityException("Session is already open!");
                }
                return this.createSubSessionIntern(iRequest, this.sessman.get(objectArray[0]), changedHashtable);
            }
            if ("setProperty".equals(string2) && abstractSession == null) {
                return (List)objectArray[0];
            }
            if (abstractSession != null) {
                if ("setAndCheckAlive".equals(string2)) {
                    return this.setAndCheckAliveIntern(abstractSession, objectArray);
                }
                if ("destroySession".equals(string2)) {
                    this.destroySessionIntern(abstractSession.getId());
                    return null;
                }
                if ("getProperty".equals(string2)) {
                    return this.getPropertyIntern(abstractSession, (String)objectArray[0]);
                }
                if ("getProperties".equals(string2)) {
                    return this.getPropertiesIntern(abstractSession);
                }
            }
        }
        return this.executeIntern(abstractSession, new Call(object, string, string2, objectArray));
    }

    private Object executeIntern(AbstractSession abstractSession, Call call) throws Throwable {
        if (abstractSession != null) {
            return abstractSession.execute(call);
        }
        throw new SecurityException("No session for call '" + call.formatMethod() + "'");
    }

    private Object createSessionIntern(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSession(iRequest, iSerializer, changedHashtable);
    }

    private Object createSubSessionIntern(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        return this.sessman.createSubSession(iRequest, abstractSession, changedHashtable);
    }

    private void destroySessionIntern(Object object) {
        this.sessman.destroy(object);
    }

    private void setPropertyIntern(AbstractSession abstractSession, String string, Object object) {
        abstractSession.setProperty(string, object);
    }

    private Object getPropertyIntern(AbstractSession abstractSession, String string) {
        Object object = abstractSession.getProperty(string);
        if (object != null) {
            for (int i = 0; i < IConnectionConstants.PROPERTY_CLASSES.length; ++i) {
                if (!IConnectionConstants.PROPERTY_CLASSES[i].isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        return null;
    }

    private ChangedHashtable<String, Object> getPropertiesIntern(AbstractSession abstractSession) {
        List list = ((ChangedHashtable)abstractSession.getProperties()).getMapping(IConnectionConstants.PROPERTY_CLASSES);
        ChangedHashtable<String, Object> changedHashtable = new ChangedHashtable<String, Object>();
        for (Map.Entry entry : list) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            changedHashtable.put((String)entry.getKey(), obj, false);
        }
        return changedHashtable;
    }

    private ArrayUtil<ResultObject> getCallBackResultsIntern(AbstractSession abstractSession) {
        if (abstractSession != null) {
            return abstractSession.removeCallBackResults();
        }
        return null;
    }

    private Object[] setAndCheckAliveIntern(AbstractSession abstractSession, Object[] objectArray) {
        abstractSession.setLastAliveTime(System.currentTimeMillis());
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.sessman.get(objectArray[i]);
                continue;
            }
            catch (RuntimeException runtimeException) {
                arrayUtil.add(objectArray[i]);
            }
        }
        if (arrayUtil.size() > 0) {
            Object[] objectArray2 = new Object[arrayUtil.size()];
            arrayUtil.toArray(objectArray2);
            return objectArray2;
        }
        return null;
    }

    private void setNewPasswordInternal(AbstractSession abstractSession, String string, String string2) throws Throwable {
        if (!(abstractSession instanceof MasterSession)) {
            throw new NoSuchMethodException("Unknown method 'setNewPassword'");
        }
        ((MasterSession)abstractSession).setNewPassword(string, string2);
    }

    public final Monitoring getMonitoring() {
        return this.monitoring;
    }

    private final void log(Object object, String string, String string2, Object[] objectArray, Object object2, Object object3, Throwable throwable, long l) {
        this.log.debug("SESSION-ID: ", object, "\nOBJECTNAME: ", string, "\nMETHOD:     ", string2, "\nPARAMS:     ", objectArray, "\nCALLBACK:   ", object2, "\nRESULT:     ", object3, "\nEXCEPTION:  ", throwable, throwable != null ? "DURATION:   " : "\nDURATION:   ", l, " ms");
    }
}

