/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.IDirectServer;
import com.sibvisions.rad.server.Server;
import com.sibvisions.util.ChangedHashtable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.remote.ConnectionInfo;
import javax.rad.remote.IConnection;
import javax.rad.remote.event.ICallBackListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectServerConnection
implements IConnection {
    private IDirectServer server = null;

    public DirectServerConnection() {
        if (this.server == null) {
            this.server = Server.getInstance();
        }
    }

    public DirectServerConnection(IDirectServer iDirectServer) {
        this.server = iDirectServer;
    }

    @Override
    public synchronized void open(ConnectionInfo connectionInfo) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfo.getConnectionId() != null) {
            throw new SecurityException("Session is already open!");
        }
        Object object = this.server.createSession(connectionInfo.getProperties());
        connectionInfo.setConnectionId(object);
        this.syncProperties(connectionInfo);
    }

    @Override
    public synchronized void openSub(ConnectionInfo connectionInfo, ConnectionInfo connectionInfo2) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfo2.getConnectionId() != null) {
            throw new SecurityException("Session is already open!");
        }
        Object object = this.server.createSubSession(connectionInfo.getConnectionId(), connectionInfo2.getProperties());
        connectionInfo2.setConnectionId(object);
        this.syncProperties(connectionInfo2);
    }

    @Override
    public boolean isOpen(ConnectionInfo connectionInfo) {
        return connectionInfo != null && connectionInfo.getConnectionId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(ConnectionInfo connectionInfo) throws Throwable {
        if (this.isOpen(connectionInfo)) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            try {
                this.server.destroySession(connectionInfo.getConnectionId());
            }
            finally {
                connectionInfo.setConnectionId(null);
            }
        } else {
            throw new IllegalStateException("Connection not open");
        }
    }

    @Override
    public synchronized void reopen(ConnectionInfo connectionInfo) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        try {
            this.close(connectionInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.open(connectionInfo);
    }

    @Override
    public synchronized Object[] call(ConnectionInfo connectionInfo, String[] stringArray, String[] stringArray2, Object[][] objectArray, ICallBackListener[] iCallBackListenerArray) throws Throwable {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("Invalid connection information: null");
        }
        if (connectionInfo.getConnectionId() == null) {
            throw new IllegalStateException("The connection is not open!");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("No remote method specified!");
        }
        if (stringArray != null && stringArray2.length != stringArray.length) {
            throw new IllegalArgumentException("More or less objects than methods!");
        }
        if (objectArray != null && objectArray.length != stringArray2.length) {
            throw new IllegalArgumentException("More or less params than methods!");
        }
        Object object = connectionInfo.getConnectionId();
        if (!(object != null || stringArray != null && "Session!".equals(stringArray[0]) && ("createSession".equals(stringArray2[0]) || "createSubSession".equals(stringArray2[0])))) {
            throw new IOException("Connection is not open!");
        }
        if (iCallBackListenerArray != null && iCallBackListenerArray.length != stringArray2.length) {
            throw new IllegalArgumentException("More or less callbacks than methods!");
        }
        if (iCallBackListenerArray != null) {
            int n = iCallBackListenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i] == null || !"Session!".equals(stringArray[i]) || iCallBackListenerArray[i] == null) continue;
                throw new SecurityException("Call back is not allowed!");
            }
        }
        Object[] objectArray2 = new Object[stringArray2.length];
        Object object2 = connectionInfo.getConnectionId();
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            Throwable throwable;
            block16: {
                throwable = null;
                try {
                    connectionInfo.setLastCallTime(System.currentTimeMillis());
                    if (iCallBackListenerArray == null || iCallBackListenerArray[i] == null) {
                        objectArray2[i] = this.server.execute(object2, stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null);
                    } else {
                        this.server.executeCallBack(object2, iCallBackListenerArray[i], stringArray != null ? stringArray[i] : null, stringArray2[i], objectArray != null ? objectArray[i] : null);
                        objectArray2[i] = null;
                    }
                }
                catch (Throwable throwable2) {
                    objectArray2[i] = null;
                    throwable = throwable2;
                }
                try {
                    this.syncProperties(connectionInfo);
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block16;
                    throwable = throwable3;
                }
            }
            if (throwable == null) continue;
            throw throwable;
        }
        return objectArray2;
    }

    @Override
    public synchronized ConnectionInfo[] setAndCheckAlive(ConnectionInfo connectionInfo, ConnectionInfo[] connectionInfoArray) throws Throwable {
        Object[] objectArray;
        Hashtable<Object, ConnectionInfo> hashtable;
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        if (connectionInfoArray != null) {
            hashtable = new Hashtable<Object, ConnectionInfo>();
            objectArray = new Object[connectionInfoArray.length];
            int n = connectionInfoArray.length;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = connectionInfoArray[i].getConnectionId();
                hashtable.put(objectArray[i], connectionInfoArray[i]);
            }
        } else {
            hashtable = null;
            objectArray = null;
        }
        Object[] objectArray2 = this.server.setAndCheckAlive(connectionInfo.getConnectionId(), objectArray);
        this.syncProperties(connectionInfo);
        if (objectArray2 == null) {
            return null;
        }
        ConnectionInfo[] connectionInfoArray2 = new ConnectionInfo[objectArray2.length];
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            connectionInfoArray2[i] = (ConnectionInfo)hashtable.get(objectArray2[i]);
        }
        return connectionInfoArray2;
    }

    @Override
    public synchronized void setProperty(ConnectionInfo connectionInfo, String string, Object object) throws Throwable {
        if (string != null && string.startsWith("client.")) {
            if (this.isOpen(connectionInfo)) {
                throw new SecurityException("Client properties are not accessible after the connection was opened!");
            }
            connectionInfo.getProperties().put(string, object, false);
        } else {
            connectionInfo.getProperties().put(string, object, false);
            if (this.isOpen(connectionInfo)) {
                connectionInfo.setLastCallTime(System.currentTimeMillis());
                this.server.setProperty(connectionInfo.getConnectionId(), string, object);
                this.syncProperties(connectionInfo);
            }
        }
    }

    @Override
    public synchronized Object getProperty(ConnectionInfo connectionInfo, String string) throws Throwable {
        if (connectionInfo != null) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            if (this.isOpen(connectionInfo)) {
                this.syncProperties(connectionInfo);
            }
            return connectionInfo.getProperties().get(string);
        }
        return null;
    }

    @Override
    public synchronized Hashtable<String, Object> getProperties(ConnectionInfo connectionInfo) throws Throwable {
        if (connectionInfo != null) {
            connectionInfo.setLastCallTime(System.currentTimeMillis());
            if (this.isOpen(connectionInfo)) {
                this.syncProperties(connectionInfo);
            }
            return (Hashtable)connectionInfo.getProperties().clone();
        }
        return null;
    }

    @Override
    public synchronized void setNewPassword(ConnectionInfo connectionInfo, String string, String string2) throws Throwable {
        connectionInfo.setLastCallTime(System.currentTimeMillis());
        this.server.setNewPassword(connectionInfo.getConnectionId(), string, string2);
        this.syncProperties(connectionInfo);
    }

    private void syncProperties(ConnectionInfo connectionInfo) throws Throwable {
        ChangedHashtable<String, Object> changedHashtable = this.server.getProperties(connectionInfo.getConnectionId());
        ChangedHashtable<String, Object> changedHashtable2 = connectionInfo.getProperties();
        for (Map.Entry object : changedHashtable.entrySet()) {
            changedHashtable2.put((String)object.getKey(), object.getValue(), false);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(changedHashtable2);
        for (String string : hashtable.keySet()) {
            if (changedHashtable.containsKey(string)) continue;
            changedHashtable2.remove(string);
        }
    }
}

