/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.config.ApplicationZone;
import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.type.StringUtil;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachedSession
implements ISession {
    private Object oId;
    private ApplicationZone zone;
    private ISecurityManager secman;
    private Hashtable<String, Object> htProperties = null;
    private Hashtable<String, Object> htObjects = null;
    private String sUserName;
    private String sPassword;
    private long lStart;

    public DetachedSession(String string) throws Exception {
        this.zone = (ApplicationZone)Configuration.getApplicationZone(string).clone();
        if (!Boolean.valueOf(this.zone.getProperty("/application/liveconfig")).booleanValue()) {
            this.zone.setUpdateEnabled(false);
        }
        this.oId = UUID.randomUUID().toString();
        this.lStart = System.currentTimeMillis();
    }

    @Override
    public Object getId() {
        return this.oId;
    }

    @Override
    public String getApplicationName() {
        return this.zone.getName();
    }

    @Override
    public String getUserName() {
        return this.sUserName;
    }

    @Override
    public String getPassword() {
        return this.sPassword;
    }

    @Override
    public Object put(String string, Object object) {
        if (this.htObjects == null) {
            this.htObjects = new Hashtable();
        }
        if (object == null) {
            return this.htObjects.remove(string);
        }
        return this.htObjects.put(string, object);
    }

    @Override
    public Object get(String string) throws Throwable {
        if (this.htObjects == null) {
            return null;
        }
        return this.htObjects.get(string);
    }

    @Override
    public Object call(String string, String string2, Object ... objectArray) throws Throwable {
        if (string == null) {
            throw new RuntimeException("Invalid object name '" + string + "'");
        }
        if (this.htObjects == null) {
            throw new RuntimeException("Unknown object '" + string + "'");
        }
        Object object = null;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayUtil<String> arrayUtil = StringUtil.separateList(string, ".", true);
        int n = arrayUtil.size();
        for (int i = 0; i < n; ++i) {
            String string3 = arrayUtil.get(i);
            string3 = arrayUtil.get(i);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(string3);
            if (i == 0) {
                object = this.htObjects.get(string3);
            }
            if (object == null) {
                throw new RuntimeException("Unknown object '" + stringBuilder.toString() + "'");
            }
            try {
                object = Reflective.call(object, StringUtil.formatMethodName("get", string3), new Object[0]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (object instanceof Map) {
                    Object v = ((Map)object).get(string3);
                    if (v == null && !((Map)object).containsKey(string3)) {
                        throw new RuntimeException("Unknown object '" + string3 + "'");
                    }
                    object = v;
                    continue;
                }
                throw new RuntimeException("Unknown object '" + string3 + "'", noSuchMethodException);
            }
        }
        return object;
    }

    @Override
    public Object callAction(String string, Object ... objectArray) throws Throwable {
        throw new UnsupportedOperationException("Actions are not available!");
    }

    @Override
    public IConfiguration getConfig() {
        return this.zone.getConfig();
    }

    @Override
    public long getLastAccessTime() {
        return System.currentTimeMillis();
    }

    @Override
    public long getLastAliveTime() {
        return System.currentTimeMillis();
    }

    @Override
    public String getLifeCycleName() {
        return null;
    }

    @Override
    public Hashtable<String, Object> getProperties() {
        if (this.htProperties == null) {
            this.htProperties = new Hashtable();
        }
        return this.htProperties;
    }

    @Override
    public Object getProperty(String string) {
        if (this.htProperties == null) {
            return null;
        }
        return this.htProperties.get(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        if (this.htProperties == null) {
            this.htProperties = new Hashtable();
        }
        if (object == null) {
            this.htProperties.remove(string);
        } else {
            this.htProperties.put(string, object);
        }
    }

    @Override
    public long getStartTime() {
        return this.lStart;
    }

    @Override
    public long getAliveInterval() {
        return 0L;
    }

    @Override
    public void setAliveInterval(long l) {
    }

    @Override
    public int getMaxInactiveInterval() {
        return 0;
    }

    @Override
    public void setMaxInactiveInterval(int n) {
    }

    @Override
    public boolean isAlive(long l) {
        return true;
    }

    @Override
    public boolean isInactive(long l) {
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.secman != null) {
            try {
                this.secman.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public void setUserName(String string) {
        this.sUserName = string;
    }

    public void setPassword(String string) {
        this.sPassword = string;
    }

    public ISecurityManager getSecurityManager() throws Exception {
        if (this.secman == null) {
            this.secman = AbstractSecurityManager.createSecurityManager(this);
        }
        return this.secman;
    }
}

