/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.Memory;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.remote.SessionExpiredException;
import javax.rad.server.AbstractSessionManager;
import javax.rad.server.ISession;
import javax.rad.server.event.ISessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSessionManager
extends AbstractSessionManager {
    private static final long CONTROLLER_DELAY = 10000L;
    private static final String[] USED_SYSPROPS = new String[]{"user.timezone", "user.name", "os.name", "os.version", "os.arch", "java.vendor", "java.version", "java.class.version", "java.vm.name", "file.encoding", "file.separator", "path.separator", "line.separator"};
    private Hashtable<Object, AbstractSession> htSessions = new Hashtable();
    private Hashtable<String, ISecurityManager> htSecManager = null;
    private Hashtable<String, String> htSecManagerClass = null;
    private ArrayUtil<ISessionListener> auEvents = null;
    private Object oSync = new Object();
    private Thread thController = null;
    private ILogger log = LoggerFactory.getInstance(this.getClass());

    protected DefaultSessionManager(Server server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final AbstractSession get(Object object) {
        AbstractSession abstractSession = null;
        if (object == null) throw new SecurityException("Invalid session id '" + object + "'");
        Object object2 = this.oSync;
        synchronized (object2) {
            abstractSession = this.htSessions.get(object);
        }
        if (abstractSession == null) throw new SessionExpiredException("Session expired '" + object + "'");
        long l = System.currentTimeMillis();
        if (!abstractSession.isInactive(l) && abstractSession.isAlive(l)) return abstractSession;
        this.destroy(object);
        throw new SessionExpiredException("Session expired '" + object + "'");
    }

    @Override
    public final void addSessionListener(ISessionListener iSessionListener) {
        if (this.auEvents == null) {
            this.auEvents = new ArrayUtil();
        }
        this.auEvents.add(iSessionListener);
    }

    @Override
    public final void removeSessionListener(ISessionListener iSessionListener) {
        if (this.auEvents != null) {
            this.auEvents.remove(iSessionListener);
        }
    }

    @Override
    public final ISessionListener[] getSessionListeners() {
        if (this.auEvents == null) {
            return new ISessionListener[0];
        }
        ISessionListener[] iSessionListenerArray = new ISessionListener[this.auEvents.size()];
        return this.auEvents.toArray(iSessionListenerArray);
    }

    public final Object createSession(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        MasterSession masterSession = new MasterSession(this, this.getInitialProperties(changedHashtable, iRequest));
        masterSession.setSerializer(iSerializer);
        this.addIntern(masterSession);
        this.postCreateSession(masterSession);
        return masterSession.getId();
    }

    public final Object createSubSession(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        MasterSession masterSession = abstractSession instanceof SubSession ? ((SubSession)abstractSession).getMasterSession() : (MasterSession)abstractSession;
        SubSession subSession = new SubSession(masterSession, this.getInitialProperties(changedHashtable, iRequest));
        this.addIntern(subSession);
        this.postCreateSubSession(masterSession, subSession);
        return subSession.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy(Object object) {
        if (object != null) {
            ISession iSession;
            Object object2 = this.oSync;
            synchronized (object2) {
                iSession = this.htSessions.remove(object);
            }
            if (iSession == null) {
                throw new SessionExpiredException("Session expired '" + object + "'");
            }
            if (iSession instanceof MasterSession) {
                object2 = this.htSecManager.get(iSession.getApplicationName());
                try {
                    object2.logout(iSession);
                }
                catch (Throwable throwable) {
                    this.log.error(throwable);
                }
                ArrayUtil<SubSession> arrayUtil = ((MasterSession)iSession).removeSubSessions();
                if (arrayUtil != null) {
                    int n = arrayUtil.size();
                    for (int i = 0; i < n; ++i) {
                        try {
                            this.destroy(arrayUtil.get(i).getId());
                            continue;
                        }
                        catch (Throwable throwable) {
                            this.log.info(throwable);
                        }
                    }
                }
            }
            this.fireSessionDestroyed(iSession);
            Memory.gc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIntern(AbstractSession abstractSession) {
        Object object = this.oSync;
        synchronized (object) {
            this.htSessions.put(abstractSession.getId(), abstractSession);
        }
        this.fireSessionCreated(abstractSession);
        this.startController();
    }

    final ISecurityManager getSecurityManager(ISession iSession) throws Exception {
        String string = iSession.getApplicationName();
        ISecurityManager iSecurityManager = null;
        if (this.htSecManager != null) {
            iSecurityManager = this.htSecManager.get(string);
        }
        String string2 = iSession.getConfig().getProperty("/application/securitymanager/class");
        if (!(iSecurityManager == null || string2 != null && string2.equals(this.htSecManagerClass.get(string)))) {
            this.htSecManager.remove(string);
            this.htSecManagerClass.remove(string);
            iSecurityManager.release();
            iSecurityManager = null;
        }
        if (iSecurityManager == null) {
            try {
                iSecurityManager = this.createSecurityManager(iSession);
                if (this.htSecManager == null) {
                    this.htSecManager = new Hashtable();
                    this.htSecManagerClass = new Hashtable();
                }
                this.htSecManager.put(string, iSecurityManager);
                this.htSecManagerClass.put(string, string2);
            }
            catch (Throwable throwable) {
                throw new Exception("Error during instantiation of security manager", throwable);
            }
        }
        return iSecurityManager;
    }

    final ISecurityManager getSecurityManagerFromCache(String string) {
        if (this.htSecManager != null) {
            return this.htSecManager.get(string);
        }
        return null;
    }

    protected ISecurityManager createSecurityManager(ISession iSession) throws Exception {
        return AbstractSecurityManager.createSecurityManager(iSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getSessionCount() {
        Object object = this.oSync;
        synchronized (object) {
            return this.htSessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayUtil<Object> getSessionIds() {
        Object object = this.oSync;
        synchronized (object) {
            return new ArrayUtil<Object>((Collection<Object>)this.htSessions.keySet());
        }
    }

    private void fireSessionCreated(ISession iSession) {
        if (iSession == null || this.auEvents == null) {
            return;
        }
        int n = this.auEvents.size();
        for (int i = 0; i < n; ++i) {
            this.auEvents.get(i).sessionCreated(iSession);
        }
    }

    private void fireSessionDestroyed(ISession iSession) {
        if (iSession == null || this.auEvents == null) {
            return;
        }
        int n = this.auEvents.size();
        for (int i = 0; i < n; ++i) {
            this.auEvents.get(i).sessionDestroyed(iSession);
        }
    }

    private void startController() {
        if (ThreadHandler.isStopped(this.thController)) {
            this.thController = ThreadHandler.start(new Controller());
            this.log.debug("Start Controller: ", this.thController.getName());
        }
    }

    private void validateSessions() {
        ArrayUtil<Object> arrayUtil = this.getSessionIds();
        long l = System.currentTimeMillis();
        int n = arrayUtil.size();
        for (int i = 0; i < n; ++i) {
            Object object = arrayUtil.get(i);
            ISession iSession = this.htSessions.get(object);
            if (iSession == null || !iSession.isInactive(l) && iSession.isAlive(l)) continue;
            this.log.debug("Destroy invalid session: ", object);
            this.destroy(object);
        }
    }

    private ChangedHashtable<String, Object> getInitialProperties(ChangedHashtable<String, Object> changedHashtable, IRequest iRequest) throws Exception {
        Hashtable<String, Object> hashtable;
        ChangedHashtable<String, Object> changedHashtable2 = changedHashtable != null ? changedHashtable : new ChangedHashtable();
        InetAddress inetAddress = InetAddress.getLocalHost();
        changedHashtable2.put("server.server_version", "0.4.1");
        changedHashtable2.put("server.spec_version", "0.4.1");
        changedHashtable2.put("server.hostname", inetAddress.getHostName());
        changedHashtable2.put("server.address", inetAddress.getHostAddress());
        String string = "server.sysprop.";
        int n = USED_SYSPROPS.length;
        for (int i = 0; i < n; ++i) {
            String string2 = System.getProperty(USED_SYSPROPS[i]);
            if (string2 == null) continue;
            changedHashtable2.put(string + USED_SYSPROPS[i], string2);
        }
        if (iRequest != null && (hashtable = iRequest.getProperties()) != null) {
            string = "server.request.";
            for (Map.Entry<String, Object> entry : hashtable.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                changedHashtable2.put(string + entry.getKey(), (String)entry.getValue());
            }
        }
        return changedHashtable2;
    }

    protected void postCreateSession(ISession iSession) {
    }

    protected void postCreateSubSession(ISession iSession, ISession iSession2) {
    }

    private final class Controller
    extends Thread {
        private Controller() {
        }

        public void run() {
            try {
                while (!ThreadHandler.isStopped()) {
                    DefaultSessionManager.this.validateSessions();
                    Thread.sleep(10000L);
                }
            }
            catch (Throwable throwable) {
                DefaultSessionManager.this.log.debug(throwable);
            }
            DefaultSessionManager.this.log.error("Controller stopped: ", this.getName());
        }
    }
}

