/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.util.Reflective;
import javax.rad.remote.event.CallBackEvent;
import javax.rad.remote.event.ICallBackListener;
import javax.rad.server.ResultObject;

final class Call {
    private Reflective refUIThread = new Reflective();
    private ICallBackListener listener;
    private Object oCallBackId;
    private String sObjectName;
    private String sMethodName;
    private Object[] oParams;
    private long lCreation = System.currentTimeMillis();

    Call(ICallBackListener iCallBackListener, String string, String string2, Object ... objectArray) {
        this.listener = iCallBackListener;
        this.sObjectName = string;
        this.sMethodName = string2;
        this.oParams = objectArray;
    }

    Call(Object object, String string, String string2, Object ... objectArray) {
        this.oCallBackId = object;
        this.sObjectName = string;
        this.sMethodName = string2;
        this.oParams = objectArray;
    }

    public String getObjectName() {
        return this.sObjectName;
    }

    public String getMethodName() {
        return this.sMethodName;
    }

    public Object[] getParameters() {
        return this.oParams;
    }

    public boolean isCallBack() {
        return this.listener != null || this.oCallBackId != null;
    }

    public String formatMethod() {
        if (this.sObjectName == null) {
            return this.sMethodName;
        }
        return this.sObjectName + "." + this.sMethodName;
    }

    void success(AbstractSession abstractSession, Object object) {
        this.sendResult(abstractSession, (byte)1, object);
    }

    void error(AbstractSession abstractSession, Throwable throwable) {
        this.sendResult(abstractSession, (byte)2, throwable);
    }

    private void sendResult(AbstractSession abstractSession, byte by, Object object) {
        this.refUIThread.invokeLater(new CallBackWorker(this, abstractSession, by, object));
    }

    static final class CallBackWorker
    implements Runnable {
        private Call call;
        private AbstractSession session;
        private Object result;
        private byte byType;

        private CallBackWorker(Call call, AbstractSession abstractSession, byte by, Object object) {
            this.call = call;
            this.session = abstractSession;
            this.result = object;
            this.byType = by;
        }

        public void run() {
            if (this.call.oCallBackId != null) {
                this.session.addCallBackResult(new ResultObject(this.byType, this.result, this.call.oCallBackId));
            } else if (this.call.listener != null) {
                this.call.listener.callBack(new CallBackEvent(this.call.sObjectName, this.call.sMethodName, 1 == this.byType ? this.result : null, (Throwable)(2 == this.byType ? this.result : null), this.call.lCreation, System.currentTimeMillis()));
            } else {
                throw new RuntimeException("Callback not possible without callback id or callback listener!");
            }
        }
    }
}

