/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<boolean[]> {
    private static final int TYPE_BOOLEAN_ARRAY_MIN = 53;
    private static final int TYPE_BOOLEAN_ARRAY_MAX = 55;

    @Override
    public Class<boolean[]> getTypeClass() {
        return boolean[].class;
    }

    @Override
    public int getMinValue() {
        return 53;
    }

    @Override
    public int getMaxValue() {
        return 55;
    }

    @Override
    public boolean[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 53, 55);
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            blArray[i] = dataInputStream.readBoolean();
        }
        return blArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, boolean[] blArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, blArray.length, 53, 55);
        for (int i = 0; i < blArray.length; ++i) {
            dataOutputStream.writeBoolean(blArray[i]);
        }
    }
}

