/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.CheckConstraintSupport;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDBAccess
extends DBAccess {
    private static String sCheckSelect = "SELECT cu.TABLE_NAME, cu.COLUMN_NAME, c.CHECK_CLAUSE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS t, INFORMATION_SCHEMA.CHECK_CONSTRAINTS c, INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE cu WHERE t.CONSTRAINT_TYPE = 'CHECK' AND t.CONSTRAINT_SCHEMA = c.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = c.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = c.CONSTRAINT_NAME AND t.TABLE_NAME = ? AND t.TABLE_NAME = cu.TABLE_NAME AND t.TABLE_CATALOG = cu.TABLE_CATALOG AND t.TABLE_SCHEMA = cu.TABLE_SCHEMA AND t.CONSTRAINT_SCHEMA = cu.CONSTRAINT_SCHEMA AND t.CONSTRAINT_CATALOG = cu.CONSTRAINT_CATALOG AND t.CONSTRAINT_NAME = cu.CONSTRAINT_NAME";

    public MSSQLDBAccess() {
        this.setDriver("net.sourceforge.jtds.jdbc.Driver");
        this.setQuoteCharacters("[", "]");
    }

    private String addMSSQLSpecificAutoIncSupport(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, Object[] objectArray2) {
        int[] nArray = serverMetaData.getAutoIncrementColumnIndices();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if ((objectArray != null || objectArray2[nArray[i]] == null) && (objectArray == null || objectArray2[nArray[i]] == null || objectArray2[nArray[i]].equals(objectArray[nArray[i]]))) continue;
            return "SET IDENTITY_INSERT " + this.translateQuotes(string) + " ON " + string2 + " SET IDENTITY_INSERT " + this.translateQuotes(string) + " OFF";
        }
        return string2;
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        string2 = this.addMSSQLSpecificAutoIncSupport(string, string2, serverMetaData, null, objectArray);
        return this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        String string3 = StringUtil.removeQuotes(string2, "('", "')");
        string3 = StringUtil.removeQuotes(string3, "((", "))");
        string3 = StringUtil.removeQuotes(string3, "(", ")");
        return super.translateDefaultValue(string, n, string3);
    }

    @Override
    public Hashtable<String, Object[]> getAllowedValues(String string, String string2, String string3) throws DataSourceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Object[]> hashtable = new Hashtable();
        Hashtable<String, List<String>> hashtable2 = null;
        try {
            preparedStatement = this.getPreparedStatement(sCheckSelect, false);
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashtable2 = CheckConstraintSupport.parseCondition(resultSet.getString(3), hashtable2, false);
            }
            hashtable = CheckConstraintSupport.translateValues(this, string, string2, string3, hashtable2);
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Can't access check constraints for: '" + string3 + "'", this.formatSQLException(sQLException));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hashtable;
    }

    @Override
    public boolean isAutoQuote(String string) {
        return false;
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String var1_1, String[] var2_2, String var3_3, String var4_4, String var5_5, String var6_6, String[] var7_7) throws DataSourceException {
        block16: {
            block17: {
                var8_8 = super.getColumnMetaData(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
                var9_9 = DBAccess.removeQuotes(var8_8.getTable());
                if (var8_8.getSchema() != null && (var13_14 = this.checkTablesAndViews((String)(var10_10 = (var11_11 = DBAccess.removeQuotes((String)(var10_10 = var8_8.getSchema()))).equals(var10_10) != false ? var10_10.toLowerCase() : var11_11), var9_9 = (var12_12 = this.splitSchemaTable(var9_9))[1])).size() == 1) {
                    var8_8.setSchema(((Name)var13_14.get(0)[0]).getRealName());
                    return var8_8;
                }
                var10_10 = null;
                var11_11 = null;
                var12_13 = System.currentTimeMillis();
                if (this.getConnection().getMetaData().getDatabaseMajorVersion() <= 8) ** GOTO lbl30
                var10_10 = this.getPreparedStatement("SELECT default_schema_name FROM sys.database_principals WHERE type = 'S' AND name = ?", false);
                var10_10.setString(1, this.getUsername());
                var11_11 = var10_10.executeQuery();
                if (!var11_11.next()) break block16;
                var14_15 = var11_11.getString(1);
                if (var14_15 == null || (var15_18 = this.checkTablesAndViews(var14_15, var9_9)).size() != 1) break block17;
                var8_8.setSchema(((Name)var15_18.get(0)[0]).getRealName());
                var16_19 = var8_8;
                try {
                    if (var11_11 != null) {
                        var11_11.close();
                    }
                    MSSQLDBAccess.logger.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=" + (System.currentTimeMillis() - var12_13)});
                }
                catch (SQLException var17_20) {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var17_20));
                }
                return var16_19;
            }
            break block16;
lbl30:
            // 1 sources

            var14_15 = this.getDefaultSchema();
            if (var14_15 != null) {
                var8_8.setSchema(var14_15);
                break block16;
            }
            var8_8.setSchema("dbo");
        }
        try {
            if (var11_11 != null) {
                var11_11.close();
            }
            MSSQLDBAccess.logger.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=" + (System.currentTimeMillis() - var12_13)});
        }
        catch (SQLException var14_16) {
            throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var14_16));
        }
        catch (SQLException var14_17) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var14_17));
            }
            catch (Throwable var18_21) {
                try {
                    if (var11_11 != null) {
                        var11_11.close();
                    }
                    MSSQLDBAccess.logger.debug(new Object[]{"getColumnMetaData() - getDefaultSchema in time=" + (System.currentTimeMillis() - var12_13)});
                }
                catch (SQLException var19_22) {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(var19_22));
                }
                throw var18_21;
            }
        }
        return var8_8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Object[]> checkTablesAndViews(String string, String string2) throws DataSourceException {
        Object object;
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            resultSet = this.getConnection().getMetaData().getTables(this.getConnection().getCatalog(), string, string2, new String[]{"TABLE", "VIEW"});
            ArrayUtil<Object[]> arrayUtil = new ArrayUtil<Object[]>();
            while (resultSet.next()) {
                object = resultSet.getString("TABLE_SCHEM");
                if (((String)object).equals("sys") || ((String)object).equals("INFORMATION_SCHEMA")) continue;
                arrayUtil.add(new Object[]{new Name(resultSet.getString("TABLE_SCHEM"), this.quote(resultSet.getString("TABLE_SCHEM"))), new Name(resultSet.getString("TABLE_NAME"), this.quote(resultSet.getString("TABLE_NAME")))});
            }
            object = arrayUtil;
        }
        catch (SQLException sQLException) {
            try {
                throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    logger.debug("getTables() time=" + (System.currentTimeMillis() - l));
                    throw throwable;
                }
                catch (SQLException sQLException2) {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException2));
                }
            }
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            logger.debug("getTables() time=" + (System.currentTimeMillis() - l));
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
        }
    }
}

