/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.type.StringUtil;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBAccess
extends DBAccess {
    public HSQLDBAccess() {
        this.setDriver("org.hsqldb.jdbcDriver");
    }

    @Override
    public void open() throws DataSourceException {
        this.setDBProperty("get_column_name", "false");
        super.open();
    }

    @Override
    public Key getPK(String string, String string2, String string3) throws DataSourceException {
        return super.getPK(string, string2, this.getWritebackTable(string3));
    }

    @Override
    public List<ForeignKey> getFKs(String string, String string2, String string3) throws DataSourceException {
        return super.getFKs(string, string2, this.getWritebackTable(string3));
    }

    @Override
    public List<Key> getUKs(String string, String string2, String string3) throws DataSourceException {
        return super.getUKs(string, string2, this.getWritebackTable(string3));
    }

    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2) throws DataSourceException {
        if (stringArray2 != null) {
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray3[i] = stringArray2[i].toUpperCase();
            }
            stringArray2 = stringArray3;
        }
        return super.getColumnMetaData(string, stringArray, string2, string3, string4, this.getWritebackTable(string5), stringArray2);
    }

    @Override
    public Object[] insertDatabaseSpecific(String string, String string2, ServerMetaData serverMetaData, Object[] objectArray, String string3) throws DataSourceException {
        objectArray = this.insertAnsiSQL(string, string2, serverMetaData, objectArray, string3);
        return this.hsqlInsertPostProcessing(serverMetaData, objectArray);
    }

    @Override
    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    public String getWritebackTable(String string) {
        if (string != null) {
            return string.toUpperCase();
        }
        return null;
    }

    private Object[] hsqlInsertPostProcessing(ServerMetaData serverMetaData, Object[] objectArray) throws DataSourceException {
        if (serverMetaData.getPrimaryKeyColumnNames() != null && serverMetaData.getPrimaryKeyColumnNames().length > 0) {
            CallableStatement callableStatement = null;
            ResultSet resultSet = null;
            try {
                callableStatement = this.getConnection().prepareCall("CALL IDENTITY()");
                resultSet = callableStatement.executeQuery();
                if (resultSet.next() && serverMetaData.getPrimaryKeyColumnIndices().length > 0) {
                    objectArray[serverMetaData.getPrimaryKeyColumnIndices()[0]] = resultSet.getObject(1);
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            catch (SQLException sQLException) {
                throw new DataSourceException("The generated keys couldn't read!", this.formatSQLException(sQLException));
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw new DataSourceException("Jdbc statement close failed", this.formatSQLException(sQLException));
                }
            }
        }
        return objectArray;
    }
}

