/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.model.DataBookUtil;
import com.sibvisions.rad.persist.AbstractCachedStorage;
import com.sibvisions.rad.persist.AbstractStorage;
import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.IDBAccess;
import com.sibvisions.rad.persist.jdbc.Key;
import com.sibvisions.rad.persist.jdbc.Name;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.rad.persist.jdbc.ServerMetaData;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.KeyValueList;
import com.sibvisions.util.SecureHash;
import com.sibvisions.util.type.BeanUtil;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.And;
import javax.rad.model.condition.Filter;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.reference.StorageReferenceDefinition;
import javax.rad.persist.ColumnMetaData;
import javax.rad.persist.DataSourceException;
import javax.rad.persist.IStorage;
import javax.rad.persist.MetaData;
import javax.rad.type.bean.IBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStorage
extends AbstractCachedStorage {
    private static Hashtable<Object, ServerMetaData> htServerMetaDataCache = null;
    private static KeyValueList<Object, CacheLink> kvlCacheLink = null;
    private ServerMetaData mdServerMetaData;
    private HashMap<String, IStorage> hmpSubStorages;
    private boolean bIsOpen = false;
    private boolean bRefetch = true;
    private IDBAccess dbAccess;
    private String sFromClause;
    private String sFromClauseBeforeOpen;
    private String[] saQueryColumns;
    private String[] saQueryColumnsBeforeOpen;
    private String sBeforeQueryColumns;
    private String sWhereClause;
    private String sAfterWhereClause;
    private String[] saWritebackColumns;
    private String sWritebackTable;
    private String sWritebackTableSchema;
    private String sWritebackTableCatalog;
    private Object oCacheKey = null;
    private SortDefinition sdDefaultSort;
    private ICondition cRestrictCondition;
    private Boolean bAutoLinkReference;
    private static boolean bDefaultAutoLinkReference = true;
    private Boolean bDefaultValue;
    private static boolean bDefaultDefaultValue = true;
    private Boolean bAllowedValues;
    private static boolean bDefaultAllowedValues = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCSV(OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-1");
        try {
            int n;
            if (this.cRestrictCondition != null) {
                iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
            }
            if (sortDefinition == null) {
                sortDefinition = this.sdDefaultSort;
            }
            List<Object[]> list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, 0, -1);
            if (stringArray == null) {
                stringArray = this.mdServerMetaData.getColumnNames();
            }
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = this.mdServerMetaData.getServerColumnMetaData(stringArray[n]).getLabel();
                    if (stringArray2[n] != null) continue;
                    stringArray2[n] = ColumnMetaData.getDefaultLabel(stringArray[n]);
                }
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (n > 0) {
                    outputStreamWriter.write(string);
                }
                outputStreamWriter.write(StringUtil.quote(stringArray2[n], '\"'));
            }
            outputStreamWriter.write("\n");
            IDataType[] iDataTypeArray = new IDataType[stringArray.length];
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                iDataTypeArray[i] = ColumnMetaData.createDataType(this.mdServerMetaData.getServerColumnMetaData(stringArray[i]).getColumnMetaData());
            }
            for (n2 = 0; n2 < list.size() - 1; ++n2) {
                IBean iBean = this.createBean(list.get(n2));
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        outputStreamWriter.write(string);
                    }
                    DataBookUtil.writeQuoted(outputStreamWriter, iDataTypeArray[i], iBean.get(stringArray[i]), string);
                }
                outputStreamWriter.write("\n");
            }
            outputStreamWriter.flush();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public MetaData executeGetMetaData() throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        return this.mdServerMetaData.getMetaData();
    }

    @Override
    public int getEstimatedRowCount(ICondition iCondition) throws DataSourceException {
        List<Object[]> list;
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, new String[]{"COUNT(*)"}, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 1)) != null && list.size() >= 1 && list.get(0).length > 0) {
            Object object = list.get(0)[0];
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).intValue();
            }
            throw new DataSourceException("countRows() result data typ not supported! - " + object.getClass().getName());
        }
        return 0;
    }

    @Override
    public List<Object[]> executeFetch(ICondition iCondition, SortDefinition sortDefinition, int n, int n2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.cRestrictCondition != null) {
            iCondition = iCondition == null ? this.cRestrictCondition : new And(this.cRestrictCondition, iCondition);
        }
        if (sortDefinition == null) {
            sortDefinition = this.sdDefaultSort;
        }
        return this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, sortDefinition, n, n2);
    }

    @Override
    public Object[] executeRefetchRow(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        return this.refetchRow(objectArray, true);
    }

    @Override
    public Object[] executeInsert(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        Object[] objectArray2 = this.dbAccess.insert(this.getWritebackTable(), this.mdServerMetaData, objectArray);
        if (this.isRefetch()) {
            return this.refetchRow(objectArray2, false);
        }
        return objectArray2;
    }

    @Override
    public Object[] executeUpdate(Object[] objectArray, Object[] objectArray2) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        Object[] objectArray3 = this.dbAccess.update(this.getWritebackTable(), this.mdServerMetaData, objectArray, objectArray2);
        if (this.isRefetch()) {
            return this.refetchRow(objectArray3, false);
        }
        return objectArray3;
    }

    @Override
    public void executeDelete(Object[] objectArray) throws DataSourceException {
        if (!this.isOpen()) {
            throw new DataSourceException("DBStorage isn't open!");
        }
        if (this.getWritebackTable() == null) {
            return;
        }
        this.dbAccess.delete(this.getWritebackTable(), this.mdServerMetaData, objectArray);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsOpen()=");
        stringBuffer.append(this.bIsOpen);
        stringBuffer.append("\n");
        stringBuffer.append(this.dbAccess);
        stringBuffer.append("\n");
        stringBuffer.append(this.sBeforeQueryColumns);
        stringBuffer.append(" ");
        for (n = 0; this.saQueryColumns != null && n < this.saQueryColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saQueryColumns[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.sFromClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append(this.sAfterWhereClause);
        stringBuffer.append("\n");
        stringBuffer.append("Writeback:\n");
        stringBuffer.append(this.getWritebackTable());
        stringBuffer.append("\n");
        for (n = 0; this.saWritebackColumns != null && n < this.saWritebackColumns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.saWritebackColumns[n]);
        }
        return stringBuffer.toString();
    }

    @Override
    public MetaData getMetaData(String string, String string2) throws DataSourceException {
        if (kvlCacheLink == null) {
            kvlCacheLink = new KeyValueList();
        }
        CacheLink cacheLink = new CacheLink(string, string2);
        kvlCacheLink.put(this.oCacheKey, cacheLink, true);
        return super.getMetaData(string, string2);
    }

    public void open() throws DataSourceException {
        this.sFromClauseBeforeOpen = this.getFromClause();
        String[] stringArray = this.getQueryColumns();
        this.saQueryColumnsBeforeOpen = stringArray != null ? stringArray : null;
        this.openInternal(false);
    }

    protected void openInternal(boolean bl) throws DataSourceException {
        if (this.dbAccess == null) {
            throw new DataSourceException("DBAccess isn't set!");
        }
        this.mdServerMetaData = this.getMetaData(this.getBeforeQueryColumns(), this.getQueryColumns(), this.getFromClause(), this.getWhereClause(), this.getAfterWhereClause(), this.getWritebackTable(), this.getWritebackColumns(), this.isAutoLinkReference(), bl);
        this.bIsOpen = true;
    }

    protected void refreshMetaData() throws DataSourceException {
        if (this.hmpSubStorages != null) {
            this.hmpSubStorages.clear();
        }
        this.setFromClause(this.sFromClauseBeforeOpen);
        this.setQueryColumns(this.saQueryColumnsBeforeOpen);
        this.openInternal(false);
    }

    private IStorage putSubStorage(String string, IStorage iStorage) {
        if (this.hmpSubStorages == null) {
            this.hmpSubStorages = new HashMap();
        }
        return this.hmpSubStorages.put(string, iStorage);
    }

    public void createAutomaticLinkReference(String[] stringArray, String string, String[] stringArray2) throws ModelException {
        this.createAutomaticLinkReference(this.mdServerMetaData, stringArray, this.createAutomaticLinkStorage(string), stringArray2);
    }

    public void createAutomaticLinkReference(String[] stringArray, DBStorage dBStorage, String[] stringArray2) throws ModelException {
        this.createAutomaticLinkReference(this.mdServerMetaData, stringArray, dBStorage, stringArray2);
    }

    protected void createAutomaticLinkReference(ServerMetaData serverMetaData, String[] stringArray, AbstractStorage abstractStorage, String[] stringArray2) throws ModelException {
        int n;
        Object object;
        String string;
        if (abstractStorage.getName() != null) {
            string = abstractStorage.getName();
        } else if (abstractStorage instanceof DBStorage) {
            object = (DBStorage)abstractStorage;
            string = ((DBStorage)object).getWritebackTable() != null ? ((DBStorage)object).getWritebackTable().toLowerCase() : ((DBStorage)object).getFromClause().toLowerCase();
        } else {
            object = new StringBuilder();
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    ((StringBuilder)object).append("_");
                }
                ((StringBuilder)object).append(stringArray[n]);
            }
            string = ((StringBuilder)object).toString();
        }
        this.putSubStorage(string, abstractStorage);
        object = new StorageReferenceDefinition(stringArray, ".subStorages." + string, stringArray2);
        for (n = 0; n < stringArray.length; ++n) {
            serverMetaData.getServerColumnMetaData(stringArray[n]).setLinkReference((StorageReferenceDefinition)object);
        }
    }

    public void removeLinkReference(String string) throws ModelException {
        this.mdServerMetaData.getServerColumnMetaData(string).setLinkReference(null);
    }

    public boolean hasLinkReference(String string) throws ModelException {
        return this.hasLinkReference(this.mdServerMetaData, string);
    }

    protected boolean hasLinkReference(ServerMetaData serverMetaData, String string) throws ModelException {
        return serverMetaData.getServerColumnMetaData(string).getLinkReference() != null;
    }

    ServerMetaData getMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2, boolean bl, boolean bl2) throws DataSourceException {
        int n;
        String string6;
        String[] stringArray3;
        ServerColumnMetaData[] serverColumnMetaDataArray;
        Object object;
        String[] stringArray4;
        Object object2;
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        Object object3;
        ServerColumnMetaData[] serverColumnMetaDataArray2;
        Object object4;
        ServerMetaData serverMetaData;
        this.oCacheKey = this.createCheckSum(string, stringArray, string2, string3, string4, string5, stringArray2, bl, bl2, ((DBAccess)this.dbAccess).getUrl(), ((DBAccess)this.dbAccess).getUsername());
        if (this.isMetaDataCacheEnabled()) {
            if (this.oCacheKey != null && htServerMetaDataCache != null) {
                this.validateMetaDataCache();
                serverMetaData = htServerMetaDataCache.get(this.oCacheKey);
            } else {
                serverMetaData = null;
            }
        } else {
            if (htServerMetaDataCache != null) {
                htServerMetaDataCache = null;
                kvlCacheLink = null;
            }
            serverMetaData = null;
        }
        if (serverMetaData != null) {
            String[] stringArray5;
            serverMetaData = serverMetaData.clone();
            ServerColumnMetaData[] serverColumnMetaDataArray3 = serverMetaData.getServerColumnMetaData();
            for (int i = 0; i < serverColumnMetaDataArray3.length; ++i) {
                ForeignKey foreignKey = serverColumnMetaDataArray3[i].getLinkForeignKey();
                if (foreignKey == null) continue;
                DBStorage dBStorage = this.createAutomaticLinkStorage(foreignKey.getPKTable().getQuotedName());
                dBStorage.setDefaultSort(new SortDefinition(foreignKey.getLinkReferenceColumn().getName()));
                this.putSubStorage(foreignKey.getPKTable().getName().toLowerCase(), dBStorage);
            }
            String string7 = serverMetaData.getFromClause();
            if (string7 != null) {
                this.setFromClause(string7);
            }
            if ((stringArray5 = serverMetaData.getQueryColumns()) != null) {
                this.setQueryColumns(stringArray5);
            }
            return serverMetaData;
        }
        Key key = null;
        List<Key> list = null;
        List<ForeignKey> list2 = null;
        ArrayUtil<DBStorage> arrayUtil = null;
        DBAccess dBAccess = (DBAccess)this.dbAccess;
        string3 = string3 == null ? "1=2" : string3 + " AND 1=2";
        Hashtable<String, Object> hashtable = null;
        Hashtable<String, Object> hashtable2 = null;
        DBAccess.ColumnMetaDataInfo columnMetaDataInfo = null;
        if (string5 != null) {
            Object[] objectArray2;
            columnMetaDataInfo = dBAccess.getColumnMetaData(string5, null, null, string3, null, null, null);
            object4 = columnMetaDataInfo.getCatalog();
            serverColumnMetaDataArray2 = columnMetaDataInfo.getSchema();
            this.sWritebackTableCatalog = object4;
            this.sWritebackTableSchema = serverColumnMetaDataArray2;
            this.debug("WritebackTable Schema=" + (String)serverColumnMetaDataArray2 + ",Catalog=" + (String)object4);
            object3 = columnMetaDataInfo.getTable();
            if (this.isDefaultValue()) {
                hashtable = dBAccess.getDefaultValues((String)object4, (String)serverColumnMetaDataArray2, (String)object3);
            }
            objectArray = columnMetaDataInfo.getColumnMetaData();
            if (this.isAllowedValues()) {
                hashtable2 = dBAccess.getAllowedValues((String)object4, (String)serverColumnMetaDataArray2, (String)object3);
                n4 = objectArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (hashtable2 != null && hashtable2.get(objectArray[n3].getName()) != null || (objectArray2 = dBAccess.getDefaultAllowedValues((String)object4, (String)serverColumnMetaDataArray2, (String)object3, (ServerColumnMetaData)objectArray[n3])) == null) continue;
                    if (hashtable2 == null) {
                        hashtable2 = new Hashtable();
                    }
                    hashtable2.put(((ServerColumnMetaData)objectArray[n3]).getName(), objectArray2);
                }
            }
            key = dBAccess.getPK((String)object4, (String)serverColumnMetaDataArray2, (String)object3);
            list = dBAccess.getUKs((String)object4, (String)serverColumnMetaDataArray2, (String)object3);
            objectArray2 = new String[objectArray.length];
            BeanUtil.toArray(objectArray, objectArray2, "quotedName");
            if (stringArray2 == null) {
                stringArray2 = objectArray2;
            }
            if (bl) {
                list2 = dBAccess.getFKs((String)object4, (String)serverColumnMetaDataArray2, (String)object3);
                arrayUtil = new ArrayUtil<DBStorage>(list2.size());
                if (list2 != null) {
                    Iterator<ForeignKey> iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        ForeignKey foreignKey = iterator.next();
                        Name[] nameArray = foreignKey.getFKColumns();
                        n2 = 0;
                        for (int i = 0; i < nameArray.length && n2 == 0; ++i) {
                            int n5 = ArrayUtil.indexOf(objectArray2, nameArray[i].getQuotedName());
                            if (n5 < 0 || !((ServerColumnMetaData)objectArray[n5]).isNullable()) continue;
                            foreignKey.setNullable(true);
                            n2 = 1;
                        }
                        DBStorage dBStorage = this.createAutomaticLinkStorage(foreignKey.getPKTable().getQuotedName());
                        object2 = dBStorage.mdServerMetaData;
                        stringArray4 = ((ServerMetaData)object2).getRepresentationColumnNames();
                        object = null;
                        serverColumnMetaDataArray = ((ServerMetaData)object2).getServerColumnMetaData();
                        stringArray3 = BeanUtil.toArray(foreignKey.getPKColumns(), new String[foreignKey.getPKColumns().length], "name");
                        n2 = 0;
                        for (int i = 0; i < serverColumnMetaDataArray.length && n2 == 0; ++i) {
                            string6 = serverColumnMetaDataArray[i].getName();
                            if (serverColumnMetaDataArray[i].getColumnMetaData().getDataType() == 12 && ArrayUtil.indexOf(stringArray3, string6) < 0 && ArrayUtil.indexOf(stringArray4, string6) >= 0) {
                                foreignKey.setLinkReferenceColumn(serverColumnMetaDataArray[i].getColumnName());
                                n2 = 1;
                                continue;
                            }
                            if (object != null || ArrayUtil.indexOf(stringArray3, string6) >= 0) continue;
                            object = serverColumnMetaDataArray[i].getColumnName();
                        }
                        if (n2 == 0 && object != null) {
                            foreignKey.setLinkReferenceColumn((Name)object);
                        }
                        if (foreignKey.getLinkReferenceColumn() == null) {
                            iterator.remove();
                            continue;
                        }
                        dBStorage.setDefaultSort(new SortDefinition(foreignKey.getLinkReferenceColumn().getName()));
                        arrayUtil.add(dBStorage);
                    }
                }
                this.debug("auForeignKeys = ", list2);
                if (string2 == null || string2.equals(string5)) {
                    if (this.getQueryColumns() == null) {
                        stringArray = dBAccess.getQueryColumns(string5, list2, stringArray2);
                        this.setQueryColumns(stringArray);
                    }
                    string2 = dBAccess.getFromClause(string5, list2);
                    this.setFromClause(string2);
                }
            }
            if (string2 == null) {
                string2 = string5;
            }
        }
        serverMetaData = new ServerMetaData();
        object4 = dBAccess.getColumnMetaData(string2, stringArray, string, string3, string4, string5, stringArray2);
        serverColumnMetaDataArray2 = ((DBAccess.ColumnMetaDataInfo)object4).getColumnMetaData();
        object3 = null;
        if (columnMetaDataInfo != null) {
            object3 = columnMetaDataInfo.getColumnMetaData();
        }
        serverMetaData.setServerColumnMetaData(serverColumnMetaDataArray2);
        objectArray = new ArrayUtil();
        for (n = 0; n < serverColumnMetaDataArray2.length; ++n) {
            Object[] objectArray3;
            if (serverColumnMetaDataArray2[n].isAutoIncrement()) {
                objectArray.add(serverColumnMetaDataArray2[n].getColumnName());
            }
            if (hashtable != null) {
                serverColumnMetaDataArray2[n].setDefaultValue(hashtable.get(serverColumnMetaDataArray2[n].getName()));
            }
            if (hashtable2 != null && (objectArray3 = (Object[])hashtable2.get(serverColumnMetaDataArray2[n].getName())) != null && objectArray3.length > 0) {
                serverColumnMetaDataArray2[n].setAllowedValues(objectArray3);
            }
            if (object3 == null) continue;
            for (n3 = 0; n3 < ((ServerColumnMetaData[])object3).length; ++n3) {
                if (!object3[n3].getName().equals(serverColumnMetaDataArray2[n].getName())) continue;
                serverColumnMetaDataArray2[n].setNullable(object3[n3].isNullable());
            }
        }
        if (!objectArray.isEmpty()) {
            serverMetaData.setAutoIncrementColumnNames(objectArray.toArray(new Name[objectArray.size()]));
        }
        if (string5 != null) {
            int n6 = n = key != null && key.getColumns() != null && key.getColumns().length > 0 ? 1 : 0;
            if (n != 0) {
                serverMetaData.setPrimaryKeyColumnNames(key.getColumns());
            } else if (list != null && list.size() > 0) {
                Name[] nameArray = ((Key)list.get(0)).getColumns();
                serverMetaData.setPrimaryKeyColumnNames(nameArray);
            } else {
                ArrayUtil<Name> arrayUtil2 = new ArrayUtil<Name>();
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    boolean bl3 = false;
                    Name name = new Name(stringArray2[n2], dBAccess.quote(stringArray2[n2]));
                    for (int i = 0; i < serverColumnMetaDataArray2.length && !bl3; ++i) {
                        bl3 = serverColumnMetaDataArray2[i].getColumnName().equals(name) && serverColumnMetaDataArray2[i].getColumnMetaData().getDataType() == -2;
                    }
                    if (bl3) continue;
                    arrayUtil2.add(name);
                }
                if (!arrayUtil2.isEmpty()) {
                    serverMetaData.setPrimaryKeyColumnNames(arrayUtil2.toArray(new Name[arrayUtil2.size()]));
                }
            }
            if (list != null && list.size() > 0) {
                ArrayUtil<Name> arrayUtil3 = new ArrayUtil<Name>();
                for (n4 = 0; n4 < list.size(); ++n4) {
                    Name[] nameArray = list.get(n4).getColumns();
                    for (n2 = 0; n2 < nameArray.length; ++n2) {
                        if (arrayUtil3.indexOf(nameArray[n2]) >= 0) continue;
                        arrayUtil3.add(nameArray[n2]);
                    }
                }
                if (arrayUtil3.size() > 0) {
                    Name[] nameArray = new Name[arrayUtil3.size()];
                    arrayUtil3.toArray(nameArray);
                    serverMetaData.setRepresentationColumnNames(nameArray);
                }
            }
            if (bl && list2 != null) {
                int n7 = list2.size();
                for (int i = 0; i < n7; ++i) {
                    ForeignKey foreignKey = (ForeignKey)list2.get(i);
                    try {
                        String string8 = foreignKey.getLinkReferenceColumn().getName();
                        String string9 = dBAccess.getAutomaticLinkColumnName(foreignKey);
                        object2 = serverMetaData.getServerColumnMetaData(string9);
                        ((ServerColumnMetaData)object2).setLabel(ColumnMetaData.getDefaultLabel(string8));
                        stringArray4 = ArrayUtil.add(BeanUtil.toArray(foreignKey.getFKColumns(), new String[foreignKey.getFKColumns().length], "name"), string9);
                        object = ArrayUtil.add(BeanUtil.toArray(foreignKey.getPKColumns(), new String[foreignKey.getPKColumns().length], "name"), string8);
                        string6 = foreignKey.getPKTable().getName().toLowerCase();
                        serverColumnMetaDataArray = new StorageReferenceDefinition(stringArray4, ".subStorages." + string6, (String[])object);
                        stringArray3 = (String[])arrayUtil.get(i);
                        ((ServerColumnMetaData)object2).setLinkReference((StorageReferenceDefinition)serverColumnMetaDataArray);
                        ((ServerColumnMetaData)object2).setNullable(foreignKey.isNullable());
                        ((ServerColumnMetaData)object2).setLinkForeignKey(foreignKey);
                        this.putSubStorage(string6, (IStorage)stringArray3);
                        continue;
                    }
                    catch (ModelException modelException) {
                        object2 = new String[serverMetaData.getServerColumnMetaData().length];
                        this.debug(Arrays.toString(BeanUtil.toArray(serverMetaData.getServerColumnMetaData(), object2, "name")));
                        this.debug(modelException);
                    }
                }
            }
        }
        if (serverMetaData.getRepresentationColumnNames() == null) {
            Name[] nameArray = new Name[serverMetaData.getServerColumnMetaData().length];
            n4 = nameArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                nameArray[n3] = serverMetaData.getServerColumnMetaData()[n3].getColumnName();
            }
            serverMetaData.setRepresentationColumnNames(nameArray);
        }
        if (bl2) {
            int n8;
            String[] stringArray6 = serverMetaData.getRepresentationColumnNames();
            String[] stringArray7 = serverMetaData.getPrimaryKeyColumnNames();
            if (stringArray7 != null) {
                for (n4 = 0; n4 < stringArray7.length; ++n4) {
                    if (ArrayUtil.indexOf(stringArray6, stringArray7[n4]) >= 0) continue;
                    stringArray6 = ArrayUtil.add(stringArray6, stringArray7[n4]);
                }
            }
            ServerColumnMetaData[] serverColumnMetaDataArray4 = serverMetaData.getServerColumnMetaData();
            for (n8 = serverColumnMetaDataArray4.length - 1; n8 >= 0; --n8) {
                if (ArrayUtil.indexOf(stringArray6, serverColumnMetaDataArray4[n8].getName()) >= 0) continue;
                serverColumnMetaDataArray4 = (ServerColumnMetaData[])ArrayUtil.remove(serverColumnMetaDataArray4, n8);
            }
            this.saQueryColumns = new String[serverColumnMetaDataArray4.length];
            for (n8 = 0; n8 < serverColumnMetaDataArray4.length; ++n8) {
                this.saQueryColumns[n8] = serverColumnMetaDataArray4[n8].getColumnName().getQuotedName();
            }
            serverMetaData.setServerColumnMetaData(serverColumnMetaDataArray4);
        }
        serverMetaData.setFromClause(this.getFromClause());
        serverMetaData.setQueryColumns(this.getQueryColumns());
        if (htServerMetaDataCache == null) {
            htServerMetaDataCache = new Hashtable();
        }
        htServerMetaDataCache.put(this.oCacheKey, serverMetaData);
        this.updateMetaDataCache(serverMetaData);
        return serverMetaData;
    }

    private void updateMetaDataCache(ServerMetaData serverMetaData) {
        List<CacheLink> list;
        if (kvlCacheLink != null && (list = kvlCacheLink.get(this.oCacheKey)) != null) {
            for (CacheLink cacheLink : list) {
                this.putMetaDataToCache(cacheLink.sGroup, cacheLink.sName, serverMetaData.getMetaData());
            }
        }
    }

    private void validateMetaDataCache() {
        List<CacheLink> list;
        if (kvlCacheLink != null && (list = kvlCacheLink.get(this.oCacheKey)) != null) {
            for (CacheLink cacheLink : list) {
                if (this.getMetaDataFromCache(cacheLink.sGroup, cacheLink.sName) != null) continue;
                kvlCacheLink.remove(this.oCacheKey);
                htServerMetaDataCache.remove(this.oCacheKey);
            }
        }
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    public void close() {
        this.oCacheKey = null;
        this.bIsOpen = false;
    }

    public void setDBAccess(IDBAccess iDBAccess) {
        this.dbAccess = iDBAccess;
    }

    public IDBAccess getDBAccess() {
        return this.dbAccess;
    }

    public String getFromClause() {
        return this.sFromClause;
    }

    private String getFromClauseIntern() {
        if (this.sFromClause == null) {
            return this.sWritebackTable;
        }
        return this.sFromClause;
    }

    public void setFromClause(String string) {
        this.sFromClause = string;
    }

    public String[] getQueryColumns() {
        return this.saQueryColumns;
    }

    public void setQueryColumns(String[] stringArray) {
        this.saQueryColumns = stringArray;
    }

    public String getBeforeQueryColumns() {
        return this.sBeforeQueryColumns;
    }

    public void setBeforeQueryColumns(String string) {
        this.sBeforeQueryColumns = string;
    }

    public String getWhereClause() {
        return this.sWhereClause;
    }

    public void setWhereClause(String string) {
        this.sWhereClause = string;
    }

    public String getAfterWhereClause() {
        return this.sAfterWhereClause;
    }

    public void setAfterWhereClause(String string) {
        this.sAfterWhereClause = string;
    }

    public String[] getWritebackColumns() {
        return this.saWritebackColumns;
    }

    public void setWritebackColumns(String[] stringArray) {
        this.saWritebackColumns = stringArray;
    }

    public String getWritebackTable() {
        return this.sWritebackTable;
    }

    public void setWritebackTable(String string) {
        this.sWritebackTable = string;
    }

    public SortDefinition getDefaultSort() {
        return this.sdDefaultSort;
    }

    public void setDefaultSort(SortDefinition sortDefinition) {
        this.sdDefaultSort = sortDefinition;
    }

    public ICondition getRestrictCondition() {
        return this.cRestrictCondition;
    }

    public void setRestrictCondition(ICondition iCondition) {
        this.cRestrictCondition = iCondition;
    }

    public boolean isRefetch() {
        return this.bRefetch;
    }

    public void setRefetch(boolean bl) {
        this.bRefetch = bl;
    }

    public void setAutoLinkReference(boolean bl) {
        this.bAutoLinkReference = bl;
    }

    public boolean isAutoLinkReference() {
        if (this.bAutoLinkReference == null) {
            return bDefaultAutoLinkReference;
        }
        return this.bAutoLinkReference;
    }

    public static void setDefaultAutoLinkReference(boolean bl) {
        bDefaultAutoLinkReference = bl;
    }

    public static boolean isDefaultAutoLinkReference() {
        return bDefaultAutoLinkReference;
    }

    public void setDefaultValue(boolean bl) {
        this.bDefaultValue = bl;
    }

    public boolean isDefaultValue() {
        if (this.bDefaultValue == null) {
            return bDefaultDefaultValue;
        }
        return this.bDefaultValue;
    }

    public static void setDefaultDefaultValue(boolean bl) {
        bDefaultDefaultValue = bl;
    }

    public static boolean isDefaultDefaultValue() {
        return bDefaultDefaultValue;
    }

    public void setAllowedValues(boolean bl) {
        this.bAllowedValues = bl;
    }

    public boolean isAllowedValues() {
        if (this.bAllowedValues == null) {
            return bDefaultAllowedValues;
        }
        return this.bAllowedValues;
    }

    public static void setDefaultAllowedValues(boolean bl) {
        bDefaultAllowedValues = bl;
    }

    public boolean isDefaultAllowedValues() {
        return bDefaultAllowedValues;
    }

    protected String getWritebackTableCatalog() {
        return this.sWritebackTableCatalog;
    }

    protected String getWritebackTableSchema() {
        return this.sWritebackTableSchema;
    }

    protected Object[] refetchRow(Object[] objectArray, boolean bl) throws DataSourceException {
        List<Object[]> list;
        if (objectArray == null) {
            return null;
        }
        if (this.getWritebackTable() == null) {
            return null;
        }
        ICondition iCondition = Filter.createEqualsFilter(this.mdServerMetaData.getPrimaryKeyColumnNames(), objectArray, this.mdServerMetaData.getMetaData().getColumnMetaData());
        if (bl) {
            this.dbAccess.lockRow(this.getFromClauseIntern(), this.mdServerMetaData, iCondition);
        }
        if ((list = this.dbAccess.fetch(this.mdServerMetaData, this.sBeforeQueryColumns, this.saQueryColumns, this.getFromClauseIntern(), iCondition, this.sWhereClause, this.sAfterWhereClause, null, 0, 2)) != null && list.size() == 2 && list.get(1) == null) {
            return list.get(0);
        }
        return null;
    }

    public String[] getColumnNames() {
        return this.mdServerMetaData.getColumnNames();
    }

    public Map<String, IStorage> getSubStorages() {
        return this.hmpSubStorages;
    }

    protected DBStorage createAutomaticLinkStorage(String string) throws DataSourceException {
        DBStorage dBStorage = new DBStorage();
        dBStorage.setDBAccess(this.dbAccess);
        dBStorage.setWritebackTable(string);
        dBStorage.setAutoLinkReference(false);
        dBStorage.openInternal(true);
        return dBStorage;
    }

    protected Object createCheckSum(Object ... objectArray) {
        try {
            SecureHash secureHash = new SecureHash("MD5");
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) {
                    if (objectArray[i] instanceof String) {
                        secureHash.add(((String)objectArray[i]).getBytes());
                        continue;
                    }
                    if (objectArray[i] instanceof String[]) {
                        for (String string : (String[])objectArray[i]) {
                            if (string == null) continue;
                            secureHash.add(string.getBytes());
                        }
                        continue;
                    }
                    if (!(objectArray[i] instanceof Boolean)) continue;
                    if (Boolean.TRUE == objectArray[i]) {
                        secureHash.add(new byte[]{1});
                        continue;
                    }
                    secureHash.add(new byte[]{0});
                    continue;
                }
                secureHash.add(new byte[]{0});
            }
            return secureHash.getHash();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static final class CacheLink {
        private String sGroup;
        private String sName;
        private int iHashCode = -1;

        private CacheLink(String string, String string2) {
            this.sGroup = string;
            this.sName = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheLink) {
                return CommonUtil.equals(this.sGroup, ((CacheLink)object).sGroup) && CommonUtil.equals(this.sName, ((CacheLink)object).sName);
            }
            return false;
        }

        public int hashCode() {
            if (this.iHashCode == -1) {
                this.iHashCode = (this.sGroup != null ? this.sGroup.hashCode() : 7) + (this.sName != null ? this.sName.hashCode() : 31);
            }
            return this.iHashCode;
        }
    }
}

