/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.persist.jdbc;

import com.sibvisions.rad.persist.jdbc.DBAccess;
import com.sibvisions.rad.persist.jdbc.ForeignKey;
import com.sibvisions.rad.persist.jdbc.ServerColumnMetaData;
import com.sibvisions.util.type.StringUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import javax.rad.persist.DataSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2DBAccess
extends DBAccess {
    public DB2DBAccess() {
        this.setDriver("com.ibm.db2.jcc.DB2Driver");
    }

    @Override
    public void open() throws DataSourceException {
        this.setDBProperty("retrieveMessagesFromServerOnGetMessage", "true");
        super.open();
    }

    @Override
    public void setUsername(String string) {
        super.setUsername(DBAccess.removeQuotes(string));
    }

    @Override
    public Hashtable<String, Object> getDefaultValues(String string, String string2, String string3) throws DataSourceException {
        return super.getDefaultValues(string, string2, string3.toUpperCase());
    }

    @Override
    protected Object translateDefaultValue(String string, int n, String string2) throws Exception {
        return super.translateDefaultValue(string, n, StringUtil.removeQuotes(string2, "'"));
    }

    @Override
    public DBAccess.ColumnMetaDataInfo getColumnMetaData(String string, String[] stringArray, String string2, String string3, String string4, String string5, String[] stringArray2) throws DataSourceException {
        String string6;
        DBAccess.ColumnMetaDataInfo columnMetaDataInfo = super.getColumnMetaData(string, stringArray, string2, string3, string4, string5, stringArray2);
        if (columnMetaDataInfo != null) {
            columnMetaDataInfo.setCatalog(null);
        }
        if ((string6 = columnMetaDataInfo.getTable()) != null && !string6.startsWith("`") && !string6.endsWith("`")) {
            columnMetaDataInfo.setTable(string6.toUpperCase());
        }
        return columnMetaDataInfo;
    }

    @Override
    public List<ForeignKey> getFKs(String string, String string2, String string3) throws DataSourceException {
        List<ForeignKey> list = super.getFKs(string, string2, string3);
        for (int i = 0; i < list.size(); ++i) {
            ForeignKey foreignKey = list.get(i);
            foreignKey.setPKCatalog(null);
        }
        return list;
    }

    @Override
    protected boolean setDatabaseSpecificType(ResultSetMetaData resultSetMetaData, int n, ServerColumnMetaData serverColumnMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnType(n);
        if (n2 == 1111) {
            serverColumnMetaData.setDataType(3);
            serverColumnMetaData.setPrecision(0);
            serverColumnMetaData.setScale(-1);
            serverColumnMetaData.setSigned(resultSetMetaData.isSigned(n));
            return true;
        }
        return super.setDatabaseSpecificType(resultSetMetaData, n, serverColumnMetaData);
    }
}

