/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.remote;

import com.sibvisions.rad.model.mem.MemDataSource;
import java.util.Hashtable;
import javax.rad.model.MetaDataCacheOption;
import javax.rad.model.ModelException;
import javax.rad.persist.MetaData;
import javax.rad.remote.AbstractConnection;

public class RemoteDataSource
extends MemDataSource {
    private AbstractConnection acConnection;
    private static Hashtable<String, MetaData> htGlobalMetaDataCache = null;
    private Hashtable<String, MetaData> htLocalMetaDataCache = null;
    private static MetaDataCacheRole cacheRole = MetaDataCacheRole.DataSource;

    public RemoteDataSource() {
    }

    public RemoteDataSource(AbstractConnection abstractConnection) {
        this.acConnection = abstractConnection;
    }

    public void open() throws ModelException {
        if (this.acConnection == null) {
            throw new ModelException("Connection is null! -> open not possible");
        }
        super.open();
    }

    public AbstractConnection getConnection() {
        return this.acConnection;
    }

    public void setConnection(AbstractConnection abstractConnection) {
        if (this.acConnection != abstractConnection) {
            this.clearMetaData();
        }
        this.acConnection = abstractConnection;
    }

    public MetaData getMetaData(String string) {
        MetaDataCacheOption metaDataCacheOption = this.getMetaDataCacheOption();
        if (metaDataCacheOption == MetaDataCacheOption.Default || metaDataCacheOption == MetaDataCacheOption.On) {
            if (cacheRole == MetaDataCacheRole.Global || metaDataCacheOption == MetaDataCacheOption.On) {
                return RemoteDataSource.getGlobalMetaData(string);
            }
            if (cacheRole == MetaDataCacheRole.DataSource) {
                if (this.htLocalMetaDataCache == null) {
                    return null;
                }
                return this.htLocalMetaDataCache.get(string);
            }
        }
        return null;
    }

    public void putMetaData(String string, MetaData metaData) {
        MetaDataCacheOption metaDataCacheOption = this.getMetaDataCacheOption();
        if (metaDataCacheOption == MetaDataCacheOption.Default || metaDataCacheOption == MetaDataCacheOption.On) {
            if (cacheRole == MetaDataCacheRole.Global || metaDataCacheOption == MetaDataCacheOption.On) {
                RemoteDataSource.putGlobalMetaDataIntern(string, metaData);
            } else if (cacheRole == MetaDataCacheRole.DataSource) {
                if (this.htLocalMetaDataCache == null) {
                    this.htLocalMetaDataCache = new Hashtable();
                }
                this.htLocalMetaDataCache.put(string, metaData);
            }
        }
    }

    public void clearMetaData() {
        if (this.htLocalMetaDataCache != null) {
            this.htLocalMetaDataCache.clear();
        }
    }

    public static MetaData getGlobalMetaData(String string) {
        if (htGlobalMetaDataCache == null) {
            return null;
        }
        return htGlobalMetaDataCache.get(string);
    }

    public static void putGlobalMetaData(String string, MetaData metaData) {
        if (cacheRole == MetaDataCacheRole.Global) {
            RemoteDataSource.putGlobalMetaDataIntern(string, metaData);
        }
    }

    private static void putGlobalMetaDataIntern(String string, MetaData metaData) {
        if (htGlobalMetaDataCache == null) {
            htGlobalMetaDataCache = new Hashtable();
        }
        htGlobalMetaDataCache.put(string, metaData);
    }

    public static void clearGlobalMetaData() {
        if (htGlobalMetaDataCache != null) {
            htGlobalMetaDataCache.clear();
        }
    }

    public static void setMetaDataCacheRole(MetaDataCacheRole metaDataCacheRole) {
        cacheRole = metaDataCacheRole;
    }

    public static MetaDataCacheRole getMetaDataCacheRole() {
        return cacheRole;
    }

    private MetaDataCacheOption getMetaDataCacheOption() {
        Object object;
        try {
            object = this.acConnection.getProperty("server.client.metadatacache_option");
        }
        catch (Throwable throwable) {
            object = null;
        }
        if (object == null) {
            return MetaDataCacheOption.Default;
        }
        return MetaDataCacheOption.resolve((String)object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaDataCacheRole {
        Global,
        DataSource,
        Off;


        public static MetaDataCacheRole resolve(String string) {
            if (string != null) {
                String string2 = string.toUpperCase();
                if ("GLOBAL".equals(string2)) {
                    return Global;
                }
                if ("DATASOURCE".equals(string2)) {
                    return DataSource;
                }
                if ("OFF".equals(string2)) {
                    return Off;
                }
            }
            throw new IllegalArgumentException("Unknown enum: " + string);
        }
    }
}

