/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.mem.ChangeableDataRow;
import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.util.ArrayUtil;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;

public class MemDataPage
implements IDataPage {
    private static final int INIT_STORAGE_SIZE = 16;
    private MemDataBook dbDataBook;
    private IDataRow drMasterDataRow;
    private ArrayUtil<Object[]> alStorage;
    private int[] iaChangedRows = new int[0];
    private boolean bAllFetched = true;
    private int[] iaUsedRows;

    public MemDataPage(MemDataBook memDataBook, IDataRow iDataRow) {
        this.dbDataBook = memDataBook;
        this.drMasterDataRow = iDataRow;
        this.alStorage = new ArrayUtil(16);
    }

    public IDataBook getDataBook() {
        return this.dbDataBook;
    }

    public IDataRow getMasterDataRow() {
        return this.drMasterDataRow;
    }

    public IChangeableDataRow getDataRow(int n) throws ModelException {
        this.initFilterSort();
        if (!this.bAllFetched && n >= this.alStorage.size()) {
            this.fetchToRow(n);
        }
        if (n >= 0 && n < this.getRowCountInternal()) {
            return this.getDataRowWithoutSort(this.getInternalRowIndex(n));
        }
        return null;
    }

    public void fetchAll() throws ModelException {
        if (!this.bAllFetched) {
            this.fetchToRow(-1);
        }
    }

    public boolean isAllFetched() throws ModelException {
        return this.bAllFetched;
    }

    public int getRowCount() throws ModelException {
        this.initFilterSort();
        return this.getRowCountInternal();
    }

    public int[] getChangedDataRows() {
        return this.iaChangedRows;
    }

    public int searchNext(ICondition iCondition) throws ModelException {
        return this.searchNext(iCondition, 0);
    }

    public int searchNext(ICondition iCondition, int n) throws ModelException {
        if (iCondition != null && n >= 0) {
            this.initFilterSort();
            if (!this.bAllFetched && n >= this.alStorage.size()) {
                this.fetchToRow(n);
            }
            while (n < this.getRowCountInternal()) {
                if (iCondition.isFulfilled(this.getDataRowWithoutSort(this.getInternalRowIndex(n)))) {
                    return n;
                }
                if (this.bAllFetched || ++n < this.alStorage.size()) continue;
                this.fetchToRow(n);
            }
        }
        return -1;
    }

    public int searchPrevious(ICondition iCondition) throws ModelException {
        return this.searchPrevious(iCondition, -1);
    }

    public int searchPrevious(ICondition iCondition, int n) throws ModelException {
        if (iCondition != null && n != 0) {
            this.fetchAll();
            this.initFilterSort();
            int n2 = this.getRowCountInternal();
            n = n < 0 || n > n2 ? n2 - 1 : --n;
            while (n >= 0) {
                if (iCondition.isFulfilled(this.getDataRowWithoutSort(this.getInternalRowIndex(n)))) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataPage ::");
        if (this.dbDataBook != null) {
            stringBuilder.append("[");
            stringBuilder.append(this.dbDataBook.getName());
            stringBuilder.append("] -");
        }
        try {
            n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("[");
                stringBuilder.append(i);
                stringBuilder.append("]=");
                String[] stringArray = this.dbDataBook.getRowDefinition().getColumnNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuilder.append("[");
                    stringBuilder.append(this.alStorage.get(this.getInternalRowIndex(i))[j]);
                    stringBuilder.append("]");
                }
                stringBuilder.append(", ");
            }
        }
        catch (ModelException modelException) {
            return stringBuilder.toString() + " :: " + modelException.getMessage();
        }
        stringBuilder.append(", CHANGES: ");
        for (n = 0; n < this.iaChangedRows.length; ++n) {
            stringBuilder.append("[");
            stringBuilder.append(this.iaChangedRows[n]);
            stringBuilder.append("]");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    protected void setAllFetched(boolean bl) {
        this.bAllFetched = bl;
    }

    protected void addFetchedRow(Object[] objectArray) throws ModelException {
        this.alStorage.add(objectArray);
    }

    protected void insert(int n, Object[] objectArray) throws ModelException {
        this.initFilterSort();
        this.alStorage.add(n, objectArray);
        if (this.iaUsedRows != null) {
            this.shiftIndicies(this.iaUsedRows, n, 1);
            this.iaUsedRows = ArrayUtil.add(this.iaUsedRows, n, n);
        }
        this.shiftIndicies(this.iaChangedRows, n, 1);
        this.addChange(n);
    }

    protected void delete(int n) {
        int n2 = this.getInternalRowIndex(n);
        this.alStorage.remove(n2);
        if (this.iaUsedRows != null) {
            this.iaUsedRows = ArrayUtil.remove(this.iaUsedRows, n);
            this.shiftIndicies(this.iaUsedRows, n2, -1);
        }
        this.removeChange(n);
        this.shiftIndicies(this.iaChangedRows, n, -1);
    }

    protected void addChange(int n) {
        if (ArrayUtil.indexOf(this.iaChangedRows, n) < 0) {
            this.iaChangedRows = ArrayUtil.add(this.iaChangedRows, n);
        }
    }

    protected void removeChange(int n) {
        if (ArrayUtil.indexOf(this.iaChangedRows, n) >= 0) {
            this.iaChangedRows = ArrayUtil.remove(this.iaChangedRows, ArrayUtil.indexOf(this.iaChangedRows, n));
        }
    }

    protected Object[] getDataRowInternal(int n) throws ModelException {
        this.initFilterSort();
        return this.alStorage.get(this.getInternalRowIndex(n));
    }

    protected void setDataRowInternal(int n, Object[] objectArray) throws ModelException {
        this.initFilterSort();
        int n2 = this.getInternalRowIndex(n);
        if (n2 < this.alStorage.size()) {
            this.alStorage.set(n2, objectArray);
        }
    }

    protected void shiftIndicies(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 < n) continue;
            nArray[i] = n3 += n2;
        }
    }

    protected void setMasterDataRow(IDataRow iDataRow) throws ModelException {
        int n;
        this.drMasterDataRow = iDataRow;
        String[] stringArray = this.dbDataBook.getMasterReference().getColumnNames();
        int[] nArray = new int[stringArray.length];
        IRowDefinition iRowDefinition = this.dbDataBook.getRowDefinition();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = iRowDefinition.getColumnDefinitionIndex(stringArray[n]);
        }
        this.initFilterSort();
        for (n = 0; n < this.alStorage.size(); ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                IDataType iDataType = iRowDefinition.getColumnDefinition(nArray[i]).getDataType();
                this.alStorage.get((int)this.getInternalRowIndex((int)n))[nArray[i]] = iDataType.convertAndCheckToTypeClass(this.drMasterDataRow.getValue(i));
            }
        }
    }

    public int getEstimatedRowCount() throws ModelException {
        return this.getRowCount();
    }

    public void fetchToRow(int n) throws ModelException {
    }

    protected int getRowCountInternal() {
        if (this.iaUsedRows != null) {
            return this.iaUsedRows.length;
        }
        return this.alStorage.size();
    }

    private IChangeableDataRow getDataRowWithoutSort(int n) throws ModelException {
        return new ChangeableDataRow(this.dbDataBook.getRowDefinition(), this.alStorage.get(n), this, n);
    }

    private int getInternalRowIndex(int n) {
        if (this.iaUsedRows == null) {
            return n;
        }
        return this.iaUsedRows[n];
    }

    private void initFilterSort() throws ModelException {
        if (this.iaUsedRows == null && this.dbDataBook != null) {
            if (this.dbDataBook.isMemFilter()) {
                this.iaUsedRows = this.filter();
            }
            if (this.dbDataBook.isMemSort()) {
                this.iaUsedRows = this.sort();
            }
        }
    }

    protected void clear() {
        this.iaUsedRows = null;
    }

    private int[] filter() throws ModelException {
        ICondition iCondition = this.dbDataBook.getFilter();
        if (iCondition != null) {
            this.fetchAll();
            int[] nArray = new int[this.getRowCountInternal()];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (!iCondition.isFulfilled(this.getDataRowWithoutSort(i))) continue;
                nArray[n] = i;
                ++n;
            }
            return ArrayUtil.truncate(nArray, n);
        }
        return null;
    }

    private int[] sort() throws ModelException {
        SortDefinition sortDefinition = this.dbDataBook.getSort();
        if (sortDefinition != null) {
            this.fetchAll();
            int[] nArray = new int[this.getRowCountInternal()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.getInternalRowIndex(i);
            }
            this.quickSort(sortDefinition, nArray, 0, nArray.length - 1);
            this.insertionSort(sortDefinition, nArray, 0, nArray.length - 1);
            return nArray;
        }
        return this.iaUsedRows;
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private int compareTo(SortDefinition sortDefinition, int n, int n2) throws ModelException {
        return this.getDataRowWithoutSort(n).compareTo(this.getDataRowWithoutSort(n2), sortDefinition);
    }

    private void quickSort(SortDefinition sortDefinition, int[] nArray, int n, int n2) throws ModelException {
        if (n2 - n > 4) {
            int n3 = (n2 + n) / 2;
            if (this.compareTo(sortDefinition, nArray[n], nArray[n3]) > 0) {
                this.swap(nArray, n, n3);
            }
            if (this.compareTo(sortDefinition, nArray[n], nArray[n2]) > 0) {
                this.swap(nArray, n, n2);
            }
            if (this.compareTo(sortDefinition, nArray[n3], nArray[n2]) > 0) {
                this.swap(nArray, n3, n2);
            }
            int n4 = n2 - 1;
            this.swap(nArray, n3, n4);
            n3 = n;
            int n5 = nArray[n4];
            while (true) {
                if (this.compareTo(sortDefinition, nArray[++n3], n5) < 0) {
                    continue;
                }
                while (this.compareTo(sortDefinition, nArray[--n4], n5) > 0) {
                }
                if (n4 < n3) break;
                this.swap(nArray, n3, n4);
            }
            this.swap(nArray, n3, n2 - 1);
            this.quickSort(sortDefinition, nArray, n, n4);
            this.quickSort(sortDefinition, nArray, n3 + 1, n2);
        }
    }

    private void insertionSort(SortDefinition sortDefinition, int[] nArray, int n, int n2) throws ModelException {
        for (int i = n + 1; i <= n2; ++i) {
            int n3 = nArray[i];
            for (int j = i; j > n && this.compareTo(sortDefinition, nArray[j - 1], n3) > 0; --j) {
                nArray[j] = nArray[j - 1];
            }
            nArray[j] = n3;
        }
    }
}

