/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.mem.ChangeableDataRow;
import com.sibvisions.rad.model.mem.MemDataPage;
import com.sibvisions.util.ArrayUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.celleditor.UIChoiceCellEditor;
import javax.rad.genui.celleditor.UILinkedCellEditor;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IDataSource;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.SortDefinition;
import javax.rad.model.TreePath;
import javax.rad.model.condition.ICondition;
import javax.rad.model.event.DataBookEvent;
import javax.rad.model.event.DataBookHandler;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.IControl;
import javax.rad.ui.celleditor.IChoiceCellEditor;

public class MemDataBook
extends ChangeableDataRow
implements IDataBook {
    private static final Integer ONE = 1;
    private static int iUID = 0;
    private TreePath treePath = new TreePath(new int[0]);
    private IDataBook.SelectionMode iSelectionMode = IDataBook.SelectionMode.CURRENT_ROW;
    private ICondition cFilter;
    private SortDefinition sSort;
    private ReferenceDefinition rdMasterReference;
    private ReferenceDefinition rdTreeRootReference;
    private String[] saTreeRootMasterColumnNames;
    private IDataBook.WriteBackIsolationLevel iWritebackIsolationLevel;
    private ArrayUtil<WeakReference<IDataBook>> auDetailDataBooks;
    private IDataSource dsDataSource;
    private IDataRow auStoredSelection;
    private MemDataPage dpCurrentDataPage;
    private MemDataPage dpEmptyDataPage;
    private Hashtable<Object, MemDataPage> htDataPagesCache = new Hashtable();
    private DataBookHandler eventBeforeRowSelected;
    private DataBookHandler eventAfterRowSelected;
    private DataBookHandler eventBeforeInserting;
    private DataBookHandler eventAfterInserting;
    private DataBookHandler eventBeforeInserted;
    private DataBookHandler eventAfterInserted;
    private DataBookHandler eventBeforeUpdating;
    private DataBookHandler eventAfterUpdating;
    private DataBookHandler eventBeforeUpdated;
    private DataBookHandler eventAfterUpdated;
    private DataBookHandler eventBeforeDeleting;
    private DataBookHandler eventAfterDeleting;
    private DataBookHandler eventBeforeDeleted;
    private DataBookHandler eventAfterDeleted;
    private DataBookHandler eventBeforeRestore;
    private DataBookHandler eventAfterRestore;
    private DataBookHandler eventBeforeReload;
    private DataBookHandler eventAfterReload;
    private DataBookHandler eventBeforeColumnSelected;
    private DataBookHandler eventAfterColumnSelected;
    private String sName;
    private String sSelectedColumn = null;
    private int iReadAheadRowCount = 10;
    private int iSelectedRowIndex = -1;
    private boolean bMasterChanged = false;
    private boolean bInsertEnabled = true;
    private boolean bUpdateEnabled = true;
    private boolean bDeleteEnabled = true;
    private boolean bLockAndRefetchEnabled = false;
    private boolean bReadOnly = false;
    private boolean bDeleteCascade = true;
    private boolean bMemSort = true;
    private boolean bMemFilter = true;
    private boolean bWritebackEnabled = true;
    private boolean bIsOpen = false;

    public MemDataBook() {
    }

    public MemDataBook(RowDefinition rowDefinition) {
        super(rowDefinition);
    }

    public IDataBook getDataBook() {
        return this;
    }

    public String getName() {
        return this.sName;
    }

    public void setName(String string) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks! - " + this.getName());
        }
        this.sName = string;
    }

    public void setWritebackIsolationLevel(IDataBook.WriteBackIsolationLevel writeBackIsolationLevel) {
        this.iWritebackIsolationLevel = writeBackIsolationLevel;
    }

    public IDataBook.WriteBackIsolationLevel getWritebackIsolationLevel() {
        if (this.iWritebackIsolationLevel == null) {
            if (this.getDataSource() != null) {
                return this.getDataSource().getWritebackIsolationLevel();
            }
            return IDataBook.WriteBackIsolationLevel.DATA_ROW;
        }
        return this.iWritebackIsolationLevel;
    }

    public void setRowDefinition(IRowDefinition iRowDefinition) throws ModelException {
        int n;
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        IControl[] iControlArray = null;
        if (this.rdRowDefinition != null) {
            iControlArray = this.getControls();
            for (n = 0; n < iControlArray.length; ++n) {
                this.rdRowDefinition.removeControl(iControlArray[n]);
            }
        }
        this.rdRowDefinition = iRowDefinition;
        if (this.rdRowDefinition == null) {
            this.rdRowDefinition = new RowDefinition();
        }
        if (this.rdRowDefinition != null) {
            if (iControlArray == null) {
                iControlArray = this.getControls();
            }
            for (n = 0; n < iControlArray.length; ++n) {
                this.rdRowDefinition.addControl(iControlArray[n]);
            }
        }
    }

    public IDataSource getDataSource() {
        return this.dsDataSource;
    }

    public void setDataSource(IDataSource iDataSource) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.dsDataSource = iDataSource;
    }

    public ReferenceDefinition getMasterReference() {
        return this.rdMasterReference;
    }

    public void setMasterReference(ReferenceDefinition referenceDefinition) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.rdMasterReference = referenceDefinition;
    }

    public boolean isSelfJoined() {
        return this.rdMasterReference != null && this.rdMasterReference.getReferencedDataBook() == this;
    }

    public IDataPage getDataPage(TreePath treePath) throws ModelException {
        if (this.rdTreeRootReference == null) {
            return this.getDataPage(null, treePath);
        }
        return this.getDataPage(this.rdTreeRootReference.getReferencedDataBook(), treePath);
    }

    private IDataRow getMasterDataRowFromRootDataRow(IDataRow iDataRow) throws ModelException {
        IDataRow iDataRow2 = this.rdMasterReference.getReferencedDataBook().createEmptyRow(this.rdMasterReference.getReferencedColumnNames());
        if (this.rdTreeRootReference != null && iDataRow != null) {
            iDataRow2.setValues(this.saTreeRootMasterColumnNames, iDataRow.getValues(this.rdTreeRootReference.getReferencedColumnNames()));
        }
        return iDataRow2;
    }

    public IDataPage getDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataPage iDataPage = this.getDataPageWithRootRow(iDataRow);
        if (treePath != null) {
            for (int i = 0; i < treePath.length(); ++i) {
                IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(treePath.get(i));
                if (iChangeableDataRow == null) {
                    return null;
                }
                iDataPage = this.getDataPageIntern(iChangeableDataRow);
            }
        }
        return iDataPage;
    }

    public synchronized IDataPage getDataPageWithRootRow(IDataRow iDataRow) throws ModelException {
        if (this.getMasterReference() == null) {
            this.sync();
            return this.dpCurrentDataPage;
        }
        return this.getDataPageIntern(this.getMasterDataRowFromRootDataRow(iDataRow));
    }

    public ReferenceDefinition getRootReference() {
        return this.rdTreeRootReference;
    }

    public void setRootReference(ReferenceDefinition referenceDefinition) throws ModelException {
        if (this.isOpen()) {
            throw new ModelException("It's not allowed on open DataBooks!");
        }
        this.rdTreeRootReference = referenceDefinition;
    }

    public TreePath getTreePath() {
        try {
            this.sync();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return this.treePath;
    }

    public void setTreePath(TreePath treePath) throws ModelException {
        if (!this.treePath.equals(treePath) || this.bMasterChanged) {
            this.sync();
            this.invokeSaveEditingControls();
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            this.saveDataRowLevel(null);
            if (this.eventBeforeRowSelected != null) {
                this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iChangeableDataRow));
            }
            this.treePath = treePath == null ? new TreePath(new int[0]) : treePath;
            this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
            if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                this.setSelectedRowInternal(-1);
            } else {
                this.setSelectedRowInternal(0);
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
    }

    public void notifyMasterChanged() {
        try {
            if (this.rdMasterReference != null && this.rdMasterReference.getReferencedDataBook().getUID() != null && !this.rdMasterReference.getReferencedDataBook().isInserting() && this.dpCurrentDataPage != null && this.rdMasterReference.getReferencedDataBook().getUID() != null) {
                this.htDataPagesCache.remove(this.rdMasterReference.getReferencedDataBook().getUID());
                if (this.dpCurrentDataPage.getChangedDataRows().length == 0) {
                    this.handleStoreSelection(this.iSelectionMode);
                    this.dpCurrentDataPage = null;
                } else {
                    IDataRow iDataRow = this.getMasterDataRow(this.rdMasterReference.getReferencedDataBook());
                    this.dpCurrentDataPage.setMasterDataRow(iDataRow);
                    this.htDataPagesCache.put(iDataRow, this.dpCurrentDataPage);
                }
            }
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
        if (!this.bMasterChanged) {
            try {
                this.bMasterChanged = true;
                if (this.eventAfterReload != null) {
                    this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
                }
            }
            catch (ModelException modelException) {
                throw new RuntimeException(modelException);
            }
            this.invokeMasterChangedDetailsListeners();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataRow iDataRow2 = null;
        IDataPage iDataPage = null;
        if (this.isSelfJoined()) {
            if (treePath == null) {
                treePath = new TreePath(new int[0]);
            }
            IDataBook iDataBook = null;
            if (this.rdTreeRootReference != null) {
                iDataBook = this.rdTreeRootReference.getReferencedDataBook();
            }
            if (!this.hasDataPage(iDataBook, treePath)) return;
            iDataPage = this.getDataPage(treePath);
            iDataRow2 = iDataPage.getMasterDataRow();
            int n = 0;
            while (n < iDataPage.getRowCount()) {
                this.removeDataPage(null, treePath.getChildPath(n++));
            }
        } else {
            if (!this.hasDataPage(iDataRow)) return;
            iDataPage = this.getDataPage(iDataRow);
            iDataRow2 = iDataPage.getMasterDataRow();
        }
        for (int i = 0; i < iDataPage.getRowCount(); ++i) {
            IChangeableDataRow iChangeableDataRow = iDataPage.getDataRow(i);
            if (this.auDetailDataBooks == null) continue;
            int n = this.auDetailDataBooks.size();
            for (int j = 0; j < n; ++j) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(j).get();
                if (iDataBook == null) continue;
                iDataBook.removeDataPage(iChangeableDataRow, treePath);
            }
        }
        if (iDataRow2 instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow2).getUID() != null) {
            this.htDataPagesCache.remove(((IChangeableDataRow)iDataRow2).getUID());
        } else {
            this.htDataPagesCache.remove(iDataRow2);
        }
        if (iDataPage != this.dpCurrentDataPage) return;
        this.dpCurrentDataPage = null;
        this.bMasterChanged = true;
    }

    public IDataBook.SelectionMode getSelectionMode() {
        return this.iSelectionMode;
    }

    public void setSelectionMode(IDataBook.SelectionMode selectionMode) {
        this.iSelectionMode = selectionMode;
    }

    public boolean isInsertEnabled() {
        return this.bInsertEnabled && !this.isReadonly() && this.dpCurrentDataPage != this.dpEmptyDataPage;
    }

    public void setInsertEnabled(boolean bl) {
        this.bInsertEnabled = bl;
        this.invokeRepaintListeners();
    }

    public boolean isUpdateEnabled() throws ModelException {
        return this.bUpdateEnabled && !this.isReadonly() && this.getSelectedRow() >= 0 && !this.isDeleting();
    }

    public void setUpdateEnabled(boolean bl) {
        this.bUpdateEnabled = bl;
        this.invokeRepaintListeners();
    }

    public boolean isLockAndRefetchEnabled() {
        return this.bLockAndRefetchEnabled;
    }

    public void setLockAndRefetchEnabled(boolean bl) {
        this.bLockAndRefetchEnabled = bl;
    }

    public boolean isDeleteEnabled() throws ModelException {
        return this.bDeleteEnabled && !this.isReadonly() && this.getSelectedRow() >= 0;
    }

    public void setDeleteEnabled(boolean bl) {
        this.bDeleteEnabled = bl;
        this.invokeRepaintListeners();
    }

    public boolean isReadonly() {
        return this.bReadOnly;
    }

    public void setReadOnly(boolean bl) throws ModelException {
        if (this.isOpen() && !this.bReadOnly && bl) {
            this.saveAllRows();
        }
        this.setReadOnlyWithoutSave(bl);
    }

    public int getReadAhead() {
        return this.iReadAheadRowCount;
    }

    public void setReadAhead(int n) {
        if (n >= 0) {
            this.iReadAheadRowCount = n;
        }
    }

    public boolean isOpen() {
        return this.bIsOpen;
    }

    public synchronized void open() throws ModelException {
        if (!this.isOpen()) {
            Object[] objectArray;
            Object object;
            int n;
            if (this.getName() == null) {
                throw new ModelException("DataBook Name is null!");
            }
            if (this.rdRowDefinition.getColumnCount() == 0) {
                throw new ModelException("RowDefintion in DataBook contains no columns!");
            }
            if (UIFactoryManager.getFactory() != null) {
                int n2 = this.rdRowDefinition.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    object = this.rdRowDefinition.getColumnDefinition(n);
                    objectArray = ((ColumnDefinition)object).getAllowedValues();
                    if (((ColumnDefinition)object).getDataType().getCellEditor() != null || objectArray == null || objectArray.length <= 0) continue;
                    IChoiceCellEditor iChoiceCellEditor = UIChoiceCellEditor.getDefaultChoiceCellEditor(objectArray);
                    if (iChoiceCellEditor != null) {
                        ((ColumnDefinition)object).getDataType().setCellEditor(iChoiceCellEditor);
                        continue;
                    }
                    ColumnDefinition columnDefinition = ((ColumnDefinition)object).clone();
                    columnDefinition.setAllowedValues(null);
                    String string = columnDefinition.getName();
                    MemDataBook memDataBook = new MemDataBook();
                    memDataBook.setName("enum_" + string);
                    memDataBook.getRowDefinition().addColumnDefinition(columnDefinition);
                    memDataBook.open();
                    for (int i = 0; i < objectArray.length; ++i) {
                        memDataBook.insert(false);
                        memDataBook.setValue(string, objectArray[i]);
                    }
                    memDataBook.saveAllRows();
                    ((ColumnDefinition)object).getDataType().setCellEditor(new UILinkedCellEditor(new ReferenceDefinition(new String[]{string}, memDataBook, new String[]{string})));
                }
            }
            object = this.rdRowDefinition.getPrimaryKeyColumnNames();
            for (n = 0; object != null && n < ((String[])object).length; ++n) {
                if (this.rdRowDefinition.getColumnDefinitionIndex((String)object[n]) >= 0) continue;
                throw new ModelException("Primary key column '" + (String)object[n] + "' doesn't exist in RowDefinition of this DataBook!");
            }
            ReferenceDefinition referenceDefinition = this.getMasterReference();
            if (referenceDefinition != null) {
                IDataBook iDataBook = referenceDefinition.getReferencedDataBook();
                if (!this.isSelfJoined() && !iDataBook.isOpen()) {
                    throw new ModelException("The master DataBook has to be opened first! - " + iDataBook.getName());
                }
                objectArray = referenceDefinition.getColumnNames();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.rdRowDefinition.getColumnDefinitionIndex((String)objectArray[i]) >= 0) continue;
                    throw new ModelException("Column '" + (String)objectArray[i] + "' doesn't exist in detail DataBook '" + this.getName() + "' !");
                }
                String[] stringArray = referenceDefinition.getReferencedColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (iDataBook.getRowDefinition().getColumnDefinitionIndex(stringArray[i]) >= 0) continue;
                    throw new ModelException("Column '" + stringArray[i] + "' doesn't exist in master DataBook '" + iDataBook.getName() + "' !");
                }
                if (this.isSelfJoined()) {
                    if (this.getRootReference() != null) {
                        String[] stringArray2 = this.getRootReference().getColumnNames();
                        this.saTreeRootMasterColumnNames = new String[stringArray2.length];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            int n3 = ArrayUtil.indexOf(this.getMasterReference().getColumnNames(), stringArray2[i]);
                            if (n3 < 0) {
                                throw new ModelException("Column name " + stringArray2[i] + " of root reference is not in master reference!");
                            }
                            this.saTreeRootMasterColumnNames[i] = this.getMasterReference().getReferencedColumnNames()[n3];
                        }
                        this.getRootReference().getReferencedDataBook().addDetailDataBook(this);
                    } else {
                        this.saTreeRootMasterColumnNames = null;
                    }
                } else {
                    referenceDefinition.getReferencedDataBook().addDetailDataBook(this);
                    referenceDefinition.setConnected();
                }
            }
            if (this.getDataSource() != null) {
                if (!this.getDataSource().isOpen()) {
                    throw new ModelException("DataSource is not open!");
                }
                this.getDataSource().addDataBook(this);
            }
            this.rdRowDefinition.addDataBook(this);
            this.iSelectedRowIndex = -1;
            this.bMasterChanged = true;
            this.bIsOpen = true;
        }
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.bIsOpen = false;
            this.dpCurrentDataPage = null;
            this.htDataPagesCache.clear();
            this.iSelectedRowIndex = -1;
            this.oaStorage = null;
            if (this.getMasterReference() != null) {
                this.getMasterReference().getReferencedDataBook().removeDetailDataBook(this);
            }
            if (this.dsDataSource != null) {
                this.dsDataSource.removeDataBook(this);
            }
            if (this.rdRowDefinition != null) {
                this.rdRowDefinition.removeDataBook(this);
            }
        }
    }

    public synchronized int getRowCount() throws ModelException {
        if (this.isOpen()) {
            this.sync();
            return this.dpCurrentDataPage.getRowCount();
        }
        return 0;
    }

    public synchronized int getSelectedRow() throws ModelException {
        if (!this.isOpen()) {
            return -1;
        }
        this.sync();
        return this.iSelectedRowIndex;
    }

    public synchronized void setSelectedRow(int n) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex != n) {
            this.invokeSaveEditingControls();
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            this.saveDataRowLevelDetails(null);
            if (this.eventBeforeRowSelected != null) {
                this.eventBeforeRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_ROW_SELECTED, iChangeableDataRow));
            }
            this.setSelectedRowInternal(n);
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
    }

    public synchronized String getSelectedColumn() throws ModelException {
        return this.sSelectedColumn;
    }

    public synchronized void setSelectedColumn(String string) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (string != null) {
            this.rdRowDefinition.getColumnDefinition(string);
        }
        if (this.sSelectedColumn == null && string != null || this.sSelectedColumn != null && !this.sSelectedColumn.equals(string)) {
            if (this.eventBeforeColumnSelected != null) {
                this.eventBeforeColumnSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_COLUMN_SELECTED, null));
            }
            this.sSelectedColumn = string;
            this.invokeRepaintListeners();
            if (this.eventAfterColumnSelected != null) {
                this.eventAfterColumnSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_COLUMN_SELECTED, null));
            }
        }
    }

    public boolean isDeleteCascade() {
        return this.bDeleteCascade;
    }

    public void setDeleteCascade(boolean bl) {
        this.bDeleteCascade = bl;
    }

    public synchronized int insert(boolean bl) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.dpCurrentDataPage == this.dpEmptyDataPage) {
            throw new ModelException("Master DataBook has no selected row! - " + this.getMasterReference().getReferencedDataBook().getName());
        }
        if (!this.isInsertEnabled()) {
            throw new ModelException("Insert isn't allowed!");
        }
        this.invokeSaveEditingControls();
        this.saveDataRowLevel(null);
        this.sync();
        if (!this.dpCurrentDataPage.isAllFetched() && this.dpCurrentDataPage.getRowCount() == 0) {
            this.getDataRow(0);
        }
        IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
        if (this.eventBeforeInserting != null) {
            this.eventBeforeInserting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_INSERTING, null));
        }
        int n = this.insertInternal(bl);
        this.setSelectedRowInternal(n);
        this.copyMasterColumnsToCurrentDetail();
        if (this.eventAfterInserting != null) {
            this.eventAfterInserting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_INSERTING, null));
        }
        if (this.eventAfterRowSelected != null) {
            this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
        }
        return n;
    }

    public synchronized void update() throws ModelException {
        if (!(this.isUpdating() || this.isInserting() || this.isDeleting())) {
            if (!this.isOpen()) {
                throw new ModelException("DataBook isn't open! - " + this.sName);
            }
            this.sync();
            if (!this.isUpdateEnabled()) {
                throw new ModelException("Update isn't allowed!");
            }
            this.saveDataRowLevel(this);
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            if (this.eventBeforeUpdating != null) {
                this.eventBeforeUpdating.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_UPDATING, iChangeableDataRow));
            }
            if (this.isLockAndRefetchEnabled()) {
                this.executeLockAndRefetch();
            }
            this.setUpdating();
            this.setDetailsChangedInMasterBook();
            if (this.eventAfterUpdating != null) {
                this.eventAfterUpdating.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_UPDATING, iChangeableDataRow));
            }
        }
    }

    public synchronized void delete() throws ModelException {
        boolean bl;
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            return;
        }
        if (!this.isDeleteEnabled()) {
            throw new ModelException("Delete isn't allowed!");
        }
        IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
        if (this.eventBeforeDeleting != null) {
            this.eventBeforeDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_DELETING, iChangeableDataRow));
        }
        if (this.isInserting() && this.eventBeforeRestore != null) {
            this.eventBeforeRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RESTORE, iChangeableDataRow));
        }
        this.restoreSaveAllDetails();
        if (!this.isInserting()) {
            this.restoreSelectedRow();
        } else {
            this.invokeCancelEditingControls();
        }
        if (!this.isInserting() && this.isLockAndRefetchEnabled()) {
            this.executeLockAndRefetch();
        }
        if (bl = this.deleteInternal()) {
            this.correctSelectedRowAfterDelete();
            if (this.eventAfterRestore != null) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iChangeableDataRow));
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        }
        if (this.eventAfterDeleting != null) {
            this.eventAfterDeleting.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETING, iChangeableDataRow));
        }
        if (!bl && IDataBook.WriteBackIsolationLevel.DATA_ROW.equals((Object)this.getWritebackIsolationLevel())) {
            try {
                this.saveDataRowLevel(null);
            }
            catch (ModelException modelException) {
                if (this.isInserting() || this.isUpdating() || this.isDeleting()) {
                    this.restore();
                }
                throw modelException;
            }
        }
    }

    public synchronized void deleteAllDataRows() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        this.fetchAll();
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.setSelectedRow(i);
            this.delete();
        }
    }

    public void notifyDetailChanged() {
        try {
            boolean bl = false;
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                int[] nArray;
                if (this.auDetailDataBooks.get(i).get() == null || (nArray = ((IDataBook)this.auDetailDataBooks.get(i).get()).getChangedDataRows()) == null || nArray.length <= 0) continue;
                bl = true;
                break;
            }
            this.extentStorage();
            if (bl) {
                this.oaStorage[this.rdRowDefinition.getColumnCount() + 2] = ONE;
                this.dpCurrentDataPage.addChange(this.iSelectedRowIndex);
            } else {
                this.oaStorage[this.rdRowDefinition.getColumnCount() + 2] = null;
                this.dpCurrentDataPage.removeChange(this.iSelectedRowIndex);
            }
            this.dpCurrentDataPage.setDataRowInternal(this.iSelectedRowIndex, this.oaStorage);
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
        this.setDetailsChangedInMasterBook();
    }

    public synchronized IChangeableDataRow getDataRow(int n) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        if (n < 0) {
            return null;
        }
        this.sync();
        return this.getDataRowInternal(n);
    }

    public synchronized boolean isDeleting() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.getSelectedRow() < 0) {
            return false;
        }
        return super.isDeleting();
    }

    public synchronized boolean isUpdating() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.getSelectedRow() < 0) {
            return false;
        }
        return super.isUpdating();
    }

    public synchronized boolean isInserting() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.getSelectedRow() < 0) {
            return false;
        }
        return super.isInserting();
    }

    public synchronized boolean isDetailChanged() throws ModelException {
        if (!this.isOpen()) {
            return false;
        }
        this.sync();
        return super.isDetailChanged();
    }

    public ICondition getFilter() {
        return this.cFilter;
    }

    public synchronized void setFilter(ICondition iCondition) throws ModelException {
        if (this.isOpen()) {
            this.saveAllRows();
        }
        this.cFilter = iCondition != null ? iCondition.clone() : null;
        if (this.isOpen()) {
            if (this.isMemFilter()) {
                this.clearFilterSortInMemDataPages();
                this.invokeRepaintListeners();
            } else if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                this.reload();
            } else {
                this.reload(IDataBook.SelectionMode.FIRST_ROW);
            }
        }
    }

    public SortDefinition getSort() {
        return this.sSort;
    }

    public synchronized void setSort(SortDefinition sortDefinition) throws ModelException {
        if (this.isOpen()) {
            this.saveAllRows();
        }
        this.sSort = sortDefinition != null ? sortDefinition.clone() : null;
        if (this.isOpen()) {
            if (this.isMemSort()) {
                this.handleStoreSelection(this.iSelectionMode);
                this.clearFilterSortInMemDataPages();
                this.invokeRepaintListeners();
            } else {
                this.reload();
            }
        }
    }

    public synchronized void reload() throws ModelException {
        this.reload(this.getSelectionMode());
    }

    public synchronized void reload(IDataBook.SelectionMode selectionMode) throws ModelException {
        if (this.isOpen()) {
            this.handleStoreSelection(selectionMode);
            if (this.eventBeforeReload != null) {
                this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
            }
            if (!this.htDataPagesCache.isEmpty() || this.dpCurrentDataPage != null) {
                this.restoreAllRows();
            }
            this.executeRefresh();
            this.notifyMasterChanged();
            if (this.eventAfterReload != null) {
                this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
            }
        }
    }

    public synchronized void restoreSelectedRow() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.getSelectedRow() < 0) {
            return;
        }
        this.invokeCancelEditingControls();
        if (this.isInserting() || this.isUpdating() || this.isDeleting()) {
            this.restore();
        }
        this.invokeRepaintListeners();
    }

    public synchronized void restoreAllRows() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        if (this.dpCurrentDataPage == null) {
            return;
        }
        this.sync();
        this.invokeCancelEditingControls();
        if (this.getSelectedRow() >= 0 && (this.isInserting() || this.isUpdating() || this.isDeleting())) {
            this.restore();
        }
        int n = this.iSelectedRowIndex;
        int[] nArray = this.dpCurrentDataPage.getChangedDataRows();
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.setSelectedRowInternal(nArray[i]);
            this.restore();
        }
        if (this.iSelectedRowIndex != n) {
            this.setSelectedRow(n);
        }
        this.invokeRepaintListeners();
    }

    public synchronized void saveSelectedRow() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.getSelectedRow() < 0) {
            return;
        }
        this.invokeSaveEditingControls();
        if (this.isDeleting()) {
            IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
            if (this.eventBeforeDeleted != null) {
                this.eventBeforeDeleted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_DELETED, iChangeableDataRow));
            }
            if (this.isSelfJoined() && !this.isDeleteCascade() && this.isWritebackEnabled()) {
                if (this.treePath != null) {
                    this.removeDataPage(null, this.treePath.getChildPath(this.getSelectedRow()));
                } else {
                    this.removeDataPage(null, null);
                }
            }
            if (this.auDetailDataBooks != null) {
                int n = this.auDetailDataBooks.size();
                for (int i = 0; i < n; ++i) {
                    IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                    if (iDataBook == null) continue;
                    if (iDataBook.isDeleteCascade()) {
                        iDataBook.saveAllRows();
                        continue;
                    }
                    iDataBook.restoreAllRows();
                    if (!this.isWritebackEnabled()) continue;
                    iDataBook.removeDataPage(this, null);
                }
            }
            this.executeDelete();
            this.store();
            this.correctSelectedRowAfterDelete();
            if (this.eventAfterDeleted != null) {
                this.eventAfterDeleted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_DELETED, iChangeableDataRow));
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        } else if (this.isUpdating()) {
            IDataRow iDataRow = this.getOriginalRow();
            if (this.eventBeforeUpdated != null) {
                this.eventBeforeUpdated.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_UPDATED, iDataRow));
            }
            if (this.isWritableColumnChanged()) {
                this.executeUpdate();
            }
            this.store();
            if (this.eventAfterUpdated != null) {
                this.eventAfterUpdated.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_UPDATED, iDataRow));
            }
            this.invokeMasterChangedDetailsListeners();
        } else if (this.isInserting()) {
            if (this.eventBeforeInserted != null) {
                this.eventBeforeInserted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_INSERTED, null));
            }
            if (this.getMasterReference() != null) {
                ReferenceDefinition referenceDefinition;
                ReferenceDefinition referenceDefinition2 = referenceDefinition = this.isSelfJoined() ? this.getRootReference() : this.getMasterReference();
                if (referenceDefinition != null && referenceDefinition.getReferencedDataBook().isInserting()) {
                    referenceDefinition.getReferencedDataBook().saveSelectedRow();
                    this.syncDetails();
                } else {
                    this.copyMasterColumnsToCurrentDetail();
                }
            }
            this.executeInsert();
            this.store();
            if (this.eventAfterInserted != null) {
                this.eventAfterInserted.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_INSERTED, null));
            }
            this.invokeMasterChangedDetailsListeners();
            this.setUID(null);
        }
    }

    public synchronized void saveAllRows() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        if (this.htDataPagesCache.isEmpty() && this.dpCurrentDataPage == null) {
            return;
        }
        this.sync();
        this.invokeSaveEditingControls();
        int[] nArray = this.dpCurrentDataPage.getChangedDataRows();
        if (nArray.length > 0) {
            Arrays.sort(nArray);
            int n = this.getSelectedRow();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                if (this.iSelectedRowIndex != n2) {
                    this.setSelectedRowInternal(n2);
                }
                this.saveSelectedRow();
            }
            if (n >= this.getRowCount()) {
                n = this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED ? -1 : this.getRowCount() - 1;
            }
            if (this.iSelectedRowIndex != n) {
                this.setSelectedRowInternal(n);
            }
        }
    }

    public synchronized boolean isOutOfSync() {
        return this.dpCurrentDataPage == null || this.rdMasterReference != null && this.bMasterChanged;
    }

    public synchronized boolean isAllFetched() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        return this.dpCurrentDataPage.isAllFetched();
    }

    public synchronized void fetchAll() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.dpCurrentDataPage == this.dpEmptyDataPage) {
            return;
        }
        this.dpCurrentDataPage.fetchAll();
    }

    public synchronized IDataRow getMasterDataRow() throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        return this.dpCurrentDataPage.getMasterDataRow();
    }

    public void addDetailDataBook(IDataBook iDataBook) {
        if (this.auDetailDataBooks == null) {
            this.auDetailDataBooks = new ArrayUtil();
        } else {
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                if (this.auDetailDataBooks.get(i).get() != null) continue;
                this.auDetailDataBooks.remove(i);
            }
        }
        this.auDetailDataBooks.add(new WeakReference<IDataBook>(iDataBook));
    }

    public void removeDetailDataBook(IDataBook iDataBook) {
        if (this.auDetailDataBooks != null) {
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 != null && iDataBook2 != iDataBook) continue;
                this.auDetailDataBooks.remove(i);
            }
        }
    }

    public IDataBook[] getDetailDataBooks() {
        ArrayUtil<IDataBook> arrayUtil = new ArrayUtil<IDataBook>();
        if (this.auDetailDataBooks != null) {
            for (int i = this.auDetailDataBooks.size() - 1; i >= 0; --i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) {
                    this.auDetailDataBooks.remove(i);
                    continue;
                }
                arrayUtil.add(0, iDataBook);
            }
        }
        return arrayUtil.toArray(new IDataBook[arrayUtil.size()]);
    }

    public synchronized int[] getChangedDataRows() throws ModelException {
        IDataBook iDataBook;
        IDataRow iDataRow;
        if (!this.isOpen()) {
            return null;
        }
        if (this.dpCurrentDataPage == null) {
            return null;
        }
        if (this.getMasterReference() != null && !this.isSelfJoined() && this.htDataPagesCache.get(iDataRow = this.getMasterDataRow(iDataBook = this.getMasterReference().getReferencedDataBook())) == null) {
            if (iDataBook.getUID() != null) {
                if (this.htDataPagesCache.get(iDataBook.getUID()) == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        this.sync();
        return this.dpCurrentDataPage.getChangedDataRows();
    }

    public synchronized IDataPage getDataPage(IDataRow iDataRow) throws ModelException {
        if (this.getMasterReference() == null) {
            this.sync();
            return this.dpCurrentDataPage;
        }
        return this.getDataPageIntern(iDataRow);
    }

    public synchronized boolean hasDataPage(IDataRow iDataRow) throws ModelException {
        if (this.getMasterReference() == null) {
            return iDataRow == null;
        }
        IDataRow iDataRow2 = this.getMasterDataRow(iDataRow);
        MemDataPage memDataPage = this.htDataPagesCache.get(iDataRow2);
        if (memDataPage == null && iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
            memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow).getUID());
        }
        return memDataPage != null;
    }

    public synchronized boolean hasDataPage(IDataRow iDataRow, TreePath treePath) throws ModelException {
        IDataRow iDataRow2 = this.getMasterDataRowFromRootDataRow(iDataRow);
        MemDataPage memDataPage = this.htDataPagesCache.get(iDataRow2);
        if (memDataPage == null && iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
            memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow).getUID());
        }
        if (treePath == null) {
            return memDataPage != null;
        }
        for (int i = 0; i < treePath.length(); ++i) {
            int n = treePath.get(i);
            if (n < memDataPage.getRowCount()) {
                iDataRow2 = this.getMasterDataRow(memDataPage.getDataRow(n));
                if ((memDataPage = this.htDataPagesCache.get(iDataRow2)) == null && iDataRow2 instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow2).getUID() != null) {
                    memDataPage = this.htDataPagesCache.get(((IChangeableDataRow)iDataRow2).getUID());
                }
                if (memDataPage != null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public DataBookHandler eventBeforeRowSelected() {
        if (this.eventBeforeRowSelected == null) {
            this.eventBeforeRowSelected = new DataBookHandler();
        }
        return this.eventBeforeRowSelected;
    }

    public DataBookHandler eventAfterRowSelected() {
        if (this.eventAfterRowSelected == null) {
            this.eventAfterRowSelected = new DataBookHandler();
        }
        return this.eventAfterRowSelected;
    }

    public DataBookHandler eventBeforeInserting() {
        if (this.eventBeforeInserting == null) {
            this.eventBeforeInserting = new DataBookHandler();
        }
        return this.eventBeforeInserting;
    }

    public DataBookHandler eventAfterInserting() {
        if (this.eventAfterInserting == null) {
            this.eventAfterInserting = new DataBookHandler();
        }
        return this.eventAfterInserting;
    }

    public DataBookHandler eventBeforeInserted() {
        if (this.eventBeforeInserted == null) {
            this.eventBeforeInserted = new DataBookHandler();
        }
        return this.eventBeforeInserted;
    }

    public DataBookHandler eventAfterInserted() {
        if (this.eventAfterInserted == null) {
            this.eventAfterInserted = new DataBookHandler();
        }
        return this.eventAfterInserted;
    }

    public DataBookHandler eventBeforeUpdating() {
        if (this.eventBeforeUpdating == null) {
            this.eventBeforeUpdating = new DataBookHandler();
        }
        return this.eventBeforeUpdating;
    }

    public DataBookHandler eventAfterUpdating() {
        if (this.eventAfterUpdating == null) {
            this.eventAfterUpdating = new DataBookHandler();
        }
        return this.eventAfterUpdating;
    }

    public DataBookHandler eventBeforeUpdated() {
        if (this.eventBeforeUpdated == null) {
            this.eventBeforeUpdated = new DataBookHandler();
        }
        return this.eventBeforeUpdated;
    }

    public DataBookHandler eventAfterUpdated() {
        if (this.eventAfterUpdated == null) {
            this.eventAfterUpdated = new DataBookHandler();
        }
        return this.eventAfterUpdated;
    }

    public DataBookHandler eventBeforeDeleting() {
        if (this.eventBeforeDeleting == null) {
            this.eventBeforeDeleting = new DataBookHandler();
        }
        return this.eventBeforeDeleting;
    }

    public DataBookHandler eventAfterDeleting() {
        if (this.eventAfterDeleting == null) {
            this.eventAfterDeleting = new DataBookHandler();
        }
        return this.eventAfterDeleting;
    }

    public DataBookHandler eventBeforeDeleted() {
        if (this.eventBeforeDeleted == null) {
            this.eventBeforeDeleted = new DataBookHandler();
        }
        return this.eventBeforeDeleted;
    }

    public DataBookHandler eventAfterDeleted() {
        if (this.eventAfterDeleted == null) {
            this.eventAfterDeleted = new DataBookHandler();
        }
        return this.eventAfterDeleted;
    }

    public DataBookHandler eventBeforeRestore() {
        if (this.eventBeforeRestore == null) {
            this.eventBeforeRestore = new DataBookHandler();
        }
        return this.eventBeforeRestore;
    }

    public DataBookHandler eventAfterRestore() {
        if (this.eventAfterRestore == null) {
            this.eventAfterRestore = new DataBookHandler();
        }
        return this.eventAfterRestore;
    }

    public DataBookHandler eventBeforeReload() {
        if (this.eventBeforeReload == null) {
            this.eventBeforeReload = new DataBookHandler();
        }
        return this.eventBeforeReload;
    }

    public DataBookHandler eventAfterReload() {
        if (this.eventAfterReload == null) {
            this.eventAfterReload = new DataBookHandler();
        }
        return this.eventAfterReload;
    }

    public DataBookHandler eventBeforeColumnSelected() {
        if (this.eventBeforeColumnSelected == null) {
            this.eventBeforeColumnSelected = new DataBookHandler();
        }
        return this.eventBeforeColumnSelected;
    }

    public DataBookHandler eventAfterColumnSelected() {
        if (this.eventAfterColumnSelected == null) {
            this.eventAfterColumnSelected = new DataBookHandler();
        }
        return this.eventAfterColumnSelected;
    }

    public int searchNext(ICondition iCondition) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchNext(iCondition);
    }

    public int searchNext(ICondition iCondition, int n) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchNext(iCondition, n);
    }

    public int searchPrevious(ICondition iCondition) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchPrevious(iCondition);
    }

    public int searchPrevious(ICondition iCondition, int n) throws ModelException {
        this.sync();
        return this.dpCurrentDataPage.searchPrevious(iCondition, n);
    }

    public int getRowIndex() {
        try {
            this.sync();
            return this.iSelectedRowIndex;
        }
        catch (ModelException modelException) {
            return -1;
        }
    }

    public IDataPage getDataPage() {
        try {
            this.sync();
            return this.dpCurrentDataPage;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public synchronized Object getValue(String string) throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        return super.getValue(string);
    }

    public synchronized void setValue(String string, Object object) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            throw new ModelException("No selected row!");
        }
        if (this.isDeleting()) {
            throw new ModelException("Row is already deleted!");
        }
        this.update();
        this.setValueInternal();
        this.setWritableColumnChanged(string);
        super.setValue(string, object);
    }

    public synchronized Object[] getValues(String[] stringArray) throws ModelException {
        if (!this.isOpen()) {
            return null;
        }
        this.sync();
        return super.getValues(stringArray);
    }

    public synchronized void setValues(String[] stringArray, Object[] objectArray) throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        if (this.iSelectedRowIndex < 0) {
            throw new ModelException("No selected row!");
        }
        if (this.isDeleting()) {
            throw new ModelException("Row is already deleted!");
        }
        this.update();
        this.setValueInternal();
        if (stringArray == null) {
            stringArray = this.rdRowDefinition.getColumnNames();
        }
        boolean bl = this.isWritableColumnChanged();
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            bl = this.setWritableColumnChanged(stringArray[i]);
        }
        super.setValues(stringArray, objectArray);
    }

    public synchronized String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" ::");
        stringBuilder.append(this.sName);
        stringBuilder.append(":: \n  isOpen         = ");
        stringBuilder.append(this.bIsOpen);
        stringBuilder.append("\n");
        if (this.rdRowDefinition != null) {
            stringBuilder.append("  ");
            stringBuilder.append(this.rdRowDefinition);
        }
        if (this.rdMasterReference != null) {
            stringBuilder.append("  ");
            stringBuilder.append(this.rdMasterReference);
        }
        if (this.cFilter != null) {
            stringBuilder.append("  Filter         =");
            stringBuilder.append(this.cFilter);
        }
        if (this.auDetailDataBooks != null) {
            stringBuilder.append("  DetailBooks    =");
            for (int i = 0; i < this.auDetailDataBooks.size(); ++i) {
                object = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (object == null) continue;
                stringBuilder.append(" ");
                stringBuilder.append(object.getName());
            }
        }
        if (this.isOpen()) {
            try {
                this.sync();
            }
            catch (ModelException modelException) {
                return stringBuilder.toString() + " :: " + modelException.getMessage();
            }
            stringBuilder.append("\n  SelectedRow    = ");
            stringBuilder.append(this.iSelectedRowIndex);
            stringBuilder.append("\nCurrent DataPage:\n  ");
            stringBuilder.append(this.dpCurrentDataPage);
            Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
            object = this.htDataPagesCache.keys();
            if (enumeration.hasMoreElements()) {
                stringBuilder.append("DataPagesCache:\n");
                while (enumeration.hasMoreElements()) {
                    MemDataPage memDataPage = enumeration.nextElement();
                    Object e = object.nextElement();
                    if (memDataPage != this.dpCurrentDataPage) {
                        stringBuilder.append("  [");
                        stringBuilder.append(e);
                        stringBuilder.append("] = ");
                        stringBuilder.append(memDataPage);
                        continue;
                    }
                    stringBuilder.append("  [");
                    stringBuilder.append(e);
                    stringBuilder.append("] = Current DataPage\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    protected MemDataPage createDataPage(IDataRow iDataRow) {
        return new MemDataPage(this, iDataRow);
    }

    protected boolean isMemSort() {
        return this.bMemSort;
    }

    protected void setMemSort(boolean bl) {
        this.bMemSort = bl;
    }

    protected boolean isMemFilter() {
        return this.bMemFilter;
    }

    protected void setMemFilter(boolean bl) {
        this.bMemFilter = bl;
    }

    public boolean isWritebackEnabled() {
        return this.bWritebackEnabled;
    }

    public void setWritebackEnabled(boolean bl) {
        this.bWritebackEnabled = bl;
    }

    private IDataRow getStoredSelection() {
        return this.auStoredSelection;
    }

    private void setStoredSelection(IDataRow iDataRow) {
        this.auStoredSelection = iDataRow;
    }

    public synchronized int getEstimatedRowCount() throws ModelException {
        if (!this.isOpen()) {
            throw new ModelException("DataBook isn't open! - " + this.sName);
        }
        this.sync();
        return this.dpCurrentDataPage.getEstimatedRowCount();
    }

    protected void executeInsert() throws ModelException {
    }

    protected void executeUpdate() throws ModelException {
    }

    protected void executeDelete() throws ModelException {
    }

    protected void executeLockAndRefetch() throws ModelException {
    }

    private void invokeMasterChangedDetailsListeners() {
        this.invokeRepaintListeners();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.notifyMasterChanged();
            }
        }
    }

    private void syncDetails() throws ModelException {
        this.sync();
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.getSelectedRow();
            }
        }
    }

    private IDataRow getMasterDataRow(IDataRow iDataRow) throws ModelException {
        return iDataRow.createDataRow(this.getMasterReference().getReferencedColumnNames());
    }

    private MemDataPage getDataPageIntern(IDataRow iDataRow) throws ModelException {
        Object object;
        MemDataPage memDataPage = null;
        if (iDataRow instanceof ChangeableDataRow && (object = ((ChangeableDataRow)iDataRow).getUID()) != null && (memDataPage = this.htDataPagesCache.get(object)) != null) {
            return memDataPage;
        }
        object = this.getMasterDataRow(iDataRow);
        memDataPage = this.htDataPagesCache.get(object);
        if (memDataPage == null) {
            IChangeableDataRow iChangeableDataRow = null;
            if (iDataRow instanceof IChangeableDataRow && ((IChangeableDataRow)iDataRow).getUID() != null) {
                iChangeableDataRow = (IChangeableDataRow)iDataRow;
                memDataPage = this.htDataPagesCache.get(iChangeableDataRow.getUID());
            }
            if (memDataPage == null) {
                memDataPage = this.createDataPage((IDataRow)object);
                if (iChangeableDataRow != null && iChangeableDataRow.getUID() != null) {
                    ReferenceDefinition referenceDefinition = this.getMasterReference();
                    if (referenceDefinition != null && referenceDefinition.getReferencedDataBook().getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATASOURCE) {
                        memDataPage.setAllFetched(true);
                    }
                    this.htDataPagesCache.put(iChangeableDataRow.getUID(), memDataPage);
                } else {
                    this.htDataPagesCache.put(object, memDataPage);
                }
            }
        }
        return memDataPage;
    }

    private synchronized IChangeableDataRow getDataRowInternal(int n) throws ModelException {
        if (n < 0 || this.dpCurrentDataPage == this.dpEmptyDataPage) {
            return null;
        }
        return this.dpCurrentDataPage.getDataRow(n);
    }

    private void correctSelectedRow() throws ModelException {
        IDataRow iDataRow = this.getStoredSelection();
        if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
            this.setSelectedRowInternal(-1);
        } else if (this.getSelectionMode() == IDataBook.SelectionMode.CURRENT_ROW && iDataRow != null) {
            if (iDataRow == this) {
                this.setSelectedRowInternal(-1);
            } else {
                int n = 0;
                IChangeableDataRow iChangeableDataRow = this.getDataRow(n);
                String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
                if (stringArray == null) {
                    stringArray = this.rdRowDefinition.getColumnNames();
                }
                while (iChangeableDataRow != null && !iDataRow.equals(iChangeableDataRow, stringArray)) {
                    iChangeableDataRow = this.getDataRow(++n);
                }
                if (iChangeableDataRow != null) {
                    this.setSelectedRowInternal(n);
                } else {
                    this.setSelectedRowInternal(0);
                }
            }
        } else {
            this.setSelectedRowInternal(0);
        }
        if (this.eventAfterRowSelected != null) {
            this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, null));
        }
    }

    private void correctSelectedRowAfterDelete() throws ModelException {
        int n = this.iSelectedRowIndex;
        if (this.iSelectedRowIndex >= this.getRowCount()) {
            n = this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED ? -1 : this.getRowCount() - 1;
        }
        this.setSelectedRowInternal(n);
    }

    private void sync() throws ModelException {
        if (this.dpEmptyDataPage == null) {
            this.dpEmptyDataPage = new MemDataPage(null, null);
        }
        if (this.rdMasterReference == null) {
            if (this.dpCurrentDataPage == null) {
                this.dpCurrentDataPage = this.dpEmptyDataPage;
                this.iSelectedRowIndex = -1;
                this.dpCurrentDataPage = this.createDataPage(null);
                this.correctSelectedRow();
            }
        } else if (this.bMasterChanged) {
            ReferenceDefinition referenceDefinition;
            this.bMasterChanged = false;
            if (this.dpCurrentDataPage == null) {
                this.dpCurrentDataPage = this.dpEmptyDataPage;
                this.iSelectedRowIndex = -1;
                this.treePath = new TreePath(new int[0]);
            }
            ReferenceDefinition referenceDefinition2 = referenceDefinition = this.isSelfJoined() ? this.getRootReference() : this.getMasterReference();
            if (referenceDefinition != null && referenceDefinition.getReferencedDataBook().getSelectedRow() < 0) {
                this.dpCurrentDataPage = this.dpEmptyDataPage;
                this.iSelectedRowIndex = -1;
                this.treePath = new TreePath(new int[0]);
                this.setSelectedRowInternal(-1);
            } else if (this.isSelfJoined()) {
                IDataPage iDataPage;
                if (this.dpCurrentDataPage != this.dpEmptyDataPage && referenceDefinition != null && !this.getMasterDataRowFromRootDataRow(referenceDefinition.getReferencedDataBook()).equals(this.dpCurrentDataPage.getMasterDataRow(), this.saTreeRootMasterColumnNames)) {
                    this.treePath = new TreePath(new int[0]);
                }
                if ((iDataPage = this.getDataPage(this.treePath)) != this.dpCurrentDataPage) {
                    this.treePath = new TreePath(new int[0]);
                    this.dpCurrentDataPage = this.dpEmptyDataPage;
                    this.iSelectedRowIndex = -1;
                    this.dpCurrentDataPage = (MemDataPage)this.getDataPage(this.treePath);
                    if (this.getSelectionMode() == IDataBook.SelectionMode.DESELECTED) {
                        this.setSelectedRowInternal(-1);
                    } else {
                        this.setSelectedRowInternal(0);
                    }
                }
            } else {
                MemDataPage memDataPage = this.getDataPageIntern(this.getMasterReference().getReferencedDataBook());
                if (memDataPage != this.dpCurrentDataPage) {
                    this.dpCurrentDataPage = this.dpEmptyDataPage;
                    this.iSelectedRowIndex = -1;
                    this.treePath = new TreePath(new int[0]);
                    this.dpCurrentDataPage = memDataPage;
                    this.correctSelectedRow();
                }
            }
        }
    }

    protected void executeRefresh() throws ModelException {
        this.clearFilterSortInMemDataPages();
        this.invokeRepaintListeners();
    }

    protected void clear() {
        this.dpCurrentDataPage = null;
        this.htDataPagesCache.clear();
        this.iSelectedRowIndex = -1;
        this.oaStorage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedRowInternal(int n) throws ModelException {
        IChangeableDataRow iChangeableDataRow = null;
        try {
            iChangeableDataRow = this.getDataRow(n);
        }
        finally {
            if (iChangeableDataRow != null) {
                this.oaStorage = this.dpCurrentDataPage.getDataRowInternal(n);
                this.iSelectedRowIndex = n;
            } else {
                this.oaStorage = new Object[this.rdRowDefinition.getColumnCount()];
                this.iSelectedRowIndex = -1;
            }
        }
        this.invokeMasterChangedDetailsListeners();
    }

    private int insertInternal(boolean bl) throws ModelException {
        int n = this.getSelectedRow();
        if (!bl && this.getRowCount() > 0) {
            ++n;
        }
        if (n < 0) {
            n = 0;
        }
        this.oaStorage = this.createNewRow();
        this.setInserting();
        this.setUID(iUID++);
        this.dpCurrentDataPage.insert(n, this.oaStorage);
        this.setDetailsChangedInMasterBook();
        this.invokeMasterChangedDetailsListeners();
        return n;
    }

    private boolean deleteInternal() throws ModelException {
        int n;
        if (this.auDetailDataBooks != null) {
            int n2 = this.auDetailDataBooks.size();
            for (n = 0; n < n2; ++n) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(n).get();
                if (iDataBook == null) continue;
                if (iDataBook.isDeleteCascade()) {
                    iDataBook.deleteAllDataRows();
                    continue;
                }
                iDataBook.restoreAllRows();
            }
        }
        if (this.isInserting()) {
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
            n = 1;
        } else {
            this.setDeleting();
            this.dpCurrentDataPage.addChange(this.iSelectedRowIndex);
            this.dpCurrentDataPage.setDataRowInternal(this.iSelectedRowIndex, this.oaStorage);
            n = 0;
        }
        this.setDetailsChangedInMasterBook();
        this.invokeRepaintListeners();
        return n != 0;
    }

    protected void setValuesInternal(String[] stringArray, Object[] objectArray) throws ModelException {
        this.setValueInternal();
        if (stringArray.length != objectArray.length) {
            throw new ModelException("Number of columns and values are different!");
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl) {
                bl = this.setWritableColumnChanged(stringArray[i]);
            }
            super.setValueDRInternal(stringArray[i], objectArray[i]);
        }
    }

    protected void setValueInternal() throws ModelException {
        this.dpCurrentDataPage.setDataRowInternal(this.iSelectedRowIndex, this.oaStorage);
    }

    private void setDetailsChangedInMasterBook() {
        if (this.rdMasterReference != null && !this.isSelfJoined()) {
            IDataBook iDataBook = this.rdMasterReference.getReferencedDataBook();
            iDataBook.notifyDetailChanged();
        }
    }

    private void copyMasterColumnsToCurrentDetail() throws ModelException {
        if (this.rdMasterReference != null) {
            Object[] objectArray = this.dpCurrentDataPage.getMasterDataRow().getValues(this.rdMasterReference.getReferencedColumnNames());
            this.setValuesInternal(this.rdMasterReference.getColumnNames(), objectArray);
            if (this.isSelfJoined() && this.rdTreeRootReference != null) {
                objectArray = this.rdTreeRootReference.getReferencedDataBook().getValues(this.rdTreeRootReference.getReferencedColumnNames());
                this.setValuesInternal(this.rdTreeRootReference.getColumnNames(), objectArray);
            }
        }
    }

    private void saveDataRowLevel(IDataBook iDataBook) throws ModelException {
        ReferenceDefinition referenceDefinition;
        IDataBook iDataBook2 = this;
        ReferenceDefinition referenceDefinition2 = referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
        while (iDataBook2.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW && referenceDefinition != null) {
            iDataBook2 = referenceDefinition.getReferencedDataBook();
            referenceDefinition = iDataBook2.isSelfJoined() ? iDataBook2.getRootReference() : iDataBook2.getMasterReference();
        }
        ((MemDataBook)iDataBook2).saveDataRowLevelDetails(iDataBook);
    }

    private void saveDataRowLevelDetails(IDataBook iDataBook) throws ModelException {
        if (this.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
            this.saveDetails(iDataBook);
        } else if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 == null) continue;
                ((MemDataBook)iDataBook2).saveDataRowLevelDetails(iDataBook);
            }
        }
    }

    private void saveDetails(IDataBook iDataBook) throws ModelException {
        if (this != iDataBook) {
            this.saveAllRows();
        }
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook2 = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook2 == null) continue;
                ((MemDataBook)iDataBook2).saveDetails(iDataBook);
            }
        }
    }

    private void restoreSaveAllDetails() throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                if (iDataBook.isDeleteCascade()) {
                    iDataBook.restoreAllRows();
                    ((MemDataBook)iDataBook).restoreSaveAllDetails();
                    continue;
                }
                if (iDataBook.getWritebackIsolationLevel() == IDataBook.WriteBackIsolationLevel.DATA_ROW) {
                    iDataBook.saveAllRows();
                }
                ((MemDataBook)iDataBook).restoreSaveAllDetails();
            }
        }
    }

    private void handleStoreSelection(IDataBook.SelectionMode selectionMode) throws ModelException {
        if (this.dpCurrentDataPage != null) {
            if (selectionMode == IDataBook.SelectionMode.CURRENT_ROW) {
                if (this.getSelectedRow() < 0) {
                    if (this.dpCurrentDataPage.getRowCount() == 0) {
                        this.setStoredSelection(null);
                    } else {
                        this.setStoredSelection(this);
                    }
                } else {
                    String[] stringArray = this.rdRowDefinition.getPrimaryKeyColumnNames();
                    if (stringArray == null) {
                        stringArray = this.rdRowDefinition.getColumnNames();
                    }
                    if (stringArray != null && stringArray.length > 0) {
                        this.setStoredSelection(this.getDataRow(this.iSelectedRowIndex).createDataRow(stringArray));
                    }
                }
            } else {
                this.setStoredSelection(null);
            }
        }
    }

    private void setUID(Object object) {
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount()] = object;
    }

    private void setInserting() {
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount() + 1] = ChangeableDataRow.INSERTING;
    }

    private void setUpdating() {
        int n = this.rdRowDefinition.getColumnCount();
        Object[] objectArray = new Object[n * 2 + 3];
        System.arraycopy(this.oaStorage, 0, objectArray, 0, this.oaStorage.length);
        System.arraycopy(this.oaStorage, 0, objectArray, 3 + n, n);
        if (this.oaStorage.length > n + 2) {
            objectArray[n + 2] = this.oaStorage[n + 2];
        }
        this.oaStorage = objectArray;
        this.oaStorage[n + 1] = UPDATING;
        this.dpCurrentDataPage.addChange(this.iSelectedRowIndex);
    }

    private boolean setWritableColumnChanged(String string) throws ModelException {
        if (this.isUpdating() && this.rdRowDefinition.getColumnDefinition(string).isWritable()) {
            this.oaStorage[this.rdRowDefinition.getColumnCount() + 1] = WRITABLE_COLUMN_CHANGED;
            return true;
        }
        return false;
    }

    private void setDeleting() {
        this.extentStorage();
        this.oaStorage[this.rdRowDefinition.getColumnCount() + 1] = DELETING;
    }

    private void extentStorage() {
        int n = this.rdRowDefinition.getColumnCount();
        if (this.oaStorage.length <= n) {
            Object[] objectArray = new Object[n + 3];
            System.arraycopy(this.oaStorage, 0, objectArray, 0, n);
            this.oaStorage = objectArray;
        }
    }

    private void restoreChangeableDataRow() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount();
        if (this.isUpdating()) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.oaStorage, 3 + n, objectArray, 0, n);
            this.oaStorage = objectArray;
        } else {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.oaStorage, 0, objectArray, 0, n);
            this.oaStorage = objectArray;
        }
        this.dpCurrentDataPage.setDataRowInternal(this.iSelectedRowIndex, this.oaStorage);
    }

    private void restoreAllDetails() throws ModelException {
        if (this.auDetailDataBooks != null) {
            int n = this.auDetailDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = (IDataBook)this.auDetailDataBooks.get(i).get();
                if (iDataBook == null) continue;
                iDataBook.restoreAllRows();
            }
        }
    }

    private void restore() throws ModelException {
        IChangeableDataRow iChangeableDataRow = this.getDataRow(this.iSelectedRowIndex);
        if (this.eventBeforeRestore != null) {
            this.eventBeforeRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RESTORE, iChangeableDataRow));
        }
        if (this.isInserting()) {
            this.restoreAllDetails();
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
            this.setSelectedRowInternal(this.iSelectedRowIndex - 1);
            this.setDetailsChangedInMasterBook();
            if (this.eventAfterRestore != null) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iChangeableDataRow));
            }
            if (this.eventAfterRowSelected != null) {
                this.eventAfterRowSelected.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_ROW_SELECTED, iChangeableDataRow));
            }
        } else {
            this.dpCurrentDataPage.removeChange(this.iSelectedRowIndex);
            this.restoreChangeableDataRow();
            this.setDetailsChangedInMasterBook();
            if (this.eventAfterRestore != null) {
                this.eventAfterRestore.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RESTORE, iChangeableDataRow));
            }
        }
    }

    private void store() throws ModelException {
        if (this.isDeleting()) {
            this.dpCurrentDataPage.delete(this.iSelectedRowIndex);
            return;
        }
        this.dpCurrentDataPage.removeChange(this.iSelectedRowIndex);
        int n = this.rdRowDefinition.getColumnCount();
        Object[] objectArray = new Object[n + 3];
        System.arraycopy(this.oaStorage, 0, objectArray, 0, n + 1);
        this.oaStorage = objectArray;
        this.dpCurrentDataPage.setDataRowInternal(this.iSelectedRowIndex, this.oaStorage);
        this.setDetailsChangedInMasterBook();
    }

    protected void clearFilterSortInMemDataPages() throws ModelException {
        if (this.eventBeforeReload != null) {
            this.eventBeforeReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.BEFORE_RELOAD, null));
        }
        if (this.getMasterReference() != null) {
            Enumeration<MemDataPage> enumeration = this.htDataPagesCache.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().clear();
            }
        } else if (!this.isOutOfSync()) {
            this.dpCurrentDataPage.clear();
        }
        if (!this.isOutOfSync()) {
            this.correctSelectedRow();
        }
        if (this.eventAfterReload != null) {
            this.eventAfterReload.dispatchEvent(new DataBookEvent(this, DataBookEvent.ChangedType.AFTER_RELOAD, null));
        }
    }

    protected Object[] createNewRow() {
        int n = this.rdRowDefinition.getColumnCount();
        Object[] objectArray = new Object[n + 3];
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.rdRowDefinition.getColumnDefinition(i).getDefaultValue();
        }
        return objectArray;
    }

    public void setReadOnlyWithoutSave(boolean bl) {
        this.bReadOnly = bl;
        this.invokeRepaintListeners();
    }
}

